/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Fulfillment;
import com.google.cloud.dialogflow.v2.GetFulfillmentRequest;
import com.google.cloud.dialogflow.v2.UpdateFulfillmentRequest;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * REST stub implementation for the Fulfillments service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@Generated("by gapic-generator-java")
@BetaApi
public class HttpJsonFulfillmentsStub extends FulfillmentsStub {
  private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();

  private static final ApiMethodDescriptor<GetFulfillmentRequest, Fulfillment>
      getFulfillmentMethodDescriptor =
          ApiMethodDescriptor.<GetFulfillmentRequest, Fulfillment>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.v2.Fulfillments/GetFulfillment")
              .setHttpMethod("GET")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<GetFulfillmentRequest>newBuilder()
                      .setPath(
                          "/v2/{name=projects/*/agent/fulfillment}",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<GetFulfillmentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "name", request.getName());
                            return fields;
                          })
                      .setAdditionalPaths("/v2/{name=projects/*/locations/*/agent/fulfillment}")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<GetFulfillmentRequest> serializer =
                                ProtoRestSerializer.create();
                            return fields;
                          })
                      .setRequestBodyExtractor(request -> null)
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<Fulfillment>newBuilder()
                      .setDefaultInstance(Fulfillment.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<UpdateFulfillmentRequest, Fulfillment>
      updateFulfillmentMethodDescriptor =
          ApiMethodDescriptor.<UpdateFulfillmentRequest, Fulfillment>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.v2.Fulfillments/UpdateFulfillment")
              .setHttpMethod("PATCH")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<UpdateFulfillmentRequest>newBuilder()
                      .setPath(
                          "/v2/{fulfillment.name=projects/*/agent/fulfillment}",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<UpdateFulfillmentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(
                                fields, "fulfillment.name", request.getFulfillment().getName());
                            return fields;
                          })
                      .setAdditionalPaths(
                          "/v2/{fulfillment.name=projects/*/locations/*/agent/fulfillment}")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<UpdateFulfillmentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "updateMask", request.getUpdateMask());
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("fulfillment", request.getFulfillment()))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<Fulfillment>newBuilder()
                      .setDefaultInstance(Fulfillment.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private final UnaryCallable<GetFulfillmentRequest, Fulfillment> getFulfillmentCallable;
  private final UnaryCallable<UpdateFulfillmentRequest, Fulfillment> updateFulfillmentCallable;

  private final BackgroundResource backgroundResources;
  private final HttpJsonStubCallableFactory callableFactory;

  public static final HttpJsonFulfillmentsStub create(FulfillmentsStubSettings settings)
      throws IOException {
    return new HttpJsonFulfillmentsStub(settings, ClientContext.create(settings));
  }

  public static final HttpJsonFulfillmentsStub create(ClientContext clientContext)
      throws IOException {
    return new HttpJsonFulfillmentsStub(
        FulfillmentsStubSettings.newHttpJsonBuilder().build(), clientContext);
  }

  public static final HttpJsonFulfillmentsStub create(
      ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
    return new HttpJsonFulfillmentsStub(
        FulfillmentsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of HttpJsonFulfillmentsStub, using the given settings. This is protected
   * so that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected HttpJsonFulfillmentsStub(FulfillmentsStubSettings settings, ClientContext clientContext)
      throws IOException {
    this(settings, clientContext, new HttpJsonFulfillmentsCallableFactory());
  }

  /**
   * Constructs an instance of HttpJsonFulfillmentsStub, using the given settings. This is protected
   * so that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected HttpJsonFulfillmentsStub(
      FulfillmentsStubSettings settings,
      ClientContext clientContext,
      HttpJsonStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;

    HttpJsonCallSettings<GetFulfillmentRequest, Fulfillment> getFulfillmentTransportSettings =
        HttpJsonCallSettings.<GetFulfillmentRequest, Fulfillment>newBuilder()
            .setMethodDescriptor(getFulfillmentMethodDescriptor)
            .setTypeRegistry(typeRegistry)
            .build();
    HttpJsonCallSettings<UpdateFulfillmentRequest, Fulfillment> updateFulfillmentTransportSettings =
        HttpJsonCallSettings.<UpdateFulfillmentRequest, Fulfillment>newBuilder()
            .setMethodDescriptor(updateFulfillmentMethodDescriptor)
            .setTypeRegistry(typeRegistry)
            .build();

    this.getFulfillmentCallable =
        callableFactory.createUnaryCallable(
            getFulfillmentTransportSettings, settings.getFulfillmentSettings(), clientContext);
    this.updateFulfillmentCallable =
        callableFactory.createUnaryCallable(
            updateFulfillmentTransportSettings,
            settings.updateFulfillmentSettings(),
            clientContext);

    this.backgroundResources =
        new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  @InternalApi
  public static List<ApiMethodDescriptor> getMethodDescriptors() {
    List<ApiMethodDescriptor> methodDescriptors = new ArrayList<>();
    methodDescriptors.add(getFulfillmentMethodDescriptor);
    methodDescriptors.add(updateFulfillmentMethodDescriptor);
    return methodDescriptors;
  }

  @Override
  public UnaryCallable<GetFulfillmentRequest, Fulfillment> getFulfillmentCallable() {
    return getFulfillmentCallable;
  }

  @Override
  public UnaryCallable<UpdateFulfillmentRequest, Fulfillment> updateFulfillmentCallable() {
    return updateFulfillmentCallable;
  }

  @Override
  public final void close() {
    try {
      backgroundResources.close();
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalStateException("Failed to close resource", e);
    }
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
