/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.DeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersResponse;
import com.google.cloud.dialogflow.v2beta1.PhoneNumber;
import com.google.cloud.dialogflow.v2beta1.PhoneNumbersClient;
import com.google.cloud.dialogflow.v2beta1.UndeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.UpdatePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcPhoneNumbersStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonPhoneNumbersStub;
import com.google.cloud.dialogflow.v2beta1.stub.PhoneNumbersStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class PhoneNumbersStubSettings
extends StubSettings<PhoneNumbersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersSettings;
    private final UnaryCallSettings<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberSettings;
    private final UnaryCallSettings<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberSettings;
    private final UnaryCallSettings<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber> LIST_PHONE_NUMBERS_PAGE_STR_DESC = new PagedListDescriptor<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber>(){

        public String emptyToken() {
            return "";
        }

        public ListPhoneNumbersRequest injectToken(ListPhoneNumbersRequest payload, String token) {
            return ListPhoneNumbersRequest.newBuilder((ListPhoneNumbersRequest)payload).setPageToken(token).build();
        }

        public ListPhoneNumbersRequest injectPageSize(ListPhoneNumbersRequest payload, int pageSize) {
            return ListPhoneNumbersRequest.newBuilder((ListPhoneNumbersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPhoneNumbersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPhoneNumbersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PhoneNumber> extractResources(ListPhoneNumbersResponse payload) {
            return payload.getPhoneNumbersList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse> LIST_PHONE_NUMBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse>(){

        public ApiFuture<PhoneNumbersClient.ListPhoneNumbersPagedResponse> getFuturePagedResponse(UnaryCallable<ListPhoneNumbersRequest, ListPhoneNumbersResponse> callable, ListPhoneNumbersRequest request, ApiCallContext context, ApiFuture<ListPhoneNumbersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PHONE_NUMBERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PhoneNumbersClient.ListPhoneNumbersPagedResponse.createAsync((PageContext<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse>(){

        public ApiFuture<PhoneNumbersClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PhoneNumbersClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersSettings() {
        return this.listPhoneNumbersSettings;
    }

    public UnaryCallSettings<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberSettings() {
        return this.updatePhoneNumberSettings;
    }

    public UnaryCallSettings<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberSettings() {
        return this.deletePhoneNumberSettings;
    }

    public UnaryCallSettings<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberSettings() {
        return this.undeletePhoneNumberSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public PhoneNumbersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPhoneNumbersStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPhoneNumbersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PhoneNumbersStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PhoneNumbersStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PhoneNumbersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PhoneNumbersStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PhoneNumbersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listPhoneNumbersSettings = settingsBuilder.listPhoneNumbersSettings().build();
        this.updatePhoneNumberSettings = settingsBuilder.updatePhoneNumberSettings().build();
        this.deletePhoneNumberSettings = settingsBuilder.deletePhoneNumberSettings().build();
        this.undeletePhoneNumberSettings = settingsBuilder.undeletePhoneNumberSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PhoneNumbersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersSettings;
        private final UnaryCallSettings.Builder<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberSettings;
        private final UnaryCallSettings.Builder<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberSettings;
        private final UnaryCallSettings.Builder<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listPhoneNumbersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PHONE_NUMBERS_PAGE_STR_FACT);
            this.updatePhoneNumberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePhoneNumberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeletePhoneNumberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPhoneNumbersSettings, this.updatePhoneNumberSettings, this.deletePhoneNumberSettings, this.undeletePhoneNumberSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PhoneNumbersStubSettings settings) {
            super((StubSettings)settings);
            this.listPhoneNumbersSettings = settings.listPhoneNumbersSettings.toBuilder();
            this.updatePhoneNumberSettings = settings.updatePhoneNumberSettings.toBuilder();
            this.deletePhoneNumberSettings = settings.deletePhoneNumberSettings.toBuilder();
            this.undeletePhoneNumberSettings = settings.undeletePhoneNumberSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPhoneNumbersSettings, this.updatePhoneNumberSettings, this.deletePhoneNumberSettings, this.undeletePhoneNumberSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PhoneNumbersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PhoneNumbersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PhoneNumbersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PhoneNumbersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PhoneNumbersStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PhoneNumbersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PhoneNumbersStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PhoneNumbersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listPhoneNumbersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePhoneNumberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePhoneNumberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeletePhoneNumberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersSettings() {
            return this.listPhoneNumbersSettings;
        }

        public UnaryCallSettings.Builder<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberSettings() {
            return this.updatePhoneNumberSettings;
        }

        public UnaryCallSettings.Builder<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberSettings() {
            return this.deletePhoneNumberSettings;
        }

        public UnaryCallSettings.Builder<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberSettings() {
            return this.undeletePhoneNumberSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public PhoneNumbersStubSettings build() throws IOException {
            return new PhoneNumbersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

