/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.AnalyzeContentRequest;
import com.google.cloud.dialogflow.v2.AnalyzeContentResponse;
import com.google.cloud.dialogflow.v2.CreateParticipantRequest;
import com.google.cloud.dialogflow.v2.GetParticipantRequest;
import com.google.cloud.dialogflow.v2.ListParticipantsRequest;
import com.google.cloud.dialogflow.v2.ListParticipantsResponse;
import com.google.cloud.dialogflow.v2.Participant;
import com.google.cloud.dialogflow.v2.ParticipantsClient;
import com.google.cloud.dialogflow.v2.SuggestArticlesRequest;
import com.google.cloud.dialogflow.v2.SuggestArticlesResponse;
import com.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;
import com.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;
import com.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;
import com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;
import com.google.cloud.dialogflow.v2.UpdateParticipantRequest;
import com.google.cloud.dialogflow.v2.stub.GrpcParticipantsCallableFactory;
import com.google.cloud.dialogflow.v2.stub.ParticipantsStub;
import com.google.cloud.dialogflow.v2.stub.ParticipantsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcParticipantsStub
extends ParticipantsStub {
    private static final MethodDescriptor<CreateParticipantRequest, Participant> createParticipantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/CreateParticipant").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateParticipantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Participant.getDefaultInstance())).build();
    private static final MethodDescriptor<GetParticipantRequest, Participant> getParticipantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/GetParticipant").setRequestMarshaller(ProtoUtils.marshaller((Message)GetParticipantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Participant.getDefaultInstance())).build();
    private static final MethodDescriptor<ListParticipantsRequest, ListParticipantsResponse> listParticipantsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/ListParticipants").setRequestMarshaller(ProtoUtils.marshaller((Message)ListParticipantsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListParticipantsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateParticipantRequest, Participant> updateParticipantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/UpdateParticipant").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateParticipantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Participant.getDefaultInstance())).build();
    private static final MethodDescriptor<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/AnalyzeContent").setRequestMarshaller(ProtoUtils.marshaller((Message)AnalyzeContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnalyzeContentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/SuggestArticles").setRequestMarshaller(ProtoUtils.marshaller((Message)SuggestArticlesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SuggestArticlesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/SuggestFaqAnswers").setRequestMarshaller(ProtoUtils.marshaller((Message)SuggestFaqAnswersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SuggestFaqAnswersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Participants/SuggestSmartReplies").setRequestMarshaller(ProtoUtils.marshaller((Message)SuggestSmartRepliesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SuggestSmartRepliesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateParticipantRequest, Participant> createParticipantCallable;
    private final UnaryCallable<GetParticipantRequest, Participant> getParticipantCallable;
    private final UnaryCallable<ListParticipantsRequest, ListParticipantsResponse> listParticipantsCallable;
    private final UnaryCallable<ListParticipantsRequest, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsPagedCallable;
    private final UnaryCallable<UpdateParticipantRequest, Participant> updateParticipantCallable;
    private final UnaryCallable<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentCallable;
    private final UnaryCallable<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesCallable;
    private final UnaryCallable<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersCallable;
    private final UnaryCallable<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ParticipantsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcParticipantsStub create(ParticipantsStubSettings settings) throws IOException {
        return new GrpcParticipantsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcParticipantsStub create(ClientContext clientContext) throws IOException {
        return new GrpcParticipantsStub(ParticipantsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcParticipantsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcParticipantsStub(ParticipantsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcParticipantsStub(ParticipantsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcParticipantsCallableFactory());
    }

    protected GrpcParticipantsStub(ParticipantsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createParticipantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createParticipantMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getParticipantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getParticipantMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listParticipantsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listParticipantsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateParticipantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateParticipantMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"participant.name", (Object)String.valueOf(request.getParticipant().getName()));
            return params.build();
        }).build();
        GrpcCallSettings analyzeContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(analyzeContentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"participant", (Object)String.valueOf(request.getParticipant()));
            return params.build();
        }).build();
        GrpcCallSettings suggestArticlesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(suggestArticlesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings suggestFaqAnswersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(suggestFaqAnswersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings suggestSmartRepliesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(suggestSmartRepliesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createParticipantCallable = callableFactory.createUnaryCallable(createParticipantTransportSettings, settings.createParticipantSettings(), clientContext);
        this.getParticipantCallable = callableFactory.createUnaryCallable(getParticipantTransportSettings, settings.getParticipantSettings(), clientContext);
        this.listParticipantsCallable = callableFactory.createUnaryCallable(listParticipantsTransportSettings, settings.listParticipantsSettings(), clientContext);
        this.listParticipantsPagedCallable = callableFactory.createPagedCallable(listParticipantsTransportSettings, settings.listParticipantsSettings(), clientContext);
        this.updateParticipantCallable = callableFactory.createUnaryCallable(updateParticipantTransportSettings, settings.updateParticipantSettings(), clientContext);
        this.analyzeContentCallable = callableFactory.createUnaryCallable(analyzeContentTransportSettings, settings.analyzeContentSettings(), clientContext);
        this.suggestArticlesCallable = callableFactory.createUnaryCallable(suggestArticlesTransportSettings, settings.suggestArticlesSettings(), clientContext);
        this.suggestFaqAnswersCallable = callableFactory.createUnaryCallable(suggestFaqAnswersTransportSettings, settings.suggestFaqAnswersSettings(), clientContext);
        this.suggestSmartRepliesCallable = callableFactory.createUnaryCallable(suggestSmartRepliesTransportSettings, settings.suggestSmartRepliesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateParticipantRequest, Participant> createParticipantCallable() {
        return this.createParticipantCallable;
    }

    @Override
    public UnaryCallable<GetParticipantRequest, Participant> getParticipantCallable() {
        return this.getParticipantCallable;
    }

    @Override
    public UnaryCallable<ListParticipantsRequest, ListParticipantsResponse> listParticipantsCallable() {
        return this.listParticipantsCallable;
    }

    @Override
    public UnaryCallable<ListParticipantsRequest, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsPagedCallable() {
        return this.listParticipantsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateParticipantRequest, Participant> updateParticipantCallable() {
        return this.updateParticipantCallable;
    }

    @Override
    public UnaryCallable<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentCallable() {
        return this.analyzeContentCallable;
    }

    @Override
    public UnaryCallable<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesCallable() {
        return this.suggestArticlesCallable;
    }

    @Override
    public UnaryCallable<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersCallable() {
        return this.suggestFaqAnswersCallable;
    }

    @Override
    public UnaryCallable<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesCallable() {
        return this.suggestSmartRepliesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ParticipantsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

