/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Context;
import com.google.cloud.dialogflow.v2.ContextsClient;
import com.google.cloud.dialogflow.v2.CreateContextRequest;
import com.google.cloud.dialogflow.v2.DeleteAllContextsRequest;
import com.google.cloud.dialogflow.v2.DeleteContextRequest;
import com.google.cloud.dialogflow.v2.GetContextRequest;
import com.google.cloud.dialogflow.v2.ListContextsRequest;
import com.google.cloud.dialogflow.v2.ListContextsResponse;
import com.google.cloud.dialogflow.v2.UpdateContextRequest;
import com.google.cloud.dialogflow.v2.stub.ContextsStub;
import com.google.cloud.dialogflow.v2.stub.ContextsStubSettings;
import com.google.cloud.dialogflow.v2.stub.HttpJsonContextsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonContextsStub
extends ContextsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListContextsRequest, ListContextsResponse> listContextsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/ListContexts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/agent/sessions/*}/contexts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/agent/environments/*/users/*/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/environments/*/users/*/sessions/*}/contexts"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListContextsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetContextRequest, Context> getContextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/GetContext").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/agent/sessions/*/contexts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/agent/environments/*/users/*/sessions/*/contexts/*}", "/v2/{name=projects/*/locations/*/agent/sessions/*/contexts/*}", "/v2/{name=projects/*/locations/*/agent/environments/*/users/*/sessions/*/contexts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Context.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateContextRequest, Context> createContextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/CreateContext").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/agent/sessions/*}/contexts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/agent/environments/*/users/*/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/environments/*/users/*/sessions/*}/contexts"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("context", (Message)request.getContext(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Context.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateContextRequest, Context> updateContextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/UpdateContext").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{context.name=projects/*/agent/sessions/*/contexts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "context.name", (Object)request.getContext().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{context.name=projects/*/agent/environments/*/users/*/sessions/*/contexts/*}", "/v2/{context.name=projects/*/locations/*/agent/sessions/*/contexts/*}", "/v2/{context.name=projects/*/locations/*/agent/environments/*/users/*/sessions/*/contexts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("context", (Message)request.getContext(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Context.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteContextRequest, Empty> deleteContextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/DeleteContext").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/agent/sessions/*/contexts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/agent/environments/*/users/*/sessions/*/contexts/*}", "/v2/{name=projects/*/locations/*/agent/sessions/*/contexts/*}", "/v2/{name=projects/*/locations/*/agent/environments/*/users/*/sessions/*/contexts/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteAllContextsRequest, Empty> deleteAllContextsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.Contexts/DeleteAllContexts").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/agent/sessions/*}/contexts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/agent/environments/*/users/*/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/sessions/*}/contexts", "/v2/{parent=projects/*/locations/*/agent/environments/*/users/*/sessions/*}/contexts"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable;
    private final UnaryCallable<ListContextsRequest, ContextsClient.ListContextsPagedResponse> listContextsPagedCallable;
    private final UnaryCallable<GetContextRequest, Context> getContextCallable;
    private final UnaryCallable<CreateContextRequest, Context> createContextCallable;
    private final UnaryCallable<UpdateContextRequest, Context> updateContextCallable;
    private final UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable;
    private final UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ContextsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonContextsStub create(ContextsStubSettings settings) throws IOException {
        return new HttpJsonContextsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonContextsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonContextsStub(ContextsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonContextsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonContextsStub(ContextsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonContextsStub(ContextsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonContextsCallableFactory());
    }

    protected HttpJsonContextsStub(ContextsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listContextsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listContextsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getContextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getContextMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createContextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createContextMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateContextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateContextMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("context.name", String.valueOf(request.getContext().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteContextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteContextMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteAllContextsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAllContextsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listContextsCallable = callableFactory.createUnaryCallable(listContextsTransportSettings, settings.listContextsSettings(), clientContext);
        this.listContextsPagedCallable = callableFactory.createPagedCallable(listContextsTransportSettings, settings.listContextsSettings(), clientContext);
        this.getContextCallable = callableFactory.createUnaryCallable(getContextTransportSettings, settings.getContextSettings(), clientContext);
        this.createContextCallable = callableFactory.createUnaryCallable(createContextTransportSettings, settings.createContextSettings(), clientContext);
        this.updateContextCallable = callableFactory.createUnaryCallable(updateContextTransportSettings, settings.updateContextSettings(), clientContext);
        this.deleteContextCallable = callableFactory.createUnaryCallable(deleteContextTransportSettings, settings.deleteContextSettings(), clientContext);
        this.deleteAllContextsCallable = callableFactory.createUnaryCallable(deleteAllContextsTransportSettings, settings.deleteAllContextsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listContextsMethodDescriptor);
        methodDescriptors.add(getContextMethodDescriptor);
        methodDescriptors.add(createContextMethodDescriptor);
        methodDescriptors.add(updateContextMethodDescriptor);
        methodDescriptors.add(deleteContextMethodDescriptor);
        methodDescriptors.add(deleteAllContextsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable() {
        return this.listContextsCallable;
    }

    @Override
    public UnaryCallable<ListContextsRequest, ContextsClient.ListContextsPagedResponse> listContextsPagedCallable() {
        return this.listContextsPagedCallable;
    }

    @Override
    public UnaryCallable<GetContextRequest, Context> getContextCallable() {
        return this.getContextCallable;
    }

    @Override
    public UnaryCallable<CreateContextRequest, Context> createContextCallable() {
        return this.createContextCallable;
    }

    @Override
    public UnaryCallable<UpdateContextRequest, Context> updateContextCallable() {
        return this.updateContextCallable;
    }

    @Override
    public UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable() {
        return this.deleteContextCallable;
    }

    @Override
    public UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable() {
        return this.deleteAllContextsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ContextsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

