/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateEngineMetadata;
import com.google.cloud.discoveryengine.v1beta.CreateEngineRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteEngineMetadata;
import com.google.cloud.discoveryengine.v1beta.DeleteEngineRequest;
import com.google.cloud.discoveryengine.v1beta.Engine;
import com.google.cloud.discoveryengine.v1beta.EngineServiceClient;
import com.google.cloud.discoveryengine.v1beta.GetEngineRequest;
import com.google.cloud.discoveryengine.v1beta.ListEnginesRequest;
import com.google.cloud.discoveryengine.v1beta.ListEnginesResponse;
import com.google.cloud.discoveryengine.v1beta.PauseEngineRequest;
import com.google.cloud.discoveryengine.v1beta.ResumeEngineRequest;
import com.google.cloud.discoveryengine.v1beta.TuneEngineMetadata;
import com.google.cloud.discoveryengine.v1beta.TuneEngineRequest;
import com.google.cloud.discoveryengine.v1beta.TuneEngineResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateEngineRequest;
import com.google.cloud.discoveryengine.v1beta.stub.EngineServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.EngineServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonEngineServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonEngineServiceStub
extends EngineServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(CreateEngineMetadata.getDescriptor()).add(DeleteEngineMetadata.getDescriptor()).add(Empty.getDescriptor()).add(TuneEngineResponse.getDescriptor()).add(TuneEngineMetadata.getDescriptor()).add(Engine.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateEngineRequest, Operation> createEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/CreateEngine").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/collections/*}/engines", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "engineId", (Object)request.getEngineId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("engine", (Message)request.getEngine(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteEngineRequest, Operation> deleteEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/DeleteEngine").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateEngineRequest, Engine> updateEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/UpdateEngine").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{engine.name=projects/*/locations/*/collections/*/engines/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "engine.name", (Object)request.getEngine().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("engine", (Message)request.getEngine(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Engine.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEngineRequest, Engine> getEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/GetEngine").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Engine.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListEnginesRequest, ListEnginesResponse> listEnginesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/ListEngines").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/collections/*}/engines", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEnginesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PauseEngineRequest, Engine> pauseEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/PauseEngine").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}:pause", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Engine.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ResumeEngineRequest, Engine> resumeEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/ResumeEngine").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}:resume", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Engine.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TuneEngineRequest, Operation> tuneEngineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.EngineService/TuneEngine").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}:tune", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateEngineRequest, Operation> createEngineCallable;
    private final OperationCallable<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationCallable;
    private final UnaryCallable<DeleteEngineRequest, Operation> deleteEngineCallable;
    private final OperationCallable<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationCallable;
    private final UnaryCallable<UpdateEngineRequest, Engine> updateEngineCallable;
    private final UnaryCallable<GetEngineRequest, Engine> getEngineCallable;
    private final UnaryCallable<ListEnginesRequest, ListEnginesResponse> listEnginesCallable;
    private final UnaryCallable<ListEnginesRequest, EngineServiceClient.ListEnginesPagedResponse> listEnginesPagedCallable;
    private final UnaryCallable<PauseEngineRequest, Engine> pauseEngineCallable;
    private final UnaryCallable<ResumeEngineRequest, Engine> resumeEngineCallable;
    private final UnaryCallable<TuneEngineRequest, Operation> tuneEngineCallable;
    private final OperationCallable<TuneEngineRequest, TuneEngineResponse, TuneEngineMetadata> tuneEngineOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEngineServiceStub create(EngineServiceStubSettings settings) throws IOException {
        return new HttpJsonEngineServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEngineServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEngineServiceStub(EngineServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEngineServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEngineServiceStub(EngineServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEngineServiceStub(EngineServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEngineServiceCallableFactory());
    }

    protected HttpJsonEngineServiceStub(EngineServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1beta/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataConnector/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/engines/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataConnector}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*/engines/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/collections/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1beta/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings createEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("engine.name", String.valueOf(request.getEngine().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listEnginesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEnginesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings pauseEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(pauseEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings resumeEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resumeEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings tuneEngineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(tuneEngineMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createEngineCallable = callableFactory.createUnaryCallable(createEngineTransportSettings, settings.createEngineSettings(), clientContext);
        this.createEngineOperationCallable = callableFactory.createOperationCallable(createEngineTransportSettings, settings.createEngineOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteEngineCallable = callableFactory.createUnaryCallable(deleteEngineTransportSettings, settings.deleteEngineSettings(), clientContext);
        this.deleteEngineOperationCallable = callableFactory.createOperationCallable(deleteEngineTransportSettings, settings.deleteEngineOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateEngineCallable = callableFactory.createUnaryCallable(updateEngineTransportSettings, settings.updateEngineSettings(), clientContext);
        this.getEngineCallable = callableFactory.createUnaryCallable(getEngineTransportSettings, settings.getEngineSettings(), clientContext);
        this.listEnginesCallable = callableFactory.createUnaryCallable(listEnginesTransportSettings, settings.listEnginesSettings(), clientContext);
        this.listEnginesPagedCallable = callableFactory.createPagedCallable(listEnginesTransportSettings, settings.listEnginesSettings(), clientContext);
        this.pauseEngineCallable = callableFactory.createUnaryCallable(pauseEngineTransportSettings, settings.pauseEngineSettings(), clientContext);
        this.resumeEngineCallable = callableFactory.createUnaryCallable(resumeEngineTransportSettings, settings.resumeEngineSettings(), clientContext);
        this.tuneEngineCallable = callableFactory.createUnaryCallable(tuneEngineTransportSettings, settings.tuneEngineSettings(), clientContext);
        this.tuneEngineOperationCallable = callableFactory.createOperationCallable(tuneEngineTransportSettings, settings.tuneEngineOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createEngineMethodDescriptor);
        methodDescriptors.add(deleteEngineMethodDescriptor);
        methodDescriptors.add(updateEngineMethodDescriptor);
        methodDescriptors.add(getEngineMethodDescriptor);
        methodDescriptors.add(listEnginesMethodDescriptor);
        methodDescriptors.add(pauseEngineMethodDescriptor);
        methodDescriptors.add(resumeEngineMethodDescriptor);
        methodDescriptors.add(tuneEngineMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateEngineRequest, Operation> createEngineCallable() {
        return this.createEngineCallable;
    }

    @Override
    public OperationCallable<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationCallable() {
        return this.createEngineOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEngineRequest, Operation> deleteEngineCallable() {
        return this.deleteEngineCallable;
    }

    @Override
    public OperationCallable<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationCallable() {
        return this.deleteEngineOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateEngineRequest, Engine> updateEngineCallable() {
        return this.updateEngineCallable;
    }

    @Override
    public UnaryCallable<GetEngineRequest, Engine> getEngineCallable() {
        return this.getEngineCallable;
    }

    @Override
    public UnaryCallable<ListEnginesRequest, ListEnginesResponse> listEnginesCallable() {
        return this.listEnginesCallable;
    }

    @Override
    public UnaryCallable<ListEnginesRequest, EngineServiceClient.ListEnginesPagedResponse> listEnginesPagedCallable() {
        return this.listEnginesPagedCallable;
    }

    @Override
    public UnaryCallable<PauseEngineRequest, Engine> pauseEngineCallable() {
        return this.pauseEngineCallable;
    }

    @Override
    public UnaryCallable<ResumeEngineRequest, Engine> resumeEngineCallable() {
        return this.resumeEngineCallable;
    }

    @Override
    public UnaryCallable<TuneEngineRequest, Operation> tuneEngineCallable() {
        return this.tuneEngineCallable;
    }

    @Override
    public OperationCallable<TuneEngineRequest, TuneEngineResponse, TuneEngineMetadata> tuneEngineOperationCallable() {
        return this.tuneEngineOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

