/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CreateDataStoreMetadata;
import com.google.cloud.discoveryengine.v1.CreateDataStoreRequest;
import com.google.cloud.discoveryengine.v1.DataStore;
import com.google.cloud.discoveryengine.v1.DataStoreServiceClient;
import com.google.cloud.discoveryengine.v1.DeleteDataStoreMetadata;
import com.google.cloud.discoveryengine.v1.DeleteDataStoreRequest;
import com.google.cloud.discoveryengine.v1.GetDataStoreRequest;
import com.google.cloud.discoveryengine.v1.ListDataStoresRequest;
import com.google.cloud.discoveryengine.v1.ListDataStoresResponse;
import com.google.cloud.discoveryengine.v1.UpdateDataStoreRequest;
import com.google.cloud.discoveryengine.v1.stub.DataStoreServiceStub;
import com.google.cloud.discoveryengine.v1.stub.DataStoreServiceStubSettings;
import com.google.cloud.discoveryengine.v1.stub.HttpJsonDataStoreServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDataStoreServiceStub
extends DataStoreServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(DeleteDataStoreMetadata.getDescriptor()).add(Empty.getDescriptor()).add(DataStore.getDescriptor()).add(CreateDataStoreMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateDataStoreRequest, Operation> createDataStoreMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1.DataStoreService/CreateDataStore").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dataStores", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*/collections/*}/dataStores"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "createAdvancedSiteSearch", (Object)request.getCreateAdvancedSiteSearch());
        serializer.putQueryParam(fields, "dataStoreId", (Object)request.getDataStoreId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dataStore", (Message)request.getDataStore(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetDataStoreRequest, DataStore> getDataStoreMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1.DataStoreService/GetDataStore").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataStores/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/collections/*/dataStores/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataStore.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDataStoresRequest, ListDataStoresResponse> listDataStoresMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1.DataStoreService/ListDataStores").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dataStores", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/locations/*/collections/*}/dataStores"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDataStoresResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDataStoreRequest, Operation> deleteDataStoreMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1.DataStoreService/DeleteDataStore").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataStores/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*/collections/*/dataStores/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateDataStoreRequest, DataStore> updateDataStoreMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1.DataStoreService/UpdateDataStore").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{dataStore.name=projects/*/locations/*/dataStores/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "dataStore.name", (Object)request.getDataStore().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{dataStore.name=projects/*/locations/*/collections/*/dataStores/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dataStore", (Message)request.getDataStore(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataStore.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDataStoreRequest, Operation> createDataStoreCallable;
    private final OperationCallable<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationCallable;
    private final UnaryCallable<GetDataStoreRequest, DataStore> getDataStoreCallable;
    private final UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> listDataStoresCallable;
    private final UnaryCallable<ListDataStoresRequest, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresPagedCallable;
    private final UnaryCallable<DeleteDataStoreRequest, Operation> deleteDataStoreCallable;
    private final OperationCallable<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationCallable;
    private final UnaryCallable<UpdateDataStoreRequest, DataStore> updateDataStoreCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDataStoreServiceStub create(DataStoreServiceStubSettings settings) throws IOException {
        return new HttpJsonDataStoreServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDataStoreServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDataStoreServiceStub(DataStoreServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDataStoreServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDataStoreServiceStub(DataStoreServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDataStoreServiceStub(DataStoreServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDataStoreServiceCallableFactory());
    }

    protected HttpJsonDataStoreServiceStub(DataStoreServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}:cancel").build()).addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataConnector/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/engines/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataConnector}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*/engines/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/collections/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings createDataStoreTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDataStoreMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDataStoreTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDataStoreMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDataStoresTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDataStoresMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDataStoreTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDataStoreMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDataStoreTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDataStoreMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store.name", String.valueOf(request.getDataStore().getName()));
            return builder.build();
        }).build();
        this.createDataStoreCallable = callableFactory.createUnaryCallable(createDataStoreTransportSettings, settings.createDataStoreSettings(), clientContext);
        this.createDataStoreOperationCallable = callableFactory.createOperationCallable(createDataStoreTransportSettings, settings.createDataStoreOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getDataStoreCallable = callableFactory.createUnaryCallable(getDataStoreTransportSettings, settings.getDataStoreSettings(), clientContext);
        this.listDataStoresCallable = callableFactory.createUnaryCallable(listDataStoresTransportSettings, settings.listDataStoresSettings(), clientContext);
        this.listDataStoresPagedCallable = callableFactory.createPagedCallable(listDataStoresTransportSettings, settings.listDataStoresSettings(), clientContext);
        this.deleteDataStoreCallable = callableFactory.createUnaryCallable(deleteDataStoreTransportSettings, settings.deleteDataStoreSettings(), clientContext);
        this.deleteDataStoreOperationCallable = callableFactory.createOperationCallable(deleteDataStoreTransportSettings, settings.deleteDataStoreOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateDataStoreCallable = callableFactory.createUnaryCallable(updateDataStoreTransportSettings, settings.updateDataStoreSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDataStoreMethodDescriptor);
        methodDescriptors.add(getDataStoreMethodDescriptor);
        methodDescriptors.add(listDataStoresMethodDescriptor);
        methodDescriptors.add(deleteDataStoreMethodDescriptor);
        methodDescriptors.add(updateDataStoreMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateDataStoreRequest, Operation> createDataStoreCallable() {
        return this.createDataStoreCallable;
    }

    @Override
    public OperationCallable<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationCallable() {
        return this.createDataStoreOperationCallable;
    }

    @Override
    public UnaryCallable<GetDataStoreRequest, DataStore> getDataStoreCallable() {
        return this.getDataStoreCallable;
    }

    @Override
    public UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> listDataStoresCallable() {
        return this.listDataStoresCallable;
    }

    @Override
    public UnaryCallable<ListDataStoresRequest, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresPagedCallable() {
        return this.listDataStoresPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteDataStoreRequest, Operation> deleteDataStoreCallable() {
        return this.deleteDataStoreCallable;
    }

    @Override
    public OperationCallable<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationCallable() {
        return this.deleteDataStoreOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDataStoreRequest, DataStore> updateDataStoreCallable() {
        return this.updateDataStoreCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

