/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.GetProjectRequest;
import com.google.cloud.discoveryengine.v1alpha.Project;
import com.google.cloud.discoveryengine.v1alpha.ProjectName;
import com.google.cloud.discoveryengine.v1alpha.ProjectServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.ProvisionProjectMetadata;
import com.google.cloud.discoveryengine.v1alpha.ProvisionProjectRequest;
import com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.ProjectServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.ProjectServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProjectServiceClient
implements BackgroundResource {
    private final ProjectServiceSettings settings;
    private final ProjectServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ProjectServiceClient create() throws IOException {
        return ProjectServiceClient.create(ProjectServiceSettings.newBuilder().build());
    }

    public static final ProjectServiceClient create(ProjectServiceSettings settings) throws IOException {
        return new ProjectServiceClient(settings);
    }

    public static final ProjectServiceClient create(ProjectServiceStub stub) {
        return new ProjectServiceClient(stub);
    }

    protected ProjectServiceClient(ProjectServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ProjectServiceClient(ProjectServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ProjectServiceSettings getSettings() {
        return this.settings;
    }

    public ProjectServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Project getProject(ProjectName name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProject(request);
    }

    public final Project getProject(String name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name).build();
        return this.getProject(request);
    }

    public final Project getProject(GetProjectRequest request) {
        return (Project)this.getProjectCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.stub.getProjectCallable();
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(ProjectName name) {
        ProvisionProjectRequest request = ProvisionProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.provisionProjectAsync(request);
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(String name) {
        ProvisionProjectRequest request = ProvisionProjectRequest.newBuilder().setName(name).build();
        return this.provisionProjectAsync(request);
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(ProvisionProjectRequest request) {
        return this.provisionProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable() {
        return this.stub.provisionProjectOperationCallable();
    }

    public final UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable() {
        return this.stub.provisionProjectCallable();
    }

    public final Project reportConsentChange(ReportConsentChangeRequest.ConsentChangeAction consentChangeAction, ProjectName project, String serviceTermId, String serviceTermVersion) {
        ReportConsentChangeRequest request = ReportConsentChangeRequest.newBuilder().setConsentChangeAction(consentChangeAction).setProject(project == null ? null : project.toString()).setServiceTermId(serviceTermId).setServiceTermVersion(serviceTermVersion).build();
        return this.reportConsentChange(request);
    }

    public final Project reportConsentChange(ReportConsentChangeRequest.ConsentChangeAction consentChangeAction, String project, String serviceTermId, String serviceTermVersion) {
        ReportConsentChangeRequest request = ReportConsentChangeRequest.newBuilder().setConsentChangeAction(consentChangeAction).setProject(project).setServiceTermId(serviceTermId).setServiceTermVersion(serviceTermVersion).build();
        return this.reportConsentChange(request);
    }

    public final Project reportConsentChange(ReportConsentChangeRequest request) {
        return (Project)this.reportConsentChangeCallable().call((Object)request);
    }

    public final UnaryCallable<ReportConsentChangeRequest, Project> reportConsentChangeCallable() {
        return this.stub.reportConsentChangeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

