/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Answer;
import com.google.cloud.discoveryengine.v1beta.AnswerQueryRequest;
import com.google.cloud.discoveryengine.v1beta.AnswerQueryResponse;
import com.google.cloud.discoveryengine.v1beta.Conversation;
import com.google.cloud.discoveryengine.v1beta.ConversationalSearchServiceClient;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationRequest;
import com.google.cloud.discoveryengine.v1beta.ConverseConversationResponse;
import com.google.cloud.discoveryengine.v1beta.CreateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteConversationRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1beta.GetAnswerRequest;
import com.google.cloud.discoveryengine.v1beta.GetConversationRequest;
import com.google.cloud.discoveryengine.v1beta.GetSessionRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsRequest;
import com.google.cloud.discoveryengine.v1beta.ListConversationsResponse;
import com.google.cloud.discoveryengine.v1beta.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1beta.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1beta.Session;
import com.google.cloud.discoveryengine.v1beta.UpdateConversationRequest;
import com.google.cloud.discoveryengine.v1beta.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonConversationalSearchServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ConversationalSearchServiceStubSettings
extends StubSettings<ConversationalSearchServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings;
    private final UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings;
    private final UnaryCallSettings<DeleteConversationRequest, Empty> deleteConversationSettings;
    private final UnaryCallSettings<UpdateConversationRequest, Conversation> updateConversationSettings;
    private final UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings;
    private final PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings;
    private final UnaryCallSettings<AnswerQueryRequest, AnswerQueryResponse> answerQuerySettings;
    private final UnaryCallSettings<GetAnswerRequest, Answer> getAnswerSettings;
    private final UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings;
    private final UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings;
    private final UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings;
    private final UnaryCallSettings<GetSessionRequest, Session> getSessionSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse> listSessionsSettings;
    private static final PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation> LIST_CONVERSATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationsRequest injectToken(ListConversationsRequest payload, String token) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageToken(token).build();
        }

        public ListConversationsRequest injectPageSize(ListConversationsRequest payload, int pageSize) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Conversation> extractResources(ListConversationsResponse payload) {
            return payload.getConversationsList() == null ? ImmutableList.of() : payload.getConversationsList();
        }
    };
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList() == null ? ImmutableList.of() : payload.getSessionsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> LIST_CONVERSATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse>(){

        public ApiFuture<ConversationalSearchServiceClient.ListConversationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationsRequest, ListConversationsResponse> callable, ListConversationsRequest request, ApiCallContext context, ApiFuture<ListConversationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationalSearchServiceClient.ListConversationsPagedResponse.createAsync((PageContext<ListConversationsRequest, ListConversationsResponse, Conversation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse>(){

        public ApiFuture<ConversationalSearchServiceClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationalSearchServiceClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings() {
        return this.converseConversationSettings;
    }

    public UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings() {
        return this.createConversationSettings;
    }

    public UnaryCallSettings<DeleteConversationRequest, Empty> deleteConversationSettings() {
        return this.deleteConversationSettings;
    }

    public UnaryCallSettings<UpdateConversationRequest, Conversation> updateConversationSettings() {
        return this.updateConversationSettings;
    }

    public UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings() {
        return this.getConversationSettings;
    }

    public PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
        return this.listConversationsSettings;
    }

    public UnaryCallSettings<AnswerQueryRequest, AnswerQueryResponse> answerQuerySettings() {
        return this.answerQuerySettings;
    }

    public UnaryCallSettings<GetAnswerRequest, Answer> getAnswerSettings() {
        return this.getAnswerSettings;
    }

    public UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings() {
        return this.createSessionSettings;
    }

    public UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings() {
        return this.deleteSessionSettings;
    }

    public UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings() {
        return this.updateSessionSettings;
    }

    public UnaryCallSettings<GetSessionRequest, Session> getSessionSettings() {
        return this.getSessionSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public ConversationalSearchServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationalSearchServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationalSearchServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationalSearchServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationalSearchServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationalSearchServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationalSearchServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationalSearchServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.converseConversationSettings = settingsBuilder.converseConversationSettings().build();
        this.createConversationSettings = settingsBuilder.createConversationSettings().build();
        this.deleteConversationSettings = settingsBuilder.deleteConversationSettings().build();
        this.updateConversationSettings = settingsBuilder.updateConversationSettings().build();
        this.getConversationSettings = settingsBuilder.getConversationSettings().build();
        this.listConversationsSettings = settingsBuilder.listConversationsSettings().build();
        this.answerQuerySettings = settingsBuilder.answerQuerySettings().build();
        this.getAnswerSettings = settingsBuilder.getAnswerSettings().build();
        this.createSessionSettings = settingsBuilder.createSessionSettings().build();
        this.deleteSessionSettings = settingsBuilder.deleteSessionSettings().build();
        this.updateSessionSettings = settingsBuilder.updateSessionSettings().build();
        this.getSessionSettings = settingsBuilder.getSessionSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationalSearchServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings;
        private final UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings;
        private final UnaryCallSettings.Builder<DeleteConversationRequest, Empty> deleteConversationSettings;
        private final UnaryCallSettings.Builder<UpdateConversationRequest, Conversation> updateConversationSettings;
        private final UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings;
        private final PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings;
        private final UnaryCallSettings.Builder<AnswerQueryRequest, AnswerQueryResponse> answerQuerySettings;
        private final UnaryCallSettings.Builder<GetAnswerRequest, Answer> getAnswerSettings;
        private final UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings;
        private final UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings;
        private final UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings;
        private final UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse> listSessionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.converseConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATIONS_PAGE_STR_FACT);
            this.answerQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAnswerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.converseConversationSettings, this.createConversationSettings, this.deleteConversationSettings, this.updateConversationSettings, this.getConversationSettings, this.listConversationsSettings, this.answerQuerySettings, this.getAnswerSettings, this.createSessionSettings, this.deleteSessionSettings, this.updateSessionSettings, this.getSessionSettings, (Object[])new UnaryCallSettings.Builder[]{this.listSessionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ConversationalSearchServiceStubSettings settings) {
            super((StubSettings)settings);
            this.converseConversationSettings = settings.converseConversationSettings.toBuilder();
            this.createConversationSettings = settings.createConversationSettings.toBuilder();
            this.deleteConversationSettings = settings.deleteConversationSettings.toBuilder();
            this.updateConversationSettings = settings.updateConversationSettings.toBuilder();
            this.getConversationSettings = settings.getConversationSettings.toBuilder();
            this.listConversationsSettings = settings.listConversationsSettings.toBuilder();
            this.answerQuerySettings = settings.answerQuerySettings.toBuilder();
            this.getAnswerSettings = settings.getAnswerSettings.toBuilder();
            this.createSessionSettings = settings.createSessionSettings.toBuilder();
            this.deleteSessionSettings = settings.deleteSessionSettings.toBuilder();
            this.updateSessionSettings = settings.updateSessionSettings.toBuilder();
            this.getSessionSettings = settings.getSessionSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.converseConversationSettings, this.createConversationSettings, this.deleteConversationSettings, this.updateConversationSettings, this.getConversationSettings, this.listConversationsSettings, this.answerQuerySettings, this.getAnswerSettings, this.createSessionSettings, this.deleteSessionSettings, this.updateSessionSettings, this.getSessionSettings, (Object[])new UnaryCallSettings.Builder[]{this.listSessionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationalSearchServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationalSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationalSearchServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationalSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationalSearchServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationalSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationalSearchServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationalSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.converseConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listConversationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.answerQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getAnswerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings() {
            return this.converseConversationSettings;
        }

        public UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings() {
            return this.createConversationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConversationRequest, Empty> deleteConversationSettings() {
            return this.deleteConversationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConversationRequest, Conversation> updateConversationSettings() {
            return this.updateConversationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings() {
            return this.getConversationSettings;
        }

        public PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
            return this.listConversationsSettings;
        }

        public UnaryCallSettings.Builder<AnswerQueryRequest, AnswerQueryResponse> answerQuerySettings() {
            return this.answerQuerySettings;
        }

        public UnaryCallSettings.Builder<GetAnswerRequest, Answer> getAnswerSettings() {
            return this.getAnswerSettings;
        }

        public UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings() {
            return this.createSessionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings() {
            return this.deleteSessionSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings() {
            return this.updateSessionSettings;
        }

        public UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings() {
            return this.getSessionSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, ConversationalSearchServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public ConversationalSearchServiceStubSettings build() throws IOException {
            return new ConversationalSearchServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

