/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.discoveryengine.v1alpha.stub;

import static com.google.cloud.discoveryengine.v1alpha.ChunkServiceClient.ListChunksPagedResponse;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.Chunk;
import com.google.cloud.discoveryengine.v1alpha.GetChunkRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksResponse;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Base stub class for the ChunkService service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public abstract class ChunkServiceStub implements BackgroundResource {

  public UnaryCallable<GetChunkRequest, Chunk> getChunkCallable() {
    throw new UnsupportedOperationException("Not implemented: getChunkCallable()");
  }

  public UnaryCallable<ListChunksRequest, ListChunksPagedResponse> listChunksPagedCallable() {
    throw new UnsupportedOperationException("Not implemented: listChunksPagedCallable()");
  }

  public UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable() {
    throw new UnsupportedOperationException("Not implemented: listChunksCallable()");
  }

  @Override
  public abstract void close();
}
