/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.GetSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQuerySetsRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse;
import com.google.cloud.discoveryengine.v1beta.LocationName;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySet;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySetName;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySetServiceSettings;
import com.google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQuerySetServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQuerySetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SampleQuerySetServiceClient
implements BackgroundResource {
    private final SampleQuerySetServiceSettings settings;
    private final SampleQuerySetServiceStub stub;

    public static final SampleQuerySetServiceClient create() throws IOException {
        return SampleQuerySetServiceClient.create(SampleQuerySetServiceSettings.newBuilder().build());
    }

    public static final SampleQuerySetServiceClient create(SampleQuerySetServiceSettings settings) throws IOException {
        return new SampleQuerySetServiceClient(settings);
    }

    public static final SampleQuerySetServiceClient create(SampleQuerySetServiceStub stub) {
        return new SampleQuerySetServiceClient(stub);
    }

    protected SampleQuerySetServiceClient(SampleQuerySetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SampleQuerySetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SampleQuerySetServiceClient(SampleQuerySetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SampleQuerySetServiceSettings getSettings() {
        return this.settings;
    }

    public SampleQuerySetServiceStub getStub() {
        return this.stub;
    }

    public final SampleQuerySet getSampleQuerySet(SampleQuerySetName name) {
        GetSampleQuerySetRequest request = GetSampleQuerySetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSampleQuerySet(request);
    }

    public final SampleQuerySet getSampleQuerySet(String name) {
        GetSampleQuerySetRequest request = GetSampleQuerySetRequest.newBuilder().setName(name).build();
        return this.getSampleQuerySet(request);
    }

    public final SampleQuerySet getSampleQuerySet(GetSampleQuerySetRequest request) {
        return (SampleQuerySet)this.getSampleQuerySetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSampleQuerySetRequest, SampleQuerySet> getSampleQuerySetCallable() {
        return this.stub.getSampleQuerySetCallable();
    }

    public final ListSampleQuerySetsPagedResponse listSampleQuerySets(LocationName parent) {
        ListSampleQuerySetsRequest request = ListSampleQuerySetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSampleQuerySets(request);
    }

    public final ListSampleQuerySetsPagedResponse listSampleQuerySets(String parent) {
        ListSampleQuerySetsRequest request = ListSampleQuerySetsRequest.newBuilder().setParent(parent).build();
        return this.listSampleQuerySets(request);
    }

    public final ListSampleQuerySetsPagedResponse listSampleQuerySets(ListSampleQuerySetsRequest request) {
        return (ListSampleQuerySetsPagedResponse)((Object)this.listSampleQuerySetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSampleQuerySetsRequest, ListSampleQuerySetsPagedResponse> listSampleQuerySetsPagedCallable() {
        return this.stub.listSampleQuerySetsPagedCallable();
    }

    public final UnaryCallable<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse> listSampleQuerySetsCallable() {
        return this.stub.listSampleQuerySetsCallable();
    }

    public final SampleQuerySet createSampleQuerySet(LocationName parent, SampleQuerySet sampleQuerySet, String sampleQuerySetId) {
        CreateSampleQuerySetRequest request = CreateSampleQuerySetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSampleQuerySet(sampleQuerySet).setSampleQuerySetId(sampleQuerySetId).build();
        return this.createSampleQuerySet(request);
    }

    public final SampleQuerySet createSampleQuerySet(String parent, SampleQuerySet sampleQuerySet, String sampleQuerySetId) {
        CreateSampleQuerySetRequest request = CreateSampleQuerySetRequest.newBuilder().setParent(parent).setSampleQuerySet(sampleQuerySet).setSampleQuerySetId(sampleQuerySetId).build();
        return this.createSampleQuerySet(request);
    }

    public final SampleQuerySet createSampleQuerySet(CreateSampleQuerySetRequest request) {
        return (SampleQuerySet)this.createSampleQuerySetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSampleQuerySetRequest, SampleQuerySet> createSampleQuerySetCallable() {
        return this.stub.createSampleQuerySetCallable();
    }

    public final SampleQuerySet updateSampleQuerySet(SampleQuerySet sampleQuerySet, FieldMask updateMask) {
        UpdateSampleQuerySetRequest request = UpdateSampleQuerySetRequest.newBuilder().setSampleQuerySet(sampleQuerySet).setUpdateMask(updateMask).build();
        return this.updateSampleQuerySet(request);
    }

    public final SampleQuerySet updateSampleQuerySet(UpdateSampleQuerySetRequest request) {
        return (SampleQuerySet)this.updateSampleQuerySetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSampleQuerySetRequest, SampleQuerySet> updateSampleQuerySetCallable() {
        return this.stub.updateSampleQuerySetCallable();
    }

    public final void deleteSampleQuerySet(SampleQuerySetName name) {
        DeleteSampleQuerySetRequest request = DeleteSampleQuerySetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSampleQuerySet(request);
    }

    public final void deleteSampleQuerySet(String name) {
        DeleteSampleQuerySetRequest request = DeleteSampleQuerySetRequest.newBuilder().setName(name).build();
        this.deleteSampleQuerySet(request);
    }

    public final void deleteSampleQuerySet(DeleteSampleQuerySetRequest request) {
        this.deleteSampleQuerySetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSampleQuerySetRequest, Empty> deleteSampleQuerySetCallable() {
        return this.stub.deleteSampleQuerySetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSampleQuerySetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet, ListSampleQuerySetsPage, ListSampleQuerySetsFixedSizeCollection> {
        private ListSampleQuerySetsFixedSizeCollection(List<ListSampleQuerySetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSampleQuerySetsFixedSizeCollection createEmptyCollection() {
            return new ListSampleQuerySetsFixedSizeCollection(null, 0);
        }

        protected ListSampleQuerySetsFixedSizeCollection createCollection(List<ListSampleQuerySetsPage> pages, int collectionSize) {
            return new ListSampleQuerySetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSampleQuerySetsPage
    extends AbstractPage<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet, ListSampleQuerySetsPage> {
        private ListSampleQuerySetsPage(PageContext<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet> context, ListSampleQuerySetsResponse response) {
            super(context, (Object)response);
        }

        private static ListSampleQuerySetsPage createEmptyPage() {
            return new ListSampleQuerySetsPage(null, null);
        }

        protected ListSampleQuerySetsPage createPage(PageContext<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet> context, ListSampleQuerySetsResponse response) {
            return new ListSampleQuerySetsPage(context, response);
        }

        public ApiFuture<ListSampleQuerySetsPage> createPageAsync(PageContext<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet> context, ApiFuture<ListSampleQuerySetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSampleQuerySetsPagedResponse
    extends AbstractPagedListResponse<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet, ListSampleQuerySetsPage, ListSampleQuerySetsFixedSizeCollection> {
        public static ApiFuture<ListSampleQuerySetsPagedResponse> createAsync(PageContext<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet> context, ApiFuture<ListSampleQuerySetsResponse> futureResponse) {
            ApiFuture<ListSampleQuerySetsPage> futurePage = ListSampleQuerySetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSampleQuerySetsPagedResponse((ListSampleQuerySetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSampleQuerySetsPagedResponse(ListSampleQuerySetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSampleQuerySetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

