/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateEvaluationMetadata;
import com.google.cloud.discoveryengine.v1beta.CreateEvaluationRequest;
import com.google.cloud.discoveryengine.v1beta.Evaluation;
import com.google.cloud.discoveryengine.v1beta.EvaluationServiceClient;
import com.google.cloud.discoveryengine.v1beta.GetEvaluationRequest;
import com.google.cloud.discoveryengine.v1beta.ListEvaluationResultsRequest;
import com.google.cloud.discoveryengine.v1beta.ListEvaluationResultsResponse;
import com.google.cloud.discoveryengine.v1beta.ListEvaluationsRequest;
import com.google.cloud.discoveryengine.v1beta.ListEvaluationsResponse;
import com.google.cloud.discoveryengine.v1beta.stub.EvaluationServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcEvaluationServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonEvaluationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class EvaluationServiceStubSettings
extends StubSettings<EvaluationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetEvaluationRequest, Evaluation> getEvaluationSettings;
    private final PagedCallSettings<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings;
    private final UnaryCallSettings<CreateEvaluationRequest, Operation> createEvaluationSettings;
    private final OperationCallSettings<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationSettings;
    private final PagedCallSettings<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsSettings;
    private static final PagedListDescriptor<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> LIST_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListEvaluationsRequest injectToken(ListEvaluationsRequest payload, String token) {
            return ListEvaluationsRequest.newBuilder((ListEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListEvaluationsRequest injectPageSize(ListEvaluationsRequest payload, int pageSize) {
            return ListEvaluationsRequest.newBuilder((ListEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Evaluation> extractResources(ListEvaluationsResponse payload) {
            return payload.getEvaluationsList();
        }
    };
    private static final PagedListDescriptor<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult> LIST_EVALUATION_RESULTS_PAGE_STR_DESC = new PagedListDescriptor<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult>(){

        public String emptyToken() {
            return "";
        }

        public ListEvaluationResultsRequest injectToken(ListEvaluationResultsRequest payload, String token) {
            return ListEvaluationResultsRequest.newBuilder((ListEvaluationResultsRequest)payload).setPageToken(token).build();
        }

        public ListEvaluationResultsRequest injectPageSize(ListEvaluationResultsRequest payload, int pageSize) {
            return ListEvaluationResultsRequest.newBuilder((ListEvaluationResultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEvaluationResultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEvaluationResultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ListEvaluationResultsResponse.EvaluationResult> extractResources(ListEvaluationResultsResponse payload) {
            return payload.getEvaluationResultsList();
        }
    };
    private static final PagedListResponseFactory<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse> LIST_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse>(){

        public ApiFuture<EvaluationServiceClient.ListEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEvaluationsRequest, ListEvaluationsResponse> callable, ListEvaluationsRequest request, ApiCallContext context, ApiFuture<ListEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EvaluationServiceClient.ListEvaluationsPagedResponse.createAsync((PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse> LIST_EVALUATION_RESULTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse>(){

        public ApiFuture<EvaluationServiceClient.ListEvaluationResultsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEvaluationResultsRequest, ListEvaluationResultsResponse> callable, ListEvaluationResultsRequest request, ApiCallContext context, ApiFuture<ListEvaluationResultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVALUATION_RESULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EvaluationServiceClient.ListEvaluationResultsPagedResponse.createAsync((PageContext<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetEvaluationRequest, Evaluation> getEvaluationSettings() {
        return this.getEvaluationSettings;
    }

    public PagedCallSettings<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings() {
        return this.listEvaluationsSettings;
    }

    public UnaryCallSettings<CreateEvaluationRequest, Operation> createEvaluationSettings() {
        return this.createEvaluationSettings;
    }

    public OperationCallSettings<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationSettings() {
        return this.createEvaluationOperationSettings;
    }

    public PagedCallSettings<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsSettings() {
        return this.listEvaluationResultsSettings;
    }

    public EvaluationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEvaluationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEvaluationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EvaluationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EvaluationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EvaluationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EvaluationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EvaluationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getEvaluationSettings = settingsBuilder.getEvaluationSettings().build();
        this.listEvaluationsSettings = settingsBuilder.listEvaluationsSettings().build();
        this.createEvaluationSettings = settingsBuilder.createEvaluationSettings().build();
        this.createEvaluationOperationSettings = settingsBuilder.createEvaluationOperationSettings().build();
        this.listEvaluationResultsSettings = settingsBuilder.listEvaluationResultsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EvaluationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetEvaluationRequest, Evaluation> getEvaluationSettings;
        private final PagedCallSettings.Builder<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings;
        private final UnaryCallSettings.Builder<CreateEvaluationRequest, Operation> createEvaluationSettings;
        private final OperationCallSettings.Builder<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationSettings;
        private final PagedCallSettings.Builder<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVALUATIONS_PAGE_STR_FACT);
            this.createEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEvaluationOperationSettings = OperationCallSettings.newBuilder();
            this.listEvaluationResultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVALUATION_RESULTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEvaluationSettings, this.listEvaluationsSettings, this.createEvaluationSettings, this.listEvaluationResultsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EvaluationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getEvaluationSettings = settings.getEvaluationSettings.toBuilder();
            this.listEvaluationsSettings = settings.listEvaluationsSettings.toBuilder();
            this.createEvaluationSettings = settings.createEvaluationSettings.toBuilder();
            this.createEvaluationOperationSettings = settings.createEvaluationOperationSettings.toBuilder();
            this.listEvaluationResultsSettings = settings.listEvaluationResultsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEvaluationSettings, this.listEvaluationsSettings, this.createEvaluationSettings, this.listEvaluationResultsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EvaluationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EvaluationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EvaluationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EvaluationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EvaluationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EvaluationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EvaluationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EvaluationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listEvaluationResultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createEvaluationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Evaluation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateEvaluationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetEvaluationRequest, Evaluation> getEvaluationSettings() {
            return this.getEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListEvaluationsRequest, ListEvaluationsResponse, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsSettings() {
            return this.listEvaluationsSettings;
        }

        public UnaryCallSettings.Builder<CreateEvaluationRequest, Operation> createEvaluationSettings() {
            return this.createEvaluationSettings;
        }

        public OperationCallSettings.Builder<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationSettings() {
            return this.createEvaluationOperationSettings;
        }

        public PagedCallSettings.Builder<ListEvaluationResultsRequest, ListEvaluationResultsResponse, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsSettings() {
            return this.listEvaluationResultsSettings;
        }

        public EvaluationServiceStubSettings build() throws IOException {
            return new EvaluationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

