/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.RecommendRequest;
import com.google.cloud.discoveryengine.v1alpha.RecommendResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcRecommendationServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.RecommendationServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.RecommendationServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcRecommendationServiceStub
extends RecommendationServiceStub {
    private static final MethodDescriptor<RecommendRequest, RecommendResponse> recommendMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.RecommendationService/Recommend").setRequestMarshaller(ProtoUtils.marshaller((Message)RecommendRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RecommendResponse.getDefaultInstance())).build();
    private final UnaryCallable<RecommendRequest, RecommendResponse> recommendCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRecommendationServiceStub create(RecommendationServiceStubSettings settings) throws IOException {
        return new GrpcRecommendationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRecommendationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRecommendationServiceStub(RecommendationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRecommendationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRecommendationServiceStub(RecommendationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRecommendationServiceStub(RecommendationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRecommendationServiceCallableFactory());
    }

    protected GrpcRecommendationServiceStub(RecommendationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings recommendTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(recommendMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config", String.valueOf(request.getServingConfig()));
            return builder.build();
        }).build();
        this.recommendCallable = callableFactory.createUnaryCallable(recommendTransportSettings, settings.recommendSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RecommendRequest, RecommendResponse> recommendCallable() {
        return this.recommendCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

