/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryResponse;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsMetadata;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsResponse;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsMetadata;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsRequest;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsResponse;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.CompletionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.CompletionServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcCompletionServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCompletionServiceStub
extends CompletionServiceStub {
    private static final MethodDescriptor<CompleteQueryRequest, CompleteQueryResponse> completeQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/CompleteQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompleteQueryResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/ImportSuggestionDenyListEntries").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportSuggestionDenyListEntriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/PurgeSuggestionDenyListEntries").setRequestMarshaller(ProtoUtils.marshaller((Message)PurgeSuggestionDenyListEntriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/ImportCompletionSuggestions").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportCompletionSuggestionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.CompletionService/PurgeCompletionSuggestions").setRequestMarshaller(ProtoUtils.marshaller((Message)PurgeCompletionSuggestionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable;
    private final UnaryCallable<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesCallable;
    private final OperationCallable<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationCallable;
    private final UnaryCallable<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesCallable;
    private final OperationCallable<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationCallable;
    private final UnaryCallable<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsCallable;
    private final OperationCallable<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationCallable;
    private final UnaryCallable<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsCallable;
    private final OperationCallable<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCompletionServiceStub create(CompletionServiceStubSettings settings) throws IOException {
        return new GrpcCompletionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCompletionServiceCallableFactory());
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings completeQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store", String.valueOf(request.getDataStore()));
            return builder.build();
        }).build();
        GrpcCallSettings importSuggestionDenyListEntriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importSuggestionDenyListEntriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings purgeSuggestionDenyListEntriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(purgeSuggestionDenyListEntriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings importCompletionSuggestionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importCompletionSuggestionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings purgeCompletionSuggestionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(purgeCompletionSuggestionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.completeQueryCallable = callableFactory.createUnaryCallable(completeQueryTransportSettings, settings.completeQuerySettings(), clientContext);
        this.importSuggestionDenyListEntriesCallable = callableFactory.createUnaryCallable(importSuggestionDenyListEntriesTransportSettings, settings.importSuggestionDenyListEntriesSettings(), clientContext);
        this.importSuggestionDenyListEntriesOperationCallable = callableFactory.createOperationCallable(importSuggestionDenyListEntriesTransportSettings, settings.importSuggestionDenyListEntriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.purgeSuggestionDenyListEntriesCallable = callableFactory.createUnaryCallable(purgeSuggestionDenyListEntriesTransportSettings, settings.purgeSuggestionDenyListEntriesSettings(), clientContext);
        this.purgeSuggestionDenyListEntriesOperationCallable = callableFactory.createOperationCallable(purgeSuggestionDenyListEntriesTransportSettings, settings.purgeSuggestionDenyListEntriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importCompletionSuggestionsCallable = callableFactory.createUnaryCallable(importCompletionSuggestionsTransportSettings, settings.importCompletionSuggestionsSettings(), clientContext);
        this.importCompletionSuggestionsOperationCallable = callableFactory.createOperationCallable(importCompletionSuggestionsTransportSettings, settings.importCompletionSuggestionsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.purgeCompletionSuggestionsCallable = callableFactory.createUnaryCallable(purgeCompletionSuggestionsTransportSettings, settings.purgeCompletionSuggestionsSettings(), clientContext);
        this.purgeCompletionSuggestionsOperationCallable = callableFactory.createOperationCallable(purgeCompletionSuggestionsTransportSettings, settings.purgeCompletionSuggestionsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.completeQueryCallable;
    }

    @Override
    public UnaryCallable<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesCallable() {
        return this.importSuggestionDenyListEntriesCallable;
    }

    @Override
    public OperationCallable<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationCallable() {
        return this.importSuggestionDenyListEntriesOperationCallable;
    }

    @Override
    public UnaryCallable<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesCallable() {
        return this.purgeSuggestionDenyListEntriesCallable;
    }

    @Override
    public OperationCallable<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationCallable() {
        return this.purgeSuggestionDenyListEntriesOperationCallable;
    }

    @Override
    public UnaryCallable<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsCallable() {
        return this.importCompletionSuggestionsCallable;
    }

    @Override
    public OperationCallable<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationCallable() {
        return this.importCompletionSuggestionsOperationCallable;
    }

    @Override
    public UnaryCallable<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsCallable() {
        return this.purgeCompletionSuggestionsCallable;
    }

    @Override
    public OperationCallable<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationCallable() {
        return this.purgeCompletionSuggestionsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

