/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateEvaluationMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateEvaluationRequest;
import com.google.cloud.discoveryengine.v1alpha.Evaluation;
import com.google.cloud.discoveryengine.v1alpha.EvaluationServiceClient;
import com.google.cloud.discoveryengine.v1alpha.GetEvaluationRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationResultsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationResultsResponse;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationsResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.EvaluationServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EvaluationServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcEvaluationServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcEvaluationServiceStub
extends EvaluationServiceStub {
    private static final MethodDescriptor<GetEvaluationRequest, Evaluation> getEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EvaluationService/GetEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Evaluation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEvaluationsRequest, ListEvaluationsResponse> listEvaluationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EvaluationService/ListEvaluations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEvaluationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEvaluationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateEvaluationRequest, Operation> createEvaluationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EvaluationService/CreateEvaluation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEvaluationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEvaluationResultsRequest, ListEvaluationResultsResponse> listEvaluationResultsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EvaluationService/ListEvaluationResults").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEvaluationResultsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEvaluationResultsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetEvaluationRequest, Evaluation> getEvaluationCallable;
    private final UnaryCallable<ListEvaluationsRequest, ListEvaluationsResponse> listEvaluationsCallable;
    private final UnaryCallable<ListEvaluationsRequest, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsPagedCallable;
    private final UnaryCallable<CreateEvaluationRequest, Operation> createEvaluationCallable;
    private final OperationCallable<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationCallable;
    private final UnaryCallable<ListEvaluationResultsRequest, ListEvaluationResultsResponse> listEvaluationResultsCallable;
    private final UnaryCallable<ListEvaluationResultsRequest, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEvaluationServiceStub create(EvaluationServiceStubSettings settings) throws IOException {
        return new GrpcEvaluationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEvaluationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEvaluationServiceStub(EvaluationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEvaluationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEvaluationServiceStub(EvaluationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEvaluationServiceStub(EvaluationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEvaluationServiceCallableFactory());
    }

    protected GrpcEvaluationServiceStub(EvaluationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEvaluationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listEvaluationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEvaluationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createEvaluationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEvaluationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listEvaluationResultsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEvaluationResultsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("evaluation", String.valueOf(request.getEvaluation()));
            return builder.build();
        }).build();
        this.getEvaluationCallable = callableFactory.createUnaryCallable(getEvaluationTransportSettings, settings.getEvaluationSettings(), clientContext);
        this.listEvaluationsCallable = callableFactory.createUnaryCallable(listEvaluationsTransportSettings, settings.listEvaluationsSettings(), clientContext);
        this.listEvaluationsPagedCallable = callableFactory.createPagedCallable(listEvaluationsTransportSettings, settings.listEvaluationsSettings(), clientContext);
        this.createEvaluationCallable = callableFactory.createUnaryCallable(createEvaluationTransportSettings, settings.createEvaluationSettings(), clientContext);
        this.createEvaluationOperationCallable = callableFactory.createOperationCallable(createEvaluationTransportSettings, settings.createEvaluationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listEvaluationResultsCallable = callableFactory.createUnaryCallable(listEvaluationResultsTransportSettings, settings.listEvaluationResultsSettings(), clientContext);
        this.listEvaluationResultsPagedCallable = callableFactory.createPagedCallable(listEvaluationResultsTransportSettings, settings.listEvaluationResultsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetEvaluationRequest, Evaluation> getEvaluationCallable() {
        return this.getEvaluationCallable;
    }

    @Override
    public UnaryCallable<ListEvaluationsRequest, ListEvaluationsResponse> listEvaluationsCallable() {
        return this.listEvaluationsCallable;
    }

    @Override
    public UnaryCallable<ListEvaluationsRequest, EvaluationServiceClient.ListEvaluationsPagedResponse> listEvaluationsPagedCallable() {
        return this.listEvaluationsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateEvaluationRequest, Operation> createEvaluationCallable() {
        return this.createEvaluationCallable;
    }

    @Override
    public OperationCallable<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationCallable() {
        return this.createEvaluationOperationCallable;
    }

    @Override
    public UnaryCallable<ListEvaluationResultsRequest, ListEvaluationResultsResponse> listEvaluationResultsCallable() {
        return this.listEvaluationResultsCallable;
    }

    @Override
    public UnaryCallable<ListEvaluationResultsRequest, EvaluationServiceClient.ListEvaluationResultsPagedResponse> listEvaluationResultsPagedCallable() {
        return this.listEvaluationResultsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

