/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dlp.v2beta1.DlpServiceSettings;
import com.google.cloud.dlp.v2beta1.stub.DlpServiceStub;
import com.google.cloud.dlp.v2beta1.stub.DlpServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.privacy.dlp.v2beta1.AnalyzeDataSourceRiskRequest;
import com.google.privacy.dlp.v2beta1.BigQueryTable;
import com.google.privacy.dlp.v2beta1.ContentItem;
import com.google.privacy.dlp.v2beta1.CreateInspectOperationRequest;
import com.google.privacy.dlp.v2beta1.DeidentifyConfig;
import com.google.privacy.dlp.v2beta1.DeidentifyContentRequest;
import com.google.privacy.dlp.v2beta1.DeidentifyContentResponse;
import com.google.privacy.dlp.v2beta1.InspectConfig;
import com.google.privacy.dlp.v2beta1.InspectContentRequest;
import com.google.privacy.dlp.v2beta1.InspectContentResponse;
import com.google.privacy.dlp.v2beta1.InspectOperationMetadata;
import com.google.privacy.dlp.v2beta1.InspectOperationResult;
import com.google.privacy.dlp.v2beta1.ListInfoTypesRequest;
import com.google.privacy.dlp.v2beta1.ListInfoTypesResponse;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsRequest;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsResponse;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesRequest;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesResponse;
import com.google.privacy.dlp.v2beta1.OutputStorageConfig;
import com.google.privacy.dlp.v2beta1.PrivacyMetric;
import com.google.privacy.dlp.v2beta1.RedactContentRequest;
import com.google.privacy.dlp.v2beta1.RedactContentResponse;
import com.google.privacy.dlp.v2beta1.ResultName;
import com.google.privacy.dlp.v2beta1.RiskAnalysisOperationMetadata;
import com.google.privacy.dlp.v2beta1.RiskAnalysisOperationResult;
import com.google.privacy.dlp.v2beta1.StorageConfig;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DlpServiceClient
implements BackgroundResource {
    private final DlpServiceSettings settings;
    private final DlpServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DlpServiceClient create() throws IOException {
        return DlpServiceClient.create(DlpServiceSettings.newBuilder().build());
    }

    public static final DlpServiceClient create(DlpServiceSettings settings) throws IOException {
        return new DlpServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DlpServiceClient create(DlpServiceStub stub) {
        return new DlpServiceClient(stub);
    }

    protected DlpServiceClient(DlpServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DlpServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DlpServiceClient(DlpServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DlpServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DlpServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final InspectContentResponse inspectContent(InspectConfig inspectConfig, List<ContentItem> items) {
        InspectContentRequest request = InspectContentRequest.newBuilder().setInspectConfig(inspectConfig).addAllItems(items).build();
        return this.inspectContent(request);
    }

    public final InspectContentResponse inspectContent(InspectContentRequest request) {
        return (InspectContentResponse)this.inspectContentCallable().call((Object)request);
    }

    public final UnaryCallable<InspectContentRequest, InspectContentResponse> inspectContentCallable() {
        return this.stub.inspectContentCallable();
    }

    public final RedactContentResponse redactContent(RedactContentRequest request) {
        return (RedactContentResponse)this.redactContentCallable().call((Object)request);
    }

    public final UnaryCallable<RedactContentRequest, RedactContentResponse> redactContentCallable() {
        return this.stub.redactContentCallable();
    }

    public final DeidentifyContentResponse deidentifyContent(DeidentifyConfig deidentifyConfig, InspectConfig inspectConfig, List<ContentItem> items) {
        DeidentifyContentRequest request = DeidentifyContentRequest.newBuilder().setDeidentifyConfig(deidentifyConfig).setInspectConfig(inspectConfig).addAllItems(items).build();
        return this.deidentifyContent(request);
    }

    public final DeidentifyContentResponse deidentifyContent(DeidentifyContentRequest request) {
        return (DeidentifyContentResponse)this.deidentifyContentCallable().call((Object)request);
    }

    public final UnaryCallable<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentCallable() {
        return this.stub.deidentifyContentCallable();
    }

    public final OperationFuture<RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskAsync(PrivacyMetric privacyMetric, BigQueryTable sourceTable) {
        AnalyzeDataSourceRiskRequest request = AnalyzeDataSourceRiskRequest.newBuilder().setPrivacyMetric(privacyMetric).setSourceTable(sourceTable).build();
        return this.analyzeDataSourceRiskAsync(request);
    }

    public final OperationFuture<RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskAsync(AnalyzeDataSourceRiskRequest request) {
        return this.analyzeDataSourceRiskOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AnalyzeDataSourceRiskRequest, RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskOperationCallable() {
        return this.stub.analyzeDataSourceRiskOperationCallable();
    }

    public final UnaryCallable<AnalyzeDataSourceRiskRequest, Operation> analyzeDataSourceRiskCallable() {
        return this.stub.analyzeDataSourceRiskCallable();
    }

    public final OperationFuture<InspectOperationResult, InspectOperationMetadata> createInspectOperationAsync(InspectConfig inspectConfig, StorageConfig storageConfig, OutputStorageConfig outputConfig) {
        CreateInspectOperationRequest request = CreateInspectOperationRequest.newBuilder().setInspectConfig(inspectConfig).setStorageConfig(storageConfig).setOutputConfig(outputConfig).build();
        return this.createInspectOperationAsync(request);
    }

    public final OperationFuture<InspectOperationResult, InspectOperationMetadata> createInspectOperationAsync(CreateInspectOperationRequest request) {
        return this.createInspectOperationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationCallable() {
        return this.stub.createInspectOperationOperationCallable();
    }

    public final UnaryCallable<CreateInspectOperationRequest, Operation> createInspectOperationCallable() {
        return this.stub.createInspectOperationCallable();
    }

    public final ListInspectFindingsResponse listInspectFindings(ResultName name) {
        ListInspectFindingsRequest request = ListInspectFindingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listInspectFindings(request);
    }

    public final ListInspectFindingsResponse listInspectFindings(String name) {
        ListInspectFindingsRequest request = ListInspectFindingsRequest.newBuilder().setName(name).build();
        return this.listInspectFindings(request);
    }

    public final ListInspectFindingsResponse listInspectFindings(ListInspectFindingsRequest request) {
        return (ListInspectFindingsResponse)this.listInspectFindingsCallable().call((Object)request);
    }

    public final UnaryCallable<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsCallable() {
        return this.stub.listInspectFindingsCallable();
    }

    public final ListInfoTypesResponse listInfoTypes(String category, String languageCode) {
        ListInfoTypesRequest request = ListInfoTypesRequest.newBuilder().setCategory(category).setLanguageCode(languageCode).build();
        return this.listInfoTypes(request);
    }

    public final ListInfoTypesResponse listInfoTypes(ListInfoTypesRequest request) {
        return (ListInfoTypesResponse)this.listInfoTypesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesCallable() {
        return this.stub.listInfoTypesCallable();
    }

    public final ListRootCategoriesResponse listRootCategories(String languageCode) {
        ListRootCategoriesRequest request = ListRootCategoriesRequest.newBuilder().setLanguageCode(languageCode).build();
        return this.listRootCategories(request);
    }

    private final ListRootCategoriesResponse listRootCategories(ListRootCategoriesRequest request) {
        return (ListRootCategoriesResponse)this.listRootCategoriesCallable().call((Object)request);
    }

    public final UnaryCallable<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesCallable() {
        return this.stub.listRootCategoriesCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

