/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.cloud.dlp.v2.DlpServiceSettings;
import com.google.cloud.dlp.v2.MockDlpService;
import com.google.common.collect.Lists;
import com.google.privacy.dlp.v2.CancelDlpJobRequest;
import com.google.privacy.dlp.v2.CreateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.CreateDlpJobRequest;
import com.google.privacy.dlp.v2.CreateInspectTemplateRequest;
import com.google.privacy.dlp.v2.CreateJobTriggerRequest;
import com.google.privacy.dlp.v2.CreateStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DeidentifyContentRequest;
import com.google.privacy.dlp.v2.DeidentifyContentResponse;
import com.google.privacy.dlp.v2.DeidentifyTemplate;
import com.google.privacy.dlp.v2.DeidentifyTemplateName;
import com.google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.DeleteDlpJobRequest;
import com.google.privacy.dlp.v2.DeleteInspectTemplateRequest;
import com.google.privacy.dlp.v2.DeleteJobTriggerRequest;
import com.google.privacy.dlp.v2.DeleteStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DlpJob;
import com.google.privacy.dlp.v2.DlpJobName;
import com.google.privacy.dlp.v2.FinishDlpJobRequest;
import com.google.privacy.dlp.v2.GetDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.GetDlpJobRequest;
import com.google.privacy.dlp.v2.GetInspectTemplateRequest;
import com.google.privacy.dlp.v2.GetJobTriggerRequest;
import com.google.privacy.dlp.v2.GetStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.HybridInspectDlpJobRequest;
import com.google.privacy.dlp.v2.HybridInspectJobTriggerRequest;
import com.google.privacy.dlp.v2.HybridInspectResponse;
import com.google.privacy.dlp.v2.InspectContentRequest;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.InspectJobConfig;
import com.google.privacy.dlp.v2.InspectTemplate;
import com.google.privacy.dlp.v2.InspectTemplateName;
import com.google.privacy.dlp.v2.JobTrigger;
import com.google.privacy.dlp.v2.JobTriggerName;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesRequest;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesResponse;
import com.google.privacy.dlp.v2.ListDlpJobsRequest;
import com.google.privacy.dlp.v2.ListDlpJobsResponse;
import com.google.privacy.dlp.v2.ListInfoTypesRequest;
import com.google.privacy.dlp.v2.ListInfoTypesResponse;
import com.google.privacy.dlp.v2.ListInspectTemplatesRequest;
import com.google.privacy.dlp.v2.ListInspectTemplatesResponse;
import com.google.privacy.dlp.v2.ListJobTriggersRequest;
import com.google.privacy.dlp.v2.ListJobTriggersResponse;
import com.google.privacy.dlp.v2.ListStoredInfoTypesRequest;
import com.google.privacy.dlp.v2.ListStoredInfoTypesResponse;
import com.google.privacy.dlp.v2.OrganizationLocationName;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.RedactImageRequest;
import com.google.privacy.dlp.v2.RedactImageResponse;
import com.google.privacy.dlp.v2.ReidentifyContentRequest;
import com.google.privacy.dlp.v2.ReidentifyContentResponse;
import com.google.privacy.dlp.v2.RiskAnalysisJobConfig;
import com.google.privacy.dlp.v2.StoredInfoType;
import com.google.privacy.dlp.v2.StoredInfoTypeConfig;
import com.google.privacy.dlp.v2.StoredInfoTypeName;
import com.google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.UpdateInspectTemplateRequest;
import com.google.privacy.dlp.v2.UpdateJobTriggerRequest;
import com.google.privacy.dlp.v2.UpdateStoredInfoTypeRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DlpServiceClientTest {
    private static MockDlpService mockDlpService;
    private static MockServiceHelper serviceHelper;
    private DlpServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockDlpService = new MockDlpService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockDlpService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        DlpServiceSettings settings = ((DlpServiceSettings.Builder)((DlpServiceSettings.Builder)DlpServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = DlpServiceClient.create((DlpServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void inspectContentTest() {
        InspectContentResponse expectedResponse = InspectContentResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        InspectContentRequest request = InspectContentRequest.newBuilder().build();
        InspectContentResponse actualResponse = this.client.inspectContent(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        InspectContentRequest actualRequest = (InspectContentRequest)actualRequests.get(0);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void inspectContentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            InspectContentRequest request = InspectContentRequest.newBuilder().build();
            this.client.inspectContent(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void redactImageTest() {
        ByteString redactedImage = ByteString.copyFromUtf8((String)"28");
        String extractedText = "extractedText998260012";
        RedactImageResponse expectedResponse = RedactImageResponse.newBuilder().setRedactedImage(redactedImage).setExtractedText(extractedText).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        RedactImageRequest request = RedactImageRequest.newBuilder().build();
        RedactImageResponse actualResponse = this.client.redactImage(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RedactImageRequest actualRequest = (RedactImageRequest)actualRequests.get(0);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void redactImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            RedactImageRequest request = RedactImageRequest.newBuilder().build();
            this.client.redactImage(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deidentifyContentTest() {
        DeidentifyContentResponse expectedResponse = DeidentifyContentResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DeidentifyContentRequest request = DeidentifyContentRequest.newBuilder().build();
        DeidentifyContentResponse actualResponse = this.client.deidentifyContent(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeidentifyContentRequest actualRequest = (DeidentifyContentRequest)actualRequests.get(0);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deidentifyContentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DeidentifyContentRequest request = DeidentifyContentRequest.newBuilder().build();
            this.client.deidentifyContent(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void reidentifyContentTest() {
        ReidentifyContentResponse expectedResponse = ReidentifyContentResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ReidentifyContentRequest request = ReidentifyContentRequest.newBuilder().setParent(parent.toString()).build();
        ReidentifyContentResponse actualResponse = this.client.reidentifyContent(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ReidentifyContentRequest actualRequest = (ReidentifyContentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void reidentifyContentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ReidentifyContentRequest request = ReidentifyContentRequest.newBuilder().setParent(parent.toString()).build();
            this.client.reidentifyContent(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInfoTypesTest() {
        ListInfoTypesResponse expectedResponse = ListInfoTypesResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ListInfoTypesResponse actualResponse = this.client.listInfoTypes(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInfoTypesRequest actualRequest = (ListInfoTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInfoTypesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInfoTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInspectTemplateTest() {
        InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        InspectTemplate expectedResponse = InspectTemplate.newBuilder().setName(name.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        InspectTemplate inspectTemplate = InspectTemplate.newBuilder().build();
        InspectTemplate actualResponse = this.client.createInspectTemplate(parent, inspectTemplate);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInspectTemplateRequest actualRequest = (CreateInspectTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)inspectTemplate, (Object)actualRequest.getInspectTemplate());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInspectTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            InspectTemplate inspectTemplate = InspectTemplate.newBuilder().build();
            this.client.createInspectTemplate(parent, inspectTemplate);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateInspectTemplateTest() {
        InspectTemplateName name2 = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        InspectTemplate expectedResponse = InspectTemplate.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        InspectTemplate inspectTemplate = InspectTemplate.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        InspectTemplate actualResponse = this.client.updateInspectTemplate(name, inspectTemplate, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInspectTemplateRequest actualRequest = (UpdateInspectTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InspectTemplateName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)inspectTemplate, (Object)actualRequest.getInspectTemplate());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInspectTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
            InspectTemplate inspectTemplate = InspectTemplate.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateInspectTemplate(name, inspectTemplate, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInspectTemplateTest() {
        InspectTemplateName name2 = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        InspectTemplate expectedResponse = InspectTemplate.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        InspectTemplate actualResponse = this.client.getInspectTemplate(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInspectTemplateRequest actualRequest = (GetInspectTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InspectTemplateName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInspectTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
            this.client.getInspectTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInspectTemplatesTest() {
        String nextPageToken = "";
        InspectTemplate inspectTemplatesElement = InspectTemplate.newBuilder().build();
        List<InspectTemplate> inspectTemplates = Arrays.asList(inspectTemplatesElement);
        ListInspectTemplatesResponse expectedResponse = ListInspectTemplatesResponse.newBuilder().setNextPageToken(nextPageToken).addAllInspectTemplates(inspectTemplates).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        DlpServiceClient.ListInspectTemplatesPagedResponse pagedListResponse = this.client.listInspectTemplates(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInspectTemplatesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInspectTemplatesRequest actualRequest = (ListInspectTemplatesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInspectTemplatesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listInspectTemplates(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInspectTemplateTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
        this.client.deleteInspectTemplate(name);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInspectTemplateRequest actualRequest = (DeleteInspectTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)InspectTemplateName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInspectTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            InspectTemplateName name = InspectTemplateName.ofOrganizationInspectTemplateName((String)"[ORGANIZATION]", (String)"[INSPECT_TEMPLATE]");
            this.client.deleteInspectTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDeidentifyTemplateTest() {
        DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        DeidentifyTemplate expectedResponse = DeidentifyTemplate.newBuilder().setName(name.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        DeidentifyTemplate deidentifyTemplate = DeidentifyTemplate.newBuilder().build();
        DeidentifyTemplate actualResponse = this.client.createDeidentifyTemplate(parent, deidentifyTemplate);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDeidentifyTemplateRequest actualRequest = (CreateDeidentifyTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)deidentifyTemplate, (Object)actualRequest.getDeidentifyTemplate());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDeidentifyTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            DeidentifyTemplate deidentifyTemplate = DeidentifyTemplate.newBuilder().build();
            this.client.createDeidentifyTemplate(parent, deidentifyTemplate);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDeidentifyTemplateTest() {
        DeidentifyTemplateName name2 = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        DeidentifyTemplate expectedResponse = DeidentifyTemplate.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        DeidentifyTemplate deidentifyTemplate = DeidentifyTemplate.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        DeidentifyTemplate actualResponse = this.client.updateDeidentifyTemplate(name, deidentifyTemplate, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDeidentifyTemplateRequest actualRequest = (UpdateDeidentifyTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DeidentifyTemplateName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)deidentifyTemplate, (Object)actualRequest.getDeidentifyTemplate());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDeidentifyTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
            DeidentifyTemplate deidentifyTemplate = DeidentifyTemplate.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDeidentifyTemplate(name, deidentifyTemplate, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDeidentifyTemplateTest() {
        DeidentifyTemplateName name2 = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        DeidentifyTemplate expectedResponse = DeidentifyTemplate.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        DeidentifyTemplate actualResponse = this.client.getDeidentifyTemplate(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDeidentifyTemplateRequest actualRequest = (GetDeidentifyTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DeidentifyTemplateName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDeidentifyTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
            this.client.getDeidentifyTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDeidentifyTemplatesTest() {
        String nextPageToken = "";
        DeidentifyTemplate deidentifyTemplatesElement = DeidentifyTemplate.newBuilder().build();
        List<DeidentifyTemplate> deidentifyTemplates = Arrays.asList(deidentifyTemplatesElement);
        ListDeidentifyTemplatesResponse expectedResponse = ListDeidentifyTemplatesResponse.newBuilder().setNextPageToken(nextPageToken).addAllDeidentifyTemplates(deidentifyTemplates).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        DlpServiceClient.ListDeidentifyTemplatesPagedResponse pagedListResponse = this.client.listDeidentifyTemplates(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDeidentifyTemplatesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDeidentifyTemplatesRequest actualRequest = (ListDeidentifyTemplatesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDeidentifyTemplatesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listDeidentifyTemplates(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDeidentifyTemplateTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
        this.client.deleteDeidentifyTemplate(name);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDeidentifyTemplateRequest actualRequest = (DeleteDeidentifyTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DeidentifyTemplateName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDeidentifyTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DeidentifyTemplateName name = DeidentifyTemplateName.ofOrganizationDeidentifyTemplateName((String)"[ORGANIZATION]", (String)"[DEIDENTIFY_TEMPLATE]");
            this.client.deleteDeidentifyTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTriggerTest() {
        JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        JobTrigger expectedResponse = JobTrigger.newBuilder().setName(name.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        JobTrigger jobTrigger = JobTrigger.newBuilder().build();
        JobTrigger actualResponse = this.client.createJobTrigger(parent, jobTrigger);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobTriggerRequest actualRequest = (CreateJobTriggerRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)jobTrigger, (Object)actualRequest.getJobTrigger());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobTriggerExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            JobTrigger jobTrigger = JobTrigger.newBuilder().build();
            this.client.createJobTrigger(parent, jobTrigger);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateJobTriggerTest() {
        JobTriggerName name2 = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        JobTrigger expectedResponse = JobTrigger.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        JobTrigger jobTrigger = JobTrigger.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        JobTrigger actualResponse = this.client.updateJobTrigger(name, jobTrigger, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateJobTriggerRequest actualRequest = (UpdateJobTriggerRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobTriggerName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)jobTrigger, (Object)actualRequest.getJobTrigger());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateJobTriggerExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
            JobTrigger jobTrigger = JobTrigger.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateJobTrigger(name, jobTrigger, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void hybridInspectJobTriggerTest() {
        HybridInspectResponse expectedResponse = HybridInspectResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        HybridInspectResponse actualResponse = this.client.hybridInspectJobTrigger(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        HybridInspectJobTriggerRequest actualRequest = (HybridInspectJobTriggerRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobTriggerName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void hybridInspectJobTriggerExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
            this.client.hybridInspectJobTrigger(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTriggerTest() {
        JobTriggerName name2 = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        JobTrigger expectedResponse = JobTrigger.newBuilder().setName(name2.toString()).setDisplayName(displayName).setDescription(description).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        JobTrigger actualResponse = this.client.getJobTrigger(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobTriggerRequest actualRequest = (GetJobTriggerRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobTriggerName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobTriggerExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
            this.client.getJobTrigger(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobTriggersTest() {
        String nextPageToken = "";
        JobTrigger jobTriggersElement = JobTrigger.newBuilder().build();
        List<JobTrigger> jobTriggers = Arrays.asList(jobTriggersElement);
        ListJobTriggersResponse expectedResponse = ListJobTriggersResponse.newBuilder().setNextPageToken(nextPageToken).addAllJobTriggers(jobTriggers).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        DlpServiceClient.ListJobTriggersPagedResponse pagedListResponse = this.client.listJobTriggers(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobTriggersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobTriggersRequest actualRequest = (ListJobTriggersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobTriggersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listJobTriggers(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTriggerTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
        this.client.deleteJobTrigger(name);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobTriggerRequest actualRequest = (DeleteJobTriggerRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobTriggerName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobTriggerExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            JobTriggerName name = JobTriggerName.ofProjectJobTriggerName((String)"[PROJECT]", (String)"[JOB_TRIGGER]");
            this.client.deleteJobTrigger(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDlpJobTest() {
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        String jobTriggerName = "jobTriggerName1819490804";
        DlpJob expectedResponse = DlpJob.newBuilder().setName(name.toString()).setJobTriggerName(jobTriggerName).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InspectJobConfig inspectJob = InspectJobConfig.newBuilder().build();
        DlpJob actualResponse = this.client.createDlpJob(parent, inspectJob);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDlpJobRequest actualRequest = (CreateDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)inspectJob, (Object)actualRequest.getInspectJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            InspectJobConfig inspectJob = InspectJobConfig.newBuilder().build();
            this.client.createDlpJob(parent, inspectJob);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDlpJobTest2() {
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        String jobTriggerName = "jobTriggerName1819490804";
        DlpJob expectedResponse = DlpJob.newBuilder().setName(name.toString()).setJobTriggerName(jobTriggerName).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        RiskAnalysisJobConfig riskJob = RiskAnalysisJobConfig.newBuilder().build();
        DlpJob actualResponse = this.client.createDlpJob(parent, riskJob);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDlpJobRequest actualRequest = (CreateDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)riskJob, (Object)actualRequest.getRiskJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDlpJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            RiskAnalysisJobConfig riskJob = RiskAnalysisJobConfig.newBuilder().build();
            this.client.createDlpJob(parent, riskJob);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDlpJobsTest() {
        String nextPageToken = "";
        DlpJob jobsElement = DlpJob.newBuilder().build();
        List<DlpJob> jobs = Arrays.asList(jobsElement);
        ListDlpJobsResponse expectedResponse = ListDlpJobsResponse.newBuilder().setNextPageToken(nextPageToken).addAllJobs(jobs).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        DlpServiceClient.ListDlpJobsPagedResponse pagedListResponse = this.client.listDlpJobs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDlpJobsRequest actualRequest = (ListDlpJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProjectName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDlpJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listDlpJobs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDlpJobTest() {
        DlpJobName name2 = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        String jobTriggerName = "jobTriggerName1819490804";
        DlpJob expectedResponse = DlpJob.newBuilder().setName(name2.toString()).setJobTriggerName(jobTriggerName).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        DlpJob actualResponse = this.client.getDlpJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDlpJobRequest actualRequest = (GetDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DlpJobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
            this.client.getDlpJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDlpJobTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        this.client.deleteDlpJob(name);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDlpJobRequest actualRequest = (DeleteDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DlpJobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
            this.client.deleteDlpJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void cancelDlpJobTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        CancelDlpJobRequest request = CancelDlpJobRequest.newBuilder().setName(name.toString()).build();
        this.client.cancelDlpJob(request);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CancelDlpJobRequest actualRequest = (CancelDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DlpJobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void cancelDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
            CancelDlpJobRequest request = CancelDlpJobRequest.newBuilder().setName(name.toString()).build();
            this.client.cancelDlpJob(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createStoredInfoTypeTest() {
        StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        StoredInfoType expectedResponse = StoredInfoType.newBuilder().setName(name.toString()).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        StoredInfoTypeConfig config = StoredInfoTypeConfig.newBuilder().build();
        StoredInfoType actualResponse = this.client.createStoredInfoType(parent, config);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateStoredInfoTypeRequest actualRequest = (CreateStoredInfoTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)config, (Object)actualRequest.getConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createStoredInfoTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            StoredInfoTypeConfig config = StoredInfoTypeConfig.newBuilder().build();
            this.client.createStoredInfoType(parent, config);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateStoredInfoTypeTest() {
        StoredInfoTypeName name2 = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        StoredInfoType expectedResponse = StoredInfoType.newBuilder().setName(name2.toString()).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        StoredInfoTypeConfig config = StoredInfoTypeConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        StoredInfoType actualResponse = this.client.updateStoredInfoType(name, config, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateStoredInfoTypeRequest actualRequest = (UpdateStoredInfoTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)StoredInfoTypeName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)config, (Object)actualRequest.getConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateStoredInfoTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
            StoredInfoTypeConfig config = StoredInfoTypeConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateStoredInfoType(name, config, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStoredInfoTypeTest() {
        StoredInfoTypeName name2 = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        StoredInfoType expectedResponse = StoredInfoType.newBuilder().setName(name2.toString()).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        StoredInfoType actualResponse = this.client.getStoredInfoType(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStoredInfoTypeRequest actualRequest = (GetStoredInfoTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)StoredInfoTypeName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStoredInfoTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
            this.client.getStoredInfoType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listStoredInfoTypesTest() {
        String nextPageToken = "";
        StoredInfoType storedInfoTypesElement = StoredInfoType.newBuilder().build();
        List<StoredInfoType> storedInfoTypes = Arrays.asList(storedInfoTypesElement);
        ListStoredInfoTypesResponse expectedResponse = ListStoredInfoTypesResponse.newBuilder().setNextPageToken(nextPageToken).addAllStoredInfoTypes(storedInfoTypes).build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        DlpServiceClient.ListStoredInfoTypesPagedResponse pagedListResponse = this.client.listStoredInfoTypes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getStoredInfoTypesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListStoredInfoTypesRequest actualRequest = (ListStoredInfoTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)OrganizationLocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listStoredInfoTypesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listStoredInfoTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStoredInfoTypeTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
        this.client.deleteStoredInfoType(name);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteStoredInfoTypeRequest actualRequest = (DeleteStoredInfoTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)StoredInfoTypeName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteStoredInfoTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            StoredInfoTypeName name = StoredInfoTypeName.ofOrganizationStoredInfoTypeName((String)"[ORGANIZATION]", (String)"[STORED_INFO_TYPE]");
            this.client.deleteStoredInfoType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void hybridInspectDlpJobTest() {
        HybridInspectResponse expectedResponse = HybridInspectResponse.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        HybridInspectResponse actualResponse = this.client.hybridInspectDlpJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        HybridInspectDlpJobRequest actualRequest = (HybridInspectDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DlpJobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void hybridInspectDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
            this.client.hybridInspectDlpJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void finishDlpJobTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDlpService.addResponse((AbstractMessage)expectedResponse);
        DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
        FinishDlpJobRequest request = FinishDlpJobRequest.newBuilder().setName(name.toString()).build();
        this.client.finishDlpJob(request);
        List<AbstractMessage> actualRequests = mockDlpService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FinishDlpJobRequest actualRequest = (FinishDlpJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)DlpJobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void finishDlpJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDlpService.addException((Exception)exception);
        try {
            DlpJobName name = DlpJobName.ofProjectDlpJobName((String)"[PROJECT]", (String)"[DLP_JOB]");
            FinishDlpJobRequest request = FinishDlpJobRequest.newBuilder().setName(name.toString()).build();
            this.client.finishDlpJob(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

