/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminClient;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStubSettings;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreAdminCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.Database;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.ExportDocumentsMetadata;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.ExportDocumentsResponse;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FieldOperationMetadata;
import com.google.firestore.admin.v1.GetDatabaseRequest;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.ImportDocumentsMetadata;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.IndexOperationMetadata;
import com.google.firestore.admin.v1.ListDatabasesRequest;
import com.google.firestore.admin.v1.ListDatabasesResponse;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.UpdateDatabaseMetadata;
import com.google.firestore.admin.v1.UpdateDatabaseRequest;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFirestoreAdminStub
extends FirestoreAdminStub {
    private static final MethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/CreateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListIndexes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIndexesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIndexesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Index.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteIndexRequest, Empty> deleteIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/DeleteIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetFieldRequest, Field> getFieldMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetField").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFieldRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Field.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateFieldRequest, Operation> updateFieldMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/UpdateField").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFieldRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListFieldsRequest, ListFieldsResponse> listFieldsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListFields").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFieldsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFieldsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportDocumentsRequest, Operation> exportDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ExportDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportDocumentsRequest, Operation> importDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ImportDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDatabaseRequest, Database> getDatabaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetDatabase").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatabaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Database.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDatabasesRequest, ListDatabasesResponse> listDatabasesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListDatabases").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatabasesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatabasesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDatabaseRequest, Operation> updateDatabaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/UpdateDatabase").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatabaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable;
    private final UnaryCallable<GetFieldRequest, Field> getFieldCallable;
    private final UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable;
    private final OperationCallable<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationCallable;
    private final UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable;
    private final UnaryCallable<ListFieldsRequest, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsPagedCallable;
    private final UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable;
    private final OperationCallable<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationCallable;
    private final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable;
    private final OperationCallable<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationCallable;
    private final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable;
    private final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable;
    private final UnaryCallable<UpdateDatabaseRequest, Operation> updateDatabaseCallable;
    private final OperationCallable<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFirestoreAdminStub create(FirestoreAdminStubSettings settings) throws IOException {
        return new GrpcFirestoreAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFirestoreAdminStub create(ClientContext clientContext) throws IOException {
        return new GrpcFirestoreAdminStub(FirestoreAdminStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFirestoreAdminStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFirestoreAdminStub(FirestoreAdminStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFirestoreAdminStub(FirestoreAdminStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFirestoreAdminCallableFactory());
    }

    protected GrpcFirestoreAdminStub(FirestoreAdminStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listIndexesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getFieldTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFieldMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateFieldTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFieldMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"field.name", (Object)String.valueOf(request.getField().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listFieldsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFieldsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings exportDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings importDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getDatabaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatabaseMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listDatabasesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatabasesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateDatabaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatabaseMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"database.name", (Object)String.valueOf(request.getDatabase().getName()));
            return params.build();
        }).build();
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.getFieldCallable = callableFactory.createUnaryCallable(getFieldTransportSettings, settings.getFieldSettings(), clientContext);
        this.updateFieldCallable = callableFactory.createUnaryCallable(updateFieldTransportSettings, settings.updateFieldSettings(), clientContext);
        this.updateFieldOperationCallable = callableFactory.createOperationCallable(updateFieldTransportSettings, settings.updateFieldOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listFieldsCallable = callableFactory.createUnaryCallable(listFieldsTransportSettings, settings.listFieldsSettings(), clientContext);
        this.listFieldsPagedCallable = callableFactory.createPagedCallable(listFieldsTransportSettings, settings.listFieldsSettings(), clientContext);
        this.exportDocumentsCallable = callableFactory.createUnaryCallable(exportDocumentsTransportSettings, settings.exportDocumentsSettings(), clientContext);
        this.exportDocumentsOperationCallable = callableFactory.createOperationCallable(exportDocumentsTransportSettings, settings.exportDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDocumentsCallable = callableFactory.createUnaryCallable(importDocumentsTransportSettings, settings.importDocumentsSettings(), clientContext);
        this.importDocumentsOperationCallable = callableFactory.createOperationCallable(importDocumentsTransportSettings, settings.importDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDatabaseCallable = callableFactory.createUnaryCallable(getDatabaseTransportSettings, settings.getDatabaseSettings(), clientContext);
        this.listDatabasesCallable = callableFactory.createUnaryCallable(listDatabasesTransportSettings, settings.listDatabasesSettings(), clientContext);
        this.updateDatabaseCallable = callableFactory.createUnaryCallable(updateDatabaseTransportSettings, settings.updateDatabaseSettings(), clientContext);
        this.updateDatabaseOperationCallable = callableFactory.createOperationCallable(updateDatabaseTransportSettings, settings.updateDatabaseOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public UnaryCallable<GetFieldRequest, Field> getFieldCallable() {
        return this.getFieldCallable;
    }

    @Override
    public UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable() {
        return this.updateFieldCallable;
    }

    @Override
    public OperationCallable<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationCallable() {
        return this.updateFieldOperationCallable;
    }

    @Override
    public UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable() {
        return this.listFieldsCallable;
    }

    @Override
    public UnaryCallable<ListFieldsRequest, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsPagedCallable() {
        return this.listFieldsPagedCallable;
    }

    @Override
    public UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable() {
        return this.exportDocumentsCallable;
    }

    @Override
    public OperationCallable<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationCallable() {
        return this.exportDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.importDocumentsCallable;
    }

    @Override
    public OperationCallable<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.importDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.getDatabaseCallable;
    }

    @Override
    public UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.listDatabasesCallable;
    }

    @Override
    public UnaryCallable<UpdateDatabaseRequest, Operation> updateDatabaseCallable() {
        return this.updateDatabaseCallable;
    }

    @Override
    public OperationCallable<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationCallable() {
        return this.updateDatabaseOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

