/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminClient;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStubSettings;
import com.google.cloud.firestore.v1.stub.HttpJsonFirestoreAdminCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.Database;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.ExportDocumentsMetadata;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.ExportDocumentsResponse;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FieldOperationMetadata;
import com.google.firestore.admin.v1.GetDatabaseRequest;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.ImportDocumentsMetadata;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.IndexOperationMetadata;
import com.google.firestore.admin.v1.ListDatabasesRequest;
import com.google.firestore.admin.v1.ListDatabasesResponse;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.UpdateDatabaseMetadata;
import com.google.firestore.admin.v1.UpdateDatabaseRequest;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonFirestoreAdminStub
extends FirestoreAdminStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ExportDocumentsResponse.getDescriptor()).add(UpdateDatabaseMetadata.getDescriptor()).add(Field.getDescriptor()).add(Empty.getDescriptor()).add(ImportDocumentsMetadata.getDescriptor()).add(Database.getDescriptor()).add(Index.getDescriptor()).add(FieldOperationMetadata.getDescriptor()).add(ExportDocumentsMetadata.getDescriptor()).add(IndexOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/CreateIndex").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/collectionGroups/*}/indexes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("index", (Message)request.getIndex(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListIndexes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/collectionGroups/*}/indexes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListIndexesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetIndex").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*/collectionGroups/*/indexes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Index.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteIndexRequest, Empty> deleteIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/DeleteIndex").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*/collectionGroups/*/indexes/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFieldRequest, Field> getFieldMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetField").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*/collectionGroups/*/fields/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Field.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateFieldRequest, Operation> updateFieldMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/UpdateField").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{field.name=projects/*/databases/*/collectionGroups/*/fields/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "field.name", (Object)request.getField().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("field", (Message)request.getField(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListFieldsRequest, ListFieldsResponse> listFieldsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListFields").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/databases/*/collectionGroups/*}/fields", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFieldsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExportDocumentsRequest, Operation> exportDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ExportDocuments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*}:exportDocuments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ImportDocumentsRequest, Operation> importDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ImportDocuments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*}:importDocuments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetDatabaseRequest, Database> getDatabaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/GetDatabase").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/databases/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Database.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDatabasesRequest, ListDatabasesResponse> listDatabasesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/ListDatabases").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/databases", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDatabasesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDatabaseRequest, Operation> updateDatabaseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.firestore.admin.v1.FirestoreAdmin/UpdateDatabase").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{database.name=projects/*/databases/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "database.name", (Object)request.getDatabase().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("database", (Message)request.getDatabase(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable;
    private final UnaryCallable<GetFieldRequest, Field> getFieldCallable;
    private final UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable;
    private final OperationCallable<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationCallable;
    private final UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable;
    private final UnaryCallable<ListFieldsRequest, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsPagedCallable;
    private final UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable;
    private final OperationCallable<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationCallable;
    private final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable;
    private final OperationCallable<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationCallable;
    private final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable;
    private final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable;
    private final UnaryCallable<UpdateDatabaseRequest, Operation> updateDatabaseCallable;
    private final OperationCallable<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFirestoreAdminStub create(FirestoreAdminStubSettings settings) throws IOException {
        return new HttpJsonFirestoreAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonFirestoreAdminStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFirestoreAdminStub(FirestoreAdminStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonFirestoreAdminStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFirestoreAdminStub(FirestoreAdminStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFirestoreAdminStub(FirestoreAdminStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFirestoreAdminCallableFactory());
    }

    protected HttpJsonFirestoreAdminStub(FirestoreAdminStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/databases/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/databases/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/databases/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/databases/*}/operations").build()).build());
        HttpJsonCallSettings createIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listIndexesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getFieldTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFieldMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateFieldTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFieldMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listFieldsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFieldsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings exportDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings importDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getDatabaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDatabaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listDatabasesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDatabasesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateDatabaseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDatabaseMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.getFieldCallable = callableFactory.createUnaryCallable(getFieldTransportSettings, settings.getFieldSettings(), clientContext);
        this.updateFieldCallable = callableFactory.createUnaryCallable(updateFieldTransportSettings, settings.updateFieldSettings(), clientContext);
        this.updateFieldOperationCallable = callableFactory.createOperationCallable(updateFieldTransportSettings, settings.updateFieldOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listFieldsCallable = callableFactory.createUnaryCallable(listFieldsTransportSettings, settings.listFieldsSettings(), clientContext);
        this.listFieldsPagedCallable = callableFactory.createPagedCallable(listFieldsTransportSettings, settings.listFieldsSettings(), clientContext);
        this.exportDocumentsCallable = callableFactory.createUnaryCallable(exportDocumentsTransportSettings, settings.exportDocumentsSettings(), clientContext);
        this.exportDocumentsOperationCallable = callableFactory.createOperationCallable(exportDocumentsTransportSettings, settings.exportDocumentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.importDocumentsCallable = callableFactory.createUnaryCallable(importDocumentsTransportSettings, settings.importDocumentsSettings(), clientContext);
        this.importDocumentsOperationCallable = callableFactory.createOperationCallable(importDocumentsTransportSettings, settings.importDocumentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getDatabaseCallable = callableFactory.createUnaryCallable(getDatabaseTransportSettings, settings.getDatabaseSettings(), clientContext);
        this.listDatabasesCallable = callableFactory.createUnaryCallable(listDatabasesTransportSettings, settings.listDatabasesSettings(), clientContext);
        this.updateDatabaseCallable = callableFactory.createUnaryCallable(updateDatabaseTransportSettings, settings.updateDatabaseSettings(), clientContext);
        this.updateDatabaseOperationCallable = callableFactory.createOperationCallable(updateDatabaseTransportSettings, settings.updateDatabaseOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createIndexMethodDescriptor);
        methodDescriptors.add(listIndexesMethodDescriptor);
        methodDescriptors.add(getIndexMethodDescriptor);
        methodDescriptors.add(deleteIndexMethodDescriptor);
        methodDescriptors.add(getFieldMethodDescriptor);
        methodDescriptors.add(updateFieldMethodDescriptor);
        methodDescriptors.add(listFieldsMethodDescriptor);
        methodDescriptors.add(exportDocumentsMethodDescriptor);
        methodDescriptors.add(importDocumentsMethodDescriptor);
        methodDescriptors.add(getDatabaseMethodDescriptor);
        methodDescriptors.add(listDatabasesMethodDescriptor);
        methodDescriptors.add(updateDatabaseMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public UnaryCallable<GetFieldRequest, Field> getFieldCallable() {
        return this.getFieldCallable;
    }

    @Override
    public UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable() {
        return this.updateFieldCallable;
    }

    @Override
    public OperationCallable<UpdateFieldRequest, Field, FieldOperationMetadata> updateFieldOperationCallable() {
        return this.updateFieldOperationCallable;
    }

    @Override
    public UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable() {
        return this.listFieldsCallable;
    }

    @Override
    public UnaryCallable<ListFieldsRequest, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsPagedCallable() {
        return this.listFieldsPagedCallable;
    }

    @Override
    public UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable() {
        return this.exportDocumentsCallable;
    }

    @Override
    public OperationCallable<ExportDocumentsRequest, ExportDocumentsResponse, ExportDocumentsMetadata> exportDocumentsOperationCallable() {
        return this.exportDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.importDocumentsCallable;
    }

    @Override
    public OperationCallable<ImportDocumentsRequest, Empty, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.importDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.getDatabaseCallable;
    }

    @Override
    public UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.listDatabasesCallable;
    }

    @Override
    public UnaryCallable<UpdateDatabaseRequest, Operation> updateDatabaseCallable() {
        return this.updateDatabaseCallable;
    }

    @Override
    public OperationCallable<UpdateDatabaseRequest, Database, UpdateDatabaseMetadata> updateDatabaseOperationCallable() {
        return this.updateDatabaseOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

