/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.AutoValue_ResourcePath;
import com.google.cloud.firestore.BasePath;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1beta1.DatabaseName;
import java.util.Arrays;
import javax.annotation.Nullable;

abstract class ResourcePath
extends BasePath<ResourcePath> {
    ResourcePath() {
    }

    static ResourcePath create(DatabaseName databaseName, ImmutableList<String> segments) {
        return new AutoValue_ResourcePath(segments, databaseName);
    }

    static ResourcePath create(DatabaseName databaseName) {
        return new AutoValue_ResourcePath((ImmutableList<String>)ImmutableList.of(), databaseName);
    }

    static ResourcePath create(String resourceName) {
        String[] parts = resourceName.split("/");
        if (parts.length >= 6 && parts[0].equals("projects") && parts[2].equals("databases")) {
            Object[] path = Arrays.copyOfRange(parts, 5, parts.length);
            return ResourcePath.create(DatabaseName.create((String)parts[1], (String)parts[3]), (ImmutableList<String>)ImmutableList.builder().add(path).build());
        }
        return ResourcePath.create(DatabaseName.parse((String)resourceName));
    }

    abstract DatabaseName getDatabaseName();

    boolean isDocument() {
        int size = this.getSegments().size();
        return size > 0 && size % 2 == 0;
    }

    boolean isCollection() {
        return this.getSegments().size() % 2 == 1;
    }

    @Nullable
    String getId() {
        ImmutableList<String> parts = this.getSegments();
        if (!parts.isEmpty()) {
            return (String)parts.get(parts.size() - 1);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDatabaseName());
        ImmutableList<String> parts = this.getSegments();
        if (parts.size() > 0) {
            result.append("/documents");
            for (String part : parts) {
                result.append("/").append(part);
            }
        }
        return result.toString();
    }

    @Override
    String[] splitChildPath(String name) {
        return name.split("/");
    }

    @Override
    ResourcePath createPathWithSegments(ImmutableList<String> segments) {
        return ResourcePath.create(this.getDatabaseName(), segments);
    }
}

