/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.Query;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class QuerySnapshot
implements Iterable<DocumentSnapshot> {
    private final Query query;
    private final List<DocumentSnapshot> documentSnapshots;
    private final Instant readTime;

    QuerySnapshot(Query query, Instant readTime, List<DocumentSnapshot> results) {
        this.query = query;
        this.documentSnapshots = results;
        this.readTime = readTime;
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public Instant getReadTime() {
        return this.readTime;
    }

    @Nonnull
    public List<DocumentSnapshot> getDocuments() {
        return ImmutableList.copyOf(this.documentSnapshots);
    }

    public boolean isEmpty() {
        return this.documentSnapshots.isEmpty();
    }

    public int size() {
        return this.documentSnapshots.size();
    }

    @Override
    @Nonnull
    public Iterator<DocumentSnapshot> iterator() {
        return this.getDocuments().iterator();
    }

    @Nonnull
    public <T> List<T> toObjects(@Nonnull Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (DocumentSnapshot documentSnapshot : this.documentSnapshots) {
            results.add(CustomClassMapper.convertToCustomClass(documentSnapshot.getData(), clazz));
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySnapshot that = (QuerySnapshot)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.documentSnapshots, that.documentSnapshots) && Objects.equals(this.readTime, that.readTime);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.documentSnapshots, this.readTime);
    }
}

