/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.collection.ImmutableSortedMap;
import com.google.cloud.firestore.collection.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

class DocumentSet
implements Iterable<QueryDocumentSnapshot> {
    private static final ImmutableSortedMap<ResourcePath, QueryDocumentSnapshot> EMPTY_DOCUMENT_MAP = ImmutableSortedMap.Builder.emptyMap(ResourcePath.comparator());
    private final ImmutableSortedMap<ResourcePath, QueryDocumentSnapshot> keyIndex;
    private final ImmutableSortedSet<QueryDocumentSnapshot> sortedSet;

    static DocumentSet emptySet(Comparator<QueryDocumentSnapshot> comparator) {
        return new DocumentSet(EMPTY_DOCUMENT_MAP, new ImmutableSortedSet<QueryDocumentSnapshot>(Collections.emptyList(), comparator));
    }

    private DocumentSet(ImmutableSortedMap<ResourcePath, QueryDocumentSnapshot> keyIndex, ImmutableSortedSet<QueryDocumentSnapshot> sortedSet) {
        this.keyIndex = keyIndex;
        this.sortedSet = sortedSet;
    }

    int size() {
        return this.keyIndex.size();
    }

    boolean isEmpty() {
        return this.keyIndex.isEmpty();
    }

    boolean contains(ResourcePath key) {
        return this.keyIndex.containsKey(key);
    }

    @Nullable
    QueryDocumentSnapshot getDocument(ResourcePath key) {
        return this.keyIndex.get(key);
    }

    int indexOf(ResourcePath key) {
        QueryDocumentSnapshot document = this.keyIndex.get(key);
        if (document == null) {
            return -1;
        }
        return this.sortedSet.indexOf(document);
    }

    DocumentSet add(QueryDocumentSnapshot document) {
        DocumentSet removed = this.remove(document.getReference().getResourcePath());
        ImmutableSortedMap<ResourcePath, QueryDocumentSnapshot> newKeyIndex = removed.keyIndex.insert(document.getReference().getResourcePath(), document);
        ImmutableSortedSet<QueryDocumentSnapshot> newSortedSet = removed.sortedSet.insert(document);
        return new DocumentSet(newKeyIndex, newSortedSet);
    }

    DocumentSet remove(ResourcePath key) {
        QueryDocumentSnapshot document = this.keyIndex.get(key);
        if (document == null) {
            return this;
        }
        ImmutableSortedMap<ResourcePath, QueryDocumentSnapshot> newKeyIndex = this.keyIndex.remove(key);
        ImmutableSortedSet<QueryDocumentSnapshot> newSortedSet = this.sortedSet.remove(document);
        return new DocumentSet(newKeyIndex, newSortedSet);
    }

    List<QueryDocumentSnapshot> toList() {
        ArrayList<QueryDocumentSnapshot> documents = new ArrayList<QueryDocumentSnapshot>(this.size());
        for (QueryDocumentSnapshot document : this) {
            documents.add(document);
        }
        return documents;
    }

    @Override
    public Iterator<QueryDocumentSnapshot> iterator() {
        return this.sortedSet.iterator();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DocumentSet documentSet = (DocumentSet)other;
        if (this.size() != documentSet.size()) {
            return false;
        }
        Iterator<QueryDocumentSnapshot> thisIterator = this.iterator();
        Iterator<QueryDocumentSnapshot> otherIterator = documentSet.iterator();
        while (thisIterator.hasNext()) {
            DocumentSnapshot otherDoc;
            DocumentSnapshot thisDoc = thisIterator.next();
            if (thisDoc.equals(otherDoc = (DocumentSnapshot)otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (DocumentSnapshot document : this) {
            result = 31 * result + document.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (DocumentSnapshot doc : this) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(doc);
        }
        builder.append("]");
        return builder.toString();
    }
}

