/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.annotation.Exclude;
import com.google.cloud.firestore.annotation.IgnoreExtraProperties;
import com.google.cloud.firestore.annotation.PropertyName;
import com.google.cloud.firestore.annotation.ServerTimestamp;
import com.google.cloud.firestore.annotation.ThrowOnExtraProperties;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class CustomClassMapper {
    private static final ConcurrentMap<Class<?>, BeanMapper<?>> mappers = new ConcurrentHashMap();

    CustomClassMapper() {
    }

    private static void hardAssert(boolean assertion) {
        CustomClassMapper.hardAssert(assertion, "Internal inconsistency");
    }

    private static void hardAssert(boolean assertion, String message) {
        if (!assertion) {
            throw new RuntimeException("Hard assert failed: " + message);
        }
    }

    public static Object convertToPlainJavaTypes(Object object) {
        return CustomClassMapper.serialize(object);
    }

    public static Map<String, Object> convertToPlainJavaTypes(Map<?, Object> update) {
        Object converted = CustomClassMapper.serialize(update);
        CustomClassMapper.hardAssert(converted instanceof Map);
        Map convertedMap = (Map)converted;
        return convertedMap;
    }

    public static <T> T convertToCustomClass(Object object, Class<T> clazz) {
        return CustomClassMapper.deserializeToClass(object, clazz);
    }

    static <T> Object serialize(T o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            if (o instanceof Float) {
                return ((Float)o).doubleValue();
            }
            if (o instanceof Short) {
                throw new RuntimeException("Shorts are not supported, please use int or long");
            }
            if (o instanceof Byte) {
                throw new RuntimeException("Bytes are not supported, please use int or long");
            }
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Character) {
            throw new RuntimeException("Characters are not supported, please use Strings");
        }
        if (o instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyString = (String)key;
                    result.put(keyString, CustomClassMapper.serialize(entry.getValue()));
                    continue;
                }
                throw new RuntimeException("Maps with non-string keys are not supported");
            }
            return result;
        }
        if (o instanceof Collection) {
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.serialize(object));
                }
                return result;
            }
            throw new RuntimeException("Serializing Collections is not supported, please use Lists instead");
        }
        if (o.getClass().isArray()) {
            throw new RuntimeException("Serializing Arrays is not supported, please use Lists instead");
        }
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        if (o instanceof Date || o instanceof GeoPoint || o instanceof Blob || o instanceof DocumentReference) {
            return o;
        }
        Class<?> clazz = o.getClass();
        BeanMapper<?> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        return mapper.serialize(o);
    }

    private static <T> T deserializeToType(Object o, Type type) {
        if (o == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return CustomClassMapper.deserializeToParameterizedType(o, (ParameterizedType)type);
        }
        if (type instanceof Class) {
            return CustomClassMapper.deserializeToClass(o, (Class)type);
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw new RuntimeException("Generic Arrays are not supported, please use Lists instead");
        }
        throw new IllegalStateException("Unknown type encountered: " + type);
    }

    private static <T> T deserializeToClass(Object o, Class<T> clazz) {
        if (o == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return CustomClassMapper.deserializeToPrimitive(o, clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertString(o);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDate(o);
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBlob(o);
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertGeoPoint(o);
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDocumentReference(o);
        }
        if (clazz.isArray()) {
            throw new RuntimeException("Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            throw new RuntimeException("Class " + clazz.getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (clazz.equals(Object.class)) {
            return (T)o;
        }
        if (clazz.isEnum()) {
            return CustomClassMapper.deserializeToEnum(o, clazz);
        }
        return CustomClassMapper.convertBean(o, clazz);
    }

    private static <T> T deserializeToParameterizedType(Object o, ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        if (List.class.isAssignableFrom(rawType)) {
            Type genericType = type.getActualTypeArguments()[0];
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<T> result = new ArrayList<T>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.deserializeToType(object, genericType));
                }
                return (T)result;
            }
            throw new RuntimeException("Expected a List while deserializing, but got a " + o.getClass());
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (!keyType.equals(String.class)) {
                throw new RuntimeException("Only Maps with string keys are supported, but found Map with key type " + keyType);
            }
            Map<String, Object> map = CustomClassMapper.expectMap(o);
            HashMap<String, T> result = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.put(entry.getKey(), CustomClassMapper.deserializeToType(entry.getValue(), valueType));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw new RuntimeException("Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = CustomClassMapper.expectMap(o);
        BeanMapper mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(rawType);
        HashMap typeMapping = new HashMap();
        TypeVariable<Class<T>>[] typeVariables = mapper.clazz.getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return mapper.deserialize(map, typeMapping);
    }

    private static <T> T deserializeToPrimitive(Object o, Class<T> clazz) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInteger(o);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBoolean(o);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDouble(o);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertLong(o);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(CustomClassMapper.convertDouble(o).floatValue());
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            throw new RuntimeException("Deserializing to shorts is not supported");
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            throw new RuntimeException("Deserializing to bytes is not supported");
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            throw new RuntimeException("Deserializing to char is not supported");
        }
        throw new IllegalArgumentException("Unknown primitive type: " + clazz);
    }

    private static <T> T deserializeToEnum(Object object, Class<T> clazz) {
        if (object instanceof String) {
            String value = (String)object;
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not find enum value of " + clazz.getName() + " for value \"" + value + "\"");
            }
        }
        throw new RuntimeException("Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static <T> BeanMapper<T> loadOrCreateBeanMapperForClass(Class<T> clazz) {
        BeanMapper<T> mapper = (BeanMapper<T>)mappers.get(clazz);
        if (mapper == null) {
            mapper = new BeanMapper<T>(clazz);
            mappers.put(clazz, mapper);
        }
        return mapper;
    }

    private static Map<String, Object> expectMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new RuntimeException("Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static Integer convertInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long || o instanceof Double) {
            double value = ((Number)o).doubleValue();
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                return ((Number)o).intValue();
            }
            throw new RuntimeException("Numeric value out of 32-bit integer range: " + value + ". Did you mean to use a long or double instead of an int?");
        }
        throw new RuntimeException("Failed to convert a value of type " + o.getClass().getName() + " to int");
    }

    private static Long convertLong(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Double) {
            Double value = (Double)o;
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                return value.longValue();
            }
            throw new RuntimeException("Numeric value out of 64-bit long range: " + value + ". Did you mean to use a double instead of a long?");
        }
        throw new RuntimeException("Failed to convert a value of type " + o.getClass().getName() + " to long");
    }

    private static Double convertDouble(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            Long value = (Long)o;
            Double doubleValue = ((Long)o).doubleValue();
            if (doubleValue.longValue() == value.longValue()) {
                return doubleValue;
            }
            throw new RuntimeException("Loss of precision while converting number to double: " + o + ". Did you mean to use a 64-bit long instead?");
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new RuntimeException("Failed to convert a value of type " + o.getClass().getName() + " to double");
    }

    private static Boolean convertBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to boolean");
    }

    private static String convertString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to String");
    }

    private static Date convertDate(Object o) {
        if (o instanceof Date) {
            return (Date)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to Date");
    }

    private static Blob convertBlob(Object o) {
        if (o instanceof Blob) {
            return (Blob)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to Blob");
    }

    private static GeoPoint convertGeoPoint(Object o) {
        if (o instanceof GeoPoint) {
            return (GeoPoint)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to GeoPoint");
    }

    private static DocumentReference convertDocumentReference(Object o) {
        if (o instanceof DocumentReference) {
            return (DocumentReference)o;
        }
        throw new RuntimeException("Failed to convert value of type " + o.getClass().getName() + " to DocumentReference");
    }

    private static <T> T convertBean(Object o, Class<T> clazz) {
        BeanMapper<T> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        if (o instanceof Map) {
            return mapper.deserialize(CustomClassMapper.expectMap(o));
        }
        throw new RuntimeException("Can't convert object of type " + o.getClass().getName() + " to type " + clazz.getName());
    }

    private static class BeanMapper<T> {
        private final Class<T> clazz;
        private final Constructor<T> constructor;
        private final boolean throwOnUnknownProperties;
        private final boolean warnOnUnknownProperties;
        private final Map<String, String> properties;
        private final Map<String, Method> getters;
        private final Map<String, Method> setters;
        private final Map<String, Field> fields;
        private final HashSet<String> serverTimestamps;

        /*
         * WARNING - void declaration
         */
        public BeanMapper(Class<T> clazz) {
            Constructor<T> constructor;
            this.clazz = clazz;
            this.throwOnUnknownProperties = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.warnOnUnknownProperties = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.properties = new HashMap<String, String>();
            this.setters = new HashMap<String, Method>();
            this.getters = new HashMap<String, Method>();
            this.fields = new HashMap<String, Field>();
            this.serverTimestamps = new HashSet();
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
            this.constructor = constructor;
            for (Method method : clazz.getMethods()) {
                if (!BeanMapper.shouldIncludeGetter(method)) continue;
                String string = BeanMapper.propertyName(method);
                this.addProperty(string);
                method.setAccessible(true);
                if (this.getters.containsKey(string)) {
                    throw new RuntimeException("Found conflicting getters for name: " + method.getName());
                }
                this.getters.put(string, method);
                this.applyGetterAnnotations(method);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!BeanMapper.shouldIncludeField((Field)accessibleObject)) continue;
                String string = BeanMapper.propertyName((Field)accessibleObject);
                this.addProperty(string);
                this.applyFieldAnnotations((Field)accessibleObject);
            }
            Class<T> currentClass = clazz;
            do {
                void var6_13;
                int n;
                AccessibleObject[] accessibleObjectArray = currentClass.getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    String propertyName2;
                    String existingPropertyName;
                    Method method = accessibleObjectArray[n];
                    if (BeanMapper.shouldIncludeSetter(method) && (existingPropertyName = this.properties.get((propertyName2 = BeanMapper.propertyName(method)).toLowerCase(Locale.US))) != null) {
                        if (!existingPropertyName.equals(propertyName2)) {
                            throw new RuntimeException("Found setter with invalid case-sensitive name: " + method.getName());
                        }
                        Method existingSetter = this.setters.get(propertyName2);
                        if (existingSetter == null) {
                            method.setAccessible(true);
                            this.setters.put(propertyName2, method);
                            this.applySetterAnnotations(method);
                        } else if (!BeanMapper.isSetterOverride(method, existingSetter)) {
                            throw new RuntimeException("Found a conflicting setters with name: " + method.getName() + " (conflicts with " + existingSetter.getName() + " defined on " + existingSetter.getDeclaringClass().getName() + ")");
                        }
                    }
                    n += 1;
                }
                accessibleObjectArray = currentClass.getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var6_13 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var6_13];
                    String propertyName = BeanMapper.propertyName((Field)accessibleObject);
                    if (this.properties.containsKey(propertyName.toLowerCase(Locale.US)) && !this.fields.containsKey(propertyName)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.fields.put(propertyName, (Field)accessibleObject);
                        this.applyFieldAnnotations((Field)accessibleObject);
                    }
                    ++var6_13;
                }
            } while ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(Object.class));
            if (this.properties.isEmpty()) {
                throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
            }
        }

        private void addProperty(String property) {
            String oldValue = this.properties.put(property.toLowerCase(Locale.US), property);
            if (oldValue != null && !property.equals(oldValue)) {
                throw new RuntimeException("Found two getters or fields with conflicting case sensitivity for property: " + property.toLowerCase(Locale.US));
            }
        }

        public T deserialize(Map<String, Object> values) {
            return this.deserialize(values, Collections.emptyMap());
        }

        public T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types) {
            T instance;
            if (this.constructor == null) {
                throw new RuntimeException("Class " + this.clazz.getName() + " does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped.");
            }
            try {
                instance = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String propertyName = entry.getKey();
                if (this.setters.containsKey(propertyName)) {
                    Method setter = this.setters.get(propertyName);
                    Type[] params = setter.getGenericParameterTypes();
                    if (params.length != 1) {
                        throw new IllegalStateException("Setter does not have exactly one parameter");
                    }
                    Type resolvedType = this.resolveType(params[0], types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        setter.invoke(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.fields.containsKey(propertyName)) {
                    Field field = this.fields.get(propertyName);
                    Type resolvedType = this.resolveType(field.getGenericType(), types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        field.set(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                String message = "No setter/field for " + propertyName + " found on class " + this.clazz.getName();
                if (this.properties.containsKey(propertyName.toLowerCase(Locale.US))) {
                    message = message + " (fields/setters are case sensitive!)";
                }
                if (this.throwOnUnknownProperties) {
                    throw new RuntimeException(message);
                }
                if (!this.warnOnUnknownProperties) continue;
                System.out.print(message);
            }
            return instance;
        }

        private Type resolveType(Type type, Map<TypeVariable<Class<T>>, Type> types) {
            if (type instanceof TypeVariable) {
                Type resolvedType = types.get(type);
                if (resolvedType == null) {
                    throw new IllegalStateException("Could not resolve type " + type);
                }
                return resolvedType;
            }
            return type;
        }

        public Map<String, Object> serialize(T object) {
            if (!this.clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Can't serialize object of class " + object.getClass() + " with BeanMapper for class " + this.clazz);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String property : this.properties.values()) {
                Object propertyValue;
                if (this.getters.containsKey(property)) {
                    Method getter = this.getters.get(property);
                    try {
                        propertyValue = getter.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                Field field = this.fields.get(property);
                if (field == null) {
                    throw new IllegalStateException("Bean property without field or getter:" + property);
                }
                try {
                    propertyValue = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                Object serializedValue = this.serverTimestamps.contains(property) && propertyValue == null ? FieldValue.serverTimestamp() : CustomClassMapper.serialize(propertyValue);
                result.put(property, serializedValue);
            }
            return result;
        }

        private void applyFieldAnnotations(Field field) {
            if (field.isAnnotationPresent(ServerTimestamp.class)) {
                Class<?> fieldType = field.getType();
                if (fieldType != Date.class) {
                    throw new IllegalArgumentException("Field " + field.getName() + " is annotated with @ServerTimestamp but is " + fieldType + " instead of Date.");
                }
                this.serverTimestamps.add(BeanMapper.propertyName(field));
            }
        }

        private void applyGetterAnnotations(Method method) {
            if (method.isAnnotationPresent(ServerTimestamp.class)) {
                Class<?> returnType = method.getReturnType();
                if (returnType != Date.class) {
                    throw new IllegalArgumentException("Method " + method.getName() + " is annotated with @ServerTimestamp but returns " + returnType + " instead of Date.");
                }
                this.serverTimestamps.add(BeanMapper.propertyName(method));
            }
        }

        private void applySetterAnnotations(Method method) {
            if (method.isAnnotationPresent(ServerTimestamp.class)) {
                throw new IllegalArgumentException("Method " + method.getName() + " is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.");
            }
        }

        private static boolean shouldIncludeGetter(Method method) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeSetter(Method method) {
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeField(Field field) {
            if (field.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return false;
            }
            return !field.isAnnotationPresent(Exclude.class);
        }

        private static boolean isSetterOverride(Method base, Method override) {
            CustomClassMapper.hardAssert(base.getDeclaringClass().isAssignableFrom(override.getDeclaringClass()), "Expected override from a base class");
            CustomClassMapper.hardAssert(base.getReturnType().equals(Void.TYPE), "Expected void return type");
            CustomClassMapper.hardAssert(override.getReturnType().equals(Void.TYPE), "Expected void return type");
            Class<?>[] baseParameterTypes = base.getParameterTypes();
            Class<?>[] overrideParameterTypes = override.getParameterTypes();
            CustomClassMapper.hardAssert(baseParameterTypes.length == 1, "Expected exactly one parameter");
            CustomClassMapper.hardAssert(overrideParameterTypes.length == 1, "Expected exactly one parameter");
            return base.getName().equals(override.getName()) && baseParameterTypes[0].equals(overrideParameterTypes[0]);
        }

        private static String propertyName(Field field) {
            String annotatedName = BeanMapper.annotatedName(field);
            return annotatedName != null ? annotatedName : field.getName();
        }

        private static String propertyName(Method method) {
            String annotatedName = BeanMapper.annotatedName(method);
            return annotatedName != null ? annotatedName : BeanMapper.serializedName(method.getName());
        }

        private static String annotatedName(AccessibleObject obj) {
            if (obj.isAnnotationPresent(PropertyName.class)) {
                PropertyName annotation = obj.getAnnotation(PropertyName.class);
                return annotation.value();
            }
            return null;
        }

        private static String serializedName(String methodName) {
            String[] prefixes = new String[]{"get", "set", "is"};
            String methodPrefix = null;
            for (String prefix : prefixes) {
                if (!methodName.startsWith(prefix)) continue;
                methodPrefix = prefix;
            }
            if (methodPrefix == null) {
                throw new IllegalArgumentException("Unknown Bean prefix for method: " + methodName);
            }
            String strippedName = methodName.substring(methodPrefix.length());
            char[] chars = strippedName.toCharArray();
            for (int pos = 0; pos < chars.length && Character.isUpperCase(chars[pos]); ++pos) {
                chars[pos] = Character.toLowerCase(chars[pos]);
            }
            return new String(chars);
        }
    }
}

