/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.grpc.BaseGrpcServiceException;
import io.grpc.Status;
import java.io.IOException;
import javax.annotation.Nullable;

public final class FirestoreException
extends BaseGrpcServiceException {
    private Status status;

    private FirestoreException(String reason, Status status) {
        this(reason, status, null);
    }

    private FirestoreException(String reason, Status status, @Nullable Throwable cause) {
        super(reason, cause, status.getCode().value(), false);
        this.status = status;
    }

    private FirestoreException(String reason, ApiException exception) {
        super(reason, (Throwable)exception, exception.getStatusCode().getCode().getHttpStatusCode(), exception.isRetryable());
    }

    private FirestoreException(IOException exception, boolean retryable) {
        super(exception, retryable);
    }

    static FirestoreException invalidState(String message, Object ... params) {
        return new FirestoreException(String.format(message, params), Status.INVALID_ARGUMENT);
    }

    static FirestoreException serverRejected(Status status, String message, Object ... params) {
        return FirestoreException.serverRejected(status, null, message, params);
    }

    static FirestoreException serverRejected(Status status, @Nullable Throwable cause, String message, Object ... params) {
        return new FirestoreException(String.format(message, params), status, cause);
    }

    static FirestoreException networkException(IOException exception, boolean retryable) {
        return new FirestoreException(exception, retryable);
    }

    static FirestoreException apiException(ApiException exception) {
        return new FirestoreException(exception.getMessage(), exception);
    }

    static FirestoreException apiException(ApiException exception, String message) {
        return new FirestoreException(message, exception);
    }

    @InternalApi
    @Nullable
    Status getStatus() {
        return this.status;
    }
}

