/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Set;

class BulkCommitBatch
extends UpdateBuilder<ApiFuture<WriteResult>> {
    BulkCommitBatch(FirestoreImpl firestore, int maxBatchSize) {
        super(firestore, maxBatchSize);
    }

    BulkCommitBatch(FirestoreImpl firestore, BulkCommitBatch retryBatch, final Set<DocumentReference> docsToRetry) {
        super(firestore);
        this.writes.addAll(FluentIterable.from((Iterable)retryBatch.writes).filter((Predicate)new Predicate<UpdateBuilder.WriteOperation>(){

            public boolean apply(UpdateBuilder.WriteOperation writeOperation) {
                return docsToRetry.contains(writeOperation.documentReference);
            }
        }).toList());
        Preconditions.checkState((retryBatch.state == UpdateBuilder.BatchState.SENT ? 1 : 0) != 0, (Object)"Batch should be SENT when creating a new BulkCommitBatch for retry");
        this.state = retryBatch.state;
        this.pendingOperations = retryBatch.pendingOperations;
    }

    @Override
    ApiFuture<WriteResult> wrapResult(ApiFuture<WriteResult> result) {
        return result;
    }

    @Override
    boolean allowDuplicateDocs() {
        return false;
    }
}

