/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.auto.value.AutoValue;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AutoValue_Query_QueryOptions;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Order;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.Watch;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class Query {
    final FirestoreRpcContext<?> rpcContext;
    final QueryOptions options;

    Query(FirestoreRpcContext<?> rpcContext, ResourcePath path) {
        this(rpcContext, QueryOptions.builder().setParentPath((ResourcePath)path.getParent()).setCollectionId(path.getId()).build());
    }

    protected Query(FirestoreRpcContext<?> rpcContext, QueryOptions queryOptions) {
        this.rpcContext = rpcContext;
        this.options = queryOptions;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.rpcContext.getFirestore();
    }

    private static boolean isUnaryComparison(@Nullable Object value) {
        return value == null || value.equals(Double.NaN) || value.equals(Float.valueOf(Float.NaN));
    }

    private ImmutableList<FieldOrder> createImplicitOrderBy() {
        ArrayList<FieldOrder> implicitOrders = new ArrayList<FieldOrder>((Collection<FieldOrder>)this.options.getFieldOrders());
        boolean hasDocumentId = false;
        if (implicitOrders.isEmpty()) {
            for (FieldFilter fieldFilter : this.options.getFieldFilters()) {
                if (!fieldFilter.isInequalityFilter()) continue;
                implicitOrders.add(new FieldOrder(fieldFilter.fieldReference, Direction.ASCENDING));
                break;
            }
        } else {
            for (FieldOrder fieldOrder : this.options.getFieldOrders()) {
                if (!FieldPath.isDocumentId(fieldOrder.fieldReference.getFieldPath())) continue;
                hasDocumentId = true;
            }
        }
        if (!hasDocumentId) {
            Direction lastDirection = implicitOrders.isEmpty() ? Direction.ASCENDING : ((FieldOrder)implicitOrders.get(implicitOrders.size() - 1)).direction;
            implicitOrders.add(new FieldOrder(FieldPath.documentId().toProto(), lastDirection));
        }
        return ImmutableList.builder().addAll(implicitOrders).build();
    }

    private Cursor createCursor(ImmutableList<FieldOrder> order, DocumentSnapshot documentSnapshot, boolean before) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        for (FieldOrder fieldOrder : order) {
            String path = fieldOrder.fieldReference.getFieldPath();
            if (FieldPath.isDocumentId(path)) {
                fieldValues.add(documentSnapshot.getReference());
                continue;
            }
            FieldPath fieldPath = FieldPath.fromDotSeparatedString(path);
            Preconditions.checkArgument((boolean)documentSnapshot.contains(fieldPath), (Object)"Field '%s' is missing in the provided DocumentSnapshot. Please provide a document that contains values for all specified orderBy() and where() constraints.");
            fieldValues.add(documentSnapshot.get(fieldPath));
        }
        return this.createCursor((List<FieldOrder>)order, fieldValues.toArray(), before);
    }

    private Cursor createCursor(List<FieldOrder> order, Object[] fieldValues, boolean before) {
        Cursor.Builder result = Cursor.newBuilder();
        Preconditions.checkState((fieldValues.length != 0 ? 1 : 0) != 0, (Object)"At least one cursor value must be specified.");
        Preconditions.checkState((fieldValues.length <= order.size() ? 1 : 0) != 0, (Object)"Too many cursor values specified. The specified values must match the orderBy() constraints of the query.");
        Iterator<FieldOrder> fieldOrderIterator = order.iterator();
        for (Object fieldValue : fieldValues) {
            StructuredQuery.FieldReference fieldReference;
            Object sanitizedValue = FieldPath.isDocumentId((fieldReference = fieldOrderIterator.next().fieldReference).getFieldPath()) ? this.convertReference(fieldValue) : CustomClassMapper.serialize(fieldValue);
            Value encodedValue = this.encodeValue(fieldReference, sanitizedValue);
            if (encodedValue == null) {
                throw FirestoreException.invalidState("Cannot use FieldValue.delete() or FieldValue.serverTimestamp() in a query boundary", new Object[0]);
            }
            result.addValues(encodedValue);
        }
        result.setBefore(before);
        return result.build();
    }

    private Object convertReference(Object fieldValue) {
        DocumentReference reference;
        ResourcePath basePath;
        ResourcePath resourcePath = basePath = this.options.getAllDescendants() ? this.options.getParentPath() : (ResourcePath)this.options.getParentPath().append(this.options.getCollectionId());
        if (fieldValue instanceof String) {
            reference = new DocumentReference(this.rpcContext, (ResourcePath)basePath.append((String)fieldValue));
        } else if (fieldValue instanceof DocumentReference) {
            reference = (DocumentReference)fieldValue;
        } else {
            throw new IllegalArgumentException(String.format("The corresponding value for FieldPath.documentId() must be a String or a DocumentReference, but was: %s.", fieldValue.toString()));
        }
        if (!basePath.isPrefixOf(reference.getResourcePath())) {
            throw new IllegalArgumentException(String.format("'%s' is not part of the query result set and cannot be used as a query boundary.", reference.getPath()));
        }
        if (!this.options.getAllDescendants() && !reference.getParent().getResourcePath().equals(basePath)) {
            throw new IllegalArgumentException(String.format("Only a direct child can be used as a query boundary. Found: '%s'", reference.getPath()));
        }
        return reference;
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull String field, @Nullable Object value) {
        return this.whereEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        if (Query.isUnaryComparison(value)) {
            QueryOptions.Builder newOptions = this.options.toBuilder();
            StructuredQuery.UnaryFilter.Operator op = value == null ? StructuredQuery.UnaryFilter.Operator.IS_NULL : StructuredQuery.UnaryFilter.Operator.IS_NAN;
            UnaryFilter newFieldFilter = new UnaryFilter(fieldPath.toProto(), op);
            newOptions.setFieldFilters(this.append(this.options.getFieldFilters(), newFieldFilter));
            return new Query(this.rpcContext, newOptions.build());
        }
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.EQUAL, value);
    }

    @Nonnull
    public Query whereNotEqualTo(@Nonnull String field, @Nullable Object value) {
        return this.whereNotEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereNotEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereNotEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        if (Query.isUnaryComparison(value)) {
            QueryOptions.Builder newOptions = this.options.toBuilder();
            StructuredQuery.UnaryFilter.Operator op = value == null ? StructuredQuery.UnaryFilter.Operator.IS_NOT_NULL : StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN;
            UnaryFilter newFieldFilter = new UnaryFilter(fieldPath.toProto(), op);
            newOptions.setFieldFilters(this.append(this.options.getFieldFilters(), newFieldFilter));
            return new Query(this.rpcContext, newOptions.build());
        }
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.NOT_EQUAL, value);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereLessThan() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN, value);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereLessThanOrEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereGreaterThan() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN, value);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereGreaterThanOrEqualTo() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @Nonnull
    public Query whereArrayContains(@Nonnull String field, @Nonnull Object value) {
        return this.whereArrayContains(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereArrayContains(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereArrayContains() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS, value);
    }

    @Nonnull
    public Query whereArrayContainsAny(@Nonnull String field, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereArrayContainsAny() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(FieldPath.fromDotSeparatedString(field), StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY, values);
    }

    @Nonnull
    public Query whereArrayContainsAny(@Nonnull FieldPath fieldPath, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereArrayContainsAny() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY, values);
    }

    @Nonnull
    public Query whereIn(@Nonnull String field, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereIn() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(FieldPath.fromDotSeparatedString(field), StructuredQuery.FieldFilter.Operator.IN, values);
    }

    @Nonnull
    public Query whereIn(@Nonnull FieldPath fieldPath, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereIn() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.IN, values);
    }

    @Nonnull
    public Query whereNotIn(@Nonnull String field, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereNotIn() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(FieldPath.fromDotSeparatedString(field), StructuredQuery.FieldFilter.Operator.NOT_IN, values);
    }

    @Nonnull
    public Query whereNotIn(@Nonnull FieldPath fieldPath, @Nonnull List<? extends Object> values) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot call whereNotIn() after defining a boundary with startAt(), startAfter(), endBefore() or endAt().");
        return this.whereHelper(fieldPath, StructuredQuery.FieldFilter.Operator.NOT_IN, values);
    }

    private Query whereHelper(FieldPath fieldPath, StructuredQuery.FieldFilter.Operator operator, Object value) {
        Preconditions.checkArgument((!Query.isUnaryComparison(value) ? 1 : 0) != 0, (String)"Cannot use '%s' in field comparison. Use an equality filter instead.", (Object)value);
        if (fieldPath.equals(FieldPath.DOCUMENT_ID)) {
            if (operator == StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS || operator == StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY) {
                throw new IllegalArgumentException(String.format("Invalid query. You cannot perform '%s' queries on FieldPath.documentId().", operator.toString()));
            }
            if (operator == StructuredQuery.FieldFilter.Operator.IN | operator == StructuredQuery.FieldFilter.Operator.NOT_IN) {
                if (!(value instanceof List) || ((List)value).isEmpty()) {
                    throw new IllegalArgumentException(String.format("Invalid Query. A non-empty array is required for '%s' filters.", operator.toString()));
                }
                ArrayList<Object> referenceList = new ArrayList<Object>();
                for (Object arrayValue : (List)value) {
                    Object convertedValue = this.convertReference(arrayValue);
                    referenceList.add(convertedValue);
                }
                value = referenceList;
            } else {
                value = this.convertReference(value);
            }
        }
        QueryOptions.Builder newOptions = this.options.toBuilder();
        ComparisonFilter newFieldFilter = new ComparisonFilter(fieldPath.toProto(), operator, this.encodeValue(fieldPath, (Object)value));
        newOptions.setFieldFilters(this.append(this.options.getFieldFilters(), newFieldFilter));
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query orderBy(@Nonnull String field) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath) {
        return this.orderBy(fieldPath, Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull String field, @Nonnull Direction direction) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), direction);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath, @Nonnull Direction direction) {
        Preconditions.checkState((this.options.getStartCursor() == null && this.options.getEndCursor() == null ? 1 : 0) != 0, (Object)"Cannot specify an orderBy() constraint after calling startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions.Builder newOptions = this.options.toBuilder();
        FieldOrder newFieldOrder = new FieldOrder(fieldPath.toProto(), direction);
        newOptions.setFieldOrders(this.append(this.options.getFieldOrders(), newFieldOrder));
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query limit(int limit) {
        return new Query(this.rpcContext, this.options.toBuilder().setLimit(limit).setLimitType(LimitType.First).build());
    }

    @Nonnull
    public Query limitToLast(int limit) {
        return new Query(this.rpcContext, this.options.toBuilder().setLimit(limit).setLimitType(LimitType.Last).build());
    }

    @Nonnull
    public Query offset(int offset) {
        return new Query(this.rpcContext, this.options.toBuilder().setOffset(offset).build());
    }

    @Nonnull
    public Query startAt(@Nonnull DocumentSnapshot snapshot) {
        ImmutableList<FieldOrder> fieldOrders = this.createImplicitOrderBy();
        Cursor cursor = this.createCursor(fieldOrders, snapshot, true);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setFieldOrders(fieldOrders);
        newOptions.setStartCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query startAt(Object ... fieldValues) {
        Cursor cursor = this.createCursor((List<FieldOrder>)this.options.getFieldOrders(), fieldValues, true);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setStartCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query select(String ... fields) {
        FieldPath[] fieldPaths = new FieldPath[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldPaths[i] = FieldPath.fromDotSeparatedString(fields[i]);
        }
        return this.select(fieldPaths);
    }

    @Nonnull
    public Query select(FieldPath ... fieldPaths) {
        ImmutableList.Builder fieldProjections = ImmutableList.builder();
        if (fieldPaths.length == 0) {
            fieldPaths = new FieldPath[]{FieldPath.DOCUMENT_ID};
        }
        for (FieldPath path : fieldPaths) {
            StructuredQuery.FieldReference fieldReference = StructuredQuery.FieldReference.newBuilder().setFieldPath(path.getEncodedPath()).build();
            fieldProjections.add((Object)fieldReference);
        }
        QueryOptions.Builder newOptions = this.options.toBuilder().setFieldProjections((ImmutableList<StructuredQuery.FieldReference>)fieldProjections.build());
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query startAfter(@Nonnull DocumentSnapshot snapshot) {
        ImmutableList<FieldOrder> fieldOrders = this.createImplicitOrderBy();
        Cursor cursor = this.createCursor(fieldOrders, snapshot, false);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setFieldOrders(fieldOrders);
        newOptions.setStartCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    public Query startAfter(Object ... fieldValues) {
        Cursor cursor = this.createCursor((List<FieldOrder>)this.options.getFieldOrders(), fieldValues, false);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setStartCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query endBefore(@Nonnull DocumentSnapshot snapshot) {
        ImmutableList<FieldOrder> fieldOrders = this.createImplicitOrderBy();
        Cursor cursor = this.createCursor(fieldOrders, snapshot, true);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setFieldOrders(fieldOrders);
        newOptions.setEndCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query endBefore(Object ... fieldValues) {
        Cursor cursor = this.createCursor((List<FieldOrder>)this.options.getFieldOrders(), fieldValues, true);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setEndCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query endAt(Object ... fieldValues) {
        Cursor cursor = this.createCursor((List<FieldOrder>)this.options.getFieldOrders(), fieldValues, false);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setEndCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    @Nonnull
    public Query endAt(@Nonnull DocumentSnapshot snapshot) {
        ImmutableList<FieldOrder> fieldOrders = this.createImplicitOrderBy();
        Cursor cursor = this.createCursor(fieldOrders, snapshot, false);
        QueryOptions.Builder newOptions = this.options.toBuilder();
        newOptions.setFieldOrders(fieldOrders);
        newOptions.setEndCursor(cursor);
        return new Query(this.rpcContext, newOptions.build());
    }

    StructuredQuery.Builder buildQuery() {
        Cursor cursor;
        StructuredQuery.Filter filter;
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        StructuredQuery.CollectionSelector.Builder collectionSelector = StructuredQuery.CollectionSelector.newBuilder();
        collectionSelector.setCollectionId(this.options.getCollectionId());
        collectionSelector.setAllDescendants(this.options.getAllDescendants());
        structuredQuery.addFrom(collectionSelector);
        if (this.options.getFieldFilters().size() == 1) {
            filter = ((FieldFilter)this.options.getFieldFilters().get(0)).toProto();
            if (filter.hasFieldFilter()) {
                structuredQuery.getWhereBuilder().setFieldFilter(filter.getFieldFilter());
            } else {
                Preconditions.checkState((boolean)filter.hasUnaryFilter(), (Object)"Expected a UnaryFilter or a FieldFilter.");
                structuredQuery.getWhereBuilder().setUnaryFilter(filter.getUnaryFilter());
            }
        } else if (this.options.getFieldFilters().size() > 1) {
            filter = StructuredQuery.Filter.newBuilder();
            StructuredQuery.CompositeFilter.Builder compositeFilter = StructuredQuery.CompositeFilter.newBuilder();
            compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
            for (FieldFilter fieldFilter : this.options.getFieldFilters()) {
                compositeFilter.addFilters(fieldFilter.toProto());
            }
            filter.setCompositeFilter(compositeFilter.build());
            structuredQuery.setWhere(filter.build());
        }
        if (!this.options.getFieldOrders().isEmpty()) {
            for (FieldOrder order : this.options.getFieldOrders()) {
                switch (this.options.getLimitType()) {
                    case First: {
                        structuredQuery.addOrderBy(order.toProto());
                        break;
                    }
                    case Last: {
                        order = new FieldOrder(order.fieldReference, order.direction.equals((Object)Direction.ASCENDING) ? Direction.DESCENDING : Direction.ASCENDING);
                        structuredQuery.addOrderBy(order.toProto());
                    }
                }
            }
        } else if (LimitType.Last.equals((Object)this.options.getLimitType())) {
            throw new IllegalStateException("limitToLast() queries require specifying at least one orderBy() clause.");
        }
        if (!this.options.getFieldProjections().isEmpty()) {
            structuredQuery.getSelectBuilder().addAllFields(this.options.getFieldProjections());
        }
        if (this.options.getLimit() != null) {
            structuredQuery.setLimit(Int32Value.newBuilder().setValue(this.options.getLimit().intValue()));
        }
        if (this.options.getOffset() != null) {
            structuredQuery.setOffset(this.options.getOffset().intValue());
        }
        if (this.options.getStartCursor() != null) {
            switch (this.options.getLimitType()) {
                case First: {
                    structuredQuery.setStartAt(this.options.getStartCursor());
                    break;
                }
                case Last: {
                    cursor = this.options.getStartCursor().toBuilder().setBefore(!this.options.getStartCursor().getBefore()).build();
                    structuredQuery.setEndAt(cursor);
                }
            }
        }
        if (this.options.getEndCursor() != null) {
            switch (this.options.getLimitType()) {
                case First: {
                    structuredQuery.setEndAt(this.options.getEndCursor());
                    break;
                }
                case Last: {
                    cursor = this.options.getEndCursor().toBuilder().setBefore(!this.options.getEndCursor().getBefore()).build();
                    structuredQuery.setStartAt(cursor);
                }
            }
        }
        return structuredQuery;
    }

    public void stream(final @Nonnull ApiStreamObserver<DocumentSnapshot> responseObserver) {
        Preconditions.checkState((!LimitType.Last.equals((Object)this.options.getLimitType()) ? 1 : 0) != 0, (Object)"Query results for queries that include limitToLast() constraints cannot be streamed. Use Query.get() instead.");
        this.internalStream(new QuerySnapshotObserver(){

            public void onNext(QueryDocumentSnapshot documentSnapshot) {
                responseObserver.onNext((Object)documentSnapshot);
            }

            public void onError(Throwable throwable) {
                responseObserver.onError(throwable);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        }, null);
    }

    public RunQueryRequest toProto() {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        request.setStructuredQuery(this.buildQuery()).setParent(this.options.getParentPath().toString());
        return request.build();
    }

    public static Query fromProto(Firestore firestore, RunQueryRequest proto) {
        Preconditions.checkState((boolean)FirestoreRpcContext.class.isAssignableFrom(firestore.getClass()), (Object)"The firestore instance passed to this method must also implement FirestoreRpcContext.");
        return Query.fromProto((FirestoreRpcContext)((Object)firestore), proto);
    }

    private static Query fromProto(FirestoreRpcContext<?> rpcContext, RunQueryRequest proto) {
        QueryOptions.Builder queryOptions = QueryOptions.builder();
        StructuredQuery structuredQuery = proto.getStructuredQuery();
        ResourcePath parentPath = ResourcePath.create(proto.getParent());
        if (!rpcContext.getDatabaseName().equals(parentPath.getDatabaseName().toString())) {
            throw new IllegalArgumentException(String.format("Cannot deserialize query from different Firestore project (\"%s\" vs \"%s\")", rpcContext.getDatabaseName(), parentPath.getDatabaseName()));
        }
        queryOptions.setParentPath(parentPath);
        Preconditions.checkArgument((structuredQuery.getFromCount() == 1 ? 1 : 0) != 0, (Object)"Can only deserialize query with exactly one collection selector.");
        queryOptions.setCollectionId(structuredQuery.getFrom(0).getCollectionId());
        queryOptions.setAllDescendants(structuredQuery.getFrom(0).getAllDescendants());
        if (structuredQuery.hasWhere()) {
            StructuredQuery.Filter where = structuredQuery.getWhere();
            if (where.hasCompositeFilter()) {
                StructuredQuery.CompositeFilter compositeFilter = where.getCompositeFilter();
                ImmutableList.Builder fieldFilters = ImmutableList.builder();
                for (StructuredQuery.Filter filter : compositeFilter.getFiltersList()) {
                    fieldFilters.add((Object)FieldFilter.fromProto(filter));
                }
                queryOptions.setFieldFilters((ImmutableList<FieldFilter>)fieldFilters.build());
            } else {
                queryOptions.setFieldFilters((ImmutableList<FieldFilter>)ImmutableList.of((Object)FieldFilter.fromProto(where)));
            }
        }
        ImmutableList.Builder fieldOrders = ImmutableList.builder();
        for (StructuredQuery.Order order : structuredQuery.getOrderByList()) {
            fieldOrders.add((Object)new FieldOrder(order.getField(), Direction.valueOf(order.getDirection().name())));
        }
        queryOptions.setFieldOrders((ImmutableList<FieldOrder>)fieldOrders.build());
        if (structuredQuery.hasLimit()) {
            queryOptions.setLimit(structuredQuery.getLimit().getValue());
        }
        if (structuredQuery.getOffset() != 0) {
            queryOptions.setOffset(structuredQuery.getOffset());
        }
        if (structuredQuery.hasSelect()) {
            queryOptions.setFieldProjections((ImmutableList<StructuredQuery.FieldReference>)ImmutableList.copyOf((Collection)structuredQuery.getSelect().getFieldsList()));
        }
        if (structuredQuery.hasStartAt()) {
            queryOptions.setStartCursor(structuredQuery.getStartAt());
        }
        if (structuredQuery.hasEndAt()) {
            queryOptions.setEndCursor(structuredQuery.getEndAt());
        }
        return new Query(rpcContext, queryOptions.build());
    }

    private Value encodeValue(StructuredQuery.FieldReference fieldReference, Object value) {
        return this.encodeValue(FieldPath.fromDotSeparatedString(fieldReference.getFieldPath()), value);
    }

    private Value encodeValue(FieldPath fieldPath, Object value) {
        Object sanitizedObject = CustomClassMapper.serialize(value);
        Value encodedValue = UserDataConverter.encodeValue(fieldPath, sanitizedObject, UserDataConverter.ARGUMENT);
        if (encodedValue == null) {
            throw FirestoreException.invalidState("Cannot use Firestore sentinels in FieldFilter or cursors", new Object[0]);
        }
        return encodedValue;
    }

    private void internalStream(final QuerySnapshotObserver documentObserver, @Nullable ByteString transactionId) {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        request.setStructuredQuery(this.buildQuery()).setParent(this.options.getParentPath().toString());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.RunQuery: Start", (Map)ImmutableMap.of((Object)"transactional", (Object)AttributeValue.booleanAttributeValue((transactionId != null ? 1 : 0) != 0)));
        ApiStreamObserver<RunQueryResponse> observer = new ApiStreamObserver<RunQueryResponse>(){
            Timestamp readTime;
            boolean firstResponse;
            int numDocuments;

            public void onNext(RunQueryResponse response) {
                if (!this.firstResponse) {
                    this.firstResponse = true;
                    Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: First response");
                }
                if (response.hasDocument()) {
                    ++this.numDocuments;
                    if (this.numDocuments % 100 == 0) {
                        Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Received 100 documents");
                    }
                    Document document = response.getDocument();
                    QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(Query.this.rpcContext, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime()), document);
                    documentObserver.onNext(documentSnapshot);
                }
                if (this.readTime == null) {
                    this.readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime());
                }
            }

            public void onError(Throwable throwable) {
                Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Error");
                documentObserver.onError(throwable);
            }

            public void onCompleted() {
                Tracing.getTracer().getCurrentSpan().addAnnotation("Firestore.Query: Completed", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)this.numDocuments)));
                documentObserver.onCompleted(this.readTime);
            }
        };
        this.rpcContext.streamRequest(request.build(), observer, this.rpcContext.getClient().runQueryCallable());
    }

    @Nonnull
    public ApiFuture<QuerySnapshot> get() {
        return this.get(null);
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(this.rpcContext.getClient().getExecutor(), listener);
    }

    @Nonnull
    public ListenerRegistration addSnapshotListener(@Nonnull Executor executor, @Nonnull EventListener<QuerySnapshot> listener) {
        return Watch.forQuery(this).runWatch(executor, listener);
    }

    ApiFuture<QuerySnapshot> get(@Nullable ByteString transactionId) {
        final SettableApiFuture result = SettableApiFuture.create();
        this.internalStream(new QuerySnapshotObserver(){
            List<QueryDocumentSnapshot> documentSnapshots = new ArrayList<QueryDocumentSnapshot>();

            public void onNext(QueryDocumentSnapshot documentSnapshot) {
                this.documentSnapshots.add(documentSnapshot);
            }

            public void onError(Throwable throwable) {
                result.setException(throwable);
            }

            public void onCompleted() {
                List resultView = LimitType.Last.equals((Object)Query.this.options.getLimitType()) ? Lists.reverse(this.documentSnapshots) : this.documentSnapshots;
                QuerySnapshot querySnapshot = QuerySnapshot.withDocuments(Query.this, this.getReadTime(), resultView);
                result.set((Object)querySnapshot);
            }
        }, transactionId);
        return result;
    }

    Comparator<QueryDocumentSnapshot> comparator() {
        return new Comparator<QueryDocumentSnapshot>(){

            @Override
            public int compare(QueryDocumentSnapshot doc1, QueryDocumentSnapshot doc2) {
                ImmutableList<FieldOrder> fieldOrders = Query.this.options.getFieldOrders();
                Direction lastDirection = fieldOrders.isEmpty() ? Direction.ASCENDING : ((FieldOrder)fieldOrders.get(fieldOrders.size() - 1)).direction;
                ArrayList<FieldOrder> orderBys = new ArrayList<FieldOrder>((Collection<FieldOrder>)fieldOrders);
                orderBys.add(new FieldOrder(FieldPath.DOCUMENT_ID.toProto(), lastDirection));
                for (FieldOrder orderBy : orderBys) {
                    int comp;
                    String path = orderBy.fieldReference.getFieldPath();
                    if (FieldPath.isDocumentId(path)) {
                        comp = doc1.getReference().getResourcePath().compareTo(doc2.getReference().getResourcePath());
                    } else {
                        FieldPath fieldPath = FieldPath.fromDotSeparatedString(path);
                        Preconditions.checkState((doc1.contains(fieldPath) && doc2.contains(fieldPath) ? 1 : 0) != 0, (Object)"Can only compare fields that exist in the DocumentSnapshot. Please include the fields you are ordering on in your select() call.");
                        Value v1 = doc1.extractField(fieldPath);
                        Value v2 = doc2.extractField(fieldPath);
                        comp = Order.INSTANCE.compare(v1, v2);
                    }
                    if (comp == 0) continue;
                    int direction = orderBy.direction.equals((Object)Direction.ASCENDING) ? 1 : -1;
                    return direction * comp;
                }
                return 0;
            }
        };
    }

    private <T> ImmutableList<T> append(ImmutableList<T> existingList, T newElement) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(existingList);
        builder.add(newElement);
        return builder.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Query)) {
            return false;
        }
        Query query = (Query)obj;
        return Objects.equals(this.rpcContext, query.rpcContext) && Objects.equals(this.options, query.options);
    }

    public int hashCode() {
        return Objects.hash(this.rpcContext, this.options);
    }

    private static abstract class QuerySnapshotObserver
    implements ApiStreamObserver<QueryDocumentSnapshot> {
        private Timestamp readTime;

        private QuerySnapshotObserver() {
        }

        void onCompleted(Timestamp readTime) {
            this.readTime = readTime;
            this.onCompleted();
        }

        Timestamp getReadTime() {
            return this.readTime;
        }
    }

    @AutoValue
    static abstract class QueryOptions {
        QueryOptions() {
        }

        abstract ResourcePath getParentPath();

        abstract String getCollectionId();

        abstract boolean getAllDescendants();

        @Nullable
        abstract Integer getLimit();

        abstract LimitType getLimitType();

        @Nullable
        abstract Integer getOffset();

        @Nullable
        abstract Cursor getStartCursor();

        @Nullable
        abstract Cursor getEndCursor();

        abstract ImmutableList<FieldFilter> getFieldFilters();

        abstract ImmutableList<FieldOrder> getFieldOrders();

        abstract ImmutableList<StructuredQuery.FieldReference> getFieldProjections();

        static Builder builder() {
            return new AutoValue_Query_QueryOptions.Builder().setAllDescendants(false).setLimitType(LimitType.First).setFieldOrders((ImmutableList<FieldOrder>)ImmutableList.of()).setFieldFilters((ImmutableList<FieldFilter>)ImmutableList.of()).setFieldProjections((ImmutableList<StructuredQuery.FieldReference>)ImmutableList.of());
        }

        abstract Builder toBuilder();

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setParentPath(ResourcePath var1);

            abstract Builder setCollectionId(String var1);

            abstract Builder setAllDescendants(boolean var1);

            abstract Builder setLimit(Integer var1);

            abstract Builder setLimitType(LimitType var1);

            abstract Builder setOffset(Integer var1);

            abstract Builder setStartCursor(@Nullable Cursor var1);

            abstract Builder setEndCursor(@Nullable Cursor var1);

            abstract Builder setFieldFilters(ImmutableList<FieldFilter> var1);

            abstract Builder setFieldOrders(ImmutableList<FieldOrder> var1);

            abstract Builder setFieldProjections(ImmutableList<StructuredQuery.FieldReference> var1);

            abstract QueryOptions build();
        }
    }

    static enum LimitType {
        First,
        Last;

    }

    static final class FieldOrder {
        private final StructuredQuery.FieldReference fieldReference;
        private final Direction direction;

        FieldOrder(StructuredQuery.FieldReference fieldReference, Direction direction) {
            this.fieldReference = fieldReference;
            this.direction = direction;
        }

        StructuredQuery.Order toProto() {
            StructuredQuery.Order.Builder result = StructuredQuery.Order.newBuilder();
            result.setField(this.fieldReference);
            result.setDirection(this.direction.getDirection());
            return result.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldOrder)) {
                return false;
            }
            FieldOrder filter = (FieldOrder)o;
            return Objects.equals(this.toProto(), filter.toProto());
        }
    }

    static class ComparisonFilter
    extends FieldFilter {
        final StructuredQuery.FieldFilter.Operator operator;
        final Value value;

        ComparisonFilter(StructuredQuery.FieldReference fieldReference, StructuredQuery.FieldFilter.Operator operator, Value value) {
            super(fieldReference);
            this.value = value;
            this.operator = operator;
        }

        @Override
        boolean isInequalityFilter() {
            return this.operator.equals((Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN) || this.operator.equals((Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL) || this.operator.equals((Object)StructuredQuery.FieldFilter.Operator.LESS_THAN) || this.operator.equals((Object)StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL);
        }

        @Override
        StructuredQuery.Filter toProto() {
            StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
            result.getFieldFilterBuilder().setField(this.fieldReference).setValue(this.value).setOp(this.operator);
            return result.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ComparisonFilter)) {
                return false;
            }
            ComparisonFilter other = (ComparisonFilter)o;
            return Objects.equals(this.fieldReference, other.fieldReference) && Objects.equals(this.operator, other.operator) && Objects.equals(this.value, other.value);
        }
    }

    private static class UnaryFilter
    extends FieldFilter {
        private final StructuredQuery.UnaryFilter.Operator operator;

        UnaryFilter(StructuredQuery.FieldReference fieldReference, StructuredQuery.UnaryFilter.Operator operator) {
            super(fieldReference);
            this.operator = operator;
        }

        @Override
        boolean isInequalityFilter() {
            return false;
        }

        @Override
        StructuredQuery.Filter toProto() {
            StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
            result.getUnaryFilterBuilder().setField(this.fieldReference).setOp(this.operator);
            return result.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryFilter)) {
                return false;
            }
            UnaryFilter other = (UnaryFilter)o;
            return Objects.equals(this.fieldReference, other.fieldReference) && Objects.equals(this.operator, other.operator);
        }
    }

    static abstract class FieldFilter {
        protected final StructuredQuery.FieldReference fieldReference;

        FieldFilter(StructuredQuery.FieldReference fieldReference) {
            this.fieldReference = fieldReference;
        }

        static FieldFilter fromProto(StructuredQuery.Filter filter) {
            Preconditions.checkArgument((!filter.hasCompositeFilter() ? 1 : 0) != 0, (Object)"Cannot deserialize nested composite filters");
            if (filter.hasFieldFilter()) {
                return new ComparisonFilter(filter.getFieldFilter().getField(), filter.getFieldFilter().getOp(), filter.getFieldFilter().getValue());
            }
            Preconditions.checkState((boolean)filter.hasUnaryFilter(), (Object)"Expected unary of field filter");
            return new UnaryFilter(filter.getUnaryFilter().getField(), filter.getUnaryFilter().getOp());
        }

        abstract boolean isInequalityFilter();

        abstract StructuredQuery.Filter toProto();
    }

    public static enum Direction {
        ASCENDING(StructuredQuery.Direction.ASCENDING),
        DESCENDING(StructuredQuery.Direction.DESCENDING);

        private final StructuredQuery.Direction direction;

        private Direction(StructuredQuery.Direction direction) {
            this.direction = direction;
        }

        StructuredQuery.Direction getDirection() {
            return this.direction;
        }
    }
}

