/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterOptions;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreBundle;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.RecursiveDelete;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.TransactionRunner;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.DatabaseRootName;
import com.google.protobuf.ByteString;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

class FirestoreImpl
implements Firestore,
FirestoreRpcContext<FirestoreImpl> {
    private static final Random RANDOM = new SecureRandom();
    private static final int AUTO_ID_LENGTH = 20;
    private static final String AUTO_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Tracer tracer = Tracing.getTracer();
    private final FirestoreRpc firestoreClient;
    private final FirestoreOptions firestoreOptions;
    private final ResourcePath databasePath;
    @Nullable
    private BulkWriter bulkWriterInstance;
    private boolean closed;

    FirestoreImpl(FirestoreOptions options) {
        this(options, options.getFirestoreRpc());
    }

    FirestoreImpl(FirestoreOptions options, FirestoreRpc firestoreRpc) {
        this.firestoreClient = firestoreRpc;
        this.firestoreOptions = options;
        Preconditions.checkNotNull((Object)options.getProjectId(), (Object)"Failed to detect Project ID. Please explicitly set your Project ID in FirestoreOptions.");
        this.databasePath = ResourcePath.create(DatabaseRootName.of((String)options.getProjectId(), (String)options.getDatabaseId()));
    }

    private BulkWriter getBulkWriter() {
        if (this.bulkWriterInstance == null) {
            this.bulkWriterInstance = this.bulkWriter();
        }
        return this.bulkWriterInstance;
    }

    static String autoId() {
        StringBuilder builder = new StringBuilder();
        int maxRandom = AUTO_ID_ALPHABET.length();
        for (int i = 0; i < 20; ++i) {
            builder.append(AUTO_ID_ALPHABET.charAt(RANDOM.nextInt(maxRandom)));
        }
        return builder.toString();
    }

    @Override
    @Nonnull
    public WriteBatch batch() {
        return new WriteBatch(this);
    }

    @Override
    @Nonnull
    public BulkWriter bulkWriter() {
        return new BulkWriter(this, BulkWriterOptions.builder().setThrottlingEnabled(true).build());
    }

    @Override
    @Nonnull
    public BulkWriter bulkWriter(BulkWriterOptions options) {
        return new BulkWriter(this, options);
    }

    @Override
    @Nonnull
    public ApiFuture<Void> recursiveDelete(CollectionReference reference) {
        BulkWriter writer = this.getBulkWriter();
        return this.recursiveDelete(reference.getResourcePath(), writer);
    }

    @Override
    @Nonnull
    public ApiFuture<Void> recursiveDelete(CollectionReference reference, BulkWriter bulkWriter) {
        return this.recursiveDelete(reference.getResourcePath(), bulkWriter);
    }

    @Override
    @Nonnull
    public ApiFuture<Void> recursiveDelete(DocumentReference reference) {
        BulkWriter writer = this.getBulkWriter();
        return this.recursiveDelete(reference.getResourcePath(), writer);
    }

    @Override
    @Nonnull
    public ApiFuture<Void> recursiveDelete(DocumentReference reference, @Nonnull BulkWriter bulkWriter) {
        return this.recursiveDelete(reference.getResourcePath(), bulkWriter);
    }

    @Nonnull
    public ApiFuture<Void> recursiveDelete(ResourcePath path, BulkWriter bulkWriter) {
        return this.recursiveDelete(path, bulkWriter, 5000, 1000);
    }

    @Nonnull
    @VisibleForTesting
    ApiFuture<Void> recursiveDelete(ResourcePath path, @Nonnull BulkWriter bulkWriter, int maxLimit, int minLimit) {
        RecursiveDelete deleter = new RecursiveDelete(this, bulkWriter, path, maxLimit, minLimit);
        return deleter.run();
    }

    @Override
    @Nonnull
    public CollectionReference collection(@Nonnull String collectionPath) {
        ResourcePath path = (ResourcePath)this.databasePath.append(collectionPath);
        Preconditions.checkArgument((boolean)path.isCollection(), (Object)"Invalid path specified. Path should point to a collection");
        return new CollectionReference(this, path);
    }

    @Override
    @Nonnull
    public DocumentReference document(@Nonnull String documentPath) {
        ResourcePath document = (ResourcePath)this.databasePath.append(documentPath);
        Preconditions.checkArgument((boolean)document.isDocument(), (String)"Path should point to a Document Reference: %s", (Object)documentPath);
        return new DocumentReference(this, document);
    }

    @Override
    @Nonnull
    public Iterable<CollectionReference> listCollections() {
        DocumentReference rootDocument = new DocumentReference(this, this.databasePath);
        return rootDocument.listCollections();
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        return this.getAll(documentReferences, null, (ByteString)null);
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask) {
        return this.getAll(documentReferences, fieldMask, (ByteString)null);
    }

    @Override
    public void getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask, @Nonnull ApiStreamObserver<DocumentSnapshot> apiStreamObserver) {
        this.getAll(documentReferences, fieldMask, null, apiStreamObserver);
    }

    void getAll(final @Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask, @Nullable ByteString transactionId, final ApiStreamObserver<DocumentSnapshot> apiStreamObserver) {
        ResponseObserver<BatchGetDocumentsResponse> responseObserver = new ResponseObserver<BatchGetDocumentsResponse>(){
            int numResponses;
            boolean hasCompleted = false;

            public void onStart(StreamController streamController) {
            }

            public void onResponse(BatchGetDocumentsResponse response) {
                DocumentSnapshot documentSnapshot;
                ++this.numResponses;
                if (this.numResponses == 1) {
                    tracer.getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchGetDocuments: First response");
                } else if (this.numResponses % 100 == 0) {
                    tracer.getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchGetDocuments: Received 100 responses");
                }
                switch (response.getResultCase()) {
                    case FOUND: {
                        documentSnapshot = DocumentSnapshot.fromDocument(FirestoreImpl.this, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime()), response.getFound());
                        break;
                    }
                    case MISSING: {
                        DocumentReference documentReference = new DocumentReference(FirestoreImpl.this, ResourcePath.create(response.getMissing()));
                        documentSnapshot = DocumentSnapshot.fromMissing(FirestoreImpl.this, documentReference, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime()));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                apiStreamObserver.onNext((Object)documentSnapshot);
                if (this.numResponses == documentReferences.length) {
                    this.onComplete();
                }
            }

            public void onError(Throwable throwable) {
                tracer.getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchGetDocuments: Error");
                apiStreamObserver.onError(throwable);
            }

            public void onComplete() {
                if (this.hasCompleted) {
                    return;
                }
                this.hasCompleted = true;
                tracer.getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchGetDocuments: Complete");
                apiStreamObserver.onCompleted();
            }
        };
        BatchGetDocumentsRequest.Builder request = BatchGetDocumentsRequest.newBuilder();
        request.setDatabase(this.getDatabaseName());
        if (fieldMask != null) {
            request.setMask(fieldMask.toPb());
        }
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        for (DocumentReference docRef : documentReferences) {
            request.addDocuments(docRef.getName());
        }
        tracer.getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchGetDocuments: Start", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)documentReferences.length)));
        this.streamRequest(request.build(), responseObserver, this.firestoreClient.batchGetDocumentsCallable());
    }

    ApiFuture<List<DocumentSnapshot>> getAll(final @Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask, @Nullable ByteString transactionId) {
        final SettableApiFuture futureList = SettableApiFuture.create();
        final HashMap documentSnapshotMap = new HashMap();
        this.getAll(documentReferences, fieldMask, transactionId, new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                documentSnapshotMap.put(documentSnapshot.getReference(), documentSnapshot);
            }

            public void onError(Throwable throwable) {
                futureList.setException(throwable);
            }

            public void onCompleted() {
                ArrayList<DocumentSnapshot> documentSnapshotsList = new ArrayList<DocumentSnapshot>();
                for (DocumentReference documentReference : documentReferences) {
                    documentSnapshotsList.add((DocumentSnapshot)documentSnapshotMap.get(documentReference));
                }
                futureList.set(documentSnapshotsList);
            }
        });
        return futureList;
    }

    @Override
    @Nonnull
    public CollectionGroup collectionGroup(@Nonnull String collectionId) {
        Preconditions.checkArgument((!collectionId.contains("/") ? 1 : 0) != 0, (String)"Invalid collectionId '%s'. Collection IDs must not contain '/'.", (Object)collectionId);
        return new CollectionGroup(this, collectionId);
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runTransaction(@Nonnull Transaction.Function<T> updateFunction) {
        return this.runAsyncTransaction(new TransactionAsyncAdapter<T>(updateFunction), TransactionOptions.create());
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runTransaction(@Nonnull Transaction.Function<T> updateFunction, @Nonnull TransactionOptions transactionOptions) {
        return this.runAsyncTransaction(new TransactionAsyncAdapter<T>(updateFunction), transactionOptions);
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runAsyncTransaction(@Nonnull Transaction.AsyncFunction<T> updateFunction) {
        return this.runAsyncTransaction(updateFunction, TransactionOptions.create());
    }

    @Override
    @Nonnull
    public <T> ApiFuture<T> runAsyncTransaction(@Nonnull Transaction.AsyncFunction<T> updateFunction, @Nonnull TransactionOptions transactionOptions) {
        TransactionRunner<T> transactionRunner = new TransactionRunner<T>(this, updateFunction, transactionOptions);
        return transactionRunner.run();
    }

    @Override
    @Nonnull
    public FirestoreBundle.Builder bundleBuilder() {
        return this.bundleBuilder(null);
    }

    @Override
    @Nonnull
    public FirestoreBundle.Builder bundleBuilder(@Nullable String bundleId) {
        String id = bundleId == null ? FirestoreImpl.autoId() : bundleId;
        return new FirestoreBundle.Builder(id);
    }

    @Override
    public String getDatabaseName() {
        return this.databasePath.getDatabaseName().toString();
    }

    @Override
    public ResourcePath getResourcePath() {
        return this.databasePath;
    }

    @Override
    public FirestoreRpc getClient() {
        return this.firestoreClient;
    }

    @Override
    public Duration getTotalRequestTimeout() {
        return this.firestoreOptions.getRetrySettings().getTotalTimeout();
    }

    @Override
    public ApiClock getClock() {
        return NanoClock.getDefaultClock();
    }

    @Override
    public <RequestT, ResponseT> ApiFuture<ResponseT> sendRequest(RequestT requestT, UnaryCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        return callable.futureCall(requestT);
    }

    @Override
    public <RequestT, ResponseT> void streamRequest(RequestT requestT, ResponseObserver<ResponseT> responseObserverT, ServerStreamingCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        callable.call(requestT, responseObserverT);
    }

    @Override
    public <RequestT, ResponseT> ClientStream<RequestT> streamRequest(BidiStreamObserver<RequestT, ResponseT> responseObserverT, BidiStreamingCallable<RequestT, ResponseT> callable) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Firestore client has already been closed");
        return callable.splitCall(responseObserverT);
    }

    @Override
    public FirestoreImpl getFirestore() {
        return this;
    }

    public FirestoreOptions getOptions() {
        return this.firestoreOptions;
    }

    @Override
    public void close() throws Exception {
        this.firestoreClient.close();
        this.closed = true;
    }

    @Override
    public void shutdown() {
        this.firestoreClient.shutdown();
        this.closed = true;
    }

    @Override
    public void shutdownNow() {
        this.firestoreClient.shutdownNow();
        this.closed = true;
    }

    private static class TransactionAsyncAdapter<T>
    implements Transaction.AsyncFunction<T> {
        private final Transaction.Function<T> syncFunction;

        public TransactionAsyncAdapter(Transaction.Function<T> syncFunction) {
            this.syncFunction = syncFunction;
        }

        @Override
        public ApiFuture<T> updateCallback(Transaction transaction) {
            SettableApiFuture callbackResult = SettableApiFuture.create();
            try {
                callbackResult.set(this.syncFunction.updateCallback(transaction));
            }
            catch (Throwable e) {
                callbackResult.setException(e);
            }
            return callbackResult;
        }
    }
}

