/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.AggregateField;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AggregateFieldTest {
    @Test
    public void staticCountCreatesCountAggregateField() {
        AggregateField.CountAggregateField count = AggregateField.count();
        Truth.assertThat((Boolean)(count instanceof AggregateField.CountAggregateField)).isTrue();
    }

    @Test
    public void staticSumCreatesSumAggregateField() {
        AggregateField.SumAggregateField sum = AggregateField.sum((String)"foo");
        Truth.assertThat((Boolean)(sum instanceof AggregateField.SumAggregateField)).isTrue();
    }

    @Test
    public void staticAverageCreatesAverageAggregateField() {
        AggregateField.AverageAggregateField average = AggregateField.average((String)"foo");
        Truth.assertThat((Boolean)(average instanceof AggregateField.AverageAggregateField)).isTrue();
    }

    @Test
    public void setsProperFieldPathForSum() {
        AggregateField.SumAggregateField sum = AggregateField.sum((String)"foo");
        Truth.assertThat((Boolean)sum.getFieldPath().equals("foo")).isTrue();
    }

    @Test
    public void setsProperFieldPathForAverage() {
        AggregateField.AverageAggregateField average = AggregateField.average((String)"foo");
        Truth.assertThat((Boolean)average.getFieldPath().equals("foo")).isTrue();
    }

    @Test
    public void setsProperOperatorForCount() {
        AggregateField.CountAggregateField count = AggregateField.count();
        Truth.assertThat((Boolean)count.getOperator().equals("count")).isTrue();
    }

    @Test
    public void setsProperOperatorForSum() {
        AggregateField.SumAggregateField sum = AggregateField.sum((String)"foo");
        Truth.assertThat((Boolean)sum.getOperator().equals("sum")).isTrue();
    }

    @Test
    public void setsProperOperatorForAverage() {
        AggregateField.AverageAggregateField average = AggregateField.average((String)"foo");
        Truth.assertThat((Boolean)average.getOperator().equals("average")).isTrue();
    }

    @Test
    public void setsProperFieldPathWithEscapeChars() {
        AggregateField.SumAggregateField sum = AggregateField.sum((String)"has`invalid");
        Truth.assertThat((Boolean)sum.getFieldPath().equals("`has\\`invalid`")).isTrue();
    }

    @Test
    public void sumSetsProperAliasWithEscapeChars() {
        AggregateField.SumAggregateField sum = AggregateField.sum((String)"has`invalid");
        Truth.assertThat((Boolean)sum.getAlias().equals("sum_`has\\`invalid`")).isTrue();
    }

    @Test
    public void averageSetsProperAliasWithEscapeChars() {
        AggregateField.AverageAggregateField average = AggregateField.average((String)"has`invalid");
        Truth.assertThat((Boolean)average.getAlias().equals("average_`has\\`invalid`")).isTrue();
    }
}

