/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.Query;
import com.google.common.truth.Truth;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AggregateQuerySnapshotTest {
    @Mock
    private Query mockQuery;
    @Mock
    private Query mockQuery2;
    private AggregateQuery sampleAggregateQuery;
    private AggregateQuery sampleAggregateQuery2;
    private Timestamp sampleTimestamp;
    private Timestamp sampleTimestamp2;
    private Map<String, Value> data42;
    private Map<String, Value> data24;

    @Before
    public void initializeSampleObjects() {
        this.sampleAggregateQuery = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        this.sampleAggregateQuery2 = new AggregateQuery(this.mockQuery2, Collections.singletonList(AggregateField.count()));
        this.sampleTimestamp = Timestamp.ofTimeSecondsAndNanos((long)42L, (int)42);
        this.sampleTimestamp2 = Timestamp.ofTimeSecondsAndNanos((long)24L, (int)24);
        this.data42 = new HashMap<String, Value>();
        this.data42.put("count", Value.newBuilder().setIntegerValue(42L).build());
        this.data24 = new HashMap<String, Value>();
        this.data24.put("count", Value.newBuilder().setIntegerValue(24L).build());
    }

    @Test
    public void getQueryShouldReturnTheAggregateQuerySpecifiedToTheConstructor() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Object)snapshot.getQuery()).isSameInstanceAs((Object)this.sampleAggregateQuery);
    }

    @Test
    public void getReadTimeShouldReturnTheTimestampSpecifiedToTheConstructor() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Comparable)snapshot.getReadTime()).isSameInstanceAs((Object)this.sampleTimestamp);
    }

    @Test
    public void getCountShouldReturnTheCountSpecifiedToTheConstructor() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)42);
    }

    @Test
    public void hashCodeShouldReturnSameHashCodeWhenConstructedWithSameObjects() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Integer)snapshot1.hashCode()).isEqualTo((Object)snapshot2.hashCode());
    }

    @Test
    public void hashCodeShouldReturnDifferentHashCodeWhenConstructedDifferentAggregateQuery() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery2, this.sampleTimestamp, this.data42);
        Truth.assertThat((Integer)snapshot1.hashCode()).isNotEqualTo((Object)snapshot2.hashCode());
    }

    @Test
    public void hashCodeShouldReturnSameHashCodeWhenConstructedDifferentTimestamp() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp2, this.data42);
        Truth.assertThat((Integer)snapshot1.hashCode()).isEqualTo((Object)snapshot2.hashCode());
    }

    @Test
    public void hashCodeShouldReturnDifferentHashCodeWhenConstructedDifferentCount() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data24);
        Truth.assertThat((Integer)snapshot1.hashCode()).isNotEqualTo((Object)snapshot2.hashCode());
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenNull() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Boolean)snapshot.equals(null)).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenADifferentObject() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Boolean)snapshot.equals((Object)"Not An AggregateQuerySnapshot")).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenAnAggregateQuerySnapshotWithADifferentQuery() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery2, this.sampleTimestamp, this.data42);
        Truth.assertThat((Boolean)snapshot1.equals((Object)snapshot2)).isFalse();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenAnAggregateQuerySnapshotWithADifferentReadTime() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp2, this.data42);
        Truth.assertThat((Boolean)snapshot1.equals((Object)snapshot2)).isTrue();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenAnAggregateQuerySnapshotWithADifferentCount() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data24);
        Truth.assertThat((Boolean)snapshot1.equals((Object)snapshot2)).isFalse();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenTheSameAggregateQuerySnapshotInstance() {
        AggregateQuerySnapshot snapshot = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Boolean)snapshot.equals((Object)snapshot)).isTrue();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenAnAggregateQuerySnapshotConstructedWithTheSameArguments() {
        AggregateQuerySnapshot snapshot1 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        AggregateQuerySnapshot snapshot2 = new AggregateQuerySnapshot(this.sampleAggregateQuery, this.sampleTimestamp, this.data42);
        Truth.assertThat((Boolean)snapshot1.equals((Object)snapshot2)).isTrue();
    }
}

