/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.truth.Truth;
import com.google.firestore.v1.RunAggregationQueryRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AggregateQueryTest {
    @Mock
    private Query mockQuery;
    @Mock
    private Query mockQuery2;

    @Test
    public void getQueryShouldReturnTheQuerySpecifiedToTheConstructor() {
        AggregateQuery aggregateQuery = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        Truth.assertThat((Object)aggregateQuery.getQuery()).isSameInstanceAs((Object)this.mockQuery);
    }

    @Test
    public void hashCodeShouldReturnHashCodeOfUnderlyingQueryAndAggregateFieldList() {
        List<AggregateField> list = Arrays.asList(AggregateField.count(), AggregateField.sum((String)"foo"), AggregateField.average((String)"bar"));
        AggregateQuery aggregateQuery = new AggregateQuery(this.mockQuery, list);
        Truth.assertThat((Integer)aggregateQuery.hashCode()).isEqualTo((Object)Objects.hash(this.mockQuery, list));
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenNull() {
        AggregateQuery aggregateQuery = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.count(), AggregateField.sum((String)"foo"), AggregateField.average((String)"bar")));
        Truth.assertThat((Boolean)aggregateQuery.equals(null)).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenADifferentObject() {
        AggregateQuery aggregateQuery = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.count(), AggregateField.sum((String)"foo"), AggregateField.average((String)"bar")));
        Truth.assertThat((Boolean)aggregateQuery.equals((Object)"Not An AggregateQuery")).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenAnAggregateQueryWithADifferentQuery() {
        AggregateQuery aggregateQuery1 = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        AggregateQuery aggregateQuery2 = new AggregateQuery(this.mockQuery2, Collections.singletonList(AggregateField.count()));
        Truth.assertThat((Boolean)aggregateQuery1.equals((Object)aggregateQuery2)).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenAnAggregateQueryWithDifferentAggregations() {
        AggregateQuery aggregateQuery1 = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        AggregateQuery aggregateQuery2 = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.sum((String)"foo")));
        Truth.assertThat((Boolean)aggregateQuery1.equals((Object)aggregateQuery2)).isFalse();
    }

    @Test
    public void equalsShouldReturnFalseWhenGivenAnAggregateQueryWithDifferentAggregationOrder() {
        AggregateQuery aggregateQuery1 = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.sum((String)"foo"), AggregateField.average((String)"bar")));
        AggregateQuery aggregateQuery2 = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.average((String)"bar"), AggregateField.sum((String)"foo")));
        Truth.assertThat((Boolean)aggregateQuery1.equals((Object)aggregateQuery2)).isFalse();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenTheSameAggregateQueryInstance() {
        AggregateQuery aggregateQuery = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        Truth.assertThat((Boolean)aggregateQuery.equals((Object)aggregateQuery)).isTrue();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenAnAggregateQueryWithTheSameQuery() {
        AggregateQuery aggregateQuery1 = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        AggregateQuery aggregateQuery2 = new AggregateQuery(this.mockQuery, Collections.singletonList(AggregateField.count()));
        Truth.assertThat((Boolean)aggregateQuery1.equals((Object)aggregateQuery2)).isTrue();
    }

    @Test
    public void equalsShouldReturnTrueWhenGivenMultipleAggregationsWithTheSameQuery() {
        AggregateQuery aggregateQuery1 = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.count(), AggregateField.sum((String)"foo"), AggregateField.average((String)"bar")));
        AggregateQuery aggregateQuery2 = new AggregateQuery(this.mockQuery, Arrays.asList(AggregateField.count(), AggregateField.sum((String)"foo"), AggregateField.average((String)"bar")));
        Truth.assertThat((Boolean)aggregateQuery1.equals((Object)aggregateQuery2)).isTrue();
    }

    @Test
    public void toProtoFromProtoRoundTripShouldProduceEqualAggregateQueryObjects() {
        FirestoreImpl firestore = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
        CollectionReference query1 = firestore.collection("abc");
        Query query2 = firestore.collection("def").whereEqualTo("age", (Object)42).limit(5000).orderBy("name");
        AggregateQuery countQuery1 = query1.count();
        AggregateQuery countQuery2 = query2.count();
        AggregateQuery countQuery1Recreated = AggregateQuery.fromProto((Firestore)firestore, (RunAggregationQueryRequest)countQuery1.toProto());
        AggregateQuery countQuery2Recreated = AggregateQuery.fromProto((Firestore)firestore, (RunAggregationQueryRequest)countQuery2.toProto());
        Truth.assertThat((Object)countQuery1).isNotSameInstanceAs((Object)countQuery1Recreated);
        Truth.assertThat((Object)countQuery2).isNotSameInstanceAs((Object)countQuery2Recreated);
        Truth.assertThat((Object)countQuery1).isEqualTo((Object)countQuery1Recreated);
        Truth.assertThat((Object)countQuery2).isEqualTo((Object)countQuery2Recreated);
        Truth.assertThat((Object)countQuery1).isNotEqualTo((Object)countQuery2);
    }
}

