/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterException;
import com.google.cloud.firestore.BulkWriterOptions;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.protobuf.Message;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BulkWriterTest {
    public static final ApiFuture<Message> FAILED_FUTURE = ApiFutures.immediateFailedFuture((Throwable)new ApiException((Throwable)new IllegalStateException("Mock batchWrite failed in test"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNKNOWN), false));
    private static final ApiFuture<Message> RETRYABLE_FAILED_FUTURE = ApiFutures.immediateFailedFuture((Throwable)new ApiException((Throwable)new IllegalStateException("Mock batchWrite failed in test"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true));
    private static final ApiFuture<Message> RESOURCE_EXHAUSTED_FAILED_FUTURE = ApiFutures.immediateFailedFuture((Throwable)new ApiException((Throwable)new IllegalStateException("Mock batchWrite failed in test"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.RESOURCE_EXHAUSTED), true));
    @Rule
    public Timeout timeout = new Timeout(2L, TimeUnit.SECONDS);
    @Spy
    private final FirestoreRpc firestoreRpc = (FirestoreRpc)Mockito.mock(FirestoreRpc.class);
    private ScheduledExecutorService testExecutor;
    private final ScheduledExecutorService immediateExecutor = new ScheduledThreadPoolExecutor(1){

        @Override
        @Nonnull
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
        }
    };
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), this.firestoreRpc);
    @Captor
    private ArgumentCaptor<BatchWriteRequest> batchWriteCapture;
    private BulkWriter bulkWriter;
    private DocumentReference doc1;
    private DocumentReference doc2;
    private ScheduledExecutorService timeoutExecutor;

    public static ApiFuture<BatchWriteResponse> successResponse(int updateTimeSeconds) {
        BatchWriteResponse.Builder response = BatchWriteResponse.newBuilder();
        response.addWriteResultsBuilder().getUpdateTimeBuilder().setSeconds((long)updateTimeSeconds).build();
        response.addStatusBuilder().build();
        return ApiFutures.immediateFuture((Object)response.build());
    }

    public static ApiFuture<BatchWriteResponse> failedResponse(int code) {
        BatchWriteResponse.Builder response = BatchWriteResponse.newBuilder();
        response.addWriteResultsBuilder().build();
        response.addStatusBuilder().setCode(code).build();
        return ApiFutures.immediateFuture((Object)response.build());
    }

    private ApiFuture<BatchWriteResponse> failedResponse() {
        return BulkWriterTest.failedResponse(4);
    }

    public static ApiFuture<BatchWriteResponse> mergeResponses(ApiFuture<BatchWriteResponse> ... responses) throws Exception {
        BatchWriteResponse.Builder response = BatchWriteResponse.newBuilder();
        for (ApiFuture<BatchWriteResponse> future : responses) {
            BatchWriteResponse res = (BatchWriteResponse)future.get();
            response.addStatus(res.getStatus(0));
            response.addWriteResults(res.getWriteResults(0));
        }
        return ApiFutures.immediateFuture((Object)response.build());
    }

    @Before
    public void before() {
        ((FirestoreRpc)Mockito.lenient().doReturn((Object)this.immediateExecutor).when((Object)this.firestoreRpc)).getExecutor();
        this.testExecutor = Executors.newSingleThreadScheduledExecutor();
        this.timeoutExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
        this.bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setExecutor(this.timeoutExecutor).build());
        this.doc1 = this.firestoreMock.document("coll/doc1");
        this.doc2 = this.firestoreMock.document("coll/doc2");
    }

    @After
    public void after() throws InterruptedException {
        this.shutdownScheduledExecutorService(this.timeoutExecutor);
    }

    void shutdownScheduledExecutorService(ScheduledExecutorService executorService) throws InterruptedException {
        executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void hasSetMethod() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
    }

    @Test
    public void hasUpdateMethod() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), com.google.firestore.v1.Precondition.newBuilder().setUpdateTime(com.google.protobuf.Timestamp.newBuilder().build()).build(), "coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result = this.bulkWriter.update(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP, Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0)));
        this.bulkWriter.flush().get();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
    }

    @Test
    public void hasDeleteMethod() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.delete("coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result = this.bulkWriter.delete(this.doc1, Precondition.NONE);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
    }

    @Test
    public void hasCreateMethod() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result = this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush().get();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
    }

    @Test
    public void surfacesErrors() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), (ApiFuture<? extends Message>)BulkWriterTest.this.failedResponse());
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        try {
            result.get();
            Assert.fail((String)"set() should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof BulkWriterException));
            Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED, (Object)((BulkWriterException)e.getCause()).getStatus());
        }
    }

    @Test
    public void flushResolvesImmediatelyIfNoWrites() throws Exception {
        this.bulkWriter.flush().get();
    }

    @Test
    public void addsWritesToNewBatchAfterFlush() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(1));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), "coll/doc2")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result1 = this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush();
        ApiFuture result2 = this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP, SetOptions.merge());
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), (Object)((WriteResult)result1.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result2.get()).getUpdateTime());
    }

    @Test
    public void cannotCallMethodsAfterClose() throws Exception {
        String expected = "BulkWriter has already been closed.";
        this.bulkWriter.close();
        try {
            this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            Assert.fail((String)"set() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
        try {
            this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            Assert.fail((String)"create() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
        try {
            this.bulkWriter.update(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            Assert.fail((String)"update() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
        try {
            this.bulkWriter.delete(this.doc1);
            Assert.fail((String)"delete() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
        try {
            this.bulkWriter.flush();
            Assert.fail((String)"flush() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
        try {
            this.bulkWriter.close();
            Assert.fail((String)"close() should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, (Object)e.getMessage());
        }
    }

    @Test
    public void sendsWritesToSameDocInDifferentBatches() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(1));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.update(LocalFirestoreHelper.map("foo", Value.newBuilder().setStringValue("bar").build(), "boo", Value.newBuilder().setStringValue("far").build()), Arrays.asList("boo", "foo"), com.google.firestore.v1.Precondition.newBuilder().setExists(true).build(), "coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        DocumentReference sameDoc = this.firestoreMock.document(this.doc1.getPath());
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.update(sameDoc, "foo", (Object)"bar", new Object[]{"boo", "far"});
        this.bulkWriter.close();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), (Object)((WriteResult)result1.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result2.get()).getUpdateTime());
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void sendWritesToDifferentDocsInSameBatch() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(2)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.update(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), (Object)((WriteResult)result1.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result2.get()).getUpdateTime());
    }

    @Test
    public void buffersSubsequentOpsAfterReachingMaxPendingOpCount() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(2), BulkWriterTest.failedResponse(9)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc4"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc5")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(4), BulkWriterTest.successResponse(5)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.setMaxPendingOpCount(3);
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.firestoreMock.document("coll/doc3"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.firestoreMock.document("coll/doc4"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        Assert.assertEquals((long)1L, (long)this.bulkWriter.getBufferedOperationsCount());
        this.bulkWriter.set(this.firestoreMock.document("coll/doc5"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        Assert.assertEquals((long)2L, (long)this.bulkWriter.getBufferedOperationsCount());
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void runsSuccessHandler() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3"), LocalFirestoreHelper.delete("coll/doc4")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(2), BulkWriterTest.successResponse(3), BulkWriterTest.successResponse(4)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ArrayList writeResults = new ArrayList();
        DocumentReference doc3 = this.firestoreMock.document("coll/doc3");
        DocumentReference doc4 = this.firestoreMock.document("coll/doc4");
        this.bulkWriter.addWriteResultListener((documentReference, result) -> writeResults.add((int)result.getUpdateTime().getSeconds()));
        this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.update(doc3, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.delete(doc4);
        this.bulkWriter.close();
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 4}, (Object[])writeResults.toArray());
    }

    @Test
    public void retriesFailedOperationsWithGlobalErrorCallback() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3"), LocalFirestoreHelper.delete("coll/doc4")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.failedResponse(13), BulkWriterTest.failedResponse(13), BulkWriterTest.failedResponse(13)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3"), LocalFirestoreHelper.delete("coll/doc4")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(2), BulkWriterTest.successResponse(3), BulkWriterTest.successResponse(4)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ArrayList writeResults = new ArrayList();
        ArrayList operations = new ArrayList();
        DocumentReference doc3 = this.firestoreMock.document("coll/doc3");
        DocumentReference doc4 = this.firestoreMock.document("coll/doc4");
        ExecutorService userCallbackExecutor = Executors.newSingleThreadExecutor();
        this.bulkWriter.addWriteErrorListener((Executor)userCallbackExecutor, error -> {
            operations.add(error.getOperationType().name());
            return true;
        });
        this.bulkWriter.addWriteResultListener((documentReference, result) -> {
            operations.add("SUCCESS");
            writeResults.add((int)result.getUpdateTime().getSeconds());
        });
        this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.update(doc3, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.delete(doc4);
        this.bulkWriter.close();
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 4}, (Object[])writeResults.toArray());
        Assert.assertArrayEquals((Object[])new String[]{"SUCCESS", "SET", "UPDATE", "DELETE", "SUCCESS", "SUCCESS", "SUCCESS"}, (Object[])operations.toArray());
    }

    @Test
    public void errorSurfacedEvenWithRetryFunction() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        boolean[] errorListenerCalled = new boolean[]{false};
        this.bulkWriter.addWriteErrorListener(error -> {
            errorListenerCalled[0] = true;
            Assert.assertEquals((Object)Status.INTERNAL, (Object)error.getStatus());
            return false;
        });
        ApiFuture result = this.bulkWriter.update(this.doc1, FieldPath.of((String[])new String[]{"foo"}), (Object)"bar", new Object[0]);
        this.bulkWriter.close();
        Assert.assertTrue((boolean)errorListenerCalled[0]);
        try {
            result.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.INTERNAL, (Object)((BulkWriterException)e.getCause()).getStatus());
        }
    }

    @Test
    public void surfacesExceptionsThrownByUserProvidedErrorListener() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.addWriteErrorListener(error -> {
            throw new UnsupportedOperationException("Test code threw UnsupportedOperationException");
        });
        ApiFuture result = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        try {
            result.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Test code threw UnsupportedOperationException"));
        }
    }

    @Test
    public void writeFailsIfUserProvidedSuccessListenerFails() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), com.google.firestore.v1.Precondition.newBuilder().setUpdateTime(com.google.protobuf.Timestamp.newBuilder().build()).build(), "coll/doc1")), BulkWriterTest.successResponse(1));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.addWriteResultListener((documentReference, result) -> {
            throw new UnsupportedOperationException("Test code threw UnsupportedOperationException");
        });
        ApiFuture result2 = this.bulkWriter.update(this.doc1, Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0)), "foo", (Object)"bar", new Object[0]);
        this.bulkWriter.close();
        try {
            result2.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Test code threw UnsupportedOperationException"));
        }
    }

    @Test
    public void cannotChangeExecutorOnceWriteEnqueued() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        try {
            this.bulkWriter.addWriteResultListener(MoreExecutors.directExecutor(), (documentReference, result) -> {});
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The executor cannot be changed once writes have been enqueued"));
        }
        try {
            this.bulkWriter.addWriteErrorListener(MoreExecutors.directExecutor(), error -> false);
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The executor cannot be changed once writes have been enqueued"));
        }
        this.bulkWriter.close();
    }

    @Test
    public void retriesMultipleTimes() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(1));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.addWriteErrorListener(error -> true);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), (Object)((WriteResult)result1.get()).getUpdateTime());
    }

    @Test
    public void retriesWithSmallerBatchSize() throws Exception {
        final ArrayList<Write> writes = new ArrayList<Write>();
        final ArrayList<ApiFuture<BatchWriteResponse>> successResponses = new ArrayList<ApiFuture<BatchWriteResponse>>();
        final ArrayList<ApiFuture<BatchWriteResponse>> failedResponses = new ArrayList<ApiFuture<BatchWriteResponse>>();
        for (int i = 0; i < 15; ++i) {
            writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc" + i));
            failedResponses.add(BulkWriterTest.failedResponse(10));
            successResponses.add(BulkWriterTest.successResponse(1));
        }
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(writes.toArray(new Write[0])), BulkWriterTest.mergeResponses(failedResponses.toArray(new ApiFuture[0])));
                this.put((Message)LocalFirestoreHelper.batchWrite(writes.subList(0, 10).toArray(new Write[0])), BulkWriterTest.mergeResponses(successResponses.subList(0, 10).toArray(new ApiFuture[0])));
                this.put((Message)LocalFirestoreHelper.batchWrite(writes.subList(10, 15).toArray(new Write[0])), BulkWriterTest.mergeResponses(successResponses.subList(10, 15).toArray(new ApiFuture[0])));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        for (int i = 0; i < 15; ++i) {
            this.bulkWriter.set(this.firestoreMock.document("coll/doc" + i), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        }
        this.bulkWriter.close();
    }

    @Test
    public void retryResolvesBeforeFlush() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(1));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        SettableApiFuture flushComplete = SettableApiFuture.create();
        ArrayList operations = new ArrayList();
        this.bulkWriter.addWriteErrorListener((Executor)this.testExecutor, error -> true);
        this.bulkWriter.addWriteResultListener((Executor)this.testExecutor, (reference, result) -> operations.add("DOC"));
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush().addListener(() -> {
            operations.add("FLUSH");
            flushComplete.set(null);
        }, (Executor)this.testExecutor);
        flushComplete.get();
        Assert.assertArrayEquals((Object[])new String[]{"DOC", "FLUSH"}, (Object[])operations.toArray());
    }

    @Test
    public void returnsTheErrorIfNoRetrySpecified() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(13));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.addWriteErrorListener(error -> error.getFailedAttempts() < 3);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        try {
            result1.get();
            Assert.fail((String)"Operation should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.INTERNAL, (Object)((BulkWriterException)e.getCause()).getStatus());
        }
    }

    @Test
    public void sendBatchesWhenSizeLimitIsReached() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), com.google.firestore.v1.Precondition.newBuilder().setUpdateTime(com.google.protobuf.Timestamp.newBuilder().build()).build(), "coll/doc2"), LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(2), BulkWriterTest.successResponse(3)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.setMaxBatchSize(3);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.update(this.doc2, Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0)), FieldPath.of((String[])new String[]{"foo"}), (Object)"bar", new Object[0]);
        ApiFuture result3 = this.bulkWriter.create(this.firestoreMock.document("coll/doc3"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.delete(this.firestoreMock.document("coll/doc4"));
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), (Object)((WriteResult)result1.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result2.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)3L, (int)0), (Object)((WriteResult)result3.get()).getUpdateTime());
    }

    @Test
    public void retriesIndividualWritesThatFailWithAbortedOrUnavailable() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.UPDATED_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.mergeResponses(BulkWriterTest.this.failedResponse(), BulkWriterTest.failedResponse(14), BulkWriterTest.failedResponse(10)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.UPDATED_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(2), BulkWriterTest.failedResponse(10)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.successResponse(3));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.set(this.doc2, LocalFirestoreHelper.UPDATED_FIELD_MAP);
        ApiFuture result3 = this.bulkWriter.set(this.firestoreMock.document("coll/doc3"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        try {
            result1.get();
            Assert.fail((String)"set() should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof BulkWriterException));
            Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED, (Object)((BulkWriterException)e.getCause()).getStatus());
        }
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0), (Object)((WriteResult)result2.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)3L, (int)0), (Object)((WriteResult)result3.get()).getUpdateTime());
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void writesCompleteInCorrectOrderBeforeFlush() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.failedResponse(10)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ArrayList completions = new ArrayList();
        SettableApiFuture flushComplete = SettableApiFuture.create();
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP, SetOptions.merge()).addListener(() -> completions.add("doc1"), (Executor)this.testExecutor);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP).addListener(() -> completions.add("doc2"), (Executor)this.testExecutor);
        ApiFuture flush = this.bulkWriter.flush();
        flush.addListener(() -> {
            completions.add("flush");
            flushComplete.set(null);
        }, (Executor)this.testExecutor);
        flushComplete.get();
        Assert.assertEquals((Object)"doc1", completions.get(0));
        Assert.assertEquals((Object)"doc2", completions.get(1));
        Assert.assertEquals((Object)"flush", completions.get(2));
    }

    @Test
    public void flushCompletesWhenAllWritesComplete() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc3")), BulkWriterTest.mergeResponses(BulkWriterTest.this.failedResponse(), BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(1)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result3 = this.bulkWriter.set(this.firestoreMock.document("coll/doc3"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture flush = this.bulkWriter.flush();
        try {
            result1.get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        result2.get();
        result3.get();
        flush.get(100L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void doesNotSendBatchesIfDoingSoExceedsRateLimit() throws Exception {
        final SettableApiFuture timeoutCalledFuture = SettableApiFuture.create();
        ScheduledThreadPoolExecutor customExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                if (delay > 0L) {
                    timeoutCalledFuture.set(null);
                }
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc")), BulkWriterTest.successResponse(5));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        BulkWriter bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setInitialOpsPerSecond(5).setExecutor((ScheduledExecutorService)customExecutor).build());
        for (int i = 0; i < 600; ++i) {
            bulkWriter.set(this.firestoreMock.document("coll/doc"), LocalFirestoreHelper.SINGLE_FIELD_MAP);
        }
        bulkWriter.flush();
        timeoutCalledFuture.get();
        this.shutdownScheduledExecutorService(customExecutor);
    }

    @Test
    public void flushSucceedsEvenIfBulkCommitFails() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(FAILED_FUTURE).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush().get();
    }

    @Test
    public void closeSucceedsEvenIfBulkCommitFails() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(FAILED_FUTURE).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
    }

    @Test
    public void individualWritesErrorIfBulkCommitFails() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(FAILED_FUTURE).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        int opCount = 0;
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        for (ApiFuture result : Arrays.asList(result1, result2)) {
            try {
                result.get();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Mock batchWrite failed in test"));
                ++opCount;
            }
        }
        Assert.assertEquals((long)2L, (long)opCount);
    }

    @Test
    public void individualWritesErrorIfBulkCommitFailsWithNonFirestoreException() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(FAILED_FUTURE).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        int opCount = 0;
        ApiFuture result1 = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        ApiFuture result2 = this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        for (ApiFuture result : Arrays.asList(result1, result2)) {
            try {
                result.get();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("java.lang.IllegalStateException: Mock batchWrite failed in test"));
                ++opCount;
            }
        }
        Assert.assertEquals((long)2L, (long)opCount);
    }

    @Test
    public void retriesWritesWhenBatchWriteFailsWithRetryableError() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(RETRYABLE_FAILED_FUTURE).doReturn(RETRYABLE_FAILED_FUTURE).doReturn(RETRYABLE_FAILED_FUTURE).doReturn(BulkWriterTest.successResponse(3)).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture result = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)3L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failsWritesAfterAllRetryAttemptsFail() throws Exception {
        final int[] retryAttempts = new int[]{0};
        final int[] scheduleWithDelayCount = new int[]{0};
        ScheduledThreadPoolExecutor customExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                if (delay > 0L) {
                    int expected = (int)(1000.0 * Math.pow(1.5, retryAttempts[0] - 1));
                    Assert.assertTrue(((double)delay >= 0.7 * (double)expected ? 1 : 0) != 0);
                    Assert.assertTrue(((double)delay <= 1.3 * (double)expected ? 1 : 0) != 0);
                    scheduleWithDelayCount[0] = scheduleWithDelayCount[0] + 1;
                }
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
        ((FirestoreImpl)Mockito.doAnswer(mock -> {
            retryAttempts[0] = retryAttempts[0] + 1;
            return RETRYABLE_FAILED_FUTURE;
        }).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setExecutor((ScheduledExecutorService)customExecutor).build());
        ApiFuture result = this.bulkWriter.set(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush().get();
        try {
            result.get();
            Assert.fail((String)"Expected set() operation to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Mock batchWrite failed in test"));
            Assert.assertEquals((long)11L, (long)retryAttempts[0]);
            Assert.assertEquals((long)10L, (long)scheduleWithDelayCount[0]);
        }
        finally {
            this.shutdownScheduledExecutorService(customExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appliesMaxBackoffOnRetriesForResourceExhausted() throws Exception {
        int[] retryAttempts = new int[]{0};
        final int[] scheduleWithDelayCount = new int[]{0};
        ScheduledThreadPoolExecutor customExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                if (delay > 0L) {
                    Assert.assertTrue(((double)delay >= 42000.0 ? 1 : 0) != 0);
                    Assert.assertTrue(((double)delay <= 78000.0 ? 1 : 0) != 0);
                    scheduleWithDelayCount[0] = scheduleWithDelayCount[0] + 1;
                }
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
        ((FirestoreImpl)Mockito.doAnswer(mock -> {
            retryAttempts[0] = retryAttempts[0] + 1;
            return RESOURCE_EXHAUSTED_FAILED_FUTURE;
        }).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setExecutor((ScheduledExecutorService)customExecutor).build());
        this.bulkWriter.addWriteErrorListener(error -> error.getFailedAttempts() < 5);
        ApiFuture result = this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush().get();
        try {
            result.get();
            Assert.fail((String)"Expected create() operation to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Mock batchWrite failed in test"));
            Assert.assertEquals((long)5L, (long)retryAttempts[0]);
            Assert.assertEquals((long)4L, (long)scheduleWithDelayCount[0]);
        }
        finally {
            this.shutdownScheduledExecutorService(customExecutor);
        }
    }

    @Test
    public void usesHighestBackoffFoundInBatch() throws Exception {
        final int[] expected = new int[]{60000, 1500};
        final int[] retryAttempts = new int[]{0};
        ScheduledThreadPoolExecutor customExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                if (delay > 0L) {
                    Assert.assertTrue(((double)delay >= 0.7 * (double)expected[retryAttempts[0]] ? 1 : 0) != 0);
                    Assert.assertTrue(((double)delay <= 1.3 * (double)expected[retryAttempts[0]] ? 1 : 0) != 0);
                    retryAttempts[0] = retryAttempts[0] + 1;
                }
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.mergeResponses(BulkWriterTest.failedResponse(8), BulkWriterTest.failedResponse(14)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1"), LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.failedResponse(14)));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.successResponse(2));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setExecutor((ScheduledExecutorService)customExecutor).build());
        this.bulkWriter.addWriteErrorListener(error -> error.getFailedAttempts() < 5);
        this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
        Assert.assertEquals((long)2L, (long)retryAttempts[0]);
        this.shutdownScheduledExecutorService(customExecutor);
    }

    @Test
    public void sendsBackoffBatchAfterOtherEnqueuedBatches() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.failedResponse(8));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc2")), BulkWriterTest.successResponse(0));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO, "coll/doc1")), BulkWriterTest.successResponse(0));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.bulkWriter.addWriteErrorListener(error -> error.getFailedAttempts() < 5);
        this.bulkWriter.create(this.doc1, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.flush();
        this.bulkWriter.set(this.doc2, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.bulkWriter.close();
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void optionsRequiresPositiveInteger() throws Exception {
        try {
            this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setInitialOpsPerSecond(-1).build());
            Assert.fail((String)"bulkWriter() call should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Value for argument 'initialOpsPerSecond' must be greater than 1, but was: -1");
        }
        try {
            this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setMaxOpsPerSecond(-1).build());
            Assert.fail((String)"bulkWriter() call should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Value for argument 'maxOpsPerSecond' must be greater than 1, but was: -1");
        }
    }

    @Test
    public void optionsRequiresMaxGreaterThanInitial() throws Exception {
        try {
            this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setInitialOpsPerSecond(550).setMaxOpsPerSecond(500).build());
            Assert.fail((String)"bulkWriter() call should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"'maxOpsPerSecond' cannot be less than 'initialOpsPerSecond'.");
        }
    }

    @Test
    public void cannotSetThrottlingOptionsWithThrottlingDisabled() throws Exception {
        try {
            this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setThrottlingEnabled(false).setInitialOpsPerSecond(500).build());
            Assert.fail((String)"bulkWriter() call should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Cannot set 'initialOpsPerSecond' or 'maxOpsPerSecond' when 'throttlingEnabled' is set to false.");
        }
        try {
            this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setThrottlingEnabled(false).setMaxOpsPerSecond(500).build());
            Assert.fail((String)"bulkWriter() call should have failed");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Cannot set 'initialOpsPerSecond' or 'maxOpsPerSecond' when 'throttlingEnabled' is set to false.");
        }
    }

    @Test
    public void optionsInitialAndMaxRatesAreProperlySet() throws Exception {
        BulkWriter bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setInitialOpsPerSecond(500).setMaxOpsPerSecond(550).build());
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)500L);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)550L);
        bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setMaxOpsPerSecond(1000).build());
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)500L);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)1000L);
        bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setInitialOpsPerSecond(100).build());
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)100L);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)Integer.MAX_VALUE);
        bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setMaxOpsPerSecond(100).build());
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)100L);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)100L);
        bulkWriter = this.firestoreMock.bulkWriter();
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)500L);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)Integer.MAX_VALUE);
        bulkWriter = this.firestoreMock.bulkWriter(BulkWriterOptions.builder().setThrottlingEnabled(false).build());
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getInitialCapacity(), (long)Integer.MAX_VALUE);
        Assert.assertEquals((long)bulkWriter.getRateLimiter().getMaximumRate(), (long)Integer.MAX_VALUE);
    }
}

