/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.firestore.v1.CommitRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CollectionReferenceTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<CommitRequest> argCaptor;
    private CollectionReference collectionReference;

    @Before
    public void before() {
        this.collectionReference = this.firestoreMock.collection("coll");
    }

    public boolean matchesIgnoresName(CommitRequest o) {
        CommitRequest.Builder actual = o.toBuilder();
        actual.getWritesBuilder(0).getUpdateBuilder().clearName().build();
        CommitRequest.Builder expected = LocalFirestoreHelper.SINGLE_CREATE_COMMIT_REQUEST.toBuilder();
        expected.getWritesBuilder(0).getUpdateBuilder().clearName().build();
        return actual.build().equals((Object)expected.build());
    }

    @Test
    public void getDocument() {
        DocumentReference documentReference = this.collectionReference.document("doc");
        Assert.assertEquals((Object)"doc", (Object)documentReference.getId());
        documentReference = this.collectionReference.document();
        Assert.assertEquals((long)20L, (long)documentReference.getId().length());
        try {
            this.collectionReference.document("");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("'path' must be a non-empty String"));
        }
    }

    @Test
    public void getParent() {
        DocumentReference documentReference = this.collectionReference.getParent();
        Assert.assertNull((Object)documentReference);
        CollectionReference subcollection = this.collectionReference.document("doc").collection("subcoll");
        Assert.assertEquals((Object)"subcoll", (Object)subcollection.getId());
        Assert.assertEquals((Object)"coll/doc/subcoll", (Object)subcollection.getPath());
        documentReference = subcollection.getParent();
        Assert.assertEquals((Object)"doc", (Object)documentReference.getId());
    }

    @Test
    public void addDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.argCaptor.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture future = this.collectionReference.add(LocalFirestoreHelper.SINGLE_FIELD_MAP);
        DocumentReference documentReference = (DocumentReference)future.get();
        Assert.assertEquals((long)20L, (long)documentReference.getId().length());
        future = this.collectionReference.add((Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT);
        documentReference = (DocumentReference)future.get();
        Assert.assertEquals((long)20L, (long)documentReference.getId().length());
        Assert.assertTrue((boolean)this.matchesIgnoresName((CommitRequest)this.argCaptor.getValue()));
    }
}

