/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.conformance.firestore.v1.TestDefinition;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.Precondition;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ConformanceConversions {
    private static final Gson gson = new Gson();

    private ConformanceConversions() {
    }

    static Precondition convertPrecondition(com.google.firestore.v1.Precondition precondition) {
        switch (precondition.getConditionTypeCase()) {
            case EXISTS: {
                return Precondition.exists((Boolean)precondition.getExists());
            }
            case UPDATE_TIME: {
                return Precondition.updatedAt((Timestamp)Timestamp.fromProto((com.google.protobuf.Timestamp)precondition.getUpdateTime()));
            }
        }
        return Precondition.NONE;
    }

    static List<FieldPath> convertPaths(List<TestDefinition.FieldPath> fieldsList) {
        ArrayList<FieldPath> convertedPaths = new ArrayList<FieldPath>();
        for (TestDefinition.FieldPath fieldPath : fieldsList) {
            convertedPaths.add(ConformanceConversions.convertPath(fieldPath));
        }
        return convertedPaths;
    }

    static FieldPath convertPath(TestDefinition.FieldPath fieldPath) {
        return FieldPath.of((String[])((String[])fieldPath.getFieldList().toArray((Object[])new String[0])));
    }

    static Map<String, Object> convertInput(String jsonMap) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map parsedData = (Map)gson.fromJson(jsonMap, type);
        return ConformanceConversions.convertMap(parsedData);
    }

    static List<Object> convertInput(List<String> jsonValues) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String input : jsonValues) {
            if (input.matches("^\\{.*}$")) {
                result.add(ConformanceConversions.convertInput(input));
                continue;
            }
            result.add(ConformanceConversions.convertInput("{a:" + input + "}").get("a"));
        }
        return result;
    }

    private static Map<String, Object> convertMap(Map<String, Object> parsedData) {
        parsedData.replaceAll((k, v) -> ConformanceConversions.convertValue(v));
        return parsedData;
    }

    private static Object convertValue(Object data) {
        if (data instanceof Map) {
            return ConformanceConversions.convertMap((Map)data);
        }
        if (data instanceof List) {
            return ConformanceConversions.convertArray((List)data);
        }
        if ("NaN".equals(data)) {
            return Double.NaN;
        }
        if ("Delete".equals(data)) {
            return FieldValue.delete();
        }
        if ("ServerTimestamp".equals(data)) {
            return FieldValue.serverTimestamp();
        }
        if (data instanceof Double && Double.compare((Double)data, Math.floor((Double)data)) == 0) {
            return (long)((Double)data).doubleValue();
        }
        return data;
    }

    private static Object convertArray(List<Object> list) {
        if (!list.isEmpty() && list.get(0).equals("ArrayUnion")) {
            return FieldValue.arrayUnion((Object[])((List)ConformanceConversions.convertArray(list.subList(1, list.size()))).toArray());
        }
        if (!list.isEmpty() && list.get(0).equals("ArrayRemove")) {
            return FieldValue.arrayRemove((Object[])((List)ConformanceConversions.convertArray(list.subList(1, list.size()))).toArray());
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConformanceConversions.convertValue(list.get(i)));
        }
        return list;
    }
}

