/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.conformance.ConformanceTestLocator;
import com.google.cloud.conformance.firestore.v1.TestDefinition;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.ConformanceConversions;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSet;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.AllTests;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=AllTests.class)
public class ConformanceTest {
    private static final Set<String> excludedTests = Collections.emptySet();
    private static final Set<String> includedTests = Collections.emptySet();
    private static final boolean DEBUG_MODE = !includedTests.isEmpty();

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite();
        TestDefinition.TestFile testSuite = ConformanceTest.parseTests();
        for (Test test : ConformanceTest.initTests(testSuite)) {
            suite.addTest(test);
        }
        return suite;
    }

    private static List<Test> initTests(TestDefinition.TestFile testSuite) {
        ArrayList<Test> tests = new ArrayList<Test>();
        for (TestDefinition.Test testDefinition : testSuite.getTestsList()) {
            if (!includedTests.isEmpty() && !includedTests.contains(testDefinition.getDescription()) || excludedTests.contains(testDefinition.getDescription())) continue;
            tests.add(ConformanceTest.buildTest(testDefinition));
        }
        return tests;
    }

    private static TestDefinition.TestFile parseTests() throws IOException, URISyntaxException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ConformanceTestLocator.MatchPattern matchPattern = ConformanceTestLocator.newMatchPattern((String)"com/google/cloud/conformance/firestore/v1", (String)".json");
        List jsonResources = ConformanceTestLocator.findAllResourcePaths((ConformanceTestLocator.MatchPattern)matchPattern, (ClassLoader)cl);
        TestDefinition.TestFile.Builder suite = TestDefinition.TestFile.newBuilder();
        for (String jsonResource : jsonResources) {
            InputStream is = cl.getResourceAsStream(jsonResource);
            Assert.assertNotNull((String)String.format("Unable to load test definition: '%s'", jsonResource), (Object)is);
            InputStreamReader reader = new InputStreamReader(is);
            TestDefinition.TestFile.Builder testBuilder = TestDefinition.TestFile.newBuilder();
            JsonFormat.parser().merge((Reader)reader, (Message.Builder)testBuilder);
            suite.addAllTests((Iterable)testBuilder.build().getTestsList());
        }
        return suite.build();
    }

    private static Test buildTest(TestDefinition.Test td) {
        switch (td.getTestCase()) {
            case GET: {
                return new ConformanceGetTestRunner(td.getDescription(), td.getGet());
            }
            case CREATE: {
                return new ConformanceCreateTestRunner(td.getDescription(), td.getCreate());
            }
            case SET: {
                return new ConformanceSetTestRunner(td.getDescription(), td.getSet());
            }
            case UPDATE: {
                return new ConformanceUpdateTestRunner(td.getDescription(), td.getUpdate());
            }
            case UPDATE_PATHS: {
                return new ConformanceUpdatePathsTestRunner(td.getDescription(), td.getUpdatePaths());
            }
            case DELETE: {
                return new ConformanceDeleteTestRunner(td.getDescription(), td.getDelete());
            }
            case QUERY: {
                return new ConformanceQueryTestRunner(td.getDescription(), td.getQuery());
            }
            case LISTEN: {
                return new ConformanceListenTestRunner(td.getDescription(), td.getListen());
            }
        }
        throw new UnsupportedOperationException("Unknown test case type: " + td.getTestCase());
    }

    private static final class ConformanceGetTestRunner
    extends BaseConformanceTestRunner<TestDefinition.GetTest> {
        @Captor
        private ArgumentCaptor<BatchGetDocumentsRequest> getAllCapture;
        @Captor
        private ArgumentCaptor<ResponseObserver<Message>> streamObserverCapture;

        private ConformanceGetTestRunner(String description, TestDefinition.GetTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() throws Throwable {
            ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(Collections.emptyMap())).when((Object)this.firestore)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
            this.document(((TestDefinition.GetTest)this.testParameters).getDocRefPath()).get().get();
            BatchGetDocumentsRequest request = (BatchGetDocumentsRequest)this.getAllCapture.getValue();
            Assert.assertEquals((long)1L, (long)request.getDocumentsCount());
            Assert.assertEquals((Object)((TestDefinition.GetTest)this.testParameters).getRequest().getName(), (Object)request.getDocuments(0));
        }
    }

    private static final class ConformanceCreateTestRunner
    extends BaseConformanceTestRunner<TestDefinition.CreateTest> {
        @Captor
        private ArgumentCaptor<CommitRequest> commitCapture;

        private ConformanceCreateTestRunner(String description, TestDefinition.CreateTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() {
            ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(((TestDefinition.CreateTest)this.testParameters).getRequest().getWritesCount(), 0)).when((Object)this.firestore)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
            try {
                ApiFuture apiCall = this.document(((TestDefinition.CreateTest)this.testParameters).getDocRefPath()).create(ConformanceConversions.convertInput(((TestDefinition.CreateTest)this.testParameters).getJsonData()));
                Assert.assertFalse((boolean)((TestDefinition.CreateTest)this.testParameters).getIsError());
                apiCall.get();
                CommitRequest request = (CommitRequest)this.commitCapture.getValue();
                Assert.assertEquals((Object)((TestDefinition.CreateTest)this.testParameters).getRequest(), (Object)request);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)((TestDefinition.CreateTest)this.testParameters).getIsError());
            }
        }
    }

    private static final class ConformanceSetTestRunner
    extends BaseConformanceTestRunner<TestDefinition.SetTest> {
        @Captor
        private ArgumentCaptor<CommitRequest> commitCapture;

        private ConformanceSetTestRunner(String description, TestDefinition.SetTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() {
            ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(((TestDefinition.SetTest)this.testParameters).getRequest().getWritesCount(), 0)).when((Object)this.firestore)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
            try {
                ApiFuture apiCall = ((TestDefinition.SetTest)this.testParameters).hasOption() && ((TestDefinition.SetTest)this.testParameters).getOption().getAll() ? this.document(((TestDefinition.SetTest)this.testParameters).getDocRefPath()).set(ConformanceConversions.convertInput(((TestDefinition.SetTest)this.testParameters).getJsonData()), SetOptions.merge()) : (((TestDefinition.SetTest)this.testParameters).hasOption() && ((TestDefinition.SetTest)this.testParameters).getOption().getFieldsCount() > 0 ? this.document(((TestDefinition.SetTest)this.testParameters).getDocRefPath()).set(ConformanceConversions.convertInput(((TestDefinition.SetTest)this.testParameters).getJsonData()), SetOptions.mergeFieldPaths(ConformanceConversions.convertPaths(((TestDefinition.SetTest)this.testParameters).getOption().getFieldsList()))) : this.document(((TestDefinition.SetTest)this.testParameters).getDocRefPath()).set(ConformanceConversions.convertInput(((TestDefinition.SetTest)this.testParameters).getJsonData())));
                Assert.assertFalse((boolean)((TestDefinition.SetTest)this.testParameters).getIsError());
                apiCall.get();
                CommitRequest request = (CommitRequest)this.commitCapture.getValue();
                Assert.assertEquals((Object)((TestDefinition.SetTest)this.testParameters).getRequest(), (Object)request);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)((TestDefinition.SetTest)this.testParameters).getIsError());
            }
        }
    }

    private static final class ConformanceUpdateTestRunner
    extends BaseConformanceTestRunner<TestDefinition.UpdateTest> {
        @Captor
        private ArgumentCaptor<CommitRequest> commitCapture;

        private ConformanceUpdateTestRunner(String description, TestDefinition.UpdateTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() {
            ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(((TestDefinition.UpdateTest)this.testParameters).getRequest().getWritesCount(), 0)).when((Object)this.firestore)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
            try {
                ApiFuture apiCall = ((TestDefinition.UpdateTest)this.testParameters).hasPrecondition() ? this.document(((TestDefinition.UpdateTest)this.testParameters).getDocRefPath()).update(ConformanceConversions.convertInput(((TestDefinition.UpdateTest)this.testParameters).getJsonData()), ConformanceConversions.convertPrecondition(((TestDefinition.UpdateTest)this.testParameters).getPrecondition())) : this.document(((TestDefinition.UpdateTest)this.testParameters).getDocRefPath()).update(ConformanceConversions.convertInput(((TestDefinition.UpdateTest)this.testParameters).getJsonData()));
                Assert.assertFalse((boolean)((TestDefinition.UpdateTest)this.testParameters).getIsError());
                apiCall.get();
                CommitRequest request = (CommitRequest)this.commitCapture.getValue();
                Assert.assertEquals((Object)((TestDefinition.UpdateTest)this.testParameters).getRequest(), (Object)request);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)((TestDefinition.UpdateTest)this.testParameters).getIsError());
            }
        }
    }

    private static final class ConformanceUpdatePathsTestRunner
    extends BaseConformanceTestRunner<TestDefinition.UpdatePathsTest> {
        @Captor
        private ArgumentCaptor<CommitRequest> commitCapture;

        private ConformanceUpdatePathsTestRunner(String description, TestDefinition.UpdatePathsTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() {
            ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(((TestDefinition.UpdatePathsTest)this.testParameters).getRequest().getWritesCount(), 0)).when((Object)this.firestore)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
            try {
                List<FieldPath> fieldPaths = ConformanceConversions.convertPaths(((TestDefinition.UpdatePathsTest)this.testParameters).getFieldPathsList());
                FieldPath firstField = fieldPaths.remove(0);
                List<Object> values = ConformanceConversions.convertInput((List<String>)((TestDefinition.UpdatePathsTest)this.testParameters).getJsonValuesList());
                Object firstValue = values.remove(0);
                Object[] moreFieldsAndValues = new Object[2 * fieldPaths.size()];
                for (int i = 0; i < fieldPaths.size(); ++i) {
                    moreFieldsAndValues[2 * i] = fieldPaths.get(i);
                    moreFieldsAndValues[2 * i + 1] = values.get(i);
                }
                ApiFuture apiCall = ((TestDefinition.UpdatePathsTest)this.testParameters).hasPrecondition() ? this.document(((TestDefinition.UpdatePathsTest)this.testParameters).getDocRefPath()).update(ConformanceConversions.convertPrecondition(((TestDefinition.UpdatePathsTest)this.testParameters).getPrecondition()), firstField, firstValue, moreFieldsAndValues) : this.document(((TestDefinition.UpdatePathsTest)this.testParameters).getDocRefPath()).update(firstField, firstValue, moreFieldsAndValues);
                Assert.assertFalse((boolean)((TestDefinition.UpdatePathsTest)this.testParameters).getIsError());
                apiCall.get();
                CommitRequest request = (CommitRequest)this.commitCapture.getValue();
                Assert.assertEquals((Object)((TestDefinition.UpdatePathsTest)this.testParameters).getRequest(), (Object)request);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)((TestDefinition.UpdatePathsTest)this.testParameters).getIsError());
            }
        }
    }

    private static final class ConformanceDeleteTestRunner
    extends BaseConformanceTestRunner<TestDefinition.DeleteTest> {
        @Captor
        private ArgumentCaptor<CommitRequest> commitCapture;

        private ConformanceDeleteTestRunner(String description, TestDefinition.DeleteTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() throws Throwable {
            ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(0, ((TestDefinition.DeleteTest)this.testParameters).getRequest().getWritesCount())).when((Object)this.firestore)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
            if (!((TestDefinition.DeleteTest)this.testParameters).hasPrecondition()) {
                this.document(((TestDefinition.DeleteTest)this.testParameters).getDocRefPath()).delete().get();
            } else {
                this.document(((TestDefinition.DeleteTest)this.testParameters).getDocRefPath()).delete(ConformanceConversions.convertPrecondition(((TestDefinition.DeleteTest)this.testParameters).getPrecondition())).get();
            }
            CommitRequest request = (CommitRequest)this.commitCapture.getValue();
            Assert.assertEquals((Object)((TestDefinition.DeleteTest)this.testParameters).getRequest(), (Object)request);
        }
    }

    private static final class ConformanceQueryTestRunner
    extends BaseConformanceTestRunner<TestDefinition.QueryTest> {
        @Captor
        private ArgumentCaptor<RunQueryRequest> runQueryCapture;
        @Captor
        private ArgumentCaptor<ResponseObserver<Message>> streamObserverCapture;

        private ConformanceQueryTestRunner(String description, TestDefinition.QueryTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() {
            ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestore)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
            CollectionReference query = this.collection(((TestDefinition.QueryTest)this.testParameters).getCollPath());
            try {
                for (TestDefinition.Clause clause : ((TestDefinition.QueryTest)this.testParameters).getClausesList()) {
                    query = this.applyClause((Query)query, clause);
                }
                ApiFuture apiCall = query.get();
                Assert.assertFalse((boolean)((TestDefinition.QueryTest)this.testParameters).getIsError());
                apiCall.get();
                RunQueryRequest request = (RunQueryRequest)this.runQueryCapture.getValue();
                Assert.assertEquals((Object)((TestDefinition.QueryTest)this.testParameters).getQuery(), (Object)request.getStructuredQuery());
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)((TestDefinition.QueryTest)this.testParameters).getIsError());
            }
        }

        private Query applyClause(Query query, TestDefinition.Clause clause) {
            block0 : switch (clause.getClauseCase()) {
                case SELECT: {
                    query = query.select(ConformanceConversions.convertPaths(clause.getSelect().getFieldsList()).toArray(new FieldPath[0]));
                    break;
                }
                case WHERE: {
                    TestDefinition.Where whereClause = clause.getWhere();
                    FieldPath fieldPath = ConformanceConversions.convertPath(whereClause.getPath());
                    Object value = ConformanceConversions.convertInput(Collections.singletonList(whereClause.getJsonValue())).get(0);
                    switch (whereClause.getOp()) {
                        case "<": {
                            query = query.whereLessThan(fieldPath, value);
                            break block0;
                        }
                        case "<=": {
                            query = query.whereLessThanOrEqualTo(fieldPath, value);
                            break block0;
                        }
                        case "==": {
                            query = query.whereEqualTo(fieldPath, value);
                            break block0;
                        }
                        case ">=": {
                            query = query.whereGreaterThanOrEqualTo(fieldPath, value);
                            break block0;
                        }
                        case ">": {
                            query = query.whereGreaterThan(fieldPath, value);
                            break block0;
                        }
                        case "!=": {
                            query = query.whereNotEqualTo(fieldPath, value);
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case ORDER_BY: {
                    TestDefinition.OrderBy orderClause = clause.getOrderBy();
                    FieldPath fieldPath = ConformanceConversions.convertPath(orderClause.getPath());
                    switch (orderClause.getDirection()) {
                        case "asc": {
                            query = query.orderBy(fieldPath, Query.Direction.ASCENDING);
                            break block0;
                        }
                        case "desc": {
                            query = query.orderBy(fieldPath, Query.Direction.DESCENDING);
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case OFFSET: {
                    query = query.offset(clause.getOffset());
                    break;
                }
                case LIMIT: {
                    query = query.limit(clause.getLimit());
                    break;
                }
                case START_AT: {
                    TestDefinition.Cursor cursor = clause.getStartAt();
                    if (cursor.hasDocSnapshot()) {
                        query = query.startAt(this.convertDocument(cursor.getDocSnapshot()));
                        break;
                    }
                    query = query.startAt(ConformanceConversions.convertInput((List<String>)cursor.getJsonValuesList()).toArray());
                    break;
                }
                case START_AFTER: {
                    TestDefinition.Cursor cursor = clause.getStartAfter();
                    if (cursor.hasDocSnapshot()) {
                        query = query.startAfter(this.convertDocument(cursor.getDocSnapshot()));
                        break;
                    }
                    query = query.startAfter(ConformanceConversions.convertInput((List<String>)cursor.getJsonValuesList()).toArray());
                    break;
                }
                case END_AT: {
                    TestDefinition.Cursor cursor = clause.getEndAt();
                    if (cursor.hasDocSnapshot()) {
                        query = query.endAt(this.convertDocument(cursor.getDocSnapshot()));
                        break;
                    }
                    query = query.endAt(ConformanceConversions.convertInput((List<String>)cursor.getJsonValuesList()).toArray());
                    break;
                }
                case END_BEFORE: {
                    TestDefinition.Cursor cursor = clause.getEndBefore();
                    if (cursor.hasDocSnapshot()) {
                        query = query.endBefore(this.convertDocument(cursor.getDocSnapshot()));
                        break;
                    }
                    query = query.endBefore(ConformanceConversions.convertInput((List<String>)cursor.getJsonValuesList()).toArray());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return query;
        }

        private DocumentSnapshot convertDocument(TestDefinition.DocSnapshot snapshot) {
            return DocumentSnapshot.fromObject((FirestoreRpcContext)this.firestore, (DocumentReference)this.document(snapshot.getPath()), ConformanceConversions.convertInput(snapshot.getJsonData()), (UserDataConverter.EncodingOptions)UserDataConverter.NO_DELETES);
        }
    }

    private static final class ConformanceListenTestRunner
    extends BaseConformanceTestRunner<TestDefinition.ListenTest> {
        @Captor
        private ArgumentCaptor<BidiStreamObserver<Message, Message>> streamObserverCapture;
        @Mock
        private ClientStream<ListenRequest> noOpRequestObserver;
        private final Query watchQuery = this.collection("projects/projectID/databases/(default)/documents/C").orderBy("a");

        private ConformanceListenTestRunner(String description, TestDefinition.ListenTest testParameters) {
            super(description, testParameters);
        }

        @Override
        public void runTest() throws Throwable {
            SettableApiFuture testCaseStarted = SettableApiFuture.create();
            SettableApiFuture testCaseFinished = SettableApiFuture.create();
            ((FirestoreImpl)Mockito.doAnswer(invocationOnMock -> {
                testCaseStarted.set(null);
                return this.noOpRequestObserver;
            }).when((Object)this.firestore)).streamRequest((BidiStreamObserver)this.streamObserverCapture.capture(), (BidiStreamingCallable)ArgumentMatchers.any());
            ArrayList expectedSnapshots = new ArrayList(((TestDefinition.ListenTest)this.testParameters).getSnapshotsList());
            ListenerRegistration registration = this.watchQuery.addSnapshotListener((actualSnapshot, error) -> {
                try {
                    if (actualSnapshot != null) {
                        Assert.assertNull((Object)((Object)error));
                        Assert.assertFalse((boolean)expectedSnapshots.isEmpty());
                        TestDefinition.Snapshot expectedSnapshot = (TestDefinition.Snapshot)expectedSnapshots.remove(0);
                        Assert.assertEquals((Object)this.convertQuerySnapshot(expectedSnapshot), (Object)actualSnapshot);
                        if (expectedSnapshots.isEmpty() && !((TestDefinition.ListenTest)this.testParameters).getIsError()) {
                            testCaseFinished.set(null);
                        }
                    } else {
                        Assert.assertNotNull((Object)((Object)error));
                        Assert.assertTrue((boolean)expectedSnapshots.isEmpty());
                        Assert.assertTrue((boolean)((TestDefinition.ListenTest)this.testParameters).getIsError());
                        testCaseFinished.set(null);
                    }
                }
                catch (AssertionError e) {
                    testCaseFinished.setException((Throwable)((Object)e));
                }
            });
            testCaseStarted.get();
            for (ListenResponse response : ((TestDefinition.ListenTest)this.testParameters).getResponsesList()) {
                ((BidiStreamObserver)this.streamObserverCapture.getValue()).onResponse((Object)response);
            }
            testCaseFinished.get();
            registration.remove();
        }

        private QuerySnapshot convertQuerySnapshot(TestDefinition.Snapshot testSnapshot) {
            Timestamp readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)testSnapshot.getReadTime());
            ArrayList<QueryDocumentSnapshot> documentSnapshots = new ArrayList<QueryDocumentSnapshot>();
            for (Object document : testSnapshot.getDocsList()) {
                documentSnapshots.add(QueryDocumentSnapshot.fromDocument((FirestoreRpcContext)this.firestore, (Timestamp)Timestamp.fromProto((com.google.protobuf.Timestamp)testSnapshot.getReadTime()), (Document)document));
            }
            DocumentSet documentSet = DocumentSet.emptySet((o1, o2) -> {
                for (QueryDocumentSnapshot snapshot : documentSnapshots) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    if (o1.equals((Object)snapshot)) {
                        return -1;
                    }
                    if (!o2.equals((Object)snapshot)) continue;
                    return 1;
                }
                Assert.fail((String)"Unable to find position for document snapshot");
                return 0;
            });
            for (QueryDocumentSnapshot snapshot : documentSnapshots) {
                documentSet = documentSet.add(snapshot);
            }
            ArrayList<DocumentChange> documentChanges = new ArrayList<DocumentChange>();
            for (TestDefinition.DocChange documentChange : testSnapshot.getChangesList()) {
                QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument((FirestoreRpcContext)this.firestore, (Timestamp)Timestamp.fromProto((com.google.protobuf.Timestamp)testSnapshot.getReadTime()), (Document)documentChange.getDoc());
                DocumentChange.Type changeType = ConformanceListenTestRunner.convertKind(documentChange.getKind());
                documentChanges.add(new DocumentChange(documentSnapshot, changeType, documentChange.getOldIndex(), documentChange.getNewIndex()));
            }
            return QuerySnapshot.withChanges((Query)this.watchQuery, (Timestamp)readTime, (DocumentSet)documentSet, documentChanges);
        }

        private static DocumentChange.Type convertKind(TestDefinition.DocChange.Kind kind) {
            DocumentChange.Type changeType = null;
            switch (kind) {
                case ADDED: {
                    changeType = DocumentChange.Type.ADDED;
                    break;
                }
                case REMOVED: {
                    changeType = DocumentChange.Type.REMOVED;
                    break;
                }
                case MODIFIED: {
                    changeType = DocumentChange.Type.MODIFIED;
                    break;
                }
                default: {
                    Assert.fail((String)("Unable to convert document change for kind: " + kind));
                }
            }
            return changeType;
        }
    }

    private static abstract class BaseConformanceTestRunner<T>
    implements Test,
    Describable {
        private static final String DEBUG_MESSAGE_FORMAT = "--- Test Description -----------------------------------------------------------%n%s%n--- Test Case ------------------------------------------------------------------%n%s%n--------------------------------------------------------------------------------%n";
        protected static final String ROOT_COLLECTION_PATH = "projects/projectID/databases/(default)/documents/";
        private final Description description;
        protected final T testParameters;
        protected final FirestoreImpl firestore;

        protected BaseConformanceTestRunner(String description, T testParameters) {
            this.description = Description.createTestDescription((String)ConformanceTest.class.getName(), (String)description, (Annotation[])new Annotation[0]);
            this.testParameters = testParameters;
            ScheduledExecutorService firestoreExecutor = Executors.newSingleThreadScheduledExecutor();
            FirestoreRpc firestoreRpc = (FirestoreRpc)Mockito.mock(FirestoreRpc.class);
            Mockito.when((Object)firestoreRpc.getExecutor()).thenReturn((Object)firestoreExecutor);
            this.firestore = (FirestoreImpl)Mockito.spy((Object)new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("projectID")).build(), firestoreRpc));
        }

        public final Description getDescription() {
            return this.description;
        }

        public final int countTestCases() {
            return 1;
        }

        public final void run(TestResult testResult) {
            testResult.startTest((Test)this);
            testResult.runProtected((Test)this, () -> {
                if (DEBUG_MODE) {
                    System.out.printf(DEBUG_MESSAGE_FORMAT, this.description, this.testParameters);
                }
                try (AutoCloseable mocks = MockitoAnnotations.openMocks((Object)this);){
                    this.runTest();
                }
            });
            testResult.endTest((Test)this);
        }

        public abstract void runTest() throws Throwable;

        public final String toString() {
            return this.getClass().getSimpleName() + "{description=" + this.description.getDisplayName() + '}';
        }

        final DocumentReference document(String absolutePath) {
            Preconditions.checkState((boolean)absolutePath.startsWith(ROOT_COLLECTION_PATH));
            return this.firestore.document(absolutePath.substring(ROOT_COLLECTION_PATH.length()));
        }

        final CollectionReference collection(String absolutePath) {
            Preconditions.checkState((boolean)absolutePath.startsWith(ROOT_COLLECTION_PATH));
            return this.firestore.collection(absolutePath.substring(ROOT_COLLECTION_PATH.length()));
        }
    }
}

