/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.Value;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DocumentReferenceTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<CommitRequest> commitCapture;
    @Captor
    private ArgumentCaptor<BatchGetDocumentsRequest> getAllCapture;
    @Captor
    private ArgumentCaptor<ResponseObserver<CommitResponse>> streamObserverCapture;
    private DocumentReference documentReference;

    @Before
    public void before() {
        this.documentReference = this.firestoreMock.document("coll/doc");
    }

    @Test
    public void equals() {
        DocumentReference doc1 = this.documentReference.collection("subcoll").document("doc");
        DocumentReference doc2 = this.documentReference.collection("subcoll").document("doc");
        Assert.assertEquals((Object)doc1, (Object)doc2);
    }

    @Test
    public void getCollection() {
        CollectionReference collectionReference = this.documentReference.collection("subcoll");
        Assert.assertEquals((Object)"subcoll", (Object)collectionReference.getId());
    }

    @Test
    public void getPath() {
        Assert.assertEquals((Object)LocalFirestoreHelper.DOCUMENT_PATH, (Object)this.documentReference.getPath());
    }

    @Test
    public void getParent() {
        CollectionReference collectionReference = this.documentReference.getParent();
        Assert.assertEquals((Object)"coll", (Object)collectionReference.getId());
    }

    @Test
    public void serializeBasicTypes() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_MAP).get();
        this.documentReference.set((Object)LocalFirestoreHelper.ALL_SUPPORTED_TYPES_OBJECT).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_PROTO));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getAllValues().get(0));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getAllValues().get(1));
    }

    @Test
    public void serializeDocumentReference() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map("docRef", this.documentReference, new Object[0])).get();
        HashMap<String, Value> documentReferenceFields = new HashMap<String, Value>();
        documentReferenceFields.put("docRef", Value.newBuilder().setReferenceValue(LocalFirestoreHelper.DOCUMENT_NAME).build());
        LocalFirestoreHelper.assertCommitEquals(LocalFirestoreHelper.commit(LocalFirestoreHelper.set(documentReferenceFields)), (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void doesNotSerializeAdvancedNumberTypes() {
        HashMap<LocalFirestoreHelper.InvalidPOJO, String> expectedErrorMessages = new HashMap<LocalFirestoreHelper.InvalidPOJO, String>();
        LocalFirestoreHelper.InvalidPOJO pojo = new LocalFirestoreHelper.InvalidPOJO();
        pojo.bigIntegerValue = new BigInteger("0");
        expectedErrorMessages.put(pojo, "Could not serialize object. Numbers of type BigInteger are not supported, please use an int, long, float, double or BigDecimal (found in field 'bigIntegerValue')");
        pojo = new LocalFirestoreHelper.InvalidPOJO();
        pojo.byteValue = 0;
        expectedErrorMessages.put(pojo, "Could not serialize object. Numbers of type Byte are not supported, please use an int, long, float, double or BigDecimal (found in field 'byteValue')");
        pojo = new LocalFirestoreHelper.InvalidPOJO();
        pojo.shortValue = 0;
        expectedErrorMessages.put(pojo, "Could not serialize object. Numbers of type Short are not supported, please use an int, long, float, double or BigDecimal (found in field 'shortValue')");
        for (Map.Entry testCase : expectedErrorMessages.entrySet()) {
            try {
                this.documentReference.set(testCase.getKey());
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals(testCase.getValue(), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void deserializeBasicTypes() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        Assert.assertEquals((Object)snapshot.getData(), LocalFirestoreHelper.ALL_SUPPORTED_TYPES_MAP);
        LocalFirestoreHelper.AllSupportedTypes pojo = (LocalFirestoreHelper.AllSupportedTypes)snapshot.toObject(LocalFirestoreHelper.AllSupportedTypes.class);
        Assert.assertEquals((Object)new LocalFirestoreHelper.AllSupportedTypes(), (Object)pojo);
        Assert.assertEquals((Object)"bar", (Object)snapshot.get("foo"));
        Assert.assertEquals((Object)"bar", (Object)snapshot.get(FieldPath.of((String[])new String[]{"foo"})));
        Assert.assertTrue((boolean)snapshot.contains("foo"));
        Assert.assertTrue((boolean)snapshot.contains(FieldPath.of((String[])new String[]{"foo"})));
        Assert.assertEquals((Object)"bar", (Object)snapshot.getString("foo"));
        Assert.assertEquals((Object)"bar", (Object)snapshot.getString("objectValue.foo"));
        Assert.assertEquals((Object)"bar", (Object)snapshot.get(FieldPath.of((String[])new String[]{"objectValue", "foo"})));
        Assert.assertTrue((boolean)snapshot.contains("objectValue.foo"));
        Assert.assertTrue((boolean)snapshot.contains(FieldPath.of((String[])new String[]{"objectValue", "foo"})));
        Assert.assertEquals((Object)0.0, (Object)snapshot.getDouble("doubleValue"));
        Assert.assertEquals((Object)0L, (Object)snapshot.getLong("longValue"));
        Assert.assertEquals((Object)true, (Object)snapshot.getBoolean("trueValue"));
        Assert.assertEquals((Object)LocalFirestoreHelper.DATE, (Object)snapshot.getDate("dateValue"));
        Assert.assertEquals((Object)LocalFirestoreHelper.TIMESTAMP, (Object)snapshot.getTimestamp("timestampValue"));
        Assert.assertEquals((Object)LocalFirestoreHelper.BLOB, (Object)snapshot.getBlob("bytesValue"));
        Assert.assertEquals((long)LocalFirestoreHelper.BLOB.hashCode(), (long)snapshot.getBlob("bytesValue").hashCode());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])snapshot.getBlob("bytesValue").toBytes());
        Assert.assertEquals((Object)LocalFirestoreHelper.GEO_POINT, (Object)snapshot.getGeoPoint("geoPointValue"));
        Assert.assertEquals((long)LocalFirestoreHelper.GEO_POINT.hashCode(), (long)snapshot.getGeoPoint("geoPointValue").hashCode());
        Assert.assertEquals((double)LocalFirestoreHelper.GEO_POINT.getLatitude(), (double)snapshot.getGeoPoint("geoPointValue").getLatitude(), (double)0.0);
        Assert.assertEquals((double)LocalFirestoreHelper.GEO_POINT.getLongitude(), (double)snapshot.getGeoPoint("geoPointValue").getLongitude(), (double)0.0);
        Assert.assertNull((Object)snapshot.get("nullValue"));
        Assert.assertTrue((boolean)snapshot.contains("nullValue"));
        Assert.assertTrue((boolean)snapshot.contains("objectValue.foo"));
        Assert.assertFalse((boolean)snapshot.contains("objectValue.bar"));
        Assert.assertTrue((boolean)snapshot.exists());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2), (Object)snapshot.getCreateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)3L, (int)4), (Object)snapshot.getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)5L, (int)6), (Object)snapshot.getReadTime());
        Assert.assertEquals((Object)LocalFirestoreHelper.get(), (Object)this.getAllCapture.getValue());
        Assert.assertEquals((Object)"bar", ((Map)snapshot.get("model")).get("foo"));
    }

    @Test
    public void deserializeDocumentReference() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.map("docRef", Value.newBuilder().setReferenceValue(LocalFirestoreHelper.DOCUMENT_NAME).build(), new Object[0]))).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        Assert.assertEquals((Object)this.documentReference, snapshot.getData().get("docRef"));
        Assert.assertEquals((Object)this.documentReference, (Object)snapshot.getReference());
    }

    @Test
    public void getFieldWithFieldMask() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get(FieldMask.of((FieldPath[])new FieldPath[]{FieldPath.of((String[])new String[]{"foo"})})).get();
        Assert.assertEquals((Object)"foo", (Object)((BatchGetDocumentsRequest)this.getAllCapture.getValue()).getMask().getFieldPaths(0));
        Assert.assertEquals((Object)"bar", (Object)snapshot.get("foo"));
    }

    @Test
    public void deserializesDates() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        Assert.assertEquals((Object)Timestamp.of((Date)LocalFirestoreHelper.DATE), (Object)snapshot.get("dateValue"));
        Assert.assertEquals((Object)LocalFirestoreHelper.TIMESTAMP, (Object)snapshot.get("timestampValue"));
        Assert.assertEquals((Object)Timestamp.of((Date)LocalFirestoreHelper.DATE), snapshot.getData().get("dateValue"));
        Assert.assertEquals((Object)LocalFirestoreHelper.TIMESTAMP, snapshot.getData().get("timestampValue"));
    }

    @Test
    public void doesNotDeserializeAdvancedNumberTypes() throws Exception {
        Map<String, String> fieldNamesToTypeNames = LocalFirestoreHelper.map("bigIntegerValue", "BigInteger", "shortValue", "Short", "byteValue", "Byte");
        for (Map.Entry<String, String> testCase : fieldNamesToTypeNames.entrySet()) {
            String fieldName = testCase.getKey();
            String typeName = testCase.getValue();
            Map<String, Value> response = LocalFirestoreHelper.map(fieldName, Value.newBuilder().setIntegerValue(0L).build(), new Object[0]);
            ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(response)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
            DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
            try {
                snapshot.toObject(LocalFirestoreHelper.InvalidPOJO.class);
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)String.format("Could not deserialize object. Deserializing values to %s is not supported (found in field '%s')", typeName, fieldName), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void notFound() throws Exception {
        BatchGetDocumentsResponse.Builder getDocumentResponse = BatchGetDocumentsResponse.newBuilder();
        getDocumentResponse.setMissing(LocalFirestoreHelper.DOCUMENT_NAME);
        getDocumentResponse.setReadTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(5L).setNanos(6));
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.streamingResponse(new BatchGetDocumentsResponse[]{getDocumentResponse.build()}, null)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        Assert.assertEquals((Object)this.documentReference, (Object)snapshot.getReference());
        Assert.assertFalse((boolean)snapshot.exists());
        Assert.assertEquals((Object)snapshot.getReadTime(), (Object)Timestamp.ofTimeSecondsAndNanos((long)5L, (int)6));
        Assert.assertNull((Object)snapshot.getData());
    }

    @Test
    public void deleteDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_DELETE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.delete().get();
        this.documentReference.delete(Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)479978400L, (int)123000000))).get();
        List commitRequests = this.commitCapture.getAllValues();
        LocalFirestoreHelper.assertCommitEquals(LocalFirestoreHelper.commit(LocalFirestoreHelper.delete()), (CommitRequest)commitRequests.get(0));
        Precondition.Builder precondition = com.google.firestore.v1.Precondition.newBuilder();
        precondition.getUpdateTimeBuilder().setSeconds(479978400L).setNanos(123000000);
        LocalFirestoreHelper.assertCommitEquals(LocalFirestoreHelper.commit(LocalFirestoreHelper.delete(precondition.build())), (CommitRequest)commitRequests.get(1));
    }

    @Test
    public void createDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.create(LocalFirestoreHelper.SINGLE_FIELD_MAP).get();
        this.documentReference.create((Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        List commitRequests = this.commitCapture.getAllValues();
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)commitRequests.get(0));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)commitRequests.get(1));
    }

    @Test
    public void createWithServerTimestamp() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.create(LocalFirestoreHelper.SERVER_TIMESTAMP_MAP).get();
        this.documentReference.create((Object)LocalFirestoreHelper.SERVER_TIMESTAMP_OBJECT).get();
        CommitRequest create = LocalFirestoreHelper.commit(LocalFirestoreHelper.create(Collections.emptyMap()), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.serverTimestamp(), "inner.bar", LocalFirestoreHelper.serverTimestamp()));
        List commitRequests = this.commitCapture.getAllValues();
        LocalFirestoreHelper.assertCommitEquals(create, (CommitRequest)commitRequests.get(0));
        LocalFirestoreHelper.assertCommitEquals(create, (CommitRequest)commitRequests.get(1));
    }

    @Test
    public void setWithServerTimestamp() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.FIELD_TRANSFORM_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.SERVER_TIMESTAMP_MAP).get();
        this.documentReference.set((Object)LocalFirestoreHelper.SERVER_TIMESTAMP_OBJECT).get();
        CommitRequest set = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(LocalFirestoreHelper.SERVER_TIMESTAMP_PROTO), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.serverTimestamp(), "inner.bar", LocalFirestoreHelper.serverTimestamp()));
        List commitRequests = this.commitCapture.getAllValues();
        LocalFirestoreHelper.assertCommitEquals(set, (CommitRequest)commitRequests.get(0));
        LocalFirestoreHelper.assertCommitEquals(set, (CommitRequest)commitRequests.get(1));
    }

    @Test
    public void updateWithServerTimestamp() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.FIELD_TRANSFORM_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update(LocalFirestoreHelper.SERVER_TIMESTAMP_MAP).get();
        CommitRequest update = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(Collections.emptyMap(), Collections.singletonList("inner")), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.serverTimestamp(), "inner.bar", LocalFirestoreHelper.serverTimestamp()));
        LocalFirestoreHelper.assertCommitEquals(update, (CommitRequest)this.commitCapture.getValue());
        this.documentReference.update("foo", (Object)FieldValue.serverTimestamp(), new Object[]{"inner.bar", FieldValue.serverTimestamp()});
        update = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(Collections.emptyMap(), new ArrayList<String>(), LocalFirestoreHelper.UPDATE_PRECONDITION), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.serverTimestamp(), "inner.bar", LocalFirestoreHelper.serverTimestamp()));
        LocalFirestoreHelper.assertCommitEquals(update, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void mergeWithServerTimestamps() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.SERVER_TIMESTAMP_MAP, SetOptions.mergeFields((String[])new String[]{"inner.bar"})).get();
        this.documentReference.set((Object)LocalFirestoreHelper.SERVER_TIMESTAMP_OBJECT, SetOptions.mergeFields((String[])new String[]{"inner.bar"})).get();
        CommitRequest set = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(LocalFirestoreHelper.SERVER_TIMESTAMP_PROTO, new ArrayList<String>()), LocalFirestoreHelper.transform("inner.bar", LocalFirestoreHelper.serverTimestamp(), new Object[0]));
        List commitRequests = this.commitCapture.getAllValues();
        LocalFirestoreHelper.assertCommitEquals(set, (CommitRequest)commitRequests.get(0));
        LocalFirestoreHelper.assertCommitEquals(set, (CommitRequest)commitRequests.get(1));
    }

    @Test
    public void setWithIncrement() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.FIELD_TRANSFORM_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map("integer", FieldValue.increment((long)1L), "double", FieldValue.increment((double)1.1))).get();
        CommitRequest set = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(Collections.emptyMap()), LocalFirestoreHelper.transform("integer", LocalFirestoreHelper.increment(Value.newBuilder().setIntegerValue(1L).build()), "double", LocalFirestoreHelper.increment(Value.newBuilder().setDoubleValue(1.1).build())));
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        LocalFirestoreHelper.assertCommitEquals(set, commitRequest);
    }

    @Test
    public void setWithArrayUnion() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.FIELD_TRANSFORM_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map("foo", FieldValue.arrayUnion((Object[])new Object[]{"bar", LocalFirestoreHelper.map("foo", "baz", new Object[0])}), new Object[0])).get();
        CommitRequest set = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(Collections.emptyMap()), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.arrayUnion(LocalFirestoreHelper.string("bar"), LocalFirestoreHelper.object("foo", LocalFirestoreHelper.string("baz"))), new Object[0]));
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        LocalFirestoreHelper.assertCommitEquals(set, commitRequest);
    }

    @Test
    public void setWithArrayRemove() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.FIELD_TRANSFORM_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map("foo", FieldValue.arrayRemove((Object[])new Object[]{"bar", LocalFirestoreHelper.map("foo", "baz", new Object[0])}), new Object[0])).get();
        CommitRequest set = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(Collections.emptyMap()), LocalFirestoreHelper.transform("foo", LocalFirestoreHelper.arrayRemove(LocalFirestoreHelper.string("bar"), LocalFirestoreHelper.object("foo", LocalFirestoreHelper.string("baz"))), new Object[0]));
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        LocalFirestoreHelper.assertCommitEquals(set, commitRequest);
    }

    @Test
    public void serverTimestampInArray() {
        HashMap<String, ImmutableList> list = new HashMap<String, ImmutableList>();
        list.put("foo", ImmutableList.of((Object)FieldValue.serverTimestamp()));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.serverTimestamp() is not supported inside of an array."));
        }
        list.clear();
        list.put("a", ImmutableList.of((Object)ImmutableList.of((Object)"b", LocalFirestoreHelper.map("c", FieldValue.serverTimestamp(), new Object[0]))));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.serverTimestamp() is not supported inside of an array."));
        }
    }

    @Test
    public void deleteInArray() {
        HashMap<String, ImmutableList> list = new HashMap<String, ImmutableList>();
        list.put("foo", ImmutableList.of((Object)FieldValue.delete()));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.delete() is not supported at field 'foo.`0`'."));
        }
        list.clear();
        list.put("a", ImmutableList.of((Object)ImmutableList.of((Object)"b", LocalFirestoreHelper.map("c", FieldValue.delete(), new Object[0]))));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.delete() is not supported at field 'a.`0`.`1`.c'."));
        }
    }

    @Test
    public void arrayUnionInArray() {
        HashMap<String, ImmutableList> list = new HashMap<String, ImmutableList>();
        list.put("foo", ImmutableList.of((Object)FieldValue.arrayUnion((Object[])new Object[]{"foo"})));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.arrayUnion() is not supported inside of an array."));
        }
        list.clear();
        list.put("a", ImmutableList.of((Object)ImmutableList.of((Object)"b", LocalFirestoreHelper.map("c", FieldValue.arrayUnion((Object[])new Object[]{"foo"}), new Object[0]))));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.arrayUnion() is not supported inside of an array."));
        }
    }

    @Test
    public void arrayUnionInArrayUnion() {
        HashMap<String, FieldValue> data = new HashMap<String, FieldValue>();
        data.put("foo", FieldValue.arrayUnion((Object[])new Object[]{FieldValue.arrayUnion((Object[])new Object[]{"foo"})}));
        try {
            this.documentReference.create(data);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Cannot use FieldValue.arrayUnion() as an argument at field 'foo'."));
        }
    }

    @Test
    public void deleteInArrayUnion() {
        HashMap<String, FieldValue> data = new HashMap<String, FieldValue>();
        data.put("foo", FieldValue.arrayUnion((Object[])new Object[]{FieldValue.delete()}));
        try {
            this.documentReference.set(data, SetOptions.merge());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.delete() is not supported at field 'foo'."));
        }
    }

    @Test
    public void arrayRemoveInArray() {
        HashMap<String, ImmutableList> list = new HashMap<String, ImmutableList>();
        list.put("foo", ImmutableList.of((Object)FieldValue.arrayRemove((Object[])new Object[]{"foo"})));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.arrayRemove() is not supported inside of an array."));
        }
        list.clear();
        list.put("a", ImmutableList.of((Object)ImmutableList.of((Object)"b", LocalFirestoreHelper.map("c", FieldValue.arrayRemove((Object[])new Object[]{"foo"}), new Object[0]))));
        try {
            this.documentReference.create(list);
            Assert.fail();
        }
        catch (FirestoreException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("FieldValue.arrayRemove() is not supported inside of an array."));
        }
    }

    @Test
    public void setDocumentWithMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.SINGLE_FIELD_MAP, SetOptions.merge()).get();
        this.documentReference.set((Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT, SetOptions.merge()).get();
        this.documentReference.set((Object)LocalFirestoreHelper.ALL_SUPPORTED_TYPES_OBJECT, SetOptions.mergeFields((String[])new String[]{"foo"})).get();
        this.documentReference.set((Object)LocalFirestoreHelper.ALL_SUPPORTED_TYPES_OBJECT, SetOptions.mergeFields(Arrays.asList("foo"))).get();
        this.documentReference.set((Object)LocalFirestoreHelper.ALL_SUPPORTED_TYPES_OBJECT, SetOptions.mergeFieldPaths(Arrays.asList(FieldPath.of((String[])new String[]{"foo"})))).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Arrays.asList("foo")));
        for (int i = 0; i < 5; ++i) {
            LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getAllValues().get(i));
        }
    }

    @Test
    public void setDocumentWithEmptyMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map(), SetOptions.merge()).get();
        LocalFirestoreHelper.assertCommitEquals(LocalFirestoreHelper.commit(LocalFirestoreHelper.set(Collections.emptyMap(), Collections.emptyList())), (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void setDocumentWithNestedMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.mergeFields((String[])new String[]{"first.foo"})).get();
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.mergeFields(Arrays.asList("first.foo"))).get();
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.mergeFieldPaths(Arrays.asList(FieldPath.of((String[])new String[]{"first", "foo"})))).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder nestedProto = Value.newBuilder();
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        nestedUpdate.put("first", nestedProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(nestedUpdate, Arrays.asList("first.foo")));
        for (int i = 0; i < 3; ++i) {
            LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getAllValues().get(i));
        }
    }

    @Test
    public void setMultipleFieldsWithMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.mergeFields((String[])new String[]{"first.foo", "second.foo", "second.trueValue"})).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder nestedProto = Value.newBuilder();
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        nestedUpdate.put("first", nestedProto.build());
        nestedProto.getMapValueBuilder().putFields("trueValue", Value.newBuilder().setBooleanValue(true).build());
        nestedUpdate.put("second", nestedProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(nestedUpdate, Arrays.asList("first.foo", "second.foo", "second.trueValue")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void setNestedMapWithMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.mergeFields((String[])new String[]{"first", "second"})).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder nestedProto = Value.newBuilder();
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        nestedUpdate.put("first", nestedProto.build());
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_PROTO);
        nestedUpdate.put("second", nestedProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(nestedUpdate, Arrays.asList("first", "second")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void mergeWithDotsInFieldName() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set(LocalFirestoreHelper.map("a.b.c", LocalFirestoreHelper.map("d.e", "foo", "f.g", "bar"), new Object[0]), SetOptions.mergeFieldPaths(Arrays.asList(FieldPath.of((String[])new String[]{"a.b.c", "d.e"})))).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder nestedProto = Value.newBuilder();
        nestedProto.getMapValueBuilder().putFields("d.e", Value.newBuilder().setStringValue("foo").build());
        nestedUpdate.put("a.b.c", nestedProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(nestedUpdate, Arrays.asList("`a.b.c`.`d.e`")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void extractFieldMaskFromMerge() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.set((Object)LocalFirestoreHelper.NESTED_CLASS_OBJECT, SetOptions.merge()).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder nestedProto = Value.newBuilder();
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        nestedUpdate.put("first", nestedProto.build());
        nestedProto.getMapValueBuilder().putAllFields(LocalFirestoreHelper.ALL_SUPPORTED_TYPES_PROTO);
        nestedUpdate.put("second", nestedProto.build());
        List<String> updateMask = Arrays.asList("first.foo", "second.arrayValue", "second.bytesValue", "second.dateValue", "second.doubleValue", "second.falseValue", "second.foo", "second.geoPointValue", "second.infValue", "second.instantValue", "second.longValue", "second.nanValue", "second.negInfValue", "second.nullValue", "second.objectValue.foo", "second.timestampValue", "second.trueValue", "second.model.foo", "second.vectorValue");
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.set(nestedUpdate, updateMask));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update(LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.documentReference.update("foo", (Object)"bar", new Object[0]).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo")));
        for (CommitRequest request : this.commitCapture.getAllValues()) {
            LocalFirestoreHelper.assertCommitEquals(expectedCommit, request);
        }
    }

    @Test
    public void updateWithDotsInFieldName() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update(LocalFirestoreHelper.map("a.b.c", LocalFirestoreHelper.map("d.e", "foo", new Object[0]), new Object[0])).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder valueProto = Value.newBuilder();
        valueProto.getMapValueBuilder().putFields("d.e", Value.newBuilder().setStringValue("foo").build());
        Value.Builder cProto = Value.newBuilder();
        cProto.getMapValueBuilder().putFields("c", valueProto.build());
        Value.Builder bProto = Value.newBuilder();
        bProto.getMapValueBuilder().putFields("b", cProto.build());
        nestedUpdate.put("a", bProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(nestedUpdate, Arrays.asList("a.b.c")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateNestedMap() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update("a.b", (Object)"foo", new Object[]{"a.c", FieldValue.delete()}).get();
        HashMap<String, Value> nestedUpdate = new HashMap<String, Value>();
        Value.Builder valueProto = Value.newBuilder();
        valueProto.getMapValueBuilder().putFields("b", Value.newBuilder().setStringValue("foo").build());
        nestedUpdate.put("a", valueProto.build());
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(nestedUpdate, Arrays.asList("a.b", "a.c")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateConflictingFields() throws Exception {
        try {
            this.documentReference.update("a.b", (Object)"foo", new Object[]{"a", "foo"}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Detected ambiguous definition for field 'a'.");
        }
        try {
            this.documentReference.update("a.b", (Object)"foo", new Object[]{"a.b.c", "foo"}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Detected ambiguous definition for field 'a.b'.");
        }
        try {
            this.documentReference.update("a.b", LocalFirestoreHelper.SINGLE_FIELD_MAP, new Object[]{"a", LocalFirestoreHelper.SINGLE_FIELD_MAP}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Detected ambiguous definition for field 'a'.");
        }
        try {
            this.documentReference.update("a.b", LocalFirestoreHelper.SINGLE_FIELD_MAP, new Object[]{"a.b.c", LocalFirestoreHelper.SINGLE_FIELD_MAP}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Detected ambiguous definition for field 'a.b'.");
        }
    }

    @Test
    public void deleteField() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update("foo", (Object)"bar", new Object[]{"bar.foo", FieldValue.delete()}).get();
        Value.Builder emptyMap = Value.newBuilder();
        emptyMap.getMapValueBuilder();
        HashMap<String, Value> fieldMap = new HashMap<String, Value>();
        fieldMap.put("foo", LocalFirestoreHelper.string("bar"));
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(fieldMap, Arrays.asList("foo", "bar.foo")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateNestedDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        HashMap<String, String> nestedObject = new HashMap<String, String>();
        nestedObject.put("a", "b");
        nestedObject.put("c.d", "e");
        nestedObject.put("f.g.h", "i");
        HashMap<String, Value> expandedObject = new HashMap<String, Value>();
        expandedObject.put("a", LocalFirestoreHelper.string("b"));
        expandedObject.put("c", LocalFirestoreHelper.object("d", LocalFirestoreHelper.string("e")));
        expandedObject.put("f", LocalFirestoreHelper.object("g", LocalFirestoreHelper.object("h", LocalFirestoreHelper.string("i"))));
        this.documentReference.update(nestedObject).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(expandedObject, new ArrayList<String>(nestedObject.keySet())));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateDocumentWithTwoFields() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update("a", (Object)"b", new Object[]{"c", "d"}).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(LocalFirestoreHelper.map("a", Value.newBuilder().setStringValue("b").build(), "c", Value.newBuilder().setStringValue("d").build()), Arrays.asList("a", "c")));
        LocalFirestoreHelper.assertCommitEquals(expectedCommit, (CommitRequest)this.commitCapture.getValue());
    }

    @Test
    public void updateDocumentWithPreconditions() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        Precondition options = Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)479978400L, (int)123000000));
        this.documentReference.update(LocalFirestoreHelper.SINGLE_FIELD_MAP, options).get();
        this.documentReference.update(options, "foo", (Object)"bar", new Object[0]).get();
        Precondition.Builder precondition = com.google.firestore.v1.Precondition.newBuilder();
        precondition.getUpdateTimeBuilder().setSeconds(479978400L).setNanos(123000000);
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), precondition.build()));
        for (CommitRequest request : this.commitCapture.getAllValues()) {
            LocalFirestoreHelper.assertCommitEquals(expectedCommit, request);
        }
    }

    @Test
    public void updateIndividualPojo() throws ExecutionException, InterruptedException {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.documentReference.update(LocalFirestoreHelper.UPDATED_POJO);
        this.documentReference.update(LocalFirestoreHelper.UPDATED_POJO).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(LocalFirestoreHelper.UPDATED_POJO_PROTO, Collections.singletonList("model")));
        for (CommitRequest request : this.commitCapture.getAllValues()) {
            LocalFirestoreHelper.assertCommitEquals(expectedCommit, request);
        }
    }

    @Test
    public void deleteNestedFieldUsingFieldPath() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.SINGLE_WRITE_COMMIT_RESPONSE).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        FieldPath path = FieldPath.of((String[])new String[]{"a.b", "c.d"});
        this.documentReference.update(path, (Object)FieldValue.delete(), new Object[0]).get();
        CommitRequest expectedCommit = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(Collections.emptyMap(), Collections.singletonList("`a.b`.`c.d`")));
        Assert.assertEquals((Object)expectedCommit, (Object)this.commitCapture.getValue());
    }

    @Test
    public void deserializeCustomList() throws ExecutionException, InterruptedException {
        ImmutableMap CUSTOM_LIST_PROTO = ImmutableMap.builder().put((Object)"fooList", (Object)Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).build())).build()).build();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(new Map[]{CUSTOM_LIST_PROTO})).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        LocalFirestoreHelper.CustomList customList = (LocalFirestoreHelper.CustomList)snapshot.toObject(LocalFirestoreHelper.CustomList.class);
        Assert.assertEquals(LocalFirestoreHelper.FOO_LIST, customList.fooList);
        Assert.assertEquals((Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT, customList.fooList.get(0));
    }

    @Test
    public void deserializeCustomMap() throws ExecutionException, InterruptedException {
        ImmutableMap CUSTOM_MAP_PROTO = ImmutableMap.builder().put((Object)"fooMap", (Object)Value.newBuilder().setMapValue(MapValue.newBuilder().putFields("customMap", Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).build()).build()).build()).build();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(new Map[]{CUSTOM_MAP_PROTO})).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentSnapshot snapshot = (DocumentSnapshot)this.documentReference.get().get();
        LocalFirestoreHelper.CustomMap customMap = (LocalFirestoreHelper.CustomMap)snapshot.toObject(LocalFirestoreHelper.CustomMap.class);
        Assert.assertEquals(LocalFirestoreHelper.FOO_MAP, customMap.fooMap);
        Assert.assertEquals((Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT, customMap.fooMap.get("customMap"));
    }
}

