/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreBundle;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.collect.Lists;
import com.google.firestore.bundle.BundleElement;
import com.google.firestore.bundle.BundleMetadata;
import com.google.firestore.bundle.BundledDocumentMetadata;
import com.google.firestore.bundle.BundledQuery;
import com.google.firestore.bundle.NamedQuery;
import com.google.firestore.v1.Document;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FirestoreBundleTest {
    private static final String TEST_BUNDLE_ID = "test-bundle";
    private static final int TEST_BUNDLE_VERSION = 1;
    private static final JsonFormat.Parser parser = JsonFormat.parser();
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    private Query query;

    @Before
    public void before() {
        this.query = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID);
    }

    public static void verifyMetadata(BundleMetadata meta, com.google.protobuf.Timestamp createTime, int totalDocuments, boolean expectEmptyContent) {
        if (!expectEmptyContent) {
            Assert.assertTrue((meta.getTotalBytes() > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)meta.getTotalBytes());
        }
        Assert.assertEquals((Object)TEST_BUNDLE_ID, (Object)meta.getId());
        Assert.assertEquals((long)1L, (long)meta.getVersion());
        Assert.assertEquals((long)totalDocuments, (long)meta.getTotalDocuments());
        Assert.assertEquals((Object)createTime, (Object)meta.getCreateTime());
    }

    public static void verifyDocumentAndMeta(BundledDocumentMetadata documentMetadata, Document document, String expectedDocumentName, List<String> expectedQueries, DocumentSnapshot equivalentSnapshot) {
        FirestoreBundleTest.verifyDocumentAndMeta(documentMetadata, document, expectedDocumentName, expectedQueries, equivalentSnapshot, equivalentSnapshot.getReadTime().toProto());
    }

    public static void verifyDocumentAndMeta(BundledDocumentMetadata documentMetadata, Document document, String expectedDocumentName, List<String> expectedQueries, DocumentSnapshot equivalentSnapshot, com.google.protobuf.Timestamp readTime) {
        Assert.assertEquals((Object)BundledDocumentMetadata.newBuilder().setExists(true).setName(expectedDocumentName).setReadTime(readTime).addAllQueries(expectedQueries).build(), (Object)documentMetadata);
        Assert.assertEquals((Object)Document.newBuilder().putAllFields(equivalentSnapshot.getProtoFields()).setCreateTime(equivalentSnapshot.getCreateTime().toProto()).setUpdateTime(equivalentSnapshot.getUpdateTime().toProto()).setName(expectedDocumentName).build(), (Object)document);
    }

    public static void verifyNamedQuery(NamedQuery namedQuery, String name, com.google.protobuf.Timestamp readTime, Query query, BundledQuery.LimitType limitType) {
        Assert.assertEquals((Object)NamedQuery.newBuilder().setName(name).setReadTime(readTime).setBundledQuery(BundledQuery.newBuilder().setParent(query.toProto().getParent()).setStructuredQuery(query.toProto().getStructuredQuery()).setLimitType(limitType).build()).build(), (Object)namedQuery);
    }

    @Test
    public void bundleToElementListWorks() {
        String bundleString = "20{\"a\":\"string value\"}9{\"b\":123}26{\"c\":{\"d\":\"nested value\"}}";
        List<String> elements = LocalFirestoreHelper.bundleToElementList(ByteBuffer.wrap(bundleString.getBytes(StandardCharsets.UTF_8)));
        Assert.assertArrayEquals((Object[])new String[]{"{\"a\":\"string value\"}", "{\"b\":123}", "{\"c\":{\"d\":\"nested value\"}}"}, (Object[])elements.toArray());
    }

    public static List<BundleElement> toBundleElements(ByteBuffer bundleBuffer) {
        ArrayList<BundleElement> result = new ArrayList<BundleElement>();
        for (String s : LocalFirestoreHelper.bundleToElementList(bundleBuffer)) {
            BundleElement.Builder b = BundleElement.newBuilder();
            try {
                parser.merge(s, (Message.Builder)b);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            result.add(b.build());
        }
        return result;
    }

    @Test
    public void bundleWithDocumentSnapshots() {
        FirestoreBundle.Builder bundleBuilder = new FirestoreBundle.Builder(TEST_BUNDLE_ID);
        bundleBuilder.add(LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT);
        bundleBuilder.add(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT);
        ByteBuffer bundleBuffer = bundleBuilder.build().toByteBuffer();
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)3L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), 1, false);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(1).getDocumentMetadata(), elements.get(2).getDocument(), LocalFirestoreHelper.DOCUMENT_NAME, Lists.newArrayList(), LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT);
    }

    @Test
    public void bundleWithQuerySnapshot() {
        FirestoreBundle.Builder bundleBuilder = new FirestoreBundle.Builder(TEST_BUNDLE_ID);
        QuerySnapshot snapshot = QuerySnapshot.withDocuments((Query)this.query, (Timestamp)LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime(), (List)Lists.newArrayList((Object[])new QueryDocumentSnapshot[]{QueryDocumentSnapshot.fromDocument(null, (Timestamp)LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime(), (Document)LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.toDocumentPb().build())}));
        bundleBuilder.add("test-query", snapshot);
        ByteBuffer bundleBuffer = bundleBuilder.build().toByteBuffer();
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)4L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), 1, false);
        FirestoreBundleTest.verifyNamedQuery(elements.get(1).getNamedQuery(), "test-query", LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), this.query, BundledQuery.LimitType.FIRST);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(2).getDocumentMetadata(), elements.get(3).getDocument(), LocalFirestoreHelper.DOCUMENT_NAME, Lists.newArrayList((Object[])new String[]{"test-query"}), LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT);
    }

    @Test
    public void bundleWithQueryReturningNoResult() {
        FirestoreBundle.Builder bundleBuilder = new FirestoreBundle.Builder(TEST_BUNDLE_ID);
        QuerySnapshot snapshot = QuerySnapshot.withDocuments((Query)this.query, (Timestamp)LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime(), Collections.emptyList());
        bundleBuilder.add("test-query", snapshot);
        ByteBuffer bundleBuffer = bundleBuilder.build().toByteBuffer();
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)2L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), 0, false);
        FirestoreBundleTest.verifyNamedQuery(elements.get(1).getNamedQuery(), "test-query", LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), this.query, BundledQuery.LimitType.FIRST);
    }

    @Test
    public void bundleBuiltMultipleTimes() {
        FirestoreBundle.Builder bundleBuilder = new FirestoreBundle.Builder(TEST_BUNDLE_ID);
        bundleBuilder.add(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT);
        ByteBuffer bundleBuffer = bundleBuilder.build().toByteBuffer();
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)3L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), 1, false);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(1).getDocumentMetadata(), elements.get(2).getDocument(), LocalFirestoreHelper.DOCUMENT_NAME, Lists.newArrayList(), LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT);
        bundleBuilder.add(LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT);
        bundleBuffer = bundleBuilder.build().toByteBuffer();
        elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)3L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT.getReadTime().toProto(), 1, false);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(1).getDocumentMetadata(), elements.get(2).getDocument(), LocalFirestoreHelper.DOCUMENT_NAME, Lists.newArrayList(), LocalFirestoreHelper.UPDATED_SINGLE_FIELD_SNAPSHOT);
    }

    @Test
    public void bundleWithNothingAdded() {
        FirestoreBundle.Builder bundleBuilder = new FirestoreBundle.Builder(TEST_BUNDLE_ID);
        ByteBuffer bundleBuffer = bundleBuilder.build().toByteBuffer();
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuffer);
        Assert.assertEquals((long)1L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), Timestamp.MIN_VALUE.toProto(), 0, true);
    }
}

