/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.mockito.Mockito;

public class FirestoreOptionsTest {
    @Test
    public void instantiateWithProjectId() {
        FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build();
        FirestoreImpl firestore = new FirestoreImpl(firestoreOptions, (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
        DocumentReference document = firestore.document("coll/doc1");
        Truth.assertThat((String)document.getName()).isEqualTo((Object)"projects/test-project/databases/(default)/documents/coll/doc1");
    }

    @Test
    public void instantiateWithProjectIdAndDatabaseId() {
        FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setDatabaseId("test-database").build();
        FirestoreImpl firestore = new FirestoreImpl(firestoreOptions, (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
        DocumentReference document = firestore.document("coll/doc1");
        Truth.assertThat((String)document.getName()).isEqualTo((Object)"projects/test-project/databases/test-database/documents/coll/doc1");
    }
}

