/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FirestoreTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<BatchGetDocumentsRequest> getAllCapture;
    @Captor
    private ArgumentCaptor<ResponseObserver<Message>> streamObserverCapture;
    @Captor
    private ArgumentCaptor<CommitRequest> commitCapture;

    @Test
    public void encodeFieldPath() {
        Assert.assertEquals((Object)"foo", (Object)FieldPath.of((String[])new String[]{"foo"}).getEncodedPath());
        Assert.assertEquals((Object)"foo.bar", (Object)FieldPath.of((String[])new String[]{"foo", "bar"}).getEncodedPath());
        Assert.assertEquals((Object)"`.`", (Object)FieldPath.of((String[])new String[]{"."}).getEncodedPath());
        Assert.assertEquals((Object)"`\\``", (Object)FieldPath.of((String[])new String[]{"`"}).getEncodedPath());
        Assert.assertEquals((Object)"foo.`.`.`\\\\`", (Object)FieldPath.of((String[])new String[]{"foo", ".", "\\"}).getEncodedPath());
        Assert.assertEquals((Object)"`.\\\\.\\\\.`", (Object)FieldPath.of((String[])new String[]{".\\.\\."}).getEncodedPath());
    }

    @Test
    public void illegalFieldPath() throws Exception {
        char[] prohibited;
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponseWithoutOnComplete(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference doc = this.firestoreMock.document("coll/doc");
        DocumentSnapshot snapshot = (DocumentSnapshot)doc.get().get();
        for (char c : prohibited = new char[]{'*', '~', '/', '[', ']'}) {
            try {
                snapshot.contains("foo" + c + "bar");
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Use FieldPath.of() for field names containing '\u02dc*/[]'.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void exposesOptions() {
        Assert.assertEquals((Object)"test-project", (Object)this.firestoreMock.getOptions().getProjectId());
    }

    @Test
    public void getAll() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponseWithoutOnComplete(LocalFirestoreHelper.SINGLE_FIELD_PROTO, LocalFirestoreHelper.SINGLE_FIELD_PROTO, LocalFirestoreHelper.SINGLE_FIELD_PROTO, LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference doc1 = this.firestoreMock.document("coll/doc1");
        DocumentReference doc2 = this.firestoreMock.document("coll/doc2");
        DocumentReference doc3 = this.firestoreMock.document("coll/doc3");
        DocumentReference doc4 = this.firestoreMock.document("coll/doc4");
        List snapshot = (List)this.firestoreMock.getAll(new DocumentReference[]{doc1, doc2, doc4, doc3}).get();
        Assert.assertEquals((Object)"doc1", (Object)((DocumentSnapshot)snapshot.get(0)).getId());
        Assert.assertEquals((Object)"doc2", (Object)((DocumentSnapshot)snapshot.get(1)).getId());
        Assert.assertEquals((Object)"doc4", (Object)((DocumentSnapshot)snapshot.get(2)).getId());
        Assert.assertEquals((Object)"doc3", (Object)((DocumentSnapshot)snapshot.get(3)).getId());
    }

    @Test
    public void getAllWithFieldMask() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponseWithoutOnComplete(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((BatchGetDocumentsRequest)this.getAllCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference doc1 = this.firestoreMock.document("coll/doc1");
        FieldMask fieldMask = FieldMask.of((FieldPath[])new FieldPath[]{FieldPath.of((String[])new String[]{"foo", "bar"})});
        this.firestoreMock.getAll(new DocumentReference[]{doc1}, fieldMask).get();
        BatchGetDocumentsRequest request = (BatchGetDocumentsRequest)this.getAllCapture.getValue();
        Assert.assertEquals((long)1L, (long)request.getMask().getFieldPathsCount());
        Assert.assertEquals((Object)"foo.bar", (Object)request.getMask().getFieldPaths(0));
    }

    @Test
    public void arrayUnionEquals() {
        FieldValue arrayUnion1 = FieldValue.arrayUnion((Object[])new Object[]{"foo", "bar"});
        FieldValue arrayUnion2 = FieldValue.arrayUnion((Object[])new Object[]{"foo", "bar"});
        FieldValue arrayUnion3 = FieldValue.arrayUnion((Object[])new Object[]{"foo", "baz"});
        FieldValue arrayRemove = FieldValue.arrayRemove((Object[])new Object[]{"foo", "bar"});
        Assert.assertEquals((Object)arrayUnion1, (Object)arrayUnion1);
        Assert.assertEquals((Object)arrayUnion1, (Object)arrayUnion2);
        Assert.assertNotEquals((Object)arrayUnion1, (Object)arrayUnion3);
        Assert.assertNotEquals((Object)arrayUnion1, (Object)arrayRemove);
    }

    @Test
    public void arrayRemoveEquals() {
        FieldValue arrayRemove1 = FieldValue.arrayRemove((Object[])new Object[]{"foo", "bar"});
        FieldValue arrayRemove2 = FieldValue.arrayRemove((Object[])new Object[]{"foo", "bar"});
        FieldValue arrayRemove3 = FieldValue.arrayRemove((Object[])new Object[]{"foo", "baz"});
        FieldValue arrayUnion = FieldValue.arrayUnion((Object[])new Object[]{"foo", "bar"});
        Assert.assertEquals((Object)arrayRemove1, (Object)arrayRemove1);
        Assert.assertEquals((Object)arrayRemove1, (Object)arrayRemove2);
        Assert.assertNotEquals((Object)arrayRemove1, (Object)arrayRemove3);
        Assert.assertNotEquals((Object)arrayRemove1, (Object)arrayUnion);
    }

    @Test
    public void incrementEquals() {
        FieldValue increment1 = FieldValue.increment((long)42L);
        FieldValue increment2 = FieldValue.increment((long)42L);
        FieldValue increment3 = FieldValue.increment((double)42.0);
        FieldValue increment4 = FieldValue.increment((double)42.0);
        Assert.assertEquals((Object)increment1, (Object)increment2);
        Assert.assertEquals((Object)increment3, (Object)increment4);
        Assert.assertNotEquals((Object)increment1, (Object)increment3);
        Assert.assertNotEquals((Object)increment2, (Object)increment4);
    }

    @Test
    public void arrayUnionWithPojo() throws ExecutionException, InterruptedException {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        DocumentReference doc = this.firestoreMock.document("coll/doc");
        doc.update("array", (Object)FieldValue.arrayUnion((Object[])new Object[]{LocalFirestoreHelper.SINGLE_FIELD_OBJECT}), new Object[0]).get();
        CommitRequest expectedRequest = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(Collections.emptyMap(), new ArrayList<String>()), LocalFirestoreHelper.transform("array", LocalFirestoreHelper.arrayUnion(LocalFirestoreHelper.SINGLE_FIELD_VALUE), new Object[0]));
        CommitRequest actualRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)expectedRequest, (Object)actualRequest);
    }

    @Test
    public void arrayRemoveWithPojo() throws ExecutionException, InterruptedException {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        DocumentReference doc = this.firestoreMock.document("coll/doc");
        doc.update("array", (Object)FieldValue.arrayRemove((Object[])new Object[]{LocalFirestoreHelper.SINGLE_FIELD_OBJECT}), new Object[0]).get();
        CommitRequest expectedRequest = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(Collections.emptyMap(), new ArrayList<String>()), LocalFirestoreHelper.transform("array", LocalFirestoreHelper.arrayRemove(LocalFirestoreHelper.SINGLE_FIELD_VALUE), new Object[0]));
        CommitRequest actualRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)expectedRequest, (Object)actualRequest);
    }
}

