/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.VectorValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.AggregationResult;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.DatabaseRootName;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.type.LatLng;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

public final class LocalFirestoreHelper {
    protected static RetrySettings IMMEDIATE_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ZERO).setMaxRetryDelayDuration(Duration.ZERO).setRetryDelayMultiplier(1.0).setJittered(false).build();
    public static final String DATABASE_NAME;
    public static final String COLLECTION_ID;
    public static final String DOCUMENT_PATH;
    public static final String DOCUMENT_NAME;
    public static final String DOCUMENT_ROOT;
    public static final String TRANSACTION_ID;
    public static final Map<String, Value> EMPTY_MAP_PROTO;
    public static final Map<String, Object> SINGLE_FIELD_MAP;
    public static final Map<String, Object> SINGLE_FILED_MAP_WITH_DOT;
    public static final SingleField SINGLE_FIELD_OBJECT;
    public static final Map<String, Value> SINGLE_FIELD_PROTO;
    public static final DocumentSnapshot SINGLE_FIELD_SNAPSHOT;
    public static final Value SINGLE_FIELD_VALUE;
    public static final SingleField UPDATE_SINGLE_FIELD_OBJECT;
    public static final Map<String, Object> UPDATED_FIELD_MAP;
    public static final Map<String, Value> UPDATED_FIELD_PROTO;
    public static final Map<String, Value> UPDATED_SINGLE_FIELD_PROTO;
    public static final Map<String, Value> UPDATED_POJO_PROTO;
    public static final DocumentSnapshot UPDATED_SINGLE_FIELD_SNAPSHOT;
    public static final Map<String, Float> SINGLE_FLOAT_MAP;
    public static final Map<String, Value> SINGLE_FLOAT_PROTO;
    public static final NestedClass NESTED_CLASS_OBJECT;
    public static final Map<String, Object> SERVER_TIMESTAMP_MAP;
    public static final ServerTimestamp SERVER_TIMESTAMP_OBJECT;
    public static final Map<String, Value> SERVER_TIMESTAMP_PROTO;
    public static final Map<String, Object> ALL_SUPPORTED_TYPES_MAP;
    public static final AllSupportedTypes ALL_SUPPORTED_TYPES_OBJECT;
    public static final Map<String, Value> ALL_SUPPORTED_TYPES_PROTO;
    public static final CommitRequest SINGLE_CREATE_COMMIT_REQUEST;
    public static final ApiFuture<CommitResponse> SINGLE_DELETE_COMMIT_RESPONSE;
    public static final ApiFuture<CommitResponse> SINGLE_WRITE_COMMIT_RESPONSE;
    public static final ApiFuture<CommitResponse> FIELD_TRANSFORM_COMMIT_RESPONSE;
    public static final Map<String, Object> UPDATED_POJO;
    public static final Date DATE;
    public static final Timestamp TIMESTAMP;
    public static final Instant INSTANT;
    public static final GeoPoint GEO_POINT;
    public static final Blob BLOB;
    public static final FooList<SingleField> FOO_LIST;
    public static final FooMap<String, SingleField> FOO_MAP;
    public static final Precondition UPDATE_PRECONDITION;

    public static <K, V> Map<K, V> map(K key, V value, Object ... moreKeysAndValues) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        for (int i = 0; i < moreKeysAndValues.length; i += 2) {
            map.put(moreKeysAndValues[i], moreKeysAndValues[i + 1]);
        }
        return map;
    }

    public static Map<String, Object> map() {
        return new HashMap<String, Object>();
    }

    public static Answer<BatchGetDocumentsResponse> getAllResponse(Map<String, Value> ... fields) {
        return LocalFirestoreHelper.getAllResponseImpl(true, fields);
    }

    public static Answer<BatchGetDocumentsResponse> getAllResponseWithoutOnComplete(Map<String, Value> ... fields) {
        return LocalFirestoreHelper.getAllResponseImpl(false, fields);
    }

    public static Answer<BatchGetDocumentsResponse> getAllResponseImpl(boolean withOnComplete, Map<String, Value> ... fields) {
        BatchGetDocumentsResponse[] responses = new BatchGetDocumentsResponse[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String name = DOCUMENT_NAME;
            if (fields.length > 1) {
                name = name + (i + 1);
            }
            BatchGetDocumentsResponse.Builder response = BatchGetDocumentsResponse.newBuilder();
            response.getFoundBuilder().setCreateTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).setNanos(2));
            response.getFoundBuilder().setUpdateTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(3L).setNanos(4));
            response.setReadTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(5L).setNanos(6));
            response.getFoundBuilder().setName(name).putAllFields(fields[i]);
            responses[i] = response.build();
        }
        if (withOnComplete) {
            return LocalFirestoreHelper.streamingResponse(responses, null);
        }
        return LocalFirestoreHelper.streamingResponseWithoutOnComplete(responses);
    }

    public static ApiFuture<Empty> rollbackResponse() {
        return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
    }

    public static Answer<RunQueryResponse> emptyQueryResponse() {
        RunQueryResponse[] response = new RunQueryResponse[]{};
        return LocalFirestoreHelper.streamingResponse(response, null);
    }

    public static Answer<RunQueryResponse> queryResponse() {
        return LocalFirestoreHelper.queryResponse(DOCUMENT_NAME);
    }

    public static Answer<RunQueryResponse> queryResponse(String ... documentNames) {
        return LocalFirestoreHelper.queryResponse(null, documentNames);
    }

    public static Answer<RunQueryResponse> queryResponse(@Nullable Throwable throwable, String ... documentNames) {
        RunQueryResponse[] responses = new RunQueryResponse[documentNames.length];
        for (int i = 0; i < documentNames.length; ++i) {
            RunQueryResponse.Builder runQueryResponse = RunQueryResponse.newBuilder();
            runQueryResponse.setDocument(Document.newBuilder().setName(documentNames[i]).putAllFields(SINGLE_FIELD_PROTO));
            runQueryResponse.setReadTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).setNanos(2));
            responses[i] = runQueryResponse.build();
        }
        return LocalFirestoreHelper.streamingResponse(responses, throwable);
    }

    public static Answer<RunQueryResponse> queryResponseWithDone(boolean callWithoutOnComplete, String ... documentNames) {
        RunQueryResponse[] responses = new RunQueryResponse[documentNames.length];
        for (int i = 0; i < documentNames.length; ++i) {
            RunQueryResponse.Builder runQueryResponse = RunQueryResponse.newBuilder();
            runQueryResponse.setDocument(Document.newBuilder().setName(documentNames[i]).putAllFields(SINGLE_FIELD_PROTO));
            runQueryResponse.setReadTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).setNanos(2));
            if (i == documentNames.length - 1) {
                runQueryResponse.setDone(true);
            }
            responses[i] = runQueryResponse.build();
        }
        if (callWithoutOnComplete) {
            return LocalFirestoreHelper.streamingResponseWithoutOnComplete(responses);
        }
        return LocalFirestoreHelper.streamingResponse(responses, null);
    }

    public static Answer<RunAggregationQueryResponse> countQueryResponse() {
        return LocalFirestoreHelper.countQueryResponse(42);
    }

    public static Answer<RunAggregationQueryResponse> countQueryResponse(int count) {
        return LocalFirestoreHelper.countQueryResponse(count, null);
    }

    public static Answer<RunAggregationQueryResponse> countQueryResponse(int count, @Nullable Timestamp readTime) {
        return LocalFirestoreHelper.streamingResponse(new RunAggregationQueryResponse[]{LocalFirestoreHelper.createCountQueryResponse(count, readTime)}, null);
    }

    public static Answer<RunAggregationQueryResponse> countQueryResponse(Throwable throwable) {
        return LocalFirestoreHelper.streamingResponse(new RunAggregationQueryResponse[0], throwable);
    }

    public static Answer<RunAggregationQueryResponse> aggregationQueryResponses(int count1, int count2) {
        return LocalFirestoreHelper.streamingResponse(new RunAggregationQueryResponse[]{LocalFirestoreHelper.createCountQueryResponse(count1, null), LocalFirestoreHelper.createCountQueryResponse(count2, null)}, null);
    }

    public static Answer<RunAggregationQueryResponse> aggregationQueryResponses(int count1, Throwable throwable) {
        return LocalFirestoreHelper.streamingResponse(new RunAggregationQueryResponse[]{LocalFirestoreHelper.createCountQueryResponse(count1, null)}, throwable);
    }

    private static RunAggregationQueryResponse createCountQueryResponse(int count, @Nullable Timestamp timestamp) {
        RunAggregationQueryResponse.Builder builder = RunAggregationQueryResponse.newBuilder();
        builder.setResult(AggregationResult.newBuilder().putAggregateFields("aggregate_0", Value.newBuilder().setIntegerValue((long)count).build()).build());
        if (timestamp != null) {
            builder.setReadTime(timestamp.toProto());
        }
        return builder.build();
    }

    public static <T> Answer<T> streamingResponse(T[] response, @Nullable Throwable throwable) {
        return invocation -> {
            Object[] args = invocation.getArguments();
            ResponseObserver observer = (ResponseObserver)args[1];
            observer.onStart((StreamController)Mockito.mock(StreamController.class));
            for (Object resp : response) {
                observer.onResponse(resp);
            }
            if (throwable != null) {
                observer.onError(throwable);
            }
            observer.onComplete();
            return null;
        };
    }

    public static <T> Answer<T> streamingResponseWithoutOnComplete(T[] response) {
        return invocation -> {
            Object[] args = invocation.getArguments();
            ResponseObserver observer = (ResponseObserver)args[1];
            observer.onStart((StreamController)Mockito.mock(StreamController.class));
            for (Object resp : response) {
                observer.onResponse(resp);
            }
            return null;
        };
    }

    public static ApiFuture<CommitResponse> commitResponse(int adds, int deletes) {
        int i;
        CommitResponse.Builder commitResponse = CommitResponse.newBuilder();
        commitResponse.getCommitTimeBuilder().setSeconds(0L).setNanos(0);
        for (i = 0; i < adds; ++i) {
            commitResponse.addWriteResultsBuilder().getUpdateTimeBuilder().setSeconds((long)i).setNanos(i);
        }
        for (i = 0; i < deletes; ++i) {
            commitResponse.addWriteResultsBuilder();
        }
        return ApiFutures.immediateFuture((Object)commitResponse.build());
    }

    public static BeginTransactionRequest begin() {
        return LocalFirestoreHelper.begin(null);
    }

    public static BeginTransactionRequest begin(@Nullable String previousTransactionId) {
        BeginTransactionRequest.Builder begin = BeginTransactionRequest.newBuilder();
        begin.setDatabase(DATABASE_NAME);
        if (previousTransactionId != null) {
            begin.getOptionsBuilder().getReadWriteBuilder().setRetryTransaction(ByteString.copyFromUtf8((String)previousTransactionId));
        }
        return begin.build();
    }

    public static ApiFuture<BeginTransactionResponse> beginResponse() {
        return LocalFirestoreHelper.beginResponse(TRANSACTION_ID);
    }

    public static ApiFuture<BeginTransactionResponse> beginResponse(String transactionId) {
        BeginTransactionResponse.Builder beginResponse = BeginTransactionResponse.newBuilder();
        beginResponse.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        return ApiFutures.immediateFuture((Object)beginResponse.build());
    }

    public static RollbackRequest rollback() {
        return LocalFirestoreHelper.rollback(TRANSACTION_ID);
    }

    public static RollbackRequest rollback(String transactionId) {
        RollbackRequest.Builder rollback = RollbackRequest.newBuilder();
        rollback.setDatabase(DATABASE_NAME);
        rollback.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        return rollback.build();
    }

    public static DocumentTransform.FieldTransform serverTimestamp() {
        return DocumentTransform.FieldTransform.newBuilder().setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME).build();
    }

    public static DocumentTransform.FieldTransform increment(Value value) {
        return DocumentTransform.FieldTransform.newBuilder().setIncrement(value).build();
    }

    public static DocumentTransform.FieldTransform arrayUnion(Value ... values) {
        return DocumentTransform.FieldTransform.newBuilder().setAppendMissingElements(ArrayValue.newBuilder().addAllValues(Arrays.asList(values))).build();
    }

    public static DocumentTransform.FieldTransform arrayRemove(Value ... values) {
        return DocumentTransform.FieldTransform.newBuilder().setRemoveAllFromArray(ArrayValue.newBuilder().addAllValues(Arrays.asList(values))).build();
    }

    public static List<DocumentTransform.FieldTransform> transform(String fieldPath, DocumentTransform.FieldTransform fieldTransform, Object ... fieldPathOrTransform) {
        ArrayList<DocumentTransform.FieldTransform> transforms = new ArrayList<DocumentTransform.FieldTransform>();
        DocumentTransform.FieldTransform.Builder transformBuilder = DocumentTransform.FieldTransform.newBuilder();
        transformBuilder.setFieldPath(fieldPath).mergeFrom(fieldTransform);
        transforms.add(transformBuilder.build());
        for (int i = 0; i < fieldPathOrTransform.length; i += 2) {
            String path = (String)fieldPathOrTransform[i];
            DocumentTransform.FieldTransform transform = (DocumentTransform.FieldTransform)fieldPathOrTransform[i + 1];
            transforms.add(DocumentTransform.FieldTransform.newBuilder().setFieldPath(path).mergeFrom(transform).build());
        }
        return transforms;
    }

    public static Write create(Map<String, Value> fields, String docPath) {
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(DOCUMENT_ROOT + docPath);
        document.putAllFields(fields);
        write.getCurrentDocumentBuilder().setExists(false);
        return write.build();
    }

    public static Write create(Map<String, Value> fields) {
        return LocalFirestoreHelper.create(fields, DOCUMENT_PATH);
    }

    public static Write set(Map<String, Value> fields) {
        return LocalFirestoreHelper.set(fields, null, DOCUMENT_PATH);
    }

    public static Write set(Map<String, Value> fields, String docPath) {
        return LocalFirestoreHelper.set(fields, null, docPath);
    }

    public static Write set(Map<String, Value> fields, @Nullable List<String> fieldMap) {
        return LocalFirestoreHelper.set(fields, fieldMap, DOCUMENT_PATH);
    }

    public static Write set(Map<String, Value> fields, @Nullable List<String> fieldMap, String docPath) {
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(DOCUMENT_ROOT + docPath);
        document.putAllFields(fields);
        if (fieldMap != null) {
            write.getUpdateMaskBuilder().addAllFieldPaths(fieldMap);
        }
        return write.build();
    }

    public static Write delete() {
        return LocalFirestoreHelper.delete(DOCUMENT_PATH);
    }

    public static Write delete(Precondition precondition) {
        Write.Builder write = Write.newBuilder();
        write.setDelete(DOCUMENT_NAME);
        write.getCurrentDocumentBuilder().mergeFrom(precondition);
        return write.build();
    }

    public static Write delete(String docPath) {
        Write.Builder write = Write.newBuilder();
        write.setDelete(DOCUMENT_ROOT + docPath);
        return write.build();
    }

    public static Write update(Map<String, Value> fields, List<String> fieldMap) {
        return LocalFirestoreHelper.update(fields, fieldMap, UPDATE_PRECONDITION);
    }

    public static Write update(Map<String, Value> fields, List<String> fieldMap, @Nullable Precondition precondition) {
        return LocalFirestoreHelper.update(fields, fieldMap, precondition, DOCUMENT_PATH);
    }

    public static Write update(Map<String, Value> fields, String docPath) {
        return LocalFirestoreHelper.update(fields, Collections.singletonList("foo"), UPDATE_PRECONDITION, docPath);
    }

    public static Write update(Map<String, Value> fields, @Nullable List<String> fieldMap, @Nullable Precondition precondition, String docPath) {
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(DOCUMENT_ROOT + docPath);
        document.putAllFields(fields);
        write.getUpdateMaskBuilder().addAllFieldPaths(fieldMap);
        if (precondition != null) {
            write.getCurrentDocumentBuilder().mergeFrom(precondition);
        }
        return write.build();
    }

    public static CommitRequest commit(@Nullable String transactionId, Write ... writes) {
        CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
        commitRequest.setDatabase(DATABASE_NAME);
        commitRequest.addAllWrites(Arrays.asList(writes));
        if (transactionId != null) {
            commitRequest.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        }
        return commitRequest.build();
    }

    public static CommitRequest commit(Write ... writes) {
        return LocalFirestoreHelper.commit(null, writes);
    }

    public static CommitRequest commit(Write write, List<DocumentTransform.FieldTransform> transforms) {
        return LocalFirestoreHelper.commit((String)null, write.toBuilder().addAllUpdateTransforms(transforms).build());
    }

    public static BatchWriteRequest batchWrite(Write ... writes) {
        BatchWriteRequest.Builder batchWriteRequest = BatchWriteRequest.newBuilder();
        batchWriteRequest.setDatabase(DATABASE_NAME);
        batchWriteRequest.addAllWrites(Arrays.asList(writes));
        return batchWriteRequest.build();
    }

    public static StructuredQuery filter(StructuredQuery.FieldFilter.Operator operator) {
        return LocalFirestoreHelper.filter(operator, "foo", "bar");
    }

    public static StructuredQuery findNearest(String fieldPath, double[] queryVector, int limit, StructuredQuery.FindNearest.DistanceMeasure measure) {
        ArrayValue.Builder vectorArrayBuilder = ArrayValue.newBuilder();
        for (double d : queryVector) {
            vectorArrayBuilder.addValues(Value.newBuilder().setDoubleValue(d));
        }
        StructuredQuery.FindNearest.Builder findNearest = StructuredQuery.FindNearest.newBuilder().setVectorField(StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath)).setQueryVector(Value.newBuilder().setMapValue(MapValue.newBuilder().putFields("__type__", Value.newBuilder().setStringValue("__vector__").build()).putFields("value", Value.newBuilder().setArrayValue(vectorArrayBuilder.build()).build()))).setLimit(Int32Value.newBuilder().setValue(limit)).setDistanceMeasure(measure);
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.setFindNearest(findNearest.build());
        return structuredQuery.build();
    }

    public static StructuredQuery filter(StructuredQuery.FieldFilter.Operator operator, String path, String value) {
        return LocalFirestoreHelper.filter(operator, path, LocalFirestoreHelper.string(value));
    }

    public static StructuredQuery.Filter fieldFilter(String path, StructuredQuery.FieldFilter.Operator operator, String value) {
        StructuredQuery.FieldFilter.Builder builder = StructuredQuery.FieldFilter.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(path)).setOp(operator).setValue(Value.newBuilder().setStringValue(value).build());
        return StructuredQuery.Filter.newBuilder().setFieldFilter(builder).build();
    }

    public static StructuredQuery.Filter andFilters(StructuredQuery.Filter ... filters) {
        return LocalFirestoreHelper.compositeFilter(StructuredQuery.CompositeFilter.Operator.AND, Arrays.asList(filters));
    }

    public static StructuredQuery.Filter orFilters(StructuredQuery.Filter ... filters) {
        return LocalFirestoreHelper.compositeFilter(StructuredQuery.CompositeFilter.Operator.OR, Arrays.asList(filters));
    }

    private static StructuredQuery.Filter compositeFilter(StructuredQuery.CompositeFilter.Operator operator, List<StructuredQuery.Filter> filters) {
        StructuredQuery.CompositeFilter.Builder builder = StructuredQuery.CompositeFilter.newBuilder().setOp(operator).addAllFilters(filters);
        return StructuredQuery.Filter.newBuilder().setCompositeFilter(builder).build();
    }

    public static StructuredQuery filter(StructuredQuery.FieldFilter.Operator operator, String path, Value value) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        StructuredQuery.CompositeFilter.Builder compositeFilter = structuredQuery.getWhereBuilder().getCompositeFilterBuilder();
        compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
        StructuredQuery.FieldFilter.Builder fieldFilter = compositeFilter.addFiltersBuilder().getFieldFilterBuilder();
        fieldFilter.setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(path));
        fieldFilter.setOp(operator);
        fieldFilter.setValue(value);
        return structuredQuery.build();
    }

    public static StructuredQuery unaryFilter(StructuredQuery.UnaryFilter.Operator operator) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        StructuredQuery.CompositeFilter.Builder compositeFilter = structuredQuery.getWhereBuilder().getCompositeFilterBuilder();
        compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
        StructuredQuery.UnaryFilter.Builder fieldFilter = compositeFilter.addFiltersBuilder().getUnaryFilterBuilder();
        fieldFilter.setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("foo"));
        fieldFilter.setOp(operator);
        return structuredQuery.build();
    }

    public static RunQueryRequest query(StructuredQuery ... query) {
        return LocalFirestoreHelper.query(null, false, query);
    }

    public static RunQueryRequest query(@Nullable String transactionId, boolean allDescendants, StructuredQuery ... query) {
        return LocalFirestoreHelper.query(transactionId, "", allDescendants, false, query);
    }

    public static RunQueryRequest query(@Nullable String transactionId, boolean allDescendants, boolean kindless, StructuredQuery ... query) {
        return LocalFirestoreHelper.query(transactionId, "", allDescendants, kindless, query);
    }

    public static RunQueryRequest query(@Nullable String transactionId, String parent, boolean allDescendants, boolean kindless, StructuredQuery ... query) {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        if (!parent.equals("")) {
            parent = '/' + parent;
        }
        request.setParent(DATABASE_NAME + "/documents" + parent);
        StructuredQuery.Builder structuredQuery = request.getStructuredQueryBuilder();
        StructuredQuery.CollectionSelector.Builder builder = StructuredQuery.CollectionSelector.newBuilder().setAllDescendants(allDescendants);
        if (!kindless) {
            builder.setCollectionId("coll");
        }
        structuredQuery.addFrom(builder);
        for (StructuredQuery option : query) {
            structuredQuery.mergeFrom(option);
        }
        StructuredQuery.CompositeFilter compositeFilter = structuredQuery.getWhere().getCompositeFilter();
        if (compositeFilter.getFiltersCount() == 1) {
            if (compositeFilter.getFilters(0).hasFieldFilter()) {
                StructuredQuery.FieldFilter fieldFilter = compositeFilter.getFilters(0).getFieldFilter();
                structuredQuery.getWhereBuilder().setFieldFilter(fieldFilter);
            } else {
                StructuredQuery.UnaryFilter unaryFilter = compositeFilter.getFilters(0).getUnaryFilter();
                structuredQuery.getWhereBuilder().setUnaryFilter(unaryFilter);
            }
        }
        if (transactionId != null) {
            request.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        }
        return request.build();
    }

    public static RunAggregationQueryRequest countQuery() {
        return LocalFirestoreHelper.countQuery((String)null);
    }

    public static RunAggregationQueryRequest countQuery(@Nullable String transactionId) {
        RunQueryRequest runQueryRequest = LocalFirestoreHelper.query(TRANSACTION_ID, false, new StructuredQuery[0]);
        RunAggregationQueryRequest.Builder request = RunAggregationQueryRequest.newBuilder().setParent(runQueryRequest.getParent()).setStructuredAggregationQuery(StructuredAggregationQuery.newBuilder().setStructuredQuery(runQueryRequest.getStructuredQuery()).addAggregations(StructuredAggregationQuery.Aggregation.newBuilder().setAlias("aggregate_0").setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance())));
        if (transactionId != null) {
            request.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        }
        return request.build();
    }

    public static RunAggregationQueryRequest countQuery(RunQueryRequest runQueryRequest) {
        return RunAggregationQueryRequest.newBuilder().setParent(runQueryRequest.getParent()).setStructuredAggregationQuery(StructuredAggregationQuery.newBuilder().setStructuredQuery(runQueryRequest.getStructuredQuery()).addAggregations(StructuredAggregationQuery.Aggregation.newBuilder().setAlias("aggregate_0").setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance()))).build();
    }

    public static BatchGetDocumentsRequest get() {
        return LocalFirestoreHelper.getAll(null, DOCUMENT_NAME);
    }

    public static BatchGetDocumentsRequest get(@Nullable String transactionId) {
        return LocalFirestoreHelper.getAll(transactionId, DOCUMENT_NAME);
    }

    public static BatchGetDocumentsRequest getAll(@Nullable String transactionId, String ... documentNames) {
        BatchGetDocumentsRequest.Builder request = BatchGetDocumentsRequest.newBuilder();
        request.setDatabase(DATABASE_NAME);
        for (String documentName : documentNames) {
            request.addDocuments(documentName);
        }
        if (transactionId != null) {
            request.setTransaction(ByteString.copyFromUtf8((String)transactionId));
        }
        return request.build();
    }

    public static StructuredQuery order(FieldPath fieldPath, StructuredQuery.Direction direction) {
        return LocalFirestoreHelper.order(fieldPath.getEncodedPath(), direction);
    }

    public static StructuredQuery order(String fieldPath, StructuredQuery.Direction direction) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.addOrderByBuilder().setField(LocalFirestoreHelper.field(fieldPath)).setDirection(direction);
        return structuredQuery.build();
    }

    public static StructuredQuery select(String fieldPath) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.getSelectBuilder().addFields(LocalFirestoreHelper.field(fieldPath));
        return structuredQuery.build();
    }

    public static StructuredQuery select(FieldPath fieldPath) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.getSelectBuilder().addFields(LocalFirestoreHelper.field(fieldPath.getEncodedPath()));
        return structuredQuery.build();
    }

    public static StructuredQuery startAt(boolean before) {
        return LocalFirestoreHelper.startAt(LocalFirestoreHelper.string(), before);
    }

    public static StructuredQuery startAt(Value value, boolean before) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.setStartAt(Cursor.newBuilder().setBefore(before).addValues(value));
        return structuredQuery.build();
    }

    public static StructuredQuery endAt(boolean before) {
        return LocalFirestoreHelper.endAt(LocalFirestoreHelper.string(), before);
    }

    public static StructuredQuery endAt(Value value, boolean before) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.setEndAt(Cursor.newBuilder().setBefore(before).addValues(value));
        return structuredQuery.build();
    }

    public static StructuredQuery limit(int n) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.getLimitBuilder().setValue(n);
        return structuredQuery.build();
    }

    public static StructuredQuery offset(int n) {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.setOffset(n);
        return structuredQuery.build();
    }

    public static Value string() {
        return LocalFirestoreHelper.string("bar");
    }

    public static Value string(String value) {
        return Value.newBuilder().setStringValue(value).build();
    }

    public static Value object(String key, Value value) {
        Value.Builder result = Value.newBuilder();
        result.getMapValueBuilder().putFields(key, value);
        return result.build();
    }

    public static Value reference(String value) {
        return Value.newBuilder().setReferenceValue(value).build();
    }

    public static StructuredQuery.FieldReference.Builder field(String fieldPath) {
        return StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath);
    }

    public static void assertCommitEquals(CommitRequest expected, CommitRequest actual) {
        Assert.assertEquals((Object)LocalFirestoreHelper.sortCommit(expected), (Object)LocalFirestoreHelper.sortCommit(actual));
    }

    private static CommitRequest sortCommit(CommitRequest commit) {
        CommitRequest.Builder builder = commit.toBuilder();
        for (Write.Builder writes : builder.getWritesBuilderList()) {
            if (writes.hasUpdateMask()) {
                ArrayList updateMask = new ArrayList(writes.getUpdateMask().getFieldPathsList());
                Collections.sort(updateMask);
                writes.setUpdateMask(DocumentMask.newBuilder().addAllFieldPaths(updateMask));
            }
            if (writes.getUpdateTransformsList().isEmpty()) continue;
            ArrayList<DocumentTransform.FieldTransform> transformList = new ArrayList<DocumentTransform.FieldTransform>(writes.getUpdateTransformsList());
            transformList.sort(Comparator.comparing(DocumentTransform.FieldTransform::getFieldPath));
            writes.clearUpdateTransforms().addAllUpdateTransforms(transformList);
        }
        return builder.build();
    }

    public static String autoId() {
        return FirestoreImpl.autoId();
    }

    public static <T> Map<String, T> mapAnyType(Object ... entries) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (int i = 0; i < entries.length; i += 2) {
            res.put((String)entries[i], entries[i + 1]);
        }
        return res;
    }

    private static Map<String, Object> fromJsonString(String json) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Gson gson = new Gson();
        return (Map)gson.fromJson(json, type);
    }

    public static Map<String, Object> fromSingleQuotedString(String json) {
        return LocalFirestoreHelper.fromJsonString(json.replace("'", "\""));
    }

    public static String fullPath(DocumentReference ref, FirestoreOptions options) {
        return ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)options.getProjectId(), (String)options.getDatabaseId()), (ImmutableList)ImmutableList.copyOf((Object[])ref.getPath().split("/"))).toString();
    }

    public static List<String> bundleToElementList(ByteBuffer bundle) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder lengthStringBuilder = new StringBuilder();
        while (bundle.hasRemaining()) {
            char b = (char)bundle.get();
            if (b >= '0' && b <= '9') {
                lengthStringBuilder.append(b);
                continue;
            }
            if (b == '{') {
                bundle.position(bundle.position() - 1);
                int length = Integer.parseInt(lengthStringBuilder.toString());
                lengthStringBuilder = new StringBuilder();
                byte[] element = new byte[length];
                bundle.get(element, 0, length);
                result.add(new String(element, StandardCharsets.UTF_8));
                continue;
            }
            throw new RuntimeException("Bad bundle buffer.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void assertException(VoidFunction voidFunction, String expectedErrorMessage) {
        String errorMessage = "";
        try {
            voidFunction.apply();
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        finally {
            Assert.assertEquals((Object)errorMessage, (Object)expectedErrorMessage);
        }
    }

    static {
        FOO_LIST = new FooList();
        FOO_MAP = new FooMap();
        TRANSACTION_ID = "foo";
        try {
            DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z").parse("1985-03-18 08:20:00.123 CET");
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse date", e);
        }
        TIMESTAMP = Timestamp.ofTimeSecondsAndNanos((long)TimeUnit.MILLISECONDS.toSeconds(DATE.getTime()), (int)123000);
        INSTANT = Instant.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(DATE.getTime()), 123000L);
        GEO_POINT = new GeoPoint(50.1430847, -122.947778);
        BLOB = Blob.fromBytes((byte[])new byte[]{1, 2, 3});
        SINGLE_FLOAT_MAP = LocalFirestoreHelper.map("float", Float.valueOf(0.1f), new Object[0]);
        SINGLE_FLOAT_PROTO = LocalFirestoreHelper.map("float", Value.newBuilder().setDoubleValue((double)0.1f).build(), new Object[0]);
        DATABASE_NAME = "projects/test-project/databases/(default)";
        COLLECTION_ID = "coll";
        DOCUMENT_PATH = "coll/doc";
        DOCUMENT_NAME = DATABASE_NAME + "/documents/" + DOCUMENT_PATH;
        DOCUMENT_ROOT = DATABASE_NAME + "/documents/";
        EMPTY_MAP_PROTO = LocalFirestoreHelper.map("inner", Value.newBuilder().setMapValue(MapValue.getDefaultInstance()).build(), new Object[0]);
        SINGLE_FIELD_MAP = LocalFirestoreHelper.map("foo", "bar", new Object[0]);
        SINGLE_FILED_MAP_WITH_DOT = LocalFirestoreHelper.map("c.d", "bar", new Object[0]);
        SINGLE_FIELD_OBJECT = new SingleField();
        FOO_LIST.add(SINGLE_FIELD_OBJECT);
        FOO_MAP.put("customMap", SINGLE_FIELD_OBJECT);
        SINGLE_FIELD_PROTO = LocalFirestoreHelper.map("foo", Value.newBuilder().setStringValue("bar").build(), new Object[0]);
        UPDATED_POJO_PROTO = LocalFirestoreHelper.map("model", Value.newBuilder().setMapValue(MapValue.newBuilder().putFields("foo", Value.newBuilder().setStringValue("foobar").build())).build(), new Object[0]);
        SINGLE_FIELD_SNAPSHOT = new DocumentSnapshot(null, new DocumentReference(null, ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)"test-project", (String)"(default)"), (ImmutableList)ImmutableList.of((Object)"coll", (Object)"doc"))), SINGLE_FIELD_PROTO, Timestamp.ofTimeSecondsAndNanos((long)5L, (int)6), Timestamp.ofTimeSecondsAndNanos((long)3L, (int)4), Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2));
        Value.Builder singleFieldValueBuilder = Value.newBuilder();
        singleFieldValueBuilder.getMapValueBuilder().putAllFields(SINGLE_FIELD_PROTO);
        SINGLE_FIELD_VALUE = singleFieldValueBuilder.build();
        UPDATE_SINGLE_FIELD_OBJECT = new SingleField();
        LocalFirestoreHelper.UPDATE_SINGLE_FIELD_OBJECT.foo = "foobar";
        UPDATED_FIELD_MAP = LocalFirestoreHelper.map("foo", "foobar", new Object[0]);
        UPDATED_FIELD_PROTO = LocalFirestoreHelper.map("foo", Value.newBuilder().setStringValue("foobar").build(), new Object[0]);
        UPDATED_SINGLE_FIELD_PROTO = ImmutableMap.builder().put((Object)"foo", (Object)Value.newBuilder().setMapValue(MapValue.newBuilder().putFields("foo", Value.newBuilder().setStringValue("foobar").build())).build()).build();
        UPDATED_SINGLE_FIELD_SNAPSHOT = new DocumentSnapshot(null, new DocumentReference(null, ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)"test-project", (String)"(default)"), (ImmutableList)ImmutableList.of((Object)"coll", (Object)"doc"))), UPDATED_SINGLE_FIELD_PROTO, Timestamp.ofTimeSecondsAndNanos((long)50L, (int)6), Timestamp.ofTimeSecondsAndNanos((long)30L, (int)4), Timestamp.ofTimeSecondsAndNanos((long)10L, (int)2));
        SERVER_TIMESTAMP_MAP = new HashMap<String, Object>();
        SERVER_TIMESTAMP_MAP.put("foo", FieldValue.serverTimestamp());
        SERVER_TIMESTAMP_MAP.put("inner", new HashMap());
        ((Map)SERVER_TIMESTAMP_MAP.get("inner")).put("bar", FieldValue.serverTimestamp());
        Value.Builder mapValue = Value.newBuilder();
        mapValue.getMapValueBuilder();
        SERVER_TIMESTAMP_PROTO = Collections.emptyMap();
        SERVER_TIMESTAMP_OBJECT = new ServerTimestamp();
        ALL_SUPPORTED_TYPES_MAP = new HashMap<String, Object>();
        ALL_SUPPORTED_TYPES_MAP.put("foo", "bar");
        ALL_SUPPORTED_TYPES_MAP.put("doubleValue", 0.0);
        ALL_SUPPORTED_TYPES_MAP.put("longValue", 0L);
        ALL_SUPPORTED_TYPES_MAP.put("nanValue", Double.NaN);
        ALL_SUPPORTED_TYPES_MAP.put("infValue", Double.POSITIVE_INFINITY);
        ALL_SUPPORTED_TYPES_MAP.put("negInfValue", Double.NEGATIVE_INFINITY);
        ALL_SUPPORTED_TYPES_MAP.put("trueValue", true);
        ALL_SUPPORTED_TYPES_MAP.put("falseValue", false);
        ALL_SUPPORTED_TYPES_MAP.put("objectValue", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        ALL_SUPPORTED_TYPES_MAP.put("dateValue", Timestamp.of((Date)DATE));
        ALL_SUPPORTED_TYPES_MAP.put("timestampValue", TIMESTAMP);
        ALL_SUPPORTED_TYPES_MAP.put("instantValue", TIMESTAMP);
        ALL_SUPPORTED_TYPES_MAP.put("arrayValue", ImmutableList.of((Object)"foo"));
        ALL_SUPPORTED_TYPES_MAP.put("nullValue", null);
        ALL_SUPPORTED_TYPES_MAP.put("bytesValue", BLOB);
        ALL_SUPPORTED_TYPES_MAP.put("geoPointValue", GEO_POINT);
        ALL_SUPPORTED_TYPES_MAP.put("model", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.SINGLE_FIELD_OBJECT.foo, new Object[0]));
        ALL_SUPPORTED_TYPES_MAP.put("vectorValue", FieldValue.vector((double[])new double[]{0.1, 0.2, 0.3}));
        ALL_SUPPORTED_TYPES_PROTO = ImmutableMap.builder().put((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build()).put((Object)"doubleValue", (Object)Value.newBuilder().setDoubleValue(0.0).build()).put((Object)"longValue", (Object)Value.newBuilder().setIntegerValue(0L).build()).put((Object)"nanValue", (Object)Value.newBuilder().setDoubleValue(Double.NaN).build()).put((Object)"infValue", (Object)Value.newBuilder().setDoubleValue(Double.POSITIVE_INFINITY).build()).put((Object)"negInfValue", (Object)Value.newBuilder().setDoubleValue(Double.NEGATIVE_INFINITY).build()).put((Object)"trueValue", (Object)Value.newBuilder().setBooleanValue(true).build()).put((Object)"falseValue", (Object)Value.newBuilder().setBooleanValue(false).build()).put((Object)"objectValue", (Object)Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(SINGLE_FIELD_PROTO)).build()).put((Object)"vectorValue", (Object)Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(LocalFirestoreHelper.map("__type__", Value.newBuilder().setStringValue("__vector__").build(), "value", Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(Value.newBuilder().setDoubleValue(0.1)).addValues(Value.newBuilder().setDoubleValue(0.2)).addValues(Value.newBuilder().setDoubleValue(0.3))).build()))).build()).put((Object)"dateValue", (Object)Value.newBuilder().setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(479978400L).setNanos(123000000)).build()).put((Object)"timestampValue", (Object)Value.newBuilder().setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(479978400L).setNanos(123000)).build()).put((Object)"instantValue", (Object)Value.newBuilder().setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(479978400L).setNanos(123000)).build()).put((Object)"arrayValue", (Object)Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(Value.newBuilder().setStringValue("foo"))).build()).put((Object)"nullValue", (Object)Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).put((Object)"bytesValue", (Object)Value.newBuilder().setBytesValue(BLOB.toByteString()).build()).put((Object)"geoPointValue", (Object)Value.newBuilder().setGeoPointValue(LatLng.newBuilder().setLatitude(50.1430847).setLongitude(-122.947778)).build()).put((Object)"model", (Object)Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(SINGLE_FIELD_PROTO)).build()).build();
        ALL_SUPPORTED_TYPES_OBJECT = new AllSupportedTypes();
        SINGLE_WRITE_COMMIT_RESPONSE = LocalFirestoreHelper.commitResponse(1, 0);
        SINGLE_DELETE_COMMIT_RESPONSE = LocalFirestoreHelper.commitResponse(0, 1);
        SINGLE_CREATE_COMMIT_REQUEST = LocalFirestoreHelper.commit(LocalFirestoreHelper.create(SINGLE_FIELD_PROTO));
        FIELD_TRANSFORM_COMMIT_RESPONSE = LocalFirestoreHelper.commitResponse(2, 0);
        NESTED_CLASS_OBJECT = new NestedClass();
        UPDATE_PRECONDITION = Precondition.newBuilder().setExists(true).build();
        UPDATED_POJO = LocalFirestoreHelper.map("model", UPDATE_SINGLE_FIELD_OBJECT, new Object[0]);
    }

    @FunctionalInterface
    static interface VoidFunction {
        public void apply();
    }

    public static class FooList<E>
    extends ArrayList<SingleField> {
    }

    public static class FooMap<K, V>
    extends HashMap<K, V> {
    }

    public static class SingleField {
        public String foo = "bar";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleField that = (SingleField)o;
            return this.foo.equals(that.foo);
        }
    }

    public static class ServerTimestamp {
        @com.google.cloud.firestore.annotation.ServerTimestamp
        public Date foo;
        public Inner inner = new Inner();

        class Inner {
            @com.google.cloud.firestore.annotation.ServerTimestamp
            public Date bar;

            Inner() {
            }
        }
    }

    public static class AllSupportedTypes {
        public String foo = "bar";
        public Double doubleValue = 0.0;
        public long longValue = 0L;
        public double nanValue = Double.NaN;
        public double infValue = Double.POSITIVE_INFINITY;
        public double negInfValue = Double.NEGATIVE_INFINITY;
        public boolean trueValue = true;
        public boolean falseValue = false;
        public SingleField objectValue = new SingleField();
        public Date dateValue = DATE;
        public Timestamp timestampValue = TIMESTAMP;
        public Instant instantValue = INSTANT;
        public List<String> arrayValue = ImmutableList.of((Object)"foo");
        public String nullValue = null;
        public Blob bytesValue = BLOB;
        public GeoPoint geoPointValue = GEO_POINT;
        public Map<String, Object> model;
        public VectorValue vectorValue;

        public AllSupportedTypes() {
            this.model = ImmutableMap.of((Object)"foo", (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT.foo);
            this.vectorValue = FieldValue.vector((double[])new double[]{0.1, 0.2, 0.3});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllSupportedTypes that = (AllSupportedTypes)o;
            return this.longValue == that.longValue && Double.compare(that.nanValue, this.nanValue) == 0 && Double.compare(that.infValue, this.infValue) == 0 && Double.compare(that.negInfValue, this.negInfValue) == 0 && this.trueValue == that.trueValue && this.falseValue == that.falseValue && Objects.equals(this.foo, that.foo) && Objects.equals(this.doubleValue, that.doubleValue) && Objects.equals(this.objectValue, that.objectValue) && Objects.equals(this.dateValue, that.dateValue) && Objects.equals(this.timestampValue, that.timestampValue) && Objects.equals(this.instantValue, that.instantValue) && Objects.equals(this.arrayValue, that.arrayValue) && Objects.equals(this.nullValue, that.nullValue) && Objects.equals(this.bytesValue, that.bytesValue) && Objects.equals(this.geoPointValue, that.geoPointValue) && Objects.equals(this.model, that.model) && Objects.equals(this.vectorValue, that.vectorValue);
        }
    }

    public static class NestedClass {
        public SingleField first = new SingleField();
        public AllSupportedTypes second = new AllSupportedTypes();
    }

    static class ResponseStubber {
        List<RequestResponsePair> operationList = new ArrayList<RequestResponsePair>();
        List<Object> actualRequestList = new CopyOnWriteArrayList<Object>();

        ResponseStubber() {
        }

        void put(Message request, ApiFuture<? extends Message> response) {
            this.operationList.add(new RequestResponsePair(request, response));
        }

        void initializeStub(ArgumentCaptor<? extends Message> argumentCaptor, FirestoreImpl firestoreMock) {
            Stubber stubber = null;
            for (RequestResponsePair entry : this.operationList) {
                Answer answer = invocationOnMock -> {
                    this.actualRequestList.add(invocationOnMock.getArguments()[0]);
                    return entry.response;
                };
                stubber = stubber != null ? stubber.doAnswer(answer) : Mockito.doAnswer((Answer)answer);
            }
            Preconditions.checkNotNull(stubber, (Object)"Stubber should not be null");
            ((FirestoreImpl)stubber.when((Object)firestoreMock)).sendRequest((Object)((Message)argumentCaptor.capture()), (UnaryCallable)ArgumentMatchers.any());
        }

        public void verifyAllRequestsSent() {
            Assert.assertArrayEquals((String)"Expected requests, but got actual requests", (Object[])this.operationList.stream().map(x -> x.request).toArray(), (Object[])this.actualRequestList.toArray());
        }
    }

    static class RequestResponsePair {
        Message request;
        ApiFuture<? extends Message> response;

        public RequestResponsePair(Message request, ApiFuture<? extends Message> response) {
            this.request = request;
            this.response = response;
        }
    }

    public static class InvalidPOJO {
        @Nullable
        BigInteger bigIntegerValue = null;
        @Nullable
        Byte byteValue = null;
        @Nullable
        Short shortValue = null;

        @Nullable
        public BigInteger getBigIntegerValue() {
            return this.bigIntegerValue;
        }

        public void setBigIntegerValue(@Nullable BigInteger bigIntegerValue) {
            this.bigIntegerValue = bigIntegerValue;
        }

        @Nullable
        public Byte getByteValue() {
            return this.byteValue;
        }

        public void setByteValue(@Nullable Byte byteValue) {
            this.byteValue = byteValue;
        }

        @Nullable
        public Short getShortValue() {
            return this.shortValue;
        }

        public void setShortValue(@Nullable Short shortValue) {
            this.shortValue = shortValue;
        }
    }

    public static class CustomMap {
        public FooMap<String, SingleField> fooMap;
    }

    public static class CustomList {
        public FooList<SingleField> fooList;
    }
}

