/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.annotation.DocumentId;
import com.google.cloud.firestore.annotation.Exclude;
import com.google.cloud.firestore.annotation.PropertyName;
import com.google.cloud.firestore.annotation.ThrowOnExtraProperties;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.DatabaseRootName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MapperTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    private static final double EPSILON = 3.0E-4;

    private static <T> T deserialize(String jsonString, Class<T> clazz) {
        return MapperTest.deserialize(jsonString, clazz, null);
    }

    private static <T> T deserialize(Map<String, Object> json, Class<T> clazz) {
        return MapperTest.deserialize(json, clazz, null);
    }

    private static <T> T deserialize(String jsonString, Class<T> clazz, DocumentReference docRef) {
        Map<String, Object> json = LocalFirestoreHelper.fromSingleQuotedString(jsonString);
        return (T)CustomClassMapper.convertToCustomClass(json, clazz, (DocumentReference)docRef);
    }

    private static <T> T deserialize(Map<String, Object> json, Class<T> clazz, DocumentReference docRef) {
        return (T)CustomClassMapper.convertToCustomClass(json, clazz, (DocumentReference)docRef);
    }

    private static Object serialize(Object object) {
        return CustomClassMapper.convertToPlainJavaTypes((Object)object);
    }

    private static void assertJson(String expected, Object actual) {
        Assert.assertEquals(LocalFirestoreHelper.fromSingleQuotedString(expected), (Object)actual);
    }

    private static void assertExceptionContains(String partialMessage, Runnable run) {
        try {
            run.run();
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(partialMessage));
        }
    }

    private static <T> T convertToCustomClass(Object object, Class<T> clazz, DocumentReference docRef) {
        return (T)CustomClassMapper.convertToCustomClass((Object)object, clazz, (DocumentReference)docRef);
    }

    private static <T> T convertToCustomClass(Object object, Class<T> clazz) {
        return (T)CustomClassMapper.convertToCustomClass((Object)object, clazz, null);
    }

    @Test
    public void primitiveDeserializeString() {
        StringBean bean = MapperTest.deserialize("{'value': 'foo'}", StringBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
        try {
            MapperTest.deserialize("{'value': 1.1}", StringBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 1}", StringBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 1234567890123}", StringBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': true}", StringBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeBoolean() {
        BooleanBean beanBoolean = MapperTest.deserialize("{'value': true}", BooleanBean.class);
        Assert.assertEquals((Object)true, (Object)beanBoolean.value);
        try {
            MapperTest.deserialize("{'value': 1.1}", BooleanBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 1234567890123}", BooleanBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 1}", BooleanBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", BooleanBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeDouble() {
        DoubleBean beanDouble = MapperTest.deserialize("{'value': 1.1}", DoubleBean.class);
        Assert.assertEquals((double)1.1, (double)beanDouble.value, (double)3.0E-4);
        DoubleBean beanInt = MapperTest.deserialize("{'value': 1}", DoubleBean.class);
        Assert.assertEquals((double)1.0, (double)beanInt.value, (double)3.0E-4);
        DoubleBean beanLong = MapperTest.deserialize("{'value': 1234567890123}", DoubleBean.class);
        Assert.assertEquals((double)1.234567890123E12, (double)beanLong.value, (double)3.0E-4);
        try {
            MapperTest.deserialize("{'value': true}", DoubleBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", DoubleBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeBigDecimal() {
        BigDecimalBean beanBigdecimal = MapperTest.deserialize("{'value': 123}", BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(123.0), (Object)beanBigdecimal.value);
        beanBigdecimal = MapperTest.deserialize("{'value': '123'}", BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(123L), (Object)beanBigdecimal.value);
        BigDecimalBean beanInt = MapperTest.deserialize(Collections.singletonMap("value", 1), BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)beanInt.value);
        BigDecimalBean beanLong = MapperTest.deserialize(Collections.singletonMap("value", 1234567890123L), BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(1234567890123L), (Object)beanLong.value);
        BigDecimalBean beanDouble = MapperTest.deserialize(Collections.singletonMap("value", 1.1), BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(1.1), (Object)beanDouble.value);
        BigDecimalBean beanBigDecimal = MapperTest.deserialize(Collections.singletonMap("value", BigDecimal.valueOf(1.2)), BigDecimalBean.class);
        Assert.assertEquals((Object)BigDecimal.valueOf(1.2), (Object)beanBigDecimal.value);
        try {
            MapperTest.deserialize("{'value': true}", BigDecimalBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", BigDecimalBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeFloat() {
        FloatBean beanFloat = MapperTest.deserialize("{'value': 1.1}", FloatBean.class);
        Assert.assertEquals((double)1.1, (double)beanFloat.value, (double)3.0E-4);
        FloatBean beanInt = MapperTest.deserialize(Collections.singletonMap("value", 1), FloatBean.class);
        Assert.assertEquals((double)1.0, (double)beanInt.value, (double)3.0E-4);
        FloatBean beanLong = MapperTest.deserialize(Collections.singletonMap("value", 1234567890123L), FloatBean.class);
        Assert.assertEquals((double)1.234567954432E12, (double)beanLong.value, (double)3.0E-4);
        try {
            MapperTest.deserialize("{'value': true}", FloatBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", FloatBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeInt() {
        IntBean beanInt = MapperTest.deserialize("{'value': 1}", IntBean.class);
        Assert.assertEquals((long)1L, (long)beanInt.value);
        IntBean beanDouble = MapperTest.deserialize("{'value': 1.1}", IntBean.class);
        Assert.assertEquals((long)1L, (long)beanDouble.value);
        try {
            MapperTest.deserialize("{'value': 1e10}", IntBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 1234567890123}", IntBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': true}", IntBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", IntBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeLong() {
        LongBean beanLong = MapperTest.deserialize("{'value': 1234567890123}", LongBean.class);
        Assert.assertEquals((long)1234567890123L, (long)beanLong.value);
        LongBean beanInt = MapperTest.deserialize("{'value': 1}", LongBean.class);
        Assert.assertEquals((long)1L, (long)beanInt.value);
        LongBean beanDouble = MapperTest.deserialize("{'value': 1.1}", LongBean.class);
        Assert.assertEquals((long)1L, (long)beanDouble.value);
        try {
            MapperTest.deserialize("{'value': 1e300}", LongBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': true}", LongBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MapperTest.deserialize("{'value': 'foo'}", LongBean.class);
            Assert.fail((String)"Should throw");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void primitiveDeserializeWrongTypeMap() {
        String expectedExceptionMessage = ".* Failed to convert value of type .*Map to String \\(found in field 'value'\\).*";
        Throwable exception = Assert.assertThrows(RuntimeException.class, () -> MapperTest.deserialize("{'value': {'foo': 'bar'}}", StringBean.class));
        Assert.assertTrue((boolean)exception.getMessage().matches(expectedExceptionMessage));
    }

    @Test
    public void primitiveDeserializeWrongTypeList() {
        MapperTest.assertExceptionContains("Failed to convert value of type java.util.ArrayList to String (found in field 'value')", () -> MapperTest.deserialize("{'value': ['foo']}", StringBean.class));
    }

    @Test
    public void publicFieldDeserialize() {
        PublicFieldBean bean = MapperTest.deserialize("{'value': 'foo'}", PublicFieldBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void publicPrivateFieldDeserialize() {
        PublicPrivateFieldBean bean = MapperTest.deserialize("{'value1': 'foo', 'value2': 'bar', 'value3': 'baz'}", PublicPrivateFieldBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value1);
        Assert.assertEquals(null, (Object)bean.value2);
        Assert.assertEquals(null, (Object)bean.value3);
    }

    @Test
    public void packageFieldDeserialize() {
        MapperTest.assertExceptionContains("No properties to serialize found on class com.google.cloud.firestore.MapperTest$PackageFieldBean", () -> MapperTest.deserialize("{'value': 'foo'}", PackageFieldBean.class));
    }

    @Test
    public void privateFieldDeserialize() {
        MapperTest.assertExceptionContains("No properties to serialize found on class com.google.cloud.firestore.MapperTest$PrivateFieldBean", () -> MapperTest.deserialize("{'value': 'foo'}", PrivateFieldBean.class));
    }

    @Test
    public void packageGetterDeserialize() {
        PackageGetterBean bean = MapperTest.deserialize("{'publicValue': 'foo', 'packageValue': 'bar'}", PackageGetterBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.publicValue);
        Assert.assertNull((Object)bean.packageValue);
    }

    @Test
    public void packageGetterSerialize() {
        PackageGetterBean bean = new PackageGetterBean();
        bean.packageValue = "foo";
        bean.publicValue = "bar";
        MapperTest.assertJson("{'publicValue': 'bar'}", MapperTest.serialize(bean));
    }

    @Test
    public void ignoreExtraProperties() {
        PublicFieldBean bean = MapperTest.deserialize("{'value': 'foo', 'unknown': 'bar'}", PublicFieldBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void throwOnUnknownProperties() {
        MapperTest.assertExceptionContains("No setter/field for unknown found on class com.google.cloud.firestore.MapperTest$ThrowOnUnknownPropertiesBean", () -> MapperTest.deserialize("{'value': 'foo', 'unknown': 'bar'}", ThrowOnUnknownPropertiesBean.class));
    }

    @Test
    public void twoSetterBean() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$TwoSetterBean has multiple setter overloads", () -> MapperTest.deserialize("{'value': 'foo'}", TwoSetterBean.class));
    }

    @Test
    public void XMLAndURLBean() {
        XMLAndURLBean bean = MapperTest.deserialize("{'xmlandURL1': 'foo', 'XMLAndURL2': 'bar'}", XMLAndURLBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.XMLAndURL1);
        Assert.assertEquals((Object)"bar", (Object)bean.XMLAndURL2);
    }

    @Test
    public void allCapsGetterSerializesToLowercaseByDefault() {
        AllCapsDefaultHandlingBean bean = new AllCapsDefaultHandlingBean();
        bean.setUUID("value");
        MapperTest.assertJson("{'uuid': 'value'}", MapperTest.serialize(bean));
        AllCapsDefaultHandlingBean deserialized = MapperTest.deserialize("{'uuid': 'value'}", AllCapsDefaultHandlingBean.class);
        Assert.assertEquals((Object)"value", (Object)deserialized.getUUID());
    }

    @Test
    public void allCapsWithPropertyNameSerializesToUppercase() {
        AllCapsWithPropertyName bean = new AllCapsWithPropertyName();
        bean.setUUID("value");
        MapperTest.assertJson("{'UUID': 'value'}", MapperTest.serialize(bean));
        AllCapsWithPropertyName deserialized = MapperTest.deserialize("{'UUID': 'value'}", AllCapsWithPropertyName.class);
        Assert.assertEquals((Object)"value", (Object)deserialized.getUUID());
    }

    @Test
    public void setterIsCalledWhenPresent() {
        SetterBean bean = MapperTest.deserialize("{'value': 'foo'}", SetterBean.class);
        Assert.assertEquals((Object)"setter:foo", (Object)bean.value);
    }

    @Test
    public void privateSetterIsCalledWhenPresent() {
        PrivateSetterBean bean = MapperTest.deserialize("{'value': 'foo'}", PrivateSetterBean.class);
        Assert.assertEquals((Object)"setter:foo", (Object)bean.value);
    }

    @Test
    public void setterIsCaseSensitive1() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$CaseSensitiveSetterBean1 has multiple setter overloads", () -> MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean1.class));
    }

    @Test
    public void setterIsCaseSensitive2() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$CaseSensitiveSetterBean2 has multiple setter overloads", () -> MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean2.class));
    }

    @Test
    public void caseSensitiveSetterIsCalledWhenPresent1() {
        CaseSensitiveSetterBean3 bean = MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean3.class);
        Assert.assertEquals((Object)"setter:foo", (Object)bean.value);
    }

    @Test
    public void caseSensitiveSetterIsCalledWhenPresent2() {
        CaseSensitiveSetterBean4 bean = MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean4.class);
        Assert.assertEquals((Object)"setter:foo", (Object)bean.value);
    }

    @Test
    public void caseSensitiveSetterIsCalledWhenPresent3() {
        CaseSensitiveSetterBean5 bean = MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean5.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void caseSensitiveSetterMustHaveSameCaseAsSetter() {
        MapperTest.assertExceptionContains("Found setter on com.google.cloud.firestore.MapperTest$CaseSensitiveSetterBean6 with invalid case-sensitive name: setVaLUE", () -> MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveSetterBean6.class));
    }

    @Test
    public void wrongSetterIsNotCalledWhenPresent() {
        WrongSetterBean bean = MapperTest.deserialize("{'value': 'foo'}", WrongSetterBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void nestedParsingWorks() {
        NestedBean bean = MapperTest.deserialize("{'bean': {'value': 'foo'}}", NestedBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.bean.value);
    }

    @Test
    public void beansCanContainLists() {
        ListBean bean = MapperTest.deserialize("{'values': ['foo', 'bar']}", ListBean.class);
        Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)bean.values);
    }

    @Test
    public void beansCanContainMaps() {
        MapBean bean = MapperTest.deserialize("{'values': {'foo': 'bar'}}", MapBean.class);
        Map<String, Object> expected = LocalFirestoreHelper.fromSingleQuotedString("{'foo': 'bar'}");
        Assert.assertEquals(expected, (Object)bean.values);
    }

    @Test
    public void beansCanContainUpperBoundedMaps() {
        Date date = new Date(1491847082123L);
        Map source = LocalFirestoreHelper.mapAnyType("values", LocalFirestoreHelper.mapAnyType("foo", date));
        UpperBoundedMapBean bean = MapperTest.convertToCustomClass(source, UpperBoundedMapBean.class);
        Map expected = LocalFirestoreHelper.mapAnyType("foo", date);
        Assert.assertEquals(expected, (Object)bean.values);
    }

    @Test
    public void beansCanContainMultiBoundedMaps() {
        Date date = new Date(1491847082123L);
        Map source = LocalFirestoreHelper.mapAnyType("map", LocalFirestoreHelper.mapAnyType("values", LocalFirestoreHelper.mapAnyType("foo", date)));
        MultiBoundedMapHolderBean bean = MapperTest.convertToCustomClass(source, MultiBoundedMapHolderBean.class);
        Map expected = LocalFirestoreHelper.mapAnyType("foo", date);
        Assert.assertEquals(expected, (Object)((MultiBoundedMapBean)bean.map).values);
    }

    @Test
    public void beansCanContainUnboundedMaps() {
        UnboundedMapBean bean = MapperTest.deserialize("{'values': {'foo': 'bar'}}", UnboundedMapBean.class);
        Map expected = LocalFirestoreHelper.mapAnyType("foo", "bar");
        Assert.assertEquals(expected, (Object)bean.values);
    }

    @Test
    public void beansCanContainUnboundedTypeVariableMaps() {
        Map source = LocalFirestoreHelper.mapAnyType("map", LocalFirestoreHelper.mapAnyType("values", LocalFirestoreHelper.mapAnyType("foo", "bar")));
        UnboundedTypeVariableMapHolderBean bean = MapperTest.convertToCustomClass(source, UnboundedTypeVariableMapHolderBean.class);
        Map expected = LocalFirestoreHelper.mapAnyType("foo", "bar");
        Assert.assertEquals(expected, (Object)((UnboundedTypeVariableMapBean)bean.map).values);
    }

    @Test
    public void beansCanContainNestedUnboundedMaps() {
        UnboundedMapBean bean = MapperTest.deserialize("{'values': {'foo': {'bar': 'baz'}}}", UnboundedMapBean.class);
        Map expected = LocalFirestoreHelper.mapAnyType("foo", LocalFirestoreHelper.mapAnyType("bar", "baz"));
        Assert.assertEquals(expected, (Object)bean.values);
    }

    @Test
    public void beansCanContainBeanLists() {
        NestedListBean bean = MapperTest.deserialize("{'values': [{'value': 'foo'}]}", NestedListBean.class);
        Assert.assertEquals((long)1L, (long)bean.values.size());
        Assert.assertEquals((Object)"foo", (Object)((StringBean)bean.values.get(0)).value);
    }

    @Test
    public void beansCanContainBeanMaps() {
        NestedMapBean bean = MapperTest.deserialize("{'values': {'key': {'value': 'foo'}}}", NestedMapBean.class);
        Assert.assertEquals((long)1L, (long)bean.values.size());
        Assert.assertEquals((Object)"foo", (Object)((StringBean)bean.values.get("key")).value);
    }

    @Test
    public void beanMapsMustHaveStringKeys() {
        MapperTest.assertExceptionContains("Only Maps with string keys are supported, but found Map with key type class java.lang.Integer (found in field 'values')", () -> MapperTest.deserialize("{'values': {'1': 'bar'}}", IllegalKeyMapBean.class));
    }

    @Test
    public void serializeStringBean() {
        StringBean bean = new StringBean();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void serializeDoubleBean() {
        DoubleBean bean = new DoubleBean();
        bean.value = 1.1;
        MapperTest.assertJson("{'value': 1.1}", MapperTest.serialize(bean));
    }

    @Test
    public void serializeIntBean() {
        IntBean bean = new IntBean();
        bean.value = 1;
        MapperTest.assertJson("{'value': 1}", MapperTest.serialize(Collections.singletonMap("value", 1.0)));
    }

    @Test
    public void serializeLongBean() {
        LongBean bean = new LongBean();
        bean.value = 1234567890123L;
        MapperTest.assertJson("{'value': 1.234567890123E12}", MapperTest.serialize(Collections.singletonMap("value", 1.234567890123E12)));
    }

    @Test
    public void serializeBigDecimalBean() {
        BigDecimalBean bean = new BigDecimalBean();
        bean.value = BigDecimal.valueOf(1.1);
        Assert.assertEquals(LocalFirestoreHelper.mapAnyType("value", "1.1"), (Object)MapperTest.serialize(bean));
    }

    @Test
    public void bigDecimalRoundTrip() {
        BigDecimal doubleMaxPlusOne = BigDecimal.valueOf(Double.MAX_VALUE).add(BigDecimal.ONE);
        BigDecimalBean a = new BigDecimalBean();
        a.value = doubleMaxPlusOne;
        Map serialized = (Map)MapperTest.serialize(a);
        BigDecimalBean b = MapperTest.convertToCustomClass(serialized, BigDecimalBean.class);
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void serializeBooleanBean() {
        BooleanBean bean = new BooleanBean();
        bean.value = true;
        MapperTest.assertJson("{'value': true}", MapperTest.serialize(bean));
    }

    @Test
    public void serializeFloatBean() {
        FloatBean bean = new FloatBean();
        bean.value = 0.5f;
        Assert.assertEquals(LocalFirestoreHelper.mapAnyType("value", Float.valueOf(0.5f)), (Object)MapperTest.serialize(bean));
    }

    @Test
    public void serializePublicFieldBean() {
        PublicFieldBean bean = new PublicFieldBean();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void serializePrivateFieldBean() {
        PrivateFieldBean bean = new PrivateFieldBean();
        bean.value = "foo";
        MapperTest.assertExceptionContains("No properties to serialize found on class com.google.cloud.firestore.MapperTest$PrivateFieldBean", () -> MapperTest.serialize(bean));
    }

    @Test
    public void serializePackageFieldBean() {
        PackageFieldBean bean = new PackageFieldBean();
        bean.value = "foo";
        MapperTest.assertExceptionContains("No properties to serialize found on class com.google.cloud.firestore.MapperTest$PackageFieldBean", () -> MapperTest.serialize(bean));
    }

    @Test
    public void serializePublicPrivateFieldBean() {
        PublicPrivateFieldBean bean = new PublicPrivateFieldBean();
        bean.value1 = "foo";
        bean.value2 = "bar";
        bean.value3 = "baz";
        MapperTest.assertJson("{'value1': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void getterOverridesField() {
        GetterBean bean = new GetterBean();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'getter:foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void serializeGetterBeanWithNoBackingField() {
        GetterBeanNoField bean = new GetterBeanNoField();
        MapperTest.assertJson("{'value': 'getter:value'}", MapperTest.serialize(bean));
    }

    @Test
    public void deserializeGetterBeanWithNoBackingFieldThrows() {
        MapperTest.assertExceptionContains("No setter/field", () -> MapperTest.deserialize("{'value': 'foo'}", GetterBeanNoField.class));
    }

    @Test
    public void getterOverridesPublicField() {
        GetterPublicFieldBean bean = new GetterPublicFieldBean();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'getter:foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void getterAndPublicFieldsConflictOnCaseSensitivity() {
        GetterPublicFieldBeanCaseSensitive bean = new GetterPublicFieldBeanCaseSensitive();
        bean.valueCase = "foo";
        MapperTest.assertExceptionContains("Found two getters or fields with conflicting case sensitivity for property: valuecase", () -> MapperTest.serialize(bean));
    }

    @Test
    public void caseSensitiveGetterBean1() {
        CaseSensitiveGetterBean1 bean = new CaseSensitiveGetterBean1();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void caseSensitiveGetterBean2() {
        CaseSensitiveGetterBean2 bean = new CaseSensitiveGetterBean2();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void caseSensitiveGetterBean3() {
        CaseSensitiveGetterBean3 bean = new CaseSensitiveGetterBean3();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void caseSensitiveGetterBean4() {
        CaseSensitiveGetterBean4 bean = new CaseSensitiveGetterBean4();
        bean.value = "foo";
        MapperTest.assertJson("{'vaLUE': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void nestedSerializingWorks() {
        NestedBean bean = new NestedBean();
        bean.bean = new StringBean();
        bean.bean.value = "foo";
        MapperTest.assertJson("{'bean': {'value': 'foo'}}", MapperTest.serialize(bean));
    }

    @Test
    public void serializingListsWorks() {
        ListBean bean = new ListBean();
        bean.values = Arrays.asList("foo", "bar");
        MapperTest.assertJson("{'values': ['foo', 'bar']}", MapperTest.serialize(bean));
    }

    @Test
    public void serializingMapsWorks() {
        MapBean bean = new MapBean();
        bean.values = new HashMap();
        bean.values.put("foo", "bar");
        MapperTest.assertJson("{'values': {'foo': 'bar'}}", MapperTest.serialize(bean));
    }

    @Test
    public void serializingUpperBoundedMapsWorks() {
        Date date = new Date(1491847082123L);
        UpperBoundedMapBean bean = new UpperBoundedMapBean();
        HashMap<String, Date> values = new HashMap<String, Date>();
        values.put("foo", date);
        bean.values = values;
        Map expected = LocalFirestoreHelper.mapAnyType("values", LocalFirestoreHelper.mapAnyType("foo", new Date(date.getTime())));
        Assert.assertEquals(expected, (Object)MapperTest.serialize(bean));
    }

    @Test
    public void serializingMultiBoundedObjectsWorks() {
        Date date = new Date(1491847082123L);
        MultiBoundedMapHolderBean holder = new MultiBoundedMapHolderBean();
        HashMap<String, Date> values = new HashMap<String, Date>();
        values.put("foo", date);
        holder.map = new MultiBoundedMapBean();
        ((MultiBoundedMapBean)holder.map).values = values;
        Map expected = LocalFirestoreHelper.mapAnyType("map", LocalFirestoreHelper.mapAnyType("values", LocalFirestoreHelper.mapAnyType("foo", new Date(date.getTime()))));
        Assert.assertEquals(expected, (Object)MapperTest.serialize(holder));
    }

    @Test
    public void serializeListOfBeansWorks() {
        StringBean stringBean = new StringBean();
        stringBean.value = "foo";
        NestedListBean bean = new NestedListBean();
        bean.values = new ArrayList();
        bean.values.add(stringBean);
        MapperTest.assertJson("{'values': [{'value': 'foo'}]}", MapperTest.serialize(bean));
    }

    @Test
    public void serializeMapOfBeansWorks() {
        StringBean stringBean = new StringBean();
        stringBean.value = "foo";
        NestedMapBean bean = new NestedMapBean();
        bean.values = new HashMap();
        bean.values.put("key", stringBean);
        MapperTest.assertJson("{'values': {'key': {'value': 'foo'}}}", MapperTest.serialize(bean));
    }

    @Test
    public void beanMapsMustHaveStringKeysForSerializing() {
        StringBean stringBean = new StringBean();
        stringBean.value = "foo";
        IllegalKeyMapBean bean = new IllegalKeyMapBean();
        bean.values = new HashMap();
        bean.values.put(1, stringBean);
        MapperTest.assertExceptionContains("Maps with non-string keys are not supported (found in field 'values')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void twoGettersThrows() {
        TwoGetterBean bean = new TwoGetterBean();
        bean.value = "foo";
        MapperTest.assertExceptionContains("Found conflicting getters", () -> MapperTest.serialize(bean));
    }

    @Test
    public void serializeUPPERCASE() {
        XMLAndURLBean bean = new XMLAndURLBean();
        bean.XMLAndURL1 = "foo";
        bean.XMLAndURL2 = "bar";
        MapperTest.assertJson("{'xmlandURL1': 'foo', 'XMLAndURL2': 'bar'}", MapperTest.serialize(bean));
    }

    @Test
    public void onlySerializesGetterWithCorrectArguments() {
        GetterArgumentsBean bean = new GetterArgumentsBean();
        bean.value = "foo";
        MapperTest.assertJson("{'value1': 'foo1', 'value4': 'foo4'}", MapperTest.serialize(bean));
    }

    @Test
    public void roundTripCaseSensitiveFieldBean1() {
        CaseSensitiveFieldBean1 bean = new CaseSensitiveFieldBean1();
        bean.VALUE = "foo";
        MapperTest.assertJson("{'VALUE': 'foo'}", MapperTest.serialize(bean));
        CaseSensitiveFieldBean1 deserialized = MapperTest.deserialize("{'VALUE': 'foo'}", CaseSensitiveFieldBean1.class);
        Assert.assertEquals((Object)"foo", (Object)deserialized.VALUE);
    }

    @Test
    public void roundTripCaseSensitiveFieldBean2() {
        CaseSensitiveFieldBean2 bean = new CaseSensitiveFieldBean2();
        bean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(bean));
        CaseSensitiveFieldBean2 deserialized = MapperTest.deserialize("{'value': 'foo'}", CaseSensitiveFieldBean2.class);
        Assert.assertEquals((Object)"foo", (Object)deserialized.value);
    }

    @Test
    public void roundTripCaseSensitiveFieldBean3() {
        CaseSensitiveFieldBean3 bean = new CaseSensitiveFieldBean3();
        bean.Value = "foo";
        MapperTest.assertJson("{'Value': 'foo'}", MapperTest.serialize(bean));
        CaseSensitiveFieldBean3 deserialized = MapperTest.deserialize("{'Value': 'foo'}", CaseSensitiveFieldBean3.class);
        Assert.assertEquals((Object)"foo", (Object)deserialized.Value);
    }

    @Test
    public void roundTripCaseSensitiveFieldBean4() {
        CaseSensitiveFieldBean4 bean = new CaseSensitiveFieldBean4();
        bean.valUE = "foo";
        MapperTest.assertJson("{'valUE': 'foo'}", MapperTest.serialize(bean));
        CaseSensitiveFieldBean4 deserialized = MapperTest.deserialize("{'valUE': 'foo'}", CaseSensitiveFieldBean4.class);
        Assert.assertEquals((Object)"foo", (Object)deserialized.valUE);
    }

    @Test
    public void roundTripUnicodeBean() {
        UnicodeBean bean = new UnicodeBean();
        bean.\u6f22\u5b57 = "foo";
        MapperTest.assertJson("{'\u6f22\u5b57': 'foo'}", MapperTest.serialize(bean));
        UnicodeBean deserialized = MapperTest.deserialize("{'\u6f22\u5b57': 'foo'}", UnicodeBean.class);
        Assert.assertEquals((Object)"foo", (Object)deserialized.\u6f22\u5b57);
    }

    @Test
    public void shortsCantBeSerialized() {
        ShortBean bean = new ShortBean();
        bean.value = (short)1;
        MapperTest.assertExceptionContains("Numbers of type Short are not supported, please use an int, long, float, double or BigDecimal (found in field 'value')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void bytesCantBeSerialized() {
        ByteBean bean = new ByteBean();
        bean.value = (byte)1;
        MapperTest.assertExceptionContains("Numbers of type Byte are not supported, please use an int, long, float, double or BigDecimal (found in field 'value')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void charsCantBeSerialized() {
        CharBean bean = new CharBean();
        bean.value = '\u0001';
        MapperTest.assertExceptionContains("Characters are not supported, please use Strings (found in field 'value')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void intArraysCantBeSerialized() {
        IntArrayBean bean = new IntArrayBean();
        IntArrayBean.access$8702(bean, new int[]{1});
        MapperTest.assertExceptionContains("Serializing Arrays is not supported, please use Lists instead (found in field 'values')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void objectArraysCantBeSerialized() {
        StringArrayBean bean = new StringArrayBean();
        StringArrayBean.access$8902(bean, new String[]{"foo"});
        MapperTest.assertExceptionContains("Serializing Arrays is not supported, please use Lists instead (found in field 'values')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void shortsCantBeDeserialized() {
        MapperTest.assertExceptionContains("Deserializing values to short is not supported (found in field 'value')", () -> MapperTest.deserialize("{'value': 1}", ShortBean.class));
    }

    @Test
    public void bytesCantBeDeserialized() {
        MapperTest.assertExceptionContains("Deserializing values to byte is not supported (found in field 'value')", () -> MapperTest.deserialize("{'value': 1}", ByteBean.class));
    }

    @Test
    public void charsCantBeDeserialized() {
        MapperTest.assertExceptionContains("Deserializing values to char is not supported (found in field 'value')", () -> MapperTest.deserialize("{'value': '1'}", CharBean.class));
    }

    @Test
    public void intArraysCantBeDeserialized() {
        MapperTest.assertExceptionContains("Converting to Arrays is not supported, please use Lists instead (found in field 'values')", () -> MapperTest.deserialize("{'values': [1]}", IntArrayBean.class));
    }

    @Test
    public void objectArraysCantBeDeserialized() {
        MapperTest.assertExceptionContains("Could not deserialize object. Converting to Arrays is not supported, please use Lists instead (found in field 'values')", () -> MapperTest.deserialize("{'values': ['foo']}", StringArrayBean.class));
    }

    @Test
    public void publicConstructorCanBeDeserialized() {
        PublicConstructorBean bean = MapperTest.deserialize("{'value': 'foo'}", PublicConstructorBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void privateConstructorCanBeDeserialized() {
        PrivateConstructorBean bean = MapperTest.deserialize("{'value': 'foo'}", PrivateConstructorBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void argConstructorCantBeDeserialized() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$ArgConstructorBean does not define a no-argument constructor.", () -> MapperTest.deserialize("{'value': 'foo'}", ArgConstructorBean.class));
    }

    @Test
    public void packageConstructorCanBeDeserialized() {
        Timestamp timestamp = Timestamp.now();
        PackageConstructorBean bean = MapperTest.deserialize(Collections.singletonMap("value", timestamp), PackageConstructorBean.class);
        Assert.assertEquals((Object)timestamp, (Object)bean.value);
    }

    @Test
    public void multipleConstructorsCanBeDeserialized() {
        MultipleConstructorBean bean = MapperTest.deserialize("{'value': 'foo'}", MultipleConstructorBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void objectAcceptsAnyObject() {
        ObjectBean stringValue = MapperTest.deserialize("{'value': 'foo'}", ObjectBean.class);
        Assert.assertEquals((Object)"foo", (Object)stringValue.value);
        ObjectBean listValue = MapperTest.deserialize("{'value': ['foo']}", ObjectBean.class);
        Assert.assertEquals(Collections.singletonList("foo"), (Object)listValue.value);
        ObjectBean mapValue = MapperTest.deserialize("{'value': {'foo':'bar'}}", ObjectBean.class);
        Assert.assertEquals(LocalFirestoreHelper.fromSingleQuotedString("{'foo':'bar'}"), (Object)mapValue.value);
        String complex = "{'value': {'foo':['bar', ['baz'], {'bam': 'qux'}]}, 'other':{'a': ['b']}}";
        ObjectBean complexValue = MapperTest.deserialize(complex, ObjectBean.class);
        Assert.assertEquals((Object)LocalFirestoreHelper.fromSingleQuotedString(complex).get("value"), (Object)complexValue.value);
    }

    @Test
    public void objectClassCanBePassedInAtTopLevel() {
        Assert.assertEquals((Object)"foo", (Object)MapperTest.convertToCustomClass("foo", Object.class));
        Assert.assertEquals((Object)1, (Object)MapperTest.convertToCustomClass(1, Object.class));
        Assert.assertEquals((Object)1L, (Object)MapperTest.convertToCustomClass(1L, Object.class));
        Assert.assertEquals((Object)true, (Object)MapperTest.convertToCustomClass(true, Object.class));
        Assert.assertEquals((Object)1.1, (Object)MapperTest.convertToCustomClass(1.1, Object.class));
        List<String> fooList = Collections.singletonList("foo");
        Assert.assertEquals(fooList, (Object)MapperTest.convertToCustomClass(fooList, Object.class));
        Map<String, String> fooMap = Collections.singletonMap("foo", "bar");
        Assert.assertEquals(fooMap, (Object)MapperTest.convertToCustomClass(fooMap, Object.class));
    }

    @Test
    public void primitiveClassesCanBePassedInTopLevel() {
        Assert.assertEquals((Object)"foo", (Object)MapperTest.convertToCustomClass("foo", String.class));
        Assert.assertEquals((Object)1, (Object)MapperTest.convertToCustomClass(1, Integer.class));
        Assert.assertEquals((Object)1L, (Object)MapperTest.convertToCustomClass(1L, Long.class));
        Assert.assertEquals((Object)true, (Object)MapperTest.convertToCustomClass(true, Boolean.class));
        Assert.assertEquals((Object)1.1, (Object)MapperTest.convertToCustomClass(1.1, Double.class));
    }

    @Test
    public void passingInListTopLevelThrows() {
        MapperTest.assertExceptionContains("Class java.util.List has generic type parameters, please use GenericTypeIndicator instead", () -> MapperTest.convertToCustomClass(Collections.singletonList("foo"), List.class));
    }

    @Test
    public void passingInMapTopLevelThrows() {
        MapperTest.assertExceptionContains("Class java.util.Map has generic type parameters, please use GenericTypeIndicator instead", () -> MapperTest.convertToCustomClass(Collections.singletonMap("foo", "bar"), Map.class));
    }

    @Test
    public void passingInCharacterTopLevelThrows() {
        MapperTest.assertExceptionContains("Deserializing values to Character is not supported", () -> MapperTest.convertToCustomClass(Character.valueOf('1'), Character.class));
    }

    @Test
    public void passingInShortTopLevelThrows() {
        MapperTest.assertExceptionContains("Deserializing values to Short is not supported", () -> MapperTest.convertToCustomClass(1, Short.class));
    }

    @Test
    public void passingInByteTopLevelThrows() {
        MapperTest.assertExceptionContains("Deserializing values to Byte is not supported", () -> MapperTest.convertToCustomClass(1, Byte.class));
    }

    @Test
    public void passingInGenericBeanTopLevelThrows() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$GenericBean has generic type parameters, please use GenericTypeIndicator instead", () -> MapperTest.deserialize("{'value': 'foo'}", GenericBean.class));
    }

    @Test
    public void collectionsCanBeSerializedWhenList() {
        CollectionBean bean = new CollectionBean();
        bean.values = Collections.singletonList("foo");
        MapperTest.assertJson("{'values': ['foo']}", MapperTest.serialize(bean));
    }

    @Test
    public void collectionsCantBeSerializedWhenSet() {
        CollectionBean bean = new CollectionBean();
        bean.values = Collections.singleton("foo");
        MapperTest.assertExceptionContains("Serializing Collections is not supported, please use Lists instead (found in field 'values')", () -> MapperTest.serialize(bean));
    }

    @Test
    public void collectionsCantBeDeserialized() {
        MapperTest.assertExceptionContains("Collections are not supported, please use Lists instead (found in field 'values')", () -> MapperTest.deserialize("{'values': ['foo']}", CollectionBean.class));
    }

    @Test
    public void allowNullEverywhere() {
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, Integer.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, String.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, Double.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, Long.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, Boolean.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, StringBean.class));
        Assert.assertNull((Object)MapperTest.convertToCustomClass(null, Object.class));
    }

    @Test
    public void serializingGenericBeansSupported() {
        GenericBean stringBean = new GenericBean();
        stringBean.value = "foo";
        MapperTest.assertJson("{'value': 'foo'}", MapperTest.serialize(stringBean));
        GenericBean mapBean = new GenericBean();
        mapBean.value = Collections.singletonMap("foo", "bar");
        MapperTest.assertJson("{'value': {'foo': 'bar'}}", MapperTest.serialize(mapBean));
        GenericBean listBean = new GenericBean();
        listBean.value = Collections.singletonList("foo");
        MapperTest.assertJson("{'value': ['foo']}", MapperTest.serialize(listBean));
        GenericBean recursiveBean = new GenericBean();
        recursiveBean.value = new GenericBean();
        ((GenericBean)recursiveBean.value).value = "foo";
        MapperTest.assertJson("{'value': {'value': 'foo'}}", MapperTest.serialize(recursiveBean));
        DoubleGenericBean doubleBean = new DoubleGenericBean();
        doubleBean.valueA = "foo";
        doubleBean.valueB = 1.0;
        MapperTest.assertJson("{'valueB': 1, 'valueA': 'foo'}", MapperTest.serialize(doubleBean));
    }

    @Test
    public void deserializingWrongTypeThrows() {
        MapperTest.assertExceptionContains("Failed to convert a value of type java.lang.String to int (found in field 'value')", () -> MapperTest.deserialize("{'value': 'foo'}", WrongTypeBean.class));
    }

    @Test
    public void serializingWrongTypeWorks() {
        WrongTypeBean bean = new WrongTypeBean();
        bean.value = 1;
        MapperTest.assertJson("{'value': '1'}", MapperTest.serialize(bean));
    }

    @Test
    public void excludedFieldsAreExcluded() {
        ExcludedBean bean = new ExcludedBean();
        MapperTest.assertJson("{'includedGetter': 'no-value'}", MapperTest.serialize(bean));
    }

    @Test
    public void excludedFieldsAreNotParsed() {
        ExcludedBean bean = MapperTest.deserialize("{'includedGetter': 'foo', 'excludedField': 'bar', 'excludedGetter': 'qux'}", ExcludedBean.class);
        Assert.assertEquals((Object)"no-value", (Object)bean.excludedField);
        Assert.assertEquals((Object)"no-value", (Object)bean.excludedGetter);
        Assert.assertEquals((Object)"foo", (Object)bean.getIncludedGetter());
    }

    @Test
    public void excludedSettersAreIgnored() {
        ExcludedSetterBean bean = MapperTest.deserialize("{'value': 'foo'}", ExcludedSetterBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.value);
    }

    @Test
    public void propertyNamesAreSerialized() {
        PropertyNameBean bean = new PropertyNameBean();
        bean.key = "foo";
        bean.setValue("bar");
        MapperTest.assertJson("{'my_key': 'foo', 'my_value': 'bar'}", MapperTest.serialize(bean));
    }

    @Test
    public void propertyNamesAreParsed() {
        PropertyNameBean bean = MapperTest.deserialize("{'my_key': 'foo', 'my_value': 'bar'}", PropertyNameBean.class);
        Assert.assertEquals((Object)"foo", (Object)bean.key);
        Assert.assertEquals((Object)"bar", (Object)bean.getValue());
    }

    @Test
    public void staticFieldsAreNotParsed() {
        StaticFieldBean bean = MapperTest.deserialize("{'value1': 'foo', 'value2': 'bar'}", StaticFieldBean.class);
        Assert.assertEquals((Object)"static-value", (Object)StaticFieldBean.value1);
        Assert.assertEquals((Object)"bar", (Object)bean.value2);
    }

    @Test
    public void staticFieldsAreNotSerialized() {
        StaticFieldBean bean = new StaticFieldBean();
        bean.value2 = "foo";
        MapperTest.assertJson("{'value2': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void staticSettersAreNotUsed() {
        StaticMethodBean bean = MapperTest.deserialize("{'value1': 'foo', 'value2': 'bar'}", StaticMethodBean.class);
        Assert.assertEquals((Object)"static-value", (Object)StaticMethodBean.value1);
        Assert.assertEquals((Object)"bar", (Object)bean.value2);
    }

    @Test
    public void staticMethodsAreNotSerialized() {
        StaticMethodBean bean = new StaticMethodBean();
        bean.value2 = "foo";
        MapperTest.assertJson("{'value2': 'foo'}", MapperTest.serialize(bean));
    }

    @Test
    public void enumsAreSerialized() {
        EnumBean bean = new EnumBean();
        bean.enumField = SimpleEnum.Bar;
        bean.complexEnum = ComplexEnum.One;
        bean.enumUsingPropertyName = ComplexEnum.THREE;
        bean.pathologicalEnum = PathologicalEnum.One;
        bean.setEnumValue(SimpleEnum.Foo);
        MapperTest.assertJson("{'enumField': 'Bar', 'enumValue': 'Foo', 'complexEnum': 'One', 'enumUsingPropertyName': 'Three', 'pathologicalEnum': 'Two'}", MapperTest.serialize(bean));
    }

    @Test
    public void enumsAreParsed() {
        String json = "{'enumField': 'Bar', 'enumValue': 'Foo', 'complexEnum': 'One', 'enumUsingPropertyName': 'Three', 'pathologicalEnum': 'Two'}";
        EnumBean bean = MapperTest.deserialize(json, EnumBean.class);
        Assert.assertEquals((Object)((Object)bean.enumField), (Object)((Object)SimpleEnum.Bar));
        Assert.assertEquals((Object)((Object)bean.enumValue), (Object)((Object)SimpleEnum.Foo));
        Assert.assertEquals((Object)((Object)bean.complexEnum), (Object)((Object)ComplexEnum.One));
        Assert.assertEquals((Object)((Object)bean.enumUsingPropertyName), (Object)((Object)ComplexEnum.THREE));
        Assert.assertEquals((Object)((Object)bean.pathologicalEnum), (Object)((Object)PathologicalEnum.One));
    }

    @Test
    public void enumsCanBeParsedToNull() {
        String json = "{'enumField': null}";
        EnumBean bean = MapperTest.deserialize(json, EnumBean.class);
        Assert.assertNull((Object)((Object)bean.enumField));
        Assert.assertNull((Object)((Object)bean.enumValue));
        Assert.assertNull((Object)((Object)bean.complexEnum));
    }

    @Test
    public void throwsOnUnmatchedEnums() {
        String json = "{'enumField': 'Unavailable', 'enumValue': 'Foo', 'complexEnum': 'One'}";
        MapperTest.assertExceptionContains("Could not find enum value of com.google.cloud.firestore.MapperTest$SimpleEnum for value \"Unavailable\" (found in field 'enumField')", () -> MapperTest.deserialize("{'enumField': 'Unavailable', 'enumValue': 'Foo', 'complexEnum': 'One'}", EnumBean.class));
    }

    @Test
    public void inheritedFieldsAndGettersAreSerialized() {
        FinalBean bean = new FinalBean();
        bean.finalValue = "final-value";
        bean.inheritedValue = "inherited-value";
        bean.baseValue = "base-value";
        bean.overrideValue = "override-value";
        bean.classPrivateValue = "private-value";
        bean.packageBaseValue = "package-base-value";
        bean.setFinalMethod("final-method");
        bean.setInheritedMethod("inherited-method");
        bean.setBaseMethod("base-method");
        MapperTest.assertJson("{'baseValue': 'base-value', 'baseMethod': 'base-method', 'classPrivateValue': 'private-value', 'finalMethod': 'final-method', 'finalValue': 'final-value', 'inheritedMethod': 'inherited-method', 'inheritedValue': 'inherited-value', 'overrideValue': 'override-value-final', 'packageBaseValue': 'package-base-value'}", MapperTest.serialize(bean));
    }

    @Test
    public void inheritedFieldsAndSettersAreParsed() {
        String bean = "{'baseValue': 'base-value', 'baseMethod': 'base-method', 'classPrivateValue': 'private-value', 'finalMethod': 'final-method', 'finalValue': 'final-value', 'inheritedMethod': 'inherited-method', 'inheritedValue': 'inherited-value', 'overrideValue': 'override-value', 'packageBaseValue': 'package-base-value'}";
        FinalBean finalBean = MapperTest.deserialize(bean, FinalBean.class);
        Assert.assertEquals((Object)"base-value", (Object)finalBean.baseValue);
        Assert.assertEquals((Object)"inherited-value", (Object)finalBean.inheritedValue);
        Assert.assertEquals((Object)"final-value", (Object)finalBean.finalValue);
        Assert.assertEquals((Object)"base-method", (Object)finalBean.getBaseMethod());
        Assert.assertEquals((Object)"inherited-method", (Object)finalBean.getInheritedMethod());
        Assert.assertEquals((Object)"final-method", (Object)finalBean.getFinalMethod());
        Assert.assertEquals((Object)"override-value-final", (Object)finalBean.overrideValue);
        Assert.assertEquals((Object)"private-value", (Object)finalBean.classPrivateValue);
        Assert.assertNull((Object)((InheritedBean)finalBean).classPrivateValue);
        Assert.assertNull((Object)((BaseBean)finalBean).classPrivateValue);
        InheritedBean inheritedBean = MapperTest.deserialize(bean, InheritedBean.class);
        Assert.assertEquals((Object)"base-value", (Object)inheritedBean.baseValue);
        Assert.assertEquals((Object)"inherited-value", (Object)inheritedBean.inheritedValue);
        Assert.assertEquals((Object)"base-method", (Object)inheritedBean.getBaseMethod());
        Assert.assertEquals((Object)"inherited-method", (Object)inheritedBean.getInheritedMethod());
        Assert.assertEquals((Object)"override-value-inherited", (Object)inheritedBean.overrideValue);
        Assert.assertEquals((Object)"private-value", (Object)inheritedBean.classPrivateValue);
        Assert.assertNull((Object)((BaseBean)inheritedBean).classPrivateValue);
        BaseBean baseBean = MapperTest.deserialize(bean, BaseBean.class);
        Assert.assertEquals((Object)"base-value", (Object)baseBean.baseValue);
        Assert.assertEquals((Object)"base-method", (Object)baseBean.getBaseMethod());
        Assert.assertEquals((Object)"override-value", (Object)baseBean.overrideValue);
        Assert.assertEquals((Object)"private-value", (Object)baseBean.classPrivateValue);
    }

    @Test
    public void settersFromSubclassConflictsWithBaseClass() {
        ConflictingSetterSubBean bean = new ConflictingSetterSubBean();
        bean.value = 1;
        MapperTest.assertExceptionContains("Found conflicting setters with name: setValue (conflicts with setValue defined on com.google.cloud.firestore.MapperTest$ConflictingSetterSubBean)", () -> MapperTest.serialize(bean));
    }

    @Test
    public void settersFromSubclassConflictsWithBaseClass2() {
        ConflictingSetterSubBean2 bean = new ConflictingSetterSubBean2();
        bean.value = 1;
        MapperTest.assertExceptionContains("Found conflicting setters with name: setValue (conflicts with setValue defined on com.google.cloud.firestore.MapperTest$ConflictingSetterSubBean2)", () -> MapperTest.serialize(bean));
    }

    @Test
    public void settersCanOverridePrimitiveSettersSerializing() {
        NonConflictingSetterSubBean bean = new NonConflictingSetterSubBean();
        bean.value = 1;
        MapperTest.assertJson("{'value': 1}", MapperTest.serialize(Collections.singletonMap("value", 1.0)));
    }

    @Test
    public void settersCanOverridePrimitiveSettersParsing() {
        NonConflictingSetterSubBean bean = MapperTest.deserialize("{'value': 2}", NonConflictingSetterSubBean.class);
        Assert.assertEquals((long)-2L, (long)bean.value);
    }

    @Test
    public void genericSettersFromSubclassConflictsWithBaseClass() {
        ConflictingGenericSetterSubBean bean = new ConflictingGenericSetterSubBean();
        bean.value = "hello";
        MapperTest.assertExceptionContains("Found conflicting setters with name: setValue (conflicts with setValue defined on com.google.cloud.firestore.MapperTest$ConflictingGenericSetterSubBean)", () -> MapperTest.serialize(bean));
    }

    @Test
    public void settersCanOverrideGenericSettersParsingNot() {
        MapperTest.assertExceptionContains("Class com.google.cloud.firestore.MapperTest$NonConflictingGenericSetterSubBean has multiple setter overloads", () -> {
            NonConflictingGenericSetterSubBean bean = MapperTest.deserialize("{'value': 'value'}", NonConflictingGenericSetterSubBean.class);
            Assert.assertEquals((Object)"subsetter:value", (Object)bean.value);
        });
    }

    @Test
    public void serializingRecursiveBeanThrows() {
        ObjectBean bean = new ObjectBean();
        bean.value = bean;
        MapperTest.assertExceptionContains("Exceeded maximum depth of 500, which likely indicates there's an object cycle", () -> MapperTest.serialize(bean));
    }

    @Test
    public void serializationFailureIncludesPath() {
        ObjectBean innerBean = new ObjectBean();
        innerBean.value = Collections.singletonMap("short", (short)1);
        ObjectBean outerBean = new ObjectBean();
        outerBean.value = Collections.singletonMap("inner", innerBean);
        try {
            MapperTest.serialize(outerBean);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Could not serialize object. Numbers of type Short are not supported, please use an int, long, float, double or BigDecimal (found in field 'value.inner.value.short')", (Object)e.getMessage());
        }
    }

    @Test
    public void deserializationFailureIncludesPath() {
        Map<String, Short> serialized = Collections.singletonMap("value", (short)1);
        try {
            MapperTest.convertToCustomClass(serialized, ShortBean.class);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Could not deserialize object. Deserializing values to short is not supported (found in field 'value')", (Object)e.getMessage());
        }
    }

    @Test
    public void documentIdAnnotateWrongTypeThrows() {
        String expectedErrorMessage = "instead of String or DocumentReference";
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.serialize(new FieldWithDocumentIdOnWrongTypeBean()));
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.deserialize("{'intField': 1}", FieldWithDocumentIdOnWrongTypeBean.class));
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.serialize(new GetterWithDocumentIdOnWrongTypeBean()));
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.deserialize("{'intField': 1}", GetterWithDocumentIdOnWrongTypeBean.class));
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.serialize(new PropertyWithDocumentIdOnWrongTypeBean()));
        MapperTest.assertExceptionContains("instead of String or DocumentReference", () -> MapperTest.deserialize("{'intField': 1}", PropertyWithDocumentIdOnWrongTypeBean.class));
    }

    @Test
    public void documentIdAnnotateReadOnlyThrows() {
        String expectedErrorMessage = "but no field or public setter was found";
        GetterWithoutBackingFieldOnDocumentIdBean bean = new GetterWithoutBackingFieldOnDocumentIdBean();
        MapperTest.assertExceptionContains("but no field or public setter was found", () -> MapperTest.serialize(bean));
        MapperTest.assertExceptionContains("but no field or public setter was found", () -> MapperTest.deserialize("{'docId': 'id'}", GetterWithoutBackingFieldOnDocumentIdBean.class));
    }

    @Test
    public void documentIdsDeserialize() {
        DocumentReference ref = new DocumentReference((FirestoreRpcContext)this.firestoreMock, ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)"test-project", (String)"(default)"), (ImmutableList)ImmutableList.of((Object)"coll", (Object)"doc123")));
        Assert.assertEquals((Object)"doc123", (Object)MapperTest.deserialize((String)"{}", DocumentIdOnStringField.class, (DocumentReference)ref).docId);
        Assert.assertEquals((Object)"doc123", (Object)MapperTest.deserialize(Collections.singletonMap("property", Integer.valueOf((int)100)), DocumentIdOnStringField.class, (DocumentReference)ref).docId);
        DocumentIdOnStringFieldAsProperty target = MapperTest.deserialize("{'anotherProperty': 100}", DocumentIdOnStringFieldAsProperty.class, ref);
        Assert.assertEquals((Object)"doc123", (Object)target.docId);
        Assert.assertEquals((long)100L, (long)target.someOtherProperty);
        Assert.assertEquals((Object)ref, (Object)MapperTest.deserialize("{}", DocumentIdOnDocRefGetter.class, ref).getDocRef());
        DocumentIdOnInheritedDocRefSetter target1 = MapperTest.deserialize("{}", DocumentIdOnInheritedDocRefSetter.class, ref);
        Assert.assertEquals((Object)ref, (Object)target1.getInheritedDocRef());
        Assert.assertEquals((Object)ref, (Object)target1.getDocRef());
        Assert.assertEquals((Object)"doc123", (Object)MapperTest.deserialize((String)"{'nestedDocIdHolder': {}}", DocumentIdOnNestedObjects.class, (DocumentReference)ref).nestedDocIdHolder.docId);
    }

    @Test
    public void documentIdsRoundTrip() {
        DocumentReference ref = new DocumentReference((FirestoreRpcContext)this.firestoreMock, ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)"test-project", (String)"(default)"), (ImmutableList)ImmutableList.of((Object)"coll", (Object)"doc123")));
        Assert.assertEquals(Collections.emptyMap(), (Object)MapperTest.serialize(MapperTest.deserialize("{}", DocumentIdOnStringField.class, ref)));
        Assert.assertEquals(Collections.singletonMap("anotherProperty", 100), (Object)MapperTest.serialize(MapperTest.deserialize("{'anotherProperty': 100}", DocumentIdOnStringFieldAsProperty.class, ref)));
        Assert.assertEquals(Collections.emptyMap(), (Object)MapperTest.serialize(MapperTest.deserialize("{}", DocumentIdOnDocRefGetter.class, ref)));
        Assert.assertEquals(Collections.emptyMap(), (Object)MapperTest.serialize(MapperTest.deserialize("{}", DocumentIdOnInheritedDocRefSetter.class, ref)));
        Assert.assertEquals(Collections.singletonMap("nestedDocIdHolder", Collections.emptyMap()), (Object)MapperTest.serialize(MapperTest.deserialize("{'nestedDocIdHolder': {}}", DocumentIdOnNestedObjects.class, ref)));
    }

    @Test
    public void documentIdsDeserializeConflictThrows() {
        String expectedErrorMessage = "cannot apply @DocumentId on this property";
        DocumentReference ref = new DocumentReference((FirestoreRpcContext)this.firestoreMock, ResourcePath.create((DatabaseRootName)DatabaseRootName.of((String)"test-project", (String)"(default)"), (ImmutableList)ImmutableList.of((Object)"coll", (Object)"doc123")));
        MapperTest.assertExceptionContains("cannot apply @DocumentId on this property", () -> MapperTest.deserialize("{'docId': 'toBeOverwritten'}", DocumentIdOnStringField.class, ref));
        MapperTest.assertExceptionContains("cannot apply @DocumentId on this property", () -> MapperTest.deserialize("{'docIdProperty': 'toBeOverwritten', 'anotherProperty': 100}", DocumentIdOnStringFieldAsProperty.class, ref));
        MapperTest.assertExceptionContains("cannot apply @DocumentId on this property", () -> MapperTest.deserialize("{'nestedDocIdHolder': {'docId': 'toBeOverwritten'}}", DocumentIdOnNestedObjects.class, ref));
    }

    private static class StringBean {
        private String value;

        private StringBean() {
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class BooleanBean {
        private boolean value;

        private BooleanBean() {
        }

        public boolean isValue() {
            return this.value;
        }
    }

    private static class DoubleBean {
        private double value;

        private DoubleBean() {
        }

        public double getValue() {
            return this.value;
        }
    }

    private static class BigDecimalBean {
        private BigDecimal value;

        private BigDecimalBean() {
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigDecimalBean bean = (BigDecimalBean)o;
            return Objects.equals(this.value, bean.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class FloatBean {
        private float value;

        private FloatBean() {
        }

        public float getValue() {
            return this.value;
        }
    }

    private static class IntBean {
        private int value;

        private IntBean() {
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class LongBean {
        private long value;

        private LongBean() {
        }

        public long getValue() {
            return this.value;
        }
    }

    private static class PublicFieldBean {
        public String value;

        private PublicFieldBean() {
        }
    }

    private static class PublicPrivateFieldBean {
        public String value1;
        String value2;
        private String value3;

        private PublicPrivateFieldBean() {
        }
    }

    private static class PackageGetterBean {
        private String packageValue;
        private String publicValue;

        private PackageGetterBean() {
        }

        String getPackageValue() {
            return this.packageValue;
        }

        public String getPublicValue() {
            return this.publicValue;
        }
    }

    private static class XMLAndURLBean {
        private String XMLAndURL1;
        public String XMLAndURL2;

        private XMLAndURLBean() {
        }

        public String getXMLAndURL1() {
            return this.XMLAndURL1;
        }

        public void setXMLAndURL1(String value) {
            this.XMLAndURL1 = value;
        }
    }

    private static class AllCapsDefaultHandlingBean {
        private String UUID;

        private AllCapsDefaultHandlingBean() {
        }

        public String getUUID() {
            return this.UUID;
        }

        public void setUUID(String value) {
            this.UUID = value;
        }
    }

    private static class AllCapsWithPropertyName {
        private String UUID;

        private AllCapsWithPropertyName() {
        }

        @PropertyName(value="UUID")
        public String getUUID() {
            return this.UUID;
        }

        @PropertyName(value="UUID")
        public void setUUID(String value) {
            this.UUID = value;
        }
    }

    private static class SetterBean {
        private String value;

        private SetterBean() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = "setter:" + value;
        }
    }

    private static class PrivateSetterBean {
        public String value;

        private PrivateSetterBean() {
        }

        private void setValue(String value) {
            this.value = "setter:" + value;
        }
    }

    private static class CaseSensitiveSetterBean3 {
        private String value;

        private CaseSensitiveSetterBean3() {
        }

        public String getValue() {
            return this.value;
        }

        public void setvalue(String value) {
            this.value = "setter:" + value;
        }
    }

    private static class CaseSensitiveSetterBean4 {
        private String value;

        private CaseSensitiveSetterBean4() {
        }

        public String getValue() {
            return this.value;
        }

        public void setVALUE(String value) {
            this.value = "setter:" + value;
        }
    }

    private static class CaseSensitiveSetterBean5 {
        private String value;

        private CaseSensitiveSetterBean5() {
        }

        public String getValue() {
            return this.value;
        }

        public void SETVALUE(String value) {
            this.value = "wrong setter!";
        }
    }

    private static class WrongSetterBean {
        private String value;

        private WrongSetterBean() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue() {
            this.value = "wrong setter!";
        }

        public void setValue(String one, String two) {
            this.value = "wrong setter!";
        }
    }

    private static class NestedBean {
        private StringBean bean;

        private NestedBean() {
        }

        public StringBean getBean() {
            return this.bean;
        }
    }

    private static class ListBean {
        private List<String> values;

        private ListBean() {
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    private static class MapBean {
        private Map<String, String> values;

        private MapBean() {
        }

        public Map<String, String> getValues() {
            return this.values;
        }
    }

    private static class UpperBoundedMapBean {
        private Map<String, ? extends Date> values;

        private UpperBoundedMapBean() {
        }

        public Map<String, ? extends Date> getValues() {
            return this.values;
        }
    }

    private static class MultiBoundedMapHolderBean {
        private MultiBoundedMapBean<Date> map;

        private MultiBoundedMapHolderBean() {
        }

        public MultiBoundedMapBean<Date> getMap() {
            return this.map;
        }
    }

    private static class MultiBoundedMapBean<T extends Date> {
        private Map<String, T> values;

        private MultiBoundedMapBean() {
        }

        public Map<String, T> getValues() {
            return this.values;
        }
    }

    private static class UnboundedMapBean {
        private Map<String, ?> values;

        private UnboundedMapBean() {
        }

        public Map<String, ?> getValues() {
            return this.values;
        }
    }

    private static class UnboundedTypeVariableMapHolderBean {
        private UnboundedTypeVariableMapBean<String> map;

        private UnboundedTypeVariableMapHolderBean() {
        }

        public UnboundedTypeVariableMapBean<String> getMap() {
            return this.map;
        }
    }

    private static class UnboundedTypeVariableMapBean<T> {
        private Map<String, T> values;

        private UnboundedTypeVariableMapBean() {
        }

        public Map<String, T> getValues() {
            return this.values;
        }
    }

    private static class NestedListBean {
        private List<StringBean> values;

        private NestedListBean() {
        }

        public List<StringBean> getValues() {
            return this.values;
        }
    }

    private static class NestedMapBean {
        private Map<String, StringBean> values;

        private NestedMapBean() {
        }

        public Map<String, StringBean> getValues() {
            return this.values;
        }
    }

    @ThrowOnExtraProperties
    private static class PrivateFieldBean {
        private String value;

        private PrivateFieldBean() {
        }
    }

    @ThrowOnExtraProperties
    private static class PackageFieldBean {
        String value;

        private PackageFieldBean() {
        }
    }

    private static class GetterBean {
        private String value;

        private GetterBean() {
        }

        public String getValue() {
            return "getter:" + this.value;
        }
    }

    @ThrowOnExtraProperties
    private static class GetterBeanNoField {
        private GetterBeanNoField() {
        }

        public String getValue() {
            return "getter:value";
        }
    }

    private static class GetterPublicFieldBean {
        public String value;

        private GetterPublicFieldBean() {
        }

        public String getValue() {
            return "getter:" + this.value;
        }
    }

    private static class GetterPublicFieldBeanCaseSensitive {
        public String valueCase;

        private GetterPublicFieldBeanCaseSensitive() {
        }

        public String getValueCASE() {
            return "getter:" + this.valueCase;
        }
    }

    private static class CaseSensitiveGetterBean1 {
        private String value;

        private CaseSensitiveGetterBean1() {
        }

        public String getVALUE() {
            return this.value;
        }
    }

    private static class CaseSensitiveGetterBean2 {
        private String value;

        private CaseSensitiveGetterBean2() {
        }

        public String getvalue() {
            return this.value;
        }
    }

    private static class CaseSensitiveGetterBean3 {
        private String value;

        private CaseSensitiveGetterBean3() {
        }

        public String getVAlue() {
            return this.value;
        }
    }

    private static class CaseSensitiveGetterBean4 {
        private String value;

        private CaseSensitiveGetterBean4() {
        }

        public String getvaLUE() {
            return this.value;
        }
    }

    private static class IllegalKeyMapBean {
        private Map<Integer, StringBean> values;

        private IllegalKeyMapBean() {
        }

        public Map<Integer, StringBean> getValues() {
            return this.values;
        }
    }

    private static class TwoGetterBean {
        private String value;

        private TwoGetterBean() {
        }

        public String getValue() {
            return this.value;
        }

        public String getVALUE() {
            return this.value;
        }
    }

    private static class GetterArgumentsBean {
        private String value;

        private GetterArgumentsBean() {
        }

        public String getValue1() {
            return this.value + "1";
        }

        public void getValue2() {
        }

        public String getValue3(boolean flag) {
            return this.value + "3";
        }

        public String getValue4() {
            return this.value + "4";
        }
    }

    private static class CaseSensitiveFieldBean1 {
        public String VALUE;

        private CaseSensitiveFieldBean1() {
        }
    }

    private static class CaseSensitiveFieldBean2 {
        public String value;

        private CaseSensitiveFieldBean2() {
        }
    }

    private static class CaseSensitiveFieldBean3 {
        public String Value;

        private CaseSensitiveFieldBean3() {
        }
    }

    private static class CaseSensitiveFieldBean4 {
        public String valUE;

        private CaseSensitiveFieldBean4() {
        }
    }

    private static class UnicodeBean {
        private String \u6f22\u5b57;

        private UnicodeBean() {
        }

        public String get\u6f22\u5b57() {
            return this.\u6f22\u5b57;
        }
    }

    private static class ShortBean {
        private short value;

        private ShortBean() {
        }

        public short getValue() {
            return this.value;
        }
    }

    private static class ByteBean {
        private byte value;

        private ByteBean() {
        }

        public byte getValue() {
            return this.value;
        }
    }

    private static class CharBean {
        private char value;

        private CharBean() {
        }

        public char getValue() {
            return this.value;
        }
    }

    private static class IntArrayBean {
        private int[] values;

        private IntArrayBean() {
        }

        public int[] getValues() {
            return this.values;
        }

        static /* synthetic */ int[] access$8702(IntArrayBean x0, int[] x1) {
            x0.values = x1;
            return x1;
        }
    }

    private static class StringArrayBean {
        private String[] values;

        private StringArrayBean() {
        }

        public String[] getValues() {
            return this.values;
        }

        static /* synthetic */ String[] access$8902(StringArrayBean x0, String[] x1) {
            x0.values = x1;
            return x1;
        }
    }

    private static class PublicConstructorBean {
        private String value;

        public String getValue() {
            return this.value;
        }
    }

    private static class PrivateConstructorBean {
        private String value;

        private PrivateConstructorBean() {
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class PackageConstructorBean {
        private Timestamp value;

        PackageConstructorBean() {
        }

        public Timestamp getValue() {
            return this.value;
        }
    }

    private static class MultipleConstructorBean {
        private String value;

        public MultipleConstructorBean(String value) {
            this.value = "wrong-value";
        }

        public MultipleConstructorBean() {
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ObjectBean {
        private Object value;

        private ObjectBean() {
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class CollectionBean {
        private Collection<String> values;

        private CollectionBean() {
        }

        public Collection<String> getValues() {
            return this.values;
        }
    }

    private static class GenericBean<B> {
        private B value;

        private GenericBean() {
        }

        public B getValue() {
            return this.value;
        }
    }

    private static class DoubleGenericBean<A, B> {
        private A valueA;
        private B valueB;

        private DoubleGenericBean() {
        }

        public A getValueA() {
            return this.valueA;
        }

        public B getValueB() {
            return this.valueB;
        }
    }

    private static class WrongTypeBean {
        private Integer value;

        private WrongTypeBean() {
        }

        public String getValue() {
            return "" + this.value;
        }
    }

    private static class ExcludedBean {
        @Exclude
        public String excludedField = "no-value";
        private String excludedGetter = "no-value";
        private String includedGetter = "no-value";

        private ExcludedBean() {
        }

        @Exclude
        public String getExcludedGetter() {
            return this.excludedGetter;
        }

        public String getIncludedGetter() {
            return this.includedGetter;
        }
    }

    private static class ExcludedSetterBean {
        private String value;

        private ExcludedSetterBean() {
        }

        public String getValue() {
            return this.value;
        }

        @Exclude
        public void setValue(String value) {
            this.value = "wrong setter";
        }
    }

    private static class PropertyNameBean {
        @PropertyName(value="my_key")
        public String key;
        private String value;

        private PropertyNameBean() {
        }

        @PropertyName(value="my_value")
        public String getValue() {
            return this.value;
        }

        @PropertyName(value="my_value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class StaticFieldBean {
        public static String value1 = "static-value";
        public String value2;

        private StaticFieldBean() {
        }
    }

    private static class StaticMethodBean {
        private static String value1 = "static-value";
        public String value2;

        private StaticMethodBean() {
        }

        public static String getValue1() {
            return value1;
        }

        public static void setValue1(String value1) {
            StaticMethodBean.value1 = value1;
        }
    }

    private static class EnumBean {
        public SimpleEnum enumField;
        private SimpleEnum enumValue;
        public ComplexEnum complexEnum;
        public ComplexEnum enumUsingPropertyName;
        public PathologicalEnum pathologicalEnum;

        private EnumBean() {
        }

        public SimpleEnum getEnumValue() {
            return this.enumValue;
        }

        public void setEnumValue(SimpleEnum enumValue) {
            this.enumValue = enumValue;
        }
    }

    private static enum SimpleEnum {
        Foo,
        Bar;

    }

    private static enum ComplexEnum {
        One("one"),
        Two("two"),
        THREE("three");

        private final String value;

        private ComplexEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static enum PathologicalEnum {
        One,
        Two;

    }

    private static final class FinalBean
    extends InheritedBean {
        public String finalValue;
        private String finalMethodValue;
        private String classPrivateValue;

        private FinalBean() {
        }

        @Override
        public String getClassPrivateValue() {
            return this.classPrivateValue;
        }

        public String getFinalMethod() {
            return this.finalMethodValue;
        }

        public void setFinalMethod(String value) {
            this.finalMethodValue = value;
        }

        @Override
        public String getOverrideValue() {
            return this.overrideValue + "-final";
        }

        @Override
        public void setOverrideValue(String value) {
            this.overrideValue = value + "-final";
        }
    }

    private static class InheritedBean
    extends BaseBean {
        public String inheritedValue;
        private String inheritedMethodValue;
        private String classPrivateValue;

        private InheritedBean() {
        }

        @Override
        public String getClassPrivateValue() {
            return this.classPrivateValue;
        }

        public String getInheritedMethod() {
            return this.inheritedMethodValue;
        }

        public void setInheritedMethod(String value) {
            this.inheritedMethodValue = value;
        }

        public String getOverrideValue() {
            return this.overrideValue + "-inherited";
        }

        public void setOverrideValue(String value) {
            this.overrideValue = value + "-inherited";
        }
    }

    private static class BaseBean {
        public String baseValue;
        public String overrideValue;
        String packageBaseValue;
        private String baseMethodValue;
        private String classPrivateValue;

        private BaseBean() {
        }

        public String getClassPrivateValue() {
            return this.classPrivateValue;
        }

        public String getBaseMethod() {
            return this.baseMethodValue;
        }

        public String getPackageBaseValue() {
            return this.packageBaseValue;
        }

        public void setBaseMethod(String value) {
            this.baseMethodValue = value;
        }
    }

    private static class ConflictingSetterSubBean
    extends ConflictingSetterBean {
        private ConflictingSetterSubBean() {
        }

        public void setValue(String value) {
            this.value = -1;
        }
    }

    private static class ConflictingSetterSubBean2
    extends ConflictingSetterBean {
        private ConflictingSetterSubBean2() {
        }

        public void setValue(Integer value) {
            this.value = -1;
        }
    }

    private static class NonConflictingSetterSubBean
    extends ConflictingSetterBean {
        private NonConflictingSetterSubBean() {
        }

        @Override
        public void setValue(int value) {
            this.value = value * -1;
        }
    }

    private static class ConflictingGenericSetterSubBean<T>
    extends GenericSetterBaseBean<T> {
        private ConflictingGenericSetterSubBean() {
        }

        @Override
        public void setValue(String value) {
        }
    }

    private static class GetterWithoutBackingFieldOnDocumentIdBean {
        private GetterWithoutBackingFieldOnDocumentIdBean() {
        }

        @DocumentId
        public String getDocId() {
            return "doc-id";
        }
    }

    private static class DocumentIdOnStringField {
        @DocumentId
        public String docId = "doc-id";

        private DocumentIdOnStringField() {
        }
    }

    private static class DocumentIdOnStringFieldAsProperty {
        @PropertyName(value="docIdProperty")
        @DocumentId
        public String docId = "doc-id";
        @PropertyName(value="anotherProperty")
        public int someOtherProperty = 0;

        private DocumentIdOnStringFieldAsProperty() {
        }
    }

    private static class DocumentIdOnDocRefGetter {
        private DocumentReference docRef;

        private DocumentIdOnDocRefGetter() {
        }

        @DocumentId
        public DocumentReference getDocRef() {
            return this.docRef;
        }

        public void setDocRef(DocumentReference ref) {
            this.docRef = ref;
        }
    }

    private static class DocumentIdOnInheritedDocRefSetter
    extends DocumentIdOnDocRefGetter {
        private DocumentReference inheritedDocRef;

        private DocumentIdOnInheritedDocRefSetter() {
        }

        @DocumentId
        public DocumentReference getInheritedDocRef() {
            return this.inheritedDocRef;
        }

        public void setInheritedDocRef(DocumentReference ref) {
            this.inheritedDocRef = ref;
        }
    }

    private static class DocumentIdOnNestedObjects {
        @PropertyName(value="nestedDocIdHolder")
        public DocumentIdOnStringField nestedDocIdHolder;

        private DocumentIdOnNestedObjects() {
        }
    }

    private static class PropertyWithDocumentIdOnWrongTypeBean {
        @PropertyName(value="intField")
        @DocumentId
        public int intField = 100;

        private PropertyWithDocumentIdOnWrongTypeBean() {
        }
    }

    private static class GetterWithDocumentIdOnWrongTypeBean {
        private final int intField = 100;

        private GetterWithDocumentIdOnWrongTypeBean() {
        }

        @DocumentId
        public int getIntField() {
            return 100;
        }
    }

    private static class FieldWithDocumentIdOnWrongTypeBean {
        @DocumentId
        public Integer intField;

        private FieldWithDocumentIdOnWrongTypeBean() {
        }
    }

    private static class NonConflictingGenericSetterSubBean
    extends GenericSetterBaseBean<String> {
        private NonConflictingGenericSetterSubBean() {
        }

        @Override
        public void setValue(String value) {
            this.value = "subsetter:" + value;
        }
    }

    private static class ArgConstructorBean {
        private String value;

        public ArgConstructorBean(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class CaseSensitiveSetterBean6 {
        private String value;

        private CaseSensitiveSetterBean6() {
        }

        public String getValue() {
            return this.value;
        }

        public void setVaLUE(String value) {
            this.value = "setter:" + value;
        }
    }

    private static class CaseSensitiveSetterBean2 {
        private String value;

        private CaseSensitiveSetterBean2() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = "setter:" + value;
        }

        public void setvalue(String value) {
            this.value = "wrong setter!";
        }
    }

    private static class CaseSensitiveSetterBean1 {
        private String value;

        private CaseSensitiveSetterBean1() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = "setter:" + value;
        }

        public void setVAlue(String value) {
            this.value = "wrong setter!";
        }
    }

    private static class TwoSetterBean {
        private String value;

        private TwoSetterBean() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = "string:" + value;
        }

        public void setValue(Integer value) {
            this.value = "int:" + value;
        }
    }

    @ThrowOnExtraProperties
    private static class ThrowOnUnknownPropertiesBean {
        public String value;

        private ThrowOnUnknownPropertiesBean() {
        }
    }

    private static class GenericSetterBaseBean<T> {
        public T value;

        private GenericSetterBaseBean() {
        }

        void setValue(T value) {
            this.value = value;
        }
    }

    private static class ConflictingSetterBean {
        public int value;

        private ConflictingSetterBean() {
        }

        void setValue(int value) {
            this.value = value;
        }
    }

    private static class SetBean {
        private Set<String> values;

        private SetBean() {
        }

        public Set<String> getValues() {
            return this.values;
        }
    }
}

