/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOpenTelemetryOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.EnabledTraceUtil;
import com.google.common.truth.Truth;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OpenTelemetryOptionsTest {
    @Nullable
    private Firestore firestore;

    @Before
    public void setUp() {
        GlobalOpenTelemetry.resetForTest();
    }

    @After
    public void tearDown() {
        if (this.firestore != null) {
            this.firestore.shutdown();
            this.firestore = null;
        }
    }

    FirestoreOptions.Builder getBaseOptions() {
        return ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setDatabaseId("(default)");
    }

    @Test
    public void defaultOptionsUsesEnabledTraceUtilWithNoopOpenTelemetry() {
        FirestoreOptions firestoreOptions = this.getBaseOptions().build();
        this.firestore = (Firestore)firestoreOptions.getService();
        Truth.assertThat((Object)((FirestoreOptions)this.firestore.getOptions()).getOpenTelemetryOptions().getOpenTelemetry()).isNull();
        Truth.assertThat((Object)((FirestoreOptions)this.firestore.getOptions()).getTraceUtil()).isNotNull();
        Truth.assertThat((Boolean)(((FirestoreOptions)this.firestore.getOptions()).getTraceUtil() instanceof EnabledTraceUtil)).isTrue();
        EnabledTraceUtil enabledTraceUtil = (EnabledTraceUtil)((FirestoreOptions)this.firestore.getOptions()).getTraceUtil();
        Truth.assertThat((Object)enabledTraceUtil.getOpenTelemetry().getTracerProvider()).isSameInstanceAs((Object)TracerProvider.noop());
    }

    @Test
    public void existenceOfGlobalOpenTelemetryEnablesTracingWithTheGlobalTracerProvider() {
        Resource resource = Resource.getDefault().merge(Resource.builder().put("service.name", "test").build());
        SdkTracerProvider myTracerProvider = SdkTracerProvider.builder().setResource(resource).build();
        OpenTelemetrySdk.builder().setTracerProvider(myTracerProvider).buildAndRegisterGlobal();
        FirestoreOptions firestoreOptions = this.getBaseOptions().build();
        this.firestore = (Firestore)firestoreOptions.getService();
        Truth.assertThat((Object)((FirestoreOptions)this.firestore.getOptions()).getOpenTelemetryOptions().getOpenTelemetry()).isNull();
        Truth.assertThat((Object)((FirestoreOptions)this.firestore.getOptions()).getTraceUtil()).isNotNull();
        Truth.assertThat((Boolean)(((FirestoreOptions)this.firestore.getOptions()).getTraceUtil() instanceof EnabledTraceUtil)).isTrue();
        EnabledTraceUtil enabledTraceUtil = (EnabledTraceUtil)((FirestoreOptions)this.firestore.getOptions()).getTraceUtil();
        Truth.assertThat((Boolean)enabledTraceUtil.getOpenTelemetry().getTracerProvider().equals(myTracerProvider));
    }

    @Test
    public void canPassOpenTelemetrySdkInstanceToFirestore() {
        Resource resource = Resource.getDefault().merge(Resource.builder().put("service.name", "test").build());
        SdkTracerProvider myTracerProvider = SdkTracerProvider.builder().setResource(resource).build();
        OpenTelemetrySdk myOpenTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(myTracerProvider).build();
        FirestoreOptions firestoreOptions = this.getBaseOptions().setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().setOpenTelemetry((OpenTelemetry)myOpenTelemetrySdk).build()).build();
        this.firestore = (Firestore)firestoreOptions.getService();
        Truth.assertThat((Object)((FirestoreOptions)this.firestore.getOptions()).getOpenTelemetryOptions().getOpenTelemetry()).isEqualTo((Object)myOpenTelemetrySdk);
        Truth.assertThat((Boolean)(((FirestoreOptions)this.firestore.getOptions()).getTraceUtil() instanceof EnabledTraceUtil)).isTrue();
        EnabledTraceUtil enabledTraceUtil = (EnabledTraceUtil)((FirestoreOptions)this.firestore.getOptions()).getTraceUtil();
        Truth.assertThat((Object)enabledTraceUtil).isNotNull();
        Truth.assertThat((Object)enabledTraceUtil.getOpenTelemetry()).isEqualTo((Object)myOpenTelemetrySdk);
        Truth.assertThat((Boolean)enabledTraceUtil.getOpenTelemetry().getTracerProvider().equals(myTracerProvider));
    }
}

