/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Order;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class OrderTest {
    @Test
    public void verifyOrder() {
        Value[][] groups = new Value[][]{{this.nullValue()}, {this.booleanValue(false)}, {this.booleanValue(true)}, {this.doubleValue(Double.NaN), this.doubleValue(Double.NaN)}, {this.doubleValue(Double.NEGATIVE_INFINITY)}, {this.intValue(-2147483649L)}, {this.intValue(Integer.MIN_VALUE)}, {this.doubleValue(-1.1)}, {this.intValue(-1L), this.doubleValue(-1.0)}, {this.doubleValue(-4.9E-324)}, {this.intValue(0L), this.doubleValue(-0.0), this.doubleValue(0.0), this.doubleValue(0.0)}, {this.doubleValue(Double.MIN_VALUE)}, {this.intValue(1L), this.doubleValue(1.0)}, {this.doubleValue(1.1)}, {this.intValue(Integer.MAX_VALUE)}, {this.intValue(0x80000000L)}, {this.doubleValue(Double.POSITIVE_INFINITY)}, {this.timestampValue(123L, 0)}, {this.timestampValue(123L, 123)}, {this.timestampValue(345L, 0)}, {this.stringValue("")}, {this.stringValue("\u0000\ud7ff\ue000\uffff")}, {this.stringValue("(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b")}, {this.stringValue("a")}, {this.stringValue("abc def")}, {this.stringValue("e\u0301b")}, {this.stringValue("\u00e6")}, {this.stringValue("\u00e9a")}, {this.blobValue(new byte[0])}, {this.blobValue(new byte[]{0})}, {this.blobValue(new byte[]{0, 1, 2, 3, 4})}, {this.blobValue(new byte[]{0, 1, 2, 4, 3})}, {this.blobValue(new byte[]{127})}, {this.referenceValue("projects/p1/databases/d1/documents/c1/doc1")}, {this.referenceValue("projects/p1/databases/d1/documents/c1/doc2")}, {this.referenceValue("projects/p1/databases/d1/documents/c1/doc2/c2/doc1")}, {this.referenceValue("projects/p1/databases/d1/documents/c1/doc2/c2/doc2")}, {this.referenceValue("projects/p1/databases/d1/documents/c10/doc1")}, {this.referenceValue("projects/p1/databases/d1/documents/c2/doc1")}, {this.referenceValue("projects/p2/databases/d2/documents/c1/doc1")}, {this.referenceValue("projects/p2/databases/d2/documents/c1-/doc1")}, {this.referenceValue("projects/p2/databases/d3/documents/c1-/doc1")}, {this.geoPointValue(-90.0, -180.0)}, {this.geoPointValue(-90.0, 0.0)}, {this.geoPointValue(-90.0, 180.0)}, {this.geoPointValue(0.0, -180.0)}, {this.geoPointValue(0.0, 0.0)}, {this.geoPointValue(0.0, 180.0)}, {this.geoPointValue(1.0, -180.0)}, {this.geoPointValue(1.0, 0.0)}, {this.geoPointValue(1.0, 180.0)}, {this.geoPointValue(90.0, -180.0)}, {this.geoPointValue(90.0, 0.0)}, {this.geoPointValue(90.0, 180.0)}, {this.arrayValue(new Value[0])}, {this.arrayValue(this.stringValue("bar"))}, {this.arrayValue(this.stringValue("foo"))}, {this.arrayValue(this.stringValue("foo"), this.intValue(0L))}, {this.arrayValue(this.stringValue("foo"), this.intValue(1L))}, {this.arrayValue(this.stringValue("foo"), this.stringValue("0"))}, {this.objectValue("bar", this.intValue(0L), new Object[0])}, {this.objectValue("bar", this.intValue(0L), "foo", this.intValue(1L))}, {this.objectValue("bar", this.intValue(1L), new Object[0])}, {this.objectValue("bar", this.intValue(2L), new Object[0])}, {this.objectValue("bar", this.stringValue("0"), new Object[0])}};
        for (int left = 0; left < groups.length; ++left) {
            for (int right = 0; right < groups.length; ++right) {
                for (int i = 0; i < groups[left].length; ++i) {
                    for (int j = 0; j < groups[right].length; ++j) {
                        Assert.assertEquals((String)String.format("Order does not match for: groups[%d][%d] and groups[%d][%d]", left, i, right, j), (long)Integer.compare(left, right), (long)Integer.compare(Order.INSTANCE.compare(groups[left][i], groups[right][j]), 0));
                    }
                }
            }
        }
    }

    private Value booleanValue(boolean b) {
        return Value.newBuilder().setBooleanValue(b).build();
    }

    private Value doubleValue(double d) {
        return Value.newBuilder().setDoubleValue(d).build();
    }

    private Value intValue(long l) {
        return Value.newBuilder().setIntegerValue(l).build();
    }

    private Value stringValue(String s) {
        return Value.newBuilder().setStringValue(s).build();
    }

    private Value referenceValue(String r) {
        return Value.newBuilder().setReferenceValue(r).build();
    }

    private Value blobValue(byte[] b) {
        return Value.newBuilder().setBytesValue(ByteString.copyFrom((byte[])b)).build();
    }

    private Value nullValue() {
        return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    }

    private Value timestampValue(long seconds, int nanos) {
        return Value.newBuilder().setTimestampValue(Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build()).build();
    }

    private Value geoPointValue(double latitude, double longitude) {
        return Value.newBuilder().setGeoPointValue(LatLng.newBuilder().setLatitude(latitude).setLongitude(longitude).build()).build();
    }

    private Value arrayValue(Value ... values) {
        return Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addAllValues(Arrays.asList(values)).build()).build();
    }

    private Value objectValue(String key, Value value, Object ... keysAndValues) {
        MapValue.Builder mapBuilder = MapValue.newBuilder();
        mapBuilder.putFields(key, value);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            mapBuilder.putFields((String)keysAndValues[i], (Value)keysAndValues[i + 1]);
        }
        return Value.newBuilder().setMapValue(mapBuilder.build()).build();
    }
}

