/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.QueryPartition;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PartitionQuery {
    public static final String DATABASE_NAME = "projects/test-project/databases/(default)/documents";
    public static final Cursor CURSOR1 = Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("projects/test-project/databases/(default)/documents/collection/doc1")).build();
    public static final Cursor PARTITION1 = CURSOR1.toBuilder().setBefore(true).build();
    public static final Cursor CURSOR2 = Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("projects/test-project/databases/(default)/documents/collection/doc2")).build();
    public static final Cursor PARTITION2 = CURSOR2.toBuilder().setBefore(true).build();
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Mock
    private UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> callable;
    @Mock
    private FirestoreClient.PartitionQueryPagedResponse pagedResponse;
    @Mock
    private FirestoreClient.PartitionQueryPage queryPage;
    @Captor
    private ArgumentCaptor<RunQueryRequest> runQuery;
    @Captor
    private ArgumentCaptor<ResponseObserver<PartitionQueryResponse>> streamObserverCapture;
    @Captor
    private ArgumentCaptor<PartitionQueryRequest> requestCaptor;

    @Test
    public void requestsOneLessThanDesired() throws Exception {
        int desiredPartitionsCount = 2;
        PartitionQueryRequest expectedRequest = PartitionQueryRequest.newBuilder().setParent(DATABASE_NAME).setStructuredQuery(StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setAllDescendants(true).setCollectionId("collectionId")).addOrderBy(StructuredQuery.Order.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__")).setDirection(StructuredQuery.Direction.ASCENDING))).setPartitionCount((long)(desiredPartitionsCount - 1)).build();
        PartitionQueryResponse response = PartitionQueryResponse.newBuilder().addPartitions(CURSOR1).build();
        Mockito.when((Object)this.pagedResponse.iterateAll()).thenReturn((Object)ImmutableList.of((Object)CURSOR1));
        Mockito.when((Object)((PartitionQueryResponse)this.queryPage.getResponse())).thenReturn((Object)response);
        ((FirestoreImpl)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)this.pagedResponse)).when((Object)this.firestoreMock)).sendRequest((Object)((PartitionQueryRequest)this.requestCaptor.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.firestoreMock.collectionGroup("collectionId").getPartitions((long)desiredPartitionsCount).get();
        PartitionQueryRequest actualRequest = (PartitionQueryRequest)this.requestCaptor.getValue();
        Assert.assertEquals((Object)actualRequest, (Object)expectedRequest);
    }

    @Test
    public void doesNotIssueRpcIfOnlyASinglePartitionIsRequested() throws Exception {
        int desiredPartitionsCount = 1;
        List partitions = (List)this.firestoreMock.collectionGroup("collectionId").getPartitions((long)desiredPartitionsCount).get();
        Assert.assertEquals((long)partitions.size(), (long)1L);
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getStartAt());
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getEndBefore());
    }

    @Test
    public void validatesPartitionCount() {
        int desiredPartitionsCount = 0;
        try {
            this.firestoreMock.collectionGroup("collectionId").getPartitions((long)desiredPartitionsCount);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Desired partition count must be one or greater");
        }
    }

    @Test
    public void convertsPartitionsToQueries() throws Exception {
        int desiredPartitionsCount = 3;
        PartitionQueryResponse response = PartitionQueryResponse.newBuilder().addPartitions(CURSOR1).build();
        Mockito.when((Object)this.pagedResponse.iterateAll()).thenReturn((Object)ImmutableList.of((Object)CURSOR1, (Object)CURSOR2));
        Mockito.when((Object)((PartitionQueryResponse)this.queryPage.getResponse())).thenReturn((Object)response);
        ((FirestoreImpl)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)this.pagedResponse)).when((Object)this.firestoreMock)).sendRequest((Object)((PartitionQueryRequest)this.requestCaptor.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        List partitions = (List)this.firestoreMock.collectionGroup("collectionId").getPartitions((long)desiredPartitionsCount).get();
        Assert.assertEquals((long)partitions.size(), (long)3L);
        for (QueryPartition partition : partitions) {
            partition.createQuery().get();
        }
        Assert.assertEquals((long)this.runQuery.getAllValues().size(), (long)3L);
        Assert.assertFalse((boolean)((RunQueryRequest)this.runQuery.getAllValues().get(0)).getStructuredQuery().hasStartAt());
        Assert.assertEquals((Object)((RunQueryRequest)this.runQuery.getAllValues().get(0)).getStructuredQuery().getEndAt(), (Object)PARTITION1);
        Assert.assertEquals((Object)((RunQueryRequest)this.runQuery.getAllValues().get(1)).getStructuredQuery().getStartAt(), (Object)PARTITION1);
        Assert.assertEquals((Object)((RunQueryRequest)this.runQuery.getAllValues().get(1)).getStructuredQuery().getEndAt(), (Object)PARTITION2);
        Assert.assertEquals((Object)((RunQueryRequest)this.runQuery.getAllValues().get(2)).getStructuredQuery().getStartAt(), (Object)PARTITION2);
        Assert.assertFalse((boolean)((RunQueryRequest)this.runQuery.getAllValues().get(2)).getStructuredQuery().hasEndAt());
    }

    @Test
    public void sortsPartitions() throws Exception {
        int desiredPartitionsCount = 3;
        PartitionQueryResponse response = PartitionQueryResponse.newBuilder().addPartitions(CURSOR1).build();
        Mockito.when((Object)this.pagedResponse.iterateAll()).thenReturn((Object)ImmutableList.of((Object)CURSOR2, (Object)CURSOR1));
        Mockito.when((Object)((PartitionQueryResponse)this.queryPage.getResponse())).thenReturn((Object)response);
        ((FirestoreImpl)Mockito.doReturn((Object)ApiFutures.immediateFuture((Object)this.pagedResponse)).when((Object)this.firestoreMock)).sendRequest((Object)((PartitionQueryRequest)this.requestCaptor.capture()), (UnaryCallable)ArgumentMatchers.any());
        List partitions = (List)this.firestoreMock.collectionGroup("collectionId").getPartitions((long)desiredPartitionsCount).get();
        Assert.assertEquals((Object)((DocumentReference)((QueryPartition)partitions.get(0)).getEndBefore()[0]).getId(), (Object)"doc1");
        Assert.assertEquals((Object)((DocumentReference)((QueryPartition)partitions.get(1)).getEndBefore()[0]).getId(), (Object)"doc2");
    }
}

