/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.truth.Truth;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import io.grpc.Status;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryCountTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<RunAggregationQueryRequest> runAggregationQuery;
    @Captor
    private ArgumentCaptor<ResponseObserver<RunAggregationQueryResponse>> streamObserverCapture;
    private Query query;

    @Before
    public void before() {
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ZERO).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        this.query = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID);
    }

    @Test
    public void countShouldBeZeroForEmptyCollection() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(0)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)this.query.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)0);
    }

    @Test
    public void countShouldBe99ForCollectionWith99Documents() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(99)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)this.query.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)99);
    }

    @Test
    public void countShouldMakeCorrectRequestForACollection() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(0)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        CollectionReference collection = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID);
        collection.count().get();
        Truth.assertThat((Object)this.runAggregationQuery.getValue()).isEqualTo((Object)LocalFirestoreHelper.countQuery());
    }

    @Test
    public void countShouldMakeCorrectRequestForAComplexQuery() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(0)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").startAt(new Object[]{"foo"}).endAt(new Object[]{"bar"}).limitToLast(42).count().get().get();
        Truth.assertThat((Object)this.runAggregationQuery.getValue()).isEqualTo((Object)LocalFirestoreHelper.countQuery(LocalFirestoreHelper.query(LocalFirestoreHelper.limit(42), LocalFirestoreHelper.order("foo", StructuredQuery.Direction.DESCENDING), LocalFirestoreHelper.endAt(LocalFirestoreHelper.string("foo"), false), LocalFirestoreHelper.startAt(LocalFirestoreHelper.string("bar"), true))));
    }

    @Test
    public void shouldReturnReadTimeFromResponse() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(99, Timestamp.ofTimeSecondsAndNanos((long)123L, (int)456))).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)this.query.count().get().get();
        Truth.assertThat((Comparable)snapshot.getReadTime()).isEqualTo((Object)Timestamp.ofTimeSecondsAndNanos((long)123L, (int)456));
    }

    @Test
    public void shouldIgnoreExtraRunAggregationQueryResponses() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.aggregationQueryResponses(123, 456)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)this.query.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)123);
    }

    @Test
    public void shouldIgnoreExtraErrors() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.aggregationQueryResponses(123, new Exception())).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)this.query.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)123);
    }

    @Test
    public void shouldPropagateErrors() throws Exception {
        Exception exception = new Exception();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(exception)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        Truth.assertThat((Throwable)executionException).hasCauseThat().isSameInstanceAs((Object)exception);
    }

    @Test
    public void aggregateQueryGetQueryShouldReturnCorrectValue() throws Exception {
        AggregateQuery aggregateQuery = this.query.count();
        Truth.assertThat((Object)aggregateQuery.getQuery()).isSameInstanceAs((Object)this.query);
    }

    @Test
    public void aggregateQuerySnapshotGetQueryShouldReturnCorrectValue() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        AggregateQuery aggregateQuery = this.query.count();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)aggregateQuery.get().get();
        Truth.assertThat((Object)snapshot.getQuery()).isSameInstanceAs((Object)aggregateQuery);
    }

    @Test
    public void shouldNotRetryIfExceptionIsNotFirestoreException() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(new NotFirestoreException())).doAnswer(LocalFirestoreHelper.countQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        Assert.assertThrows(ExecutionException.class, () -> future.get());
    }

    @Test
    public void shouldRetryIfExceptionIsFirestoreExceptionWithRetryableStatus() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse((Throwable)new FirestoreException("reason", Status.INTERNAL))).doAnswer(LocalFirestoreHelper.countQueryResponse(42)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)future.get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)42);
    }

    @Test
    public void shouldNotRetryIfExceptionIsFirestoreExceptionWithNonRetryableStatus() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse((Throwable)new FirestoreException("reason", Status.INVALID_ARGUMENT))).doAnswer(LocalFirestoreHelper.countQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        Assert.assertThrows(ExecutionException.class, () -> future.get());
    }

    @Test
    public void shouldRetryIfExceptionIsFirestoreExceptionWithRetryableStatusWithInfiniteTimeoutWindow() throws Exception {
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ZERO).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse((Throwable)new FirestoreException("reason", Status.INTERNAL))).doAnswer(LocalFirestoreHelper.countQueryResponse(42)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)future.get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)42);
    }

    @Test
    public void shouldRetryIfExceptionIsFirestoreExceptionWithRetryableStatusWithinTimeoutWindow() throws Exception {
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ofDays(999L)).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse((Throwable)new FirestoreException("reason", Status.INTERNAL))).doAnswer(LocalFirestoreHelper.countQueryResponse(42)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)future.get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)42);
    }

    @Test
    public void shouldNotRetryIfExceptionIsFirestoreExceptionWithRetryableStatusBeyondTimeoutWindow() {
        ApiClock clockMock = (ApiClock)Mockito.mock(ApiClock.class);
        ((FirestoreImpl)Mockito.doReturn((Object)clockMock).when((Object)this.firestoreMock)).getClock();
        ((ApiClock)Mockito.doReturn((Object)TimeUnit.SECONDS.toNanos(10L)).doReturn((Object)TimeUnit.SECONDS.toNanos(20L)).doReturn((Object)TimeUnit.SECONDS.toNanos(30L)).when((Object)clockMock)).nanoTime();
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ofSeconds(5L)).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse((Throwable)new FirestoreException("reason", Status.INTERNAL))).doAnswer(LocalFirestoreHelper.countQueryResponse(42)).when((Object)this.firestoreMock)).streamRequest((Object)((RunAggregationQueryRequest)this.runAggregationQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture future = this.query.count().get();
        Assert.assertThrows(ExecutionException.class, () -> future.get());
    }

    private static final class NotFirestoreException
    extends Exception {
        private NotFirestoreException() {
        }
    }
}

