/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiClock;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Filter;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.io.BaseEncoding;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Status;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<RunQueryRequest> runQuery;
    @Captor
    private ArgumentCaptor<ResponseObserver<RunQueryResponse>> streamObserverCapture;
    private Query query;
    private MockClock clock;

    @Before
    public void before() {
        this.clock = new MockClock();
        ((FirestoreImpl)Mockito.doReturn((Object)this.clock).when((Object)this.firestoreMock)).getClock();
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ZERO).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        this.query = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID);
    }

    @Test
    public void withLimit() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.limit(42).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.limit(42)), (Object)this.runQuery.getValue());
    }

    @Test
    public void limitToLastReversesOrderingConstraints() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").limitToLast(42).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.limit(42), LocalFirestoreHelper.order("foo", StructuredQuery.Direction.DESCENDING)), (Object)this.runQuery.getValue());
    }

    @Test
    public void limitToLastReversesCursors() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").startAt(new Object[]{"foo"}).endAt(new Object[]{"bar"}).limitToLast(42).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.limit(42), LocalFirestoreHelper.order("foo", StructuredQuery.Direction.DESCENDING), LocalFirestoreHelper.endAt(LocalFirestoreHelper.string("foo"), false), LocalFirestoreHelper.startAt(LocalFirestoreHelper.string("bar"), true)), (Object)this.runQuery.getValue());
    }

    @Test
    public void limitToLastReversesResults() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "2", LocalFirestoreHelper.DOCUMENT_NAME + "1")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        QuerySnapshot querySnapshot = (QuerySnapshot)this.query.orderBy("foo").limitToLast(2).get().get();
        Iterator docIterator = querySnapshot.iterator();
        Assert.assertEquals((Object)"doc1", (Object)((QueryDocumentSnapshot)docIterator.next()).getId());
        Assert.assertEquals((Object)"doc2", (Object)((QueryDocumentSnapshot)docIterator.next()).getId());
    }

    @Test
    public void limitToLastRequiresAtLeastOneOrderingConstraint() throws Exception {
        try {
            this.query.limitToLast(1).get().get();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"limitToLast() queries require specifying at least one orderBy() clause.");
        }
    }

    @Test
    public void limitToLastRejectsStream() {
        try {
            this.query.orderBy("foo").limitToLast(1).stream(null);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Query results for queries that include limitToLast() constraints cannot be streamed. Use Query.get() instead.");
        }
    }

    @Test
    public void withOffset() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.offset(42).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.offset(42)), (Object)this.runQuery.getValue());
    }

    @Test
    public void withFilter() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereEqualTo("foo", (Object)"bar").get().get();
        this.query.whereEqualTo("foo", null).get().get();
        this.query.whereEqualTo("foo", (Object)Double.NaN).get().get();
        this.query.whereEqualTo("foo", (Object)Float.valueOf(Float.NaN)).get().get();
        this.query.whereNotEqualTo("foo", (Object)"bar").get().get();
        this.query.whereNotEqualTo("foo", null).get().get();
        this.query.whereNotEqualTo("foo", (Object)Double.NaN).get().get();
        this.query.whereNotEqualTo("foo", (Object)Float.valueOf(Float.NaN)).get().get();
        this.query.whereGreaterThan("foo", (Object)"bar").get().get();
        this.query.whereGreaterThanOrEqualTo("foo", (Object)"bar").get().get();
        this.query.whereLessThan("foo", (Object)"bar").get().get();
        this.query.whereLessThanOrEqualTo("foo", (Object)"bar").get().get();
        this.query.whereArrayContains("foo", (Object)"bar").get().get();
        this.query.whereIn("foo", Collections.singletonList("bar"));
        this.query.whereArrayContainsAny("foo", Collections.singletonList("bar"));
        this.query.whereNotIn("foo", Collections.singletonList("bar"));
        Iterator<RunQueryRequest> expected = Arrays.asList(LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NULL)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.NOT_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NOT_NULL)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.unaryFilter(StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.IN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.NOT_IN))).iterator();
        for (RunQueryRequest actual : this.runQuery.getAllValues()) {
            Assert.assertEquals((Object)expected.next(), (Object)actual);
        }
    }

    @Test
    public void withFieldPathFilter() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereEqualTo(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereNotEqualTo(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereGreaterThan(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereGreaterThanOrEqualTo(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereLessThan(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereLessThanOrEqualTo(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereArrayContains(FieldPath.of((String[])new String[]{"foo"}), (Object)"bar").get().get();
        this.query.whereIn(FieldPath.of((String[])new String[]{"foo"}), Collections.singletonList("bar"));
        this.query.whereNotIn(FieldPath.of((String[])new String[]{"foo"}), Collections.singletonList("bar"));
        this.query.whereArrayContainsAny(FieldPath.of((String[])new String[]{"foo"}), Collections.singletonList("bar"));
        Iterator<RunQueryRequest> expected = Arrays.asList(LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.NOT_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.IN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.NOT_IN)), LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY))).iterator();
        for (RunQueryRequest actual : this.runQuery.getAllValues()) {
            Assert.assertEquals((Object)expected.next(), (Object)actual);
        }
    }

    @Test
    public void withCompositeFilter() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.where(Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)"10"), Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"b", (Object)"20"), Filter.equalTo((String)"c", (Object)"30"), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"d", (Object)"40"), Filter.greaterThan((String)"e", (Object)"50")}), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"f", (Object)"60")}), Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[0])})})})).get().get();
        StructuredQuery.Filter a = LocalFirestoreHelper.fieldFilter("a", StructuredQuery.FieldFilter.Operator.EQUAL, "10");
        StructuredQuery.Filter b = LocalFirestoreHelper.fieldFilter("b", StructuredQuery.FieldFilter.Operator.EQUAL, "20");
        StructuredQuery.Filter c = LocalFirestoreHelper.fieldFilter("c", StructuredQuery.FieldFilter.Operator.EQUAL, "30");
        StructuredQuery.Filter d = LocalFirestoreHelper.fieldFilter("d", StructuredQuery.FieldFilter.Operator.EQUAL, "40");
        StructuredQuery.Filter e = LocalFirestoreHelper.fieldFilter("e", StructuredQuery.FieldFilter.Operator.GREATER_THAN, "50");
        StructuredQuery.Filter f = LocalFirestoreHelper.fieldFilter("f", StructuredQuery.FieldFilter.Operator.EQUAL, "60");
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.setWhere(LocalFirestoreHelper.andFilters(a, LocalFirestoreHelper.orFilters(b, c, LocalFirestoreHelper.andFilters(d, e), f)));
        structuredQuery.addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId("coll").build());
        Assert.assertEquals((Object)structuredQuery.build(), (Object)((RunQueryRequest)this.runQuery.getValue()).getStructuredQuery());
    }

    @Test
    public void inQueriesWithReferenceArray() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereIn(FieldPath.documentId(), Arrays.asList("doc", this.firestoreMock.document("coll/doc"))).get().get();
        Value value = Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)).addValues(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)).build()).build();
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.IN, "__name__", value));
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void inQueriesFieldsNotUsedInOrderBy() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereIn(FieldPath.of((String[])new String[]{"foo"}), Arrays.asList("value1", "value2")).startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get().get();
        Value value = Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(Value.newBuilder().setStringValue("value1").build()).addValues(Value.newBuilder().setStringValue("value2").build()).build()).build();
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.IN, "foo", value), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME), true));
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void validatesInQueries() {
        try {
            this.query.whereIn(FieldPath.documentId(), Arrays.asList("foo", 42)).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The corresponding value for FieldPath.documentId() must be a String or a DocumentReference, but was: 42.", (Object)e.getMessage());
        }
        try {
            this.query.whereIn(FieldPath.documentId(), Arrays.asList(new Object[0])).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid Query. A non-empty array is required for 'IN' filters.", (Object)e.getMessage());
        }
    }

    @Test
    public void notInQueriesWithReferenceArray() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereNotIn(FieldPath.documentId(), Arrays.asList("doc", this.firestoreMock.document("coll/doc"))).get().get();
        Value value = Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)).addValues(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)).build()).build();
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.NOT_IN, "__name__", value));
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void validatesNotInQueries() {
        try {
            this.query.whereNotIn(FieldPath.documentId(), Arrays.asList("foo", 42)).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The corresponding value for FieldPath.documentId() must be a String or a DocumentReference, but was: 42.", (Object)e.getMessage());
        }
        try {
            this.query.whereNotIn(FieldPath.documentId(), Arrays.asList(new Object[0])).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid Query. A non-empty array is required for 'NOT_IN' filters.", (Object)e.getMessage());
        }
    }

    @Test
    public void validatesQueryOperatorForFieldPathDocumentId() {
        try {
            this.query.whereArrayContains(FieldPath.documentId(), (Object)"bar");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid query. You cannot perform 'ARRAY_CONTAINS' queries on FieldPath.documentId().", (Object)e.getMessage());
        }
        try {
            this.query.whereArrayContainsAny(FieldPath.documentId(), Collections.singletonList("bar"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid query. You cannot perform 'ARRAY_CONTAINS_ANY' queries on FieldPath.documentId().", (Object)e.getMessage());
        }
    }

    @Test
    public void withDocumentIdFilter() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereEqualTo(FieldPath.documentId(), (Object)"doc").get().get();
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL, "__name__", LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)));
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withOrderBy() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").orderBy("foo.bar", Query.Direction.DESCENDING).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.order("foo.bar", StructuredQuery.Direction.DESCENDING)), (Object)this.runQuery.getValue());
    }

    @Test
    public void withFieldPathOrderBy() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy(FieldPath.of((String[])new String[]{"foo"})).orderBy(FieldPath.of((String[])new String[]{"foo", "bar"}), Query.Direction.DESCENDING).get().get();
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.order("foo.bar", StructuredQuery.Direction.DESCENDING)), (Object)this.runQuery.getValue());
    }

    @Test
    public void withSelect() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.select(new String[0]).get().get();
        this.query.select(new String[]{"foo", "foo.bar"}).get().get();
        Iterator<RunQueryRequest> expectedQuery = Arrays.asList(LocalFirestoreHelper.query(LocalFirestoreHelper.select(FieldPath.documentId())), LocalFirestoreHelper.query(LocalFirestoreHelper.select("foo"), LocalFirestoreHelper.select("foo.bar"))).iterator();
        for (RunQueryRequest actual : this.runQuery.getAllValues()) {
            Assert.assertEquals((Object)expectedQuery.next(), (Object)actual);
        }
    }

    @Test
    public void withFieldPathSelect() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.select(new FieldPath[0]).get().get();
        this.query.select(new FieldPath[]{FieldPath.of((String[])new String[]{"foo"}), FieldPath.of((String[])new String[]{"foo", "bar"})}).get().get();
        Iterator<RunQueryRequest> expectedQuery = Arrays.asList(LocalFirestoreHelper.query(LocalFirestoreHelper.select(FieldPath.documentId())), LocalFirestoreHelper.query(LocalFirestoreHelper.select("foo"), LocalFirestoreHelper.select("foo.bar"))).iterator();
        for (RunQueryRequest actual : this.runQuery.getAllValues()) {
            Assert.assertEquals((Object)expectedQuery.next(), (Object)actual);
        }
    }

    @Test
    public void withDocumentSnapshotCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withDocumentIdAndDocumentSnapshotCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy(FieldPath.documentId()).startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withDocumentReferenceCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference documentCursor = this.firestoreMock.document(LocalFirestoreHelper.DOCUMENT_PATH);
        Value documentValue = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        this.query.startAt(new Object[]{documentCursor}).get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(documentValue, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withDocumentIdAndDocumentReferenceCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference documentCursor = this.firestoreMock.document(LocalFirestoreHelper.DOCUMENT_PATH);
        Value documentValue = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        this.query.orderBy(FieldPath.documentId()).startAt(new Object[]{documentCursor}).get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(documentValue, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withExtractedDirectionForDocumentSnapshotCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo", Query.Direction.DESCENDING).startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.DESCENDING), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.DESCENDING), LocalFirestoreHelper.startAt(true), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withInequalityFilterForDocumentSnapshotCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereEqualTo("a", (Object)"b").whereGreaterThanOrEqualTo("foo", (Object)"bar").whereEqualTo("c", (Object)"d").startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL, "a", "b"), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL, "c", "d"), LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(true), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withEqualityFilterForDocumentSnapshotCursor() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.whereEqualTo("foo", (Object)"bar").startAt(LocalFirestoreHelper.SINGLE_FIELD_SNAPSHOT).get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.EQUAL), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withStartAt() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").orderBy(FieldPath.documentId()).startAt(new Object[]{"bar", "doc"}).get().get();
        Value documentBoundary = LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME);
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(true), LocalFirestoreHelper.startAt(documentBoundary, true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withInvalidStartAt() {
        try {
            this.query.orderBy(FieldPath.documentId()).startAt(new Object[]{42}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The corresponding value for FieldPath.documentId() must be a String or a DocumentReference, but was: 42.", (Object)e.getMessage());
        }
        try {
            this.query.orderBy(FieldPath.documentId()).startAt(new Object[]{"coll/doc/coll"}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Only a direct child can be used as a query boundary. Found: 'coll/coll/doc/coll'", (Object)e.getMessage());
        }
        try {
            this.query.orderBy(FieldPath.documentId()).startAt(new Object[]{this.firestoreMock.document("foo/bar")}).get();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"'foo/bar' is not part of the query result set and cannot be used as a query boundary.", (Object)e.getMessage());
        }
    }

    @Test
    public void withStartAfter() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").startAfter(new Object[]{"bar"}).get().get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(false));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withEndBefore() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").endBefore(new Object[]{"bar"}).get().get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.endAt(true));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withEndAt() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.orderBy("foo").endAt(new Object[]{"bar"}).get().get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(LocalFirestoreHelper.order("foo", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.endAt(false));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void withCollectionGroup() {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        CollectionGroup query = this.firestoreMock.collectionGroup(LocalFirestoreHelper.COLLECTION_ID);
        query = query.whereGreaterThan(FieldPath.documentId(), (Object)"coll/doc");
        query = query.orderBy(FieldPath.documentId());
        query = query.endAt(new Object[]{"coll/doc"});
        query.get();
        RunQueryRequest queryRequest = LocalFirestoreHelper.query(null, true, LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN, "__name__", LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME)), LocalFirestoreHelper.order("__name__", StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.endAt(LocalFirestoreHelper.reference(LocalFirestoreHelper.DOCUMENT_NAME), false));
        Assert.assertEquals((Object)queryRequest, (Object)this.runQuery.getValue());
    }

    @Test
    public void collectionGroupCannotContainSlashes() {
        try {
            CollectionGroup query = this.firestoreMock.collectionGroup("foo/bar");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid collectionId 'foo/bar'. Collection IDs must not contain '/'.", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void overspecifiedCursor() {
        this.query.orderBy("foo").startAt(new Object[]{"foo", "bar", "bar", "foo"});
    }

    @Test(expected=IllegalStateException.class)
    public void orderByWithCursor() {
        this.query.startAt(new Object[]{"foo"}).orderBy("foo");
    }

    @Test
    public void getResult() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        QuerySnapshot result = (QuerySnapshot)this.query.get().get();
        Assert.assertEquals((Object)this.query, (Object)result.getQuery());
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.getDocuments().size());
        Iterator docIterator = result.iterator();
        Assert.assertEquals((Object)"doc1", (Object)((QueryDocumentSnapshot)docIterator.next()).getId());
        Assert.assertEquals((Object)"doc2", (Object)((QueryDocumentSnapshot)docIterator.next()).getId());
        Assert.assertFalse((boolean)docIterator.hasNext());
        Iterator changeIterator = result.getDocumentChanges().iterator();
        DocumentChange documentChange = (DocumentChange)changeIterator.next();
        Assert.assertEquals((Object)"doc1", (Object)documentChange.getDocument().getId());
        Assert.assertEquals((Object)DocumentChange.Type.ADDED, (Object)documentChange.getType());
        Assert.assertEquals((long)-1L, (long)documentChange.getOldIndex());
        Assert.assertEquals((long)0L, (long)documentChange.getNewIndex());
        documentChange = (DocumentChange)changeIterator.next();
        Assert.assertEquals((Object)"doc2", (Object)documentChange.getDocument().getId());
        Assert.assertEquals((Object)DocumentChange.Type.ADDED, (Object)documentChange.getType());
        Assert.assertEquals((long)-1L, (long)documentChange.getOldIndex());
        Assert.assertEquals((long)1L, (long)documentChange.getNewIndex());
        Assert.assertFalse((boolean)changeIterator.hasNext());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2), (Object)result.getReadTime());
        Assert.assertEquals(Arrays.asList(LocalFirestoreHelper.SINGLE_FIELD_OBJECT, LocalFirestoreHelper.SINGLE_FIELD_OBJECT), (Object)result.toObjects(LocalFirestoreHelper.SINGLE_FIELD_OBJECT.getClass()));
        Assert.assertEquals((long)2L, (long)result.getDocumentChanges().size());
    }

    @Test
    public void streamResult() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2").iterator();
        this.query.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
    }

    @Test
    public void successfulReturnWithoutOnComplete() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponseWithDone(true, LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2").iterator();
        this.query.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
    }

    @Test
    public void successfulReturnCallsOnCompleteTwice() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponseWithDone(false, LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2").iterator();
        final int[] counter = new int[]{0};
        this.query.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                counter[0] = counter[0] + 1;
                semaphore.release();
            }
        });
        semaphore.acquire();
        Thread.sleep(200L);
        Assert.assertEquals((long)1L, (long)counter[0]);
    }

    @Test
    public void retriesAfterRetryableError() throws Exception {
        boolean[] returnError = new boolean[]{true};
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            if (returnError[0]) {
                returnError[0] = false;
                return LocalFirestoreHelper.queryResponse(FirestoreException.forServerRejection((Status)Status.DEADLINE_EXCEEDED, (String)"Simulated test failure", (Object[])new Object[0]), LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2").answer(invocation);
            }
            return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3").answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2", "doc3").iterator();
        this.query.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        List requests = this.runQuery.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertFalse((boolean)((RunQueryRequest)requests.get(0)).hasReadTime());
        Assert.assertFalse((boolean)((RunQueryRequest)requests.get(0)).getStructuredQuery().hasStartAt());
        Assert.assertEquals((Object)com.google.protobuf.Timestamp.newBuilder().setSeconds(1L).setNanos(2).build(), (Object)((RunQueryRequest)requests.get(1)).getReadTime());
        Assert.assertFalse((boolean)((RunQueryRequest)requests.get(1)).getStructuredQuery().getStartAt().getBefore());
        Assert.assertEquals((Object)(LocalFirestoreHelper.DOCUMENT_NAME + "2"), (Object)((RunQueryRequest)requests.get(1)).getStructuredQuery().getStartAt().getValues(0).getReferenceValue());
    }

    @Test
    public void doesNotRetryAfterNonRetryableError() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(FirestoreException.forServerRejection((Status)Status.PERMISSION_DENIED, (String)"Simulated test failure", (Object[])new Object[0]), LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2").iterator();
        this.query.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                semaphore.release();
            }

            public void onCompleted() {
            }
        });
        semaphore.acquire();
        Assert.assertEquals((long)1L, (long)this.runQuery.getAllValues().size());
    }

    @Test
    public void onlyRetriesWhenResultSent() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(FirestoreException.forServerRejection((Status)Status.DEADLINE_EXCEEDED, (String)"Simulated test failure", (Object[])new Object[0]), new String[0])).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        Assert.assertThrows(ExecutionException.class, () -> this.query.get().get());
        Assert.assertEquals((long)1L, (long)this.runQuery.getAllValues().size());
    }

    @Test
    public void retriesWithoutTimeout() throws Exception {
        boolean[] returnError = new boolean[]{true};
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            this.clock.advance(Duration.ofHours(1L).toNanos());
            if (returnError[0]) {
                returnError[0] = false;
                return LocalFirestoreHelper.queryResponse(FirestoreException.forServerRejection((Status)Status.DEADLINE_EXCEEDED, (String)"Simulated test failure", (Object[])new Object[0]), LocalFirestoreHelper.DOCUMENT_NAME + "1").answer(invocation);
            }
            return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "2").answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        this.query.get().get();
        Assert.assertEquals((long)2L, (long)this.runQuery.getAllValues().size());
    }

    @Test
    public void doesNotRetryWithTimeout() {
        ((FirestoreImpl)Mockito.doReturn((Object)Duration.ofMinutes(1L)).when((Object)this.firestoreMock)).getTotalRequestTimeoutDuration();
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            this.clock.advance(Duration.ofHours(1L).toNanos());
            return LocalFirestoreHelper.queryResponse(FirestoreException.forServerRejection((Status)Status.DEADLINE_EXCEEDED, (String)"Simulated test failure", (Object[])new Object[0]), LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2").answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        Assert.assertThrows(ExecutionException.class, () -> this.query.get().get());
        Assert.assertEquals((long)1L, (long)this.runQuery.getAllValues().size());
    }

    @Test
    public void equalsTest() {
        Assert.assertEquals((Object)this.query.limit(42).offset(1337), (Object)this.query.offset(1337).limit(42));
        Assert.assertEquals((long)this.query.limit(42).offset(1337).hashCode(), (long)this.query.offset(1337).limit(42).hashCode());
    }

    @Test
    public void serializationTest() {
        this.assertSerialization(this.query);
        this.query = this.query.whereEqualTo("a", null);
        this.assertSerialization(this.query);
        this.query = this.query.whereEqualTo("b", (Object)Double.NaN);
        this.assertSerialization(this.query);
        this.query = this.query.whereGreaterThan("c", (Object)1);
        this.assertSerialization(this.query);
        this.query = this.query.whereGreaterThanOrEqualTo(FieldPath.of((String[])new String[]{"d", ".e."}), (Object)2);
        this.assertSerialization(this.query);
        this.query = this.query.whereLessThan("f", (Object)3);
        this.assertSerialization(this.query);
        this.query = this.query.whereLessThanOrEqualTo(FieldPath.of((String[])new String[]{"g", ".h."}), (Object)4);
        this.assertSerialization(this.query);
        this.query = this.query.whereIn("i", Collections.singletonList(5));
        this.assertSerialization(this.query);
        this.query = this.query.whereArrayContains("j", Collections.singletonList(6));
        this.assertSerialization(this.query);
        this.query = this.query.whereArrayContainsAny("k", Collections.singletonList(7));
        this.assertSerialization(this.query);
        this.query = this.query.orderBy("l");
        this.assertSerialization(this.query);
        this.query = this.query.orderBy(FieldPath.of((String[])new String[]{"m", ".n."}), Query.Direction.DESCENDING);
        this.assertSerialization(this.query);
        this.query = this.query.startAt(new Object[]{"o"});
        this.assertSerialization(this.query);
        this.query = this.query.startAfter(new Object[]{"p"});
        this.assertSerialization(this.query);
        this.query = this.query.endBefore(new Object[]{"q"});
        this.assertSerialization(this.query);
        this.query = this.query.endAt(new Object[]{"r"});
        this.assertSerialization(this.query);
        this.query = this.query.limit(8);
        this.assertSerialization(this.query);
        this.query = this.query.offset(9);
        this.assertSerialization(this.query);
    }

    @Test
    public void serializationTestWithEmptyCompositeFilter() {
        this.assertSerialization(this.query);
        this.query.where(Filter.or((Filter[])new Filter[0]));
        this.assertSerialization(this.query);
        this.query.where(Filter.and((Filter[])new Filter[0]));
        this.assertSerialization(this.query);
        this.query.where(Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[0])})})}));
        this.assertSerialization(this.query);
    }

    @Test
    public void serializationTestWithSingleFilterCompositeFilters() {
        this.assertSerialization(this.query);
        this.query.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)10)}));
        this.assertSerialization(this.query);
        this.query.where(Filter.and((Filter[])new Filter[]{Filter.greaterThan((String)"b", (Object)20)}));
        this.assertSerialization(this.query);
        this.query.where(Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"c", (Object)30)})})})}));
        this.assertSerialization(this.query);
    }

    @Test
    public void serializationTestWithNestedCompositeFiltersOuterAnd() {
        this.assertSerialization(this.query);
        this.query.where(Filter.inArray((String)"a", Arrays.asList(1, 2)));
        this.assertSerialization(this.query);
        this.query.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"b", (Object)20), Filter.equalTo((String)"c", (Object)30), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"d", (Object)40), Filter.greaterThan((String)"e", (Object)50)}), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"f", (Object)60)}), Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[0])})}));
        this.assertSerialization(this.query);
        this.query = this.query.orderBy("l");
        this.assertSerialization(this.query);
        this.query = this.query.startAt(new Object[]{"o"});
        this.assertSerialization(this.query);
        this.query = this.query.startAfter(new Object[]{"p"});
        this.assertSerialization(this.query);
        this.query = this.query.endBefore(new Object[]{"q"});
        this.assertSerialization(this.query);
        this.query = this.query.endAt(new Object[]{"r"});
        this.assertSerialization(this.query);
        this.query = this.query.limit(8);
        this.assertSerialization(this.query);
        this.query = this.query.offset(9);
        this.assertSerialization(this.query);
    }

    @Test
    public void serializationTestWithNestedCompositeFiltersOuterOr() {
        this.assertSerialization(this.query);
        this.query.where(Filter.or((Filter[])new Filter[]{Filter.inArray((String)"a", Arrays.asList(1, 2)), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"b", (Object)20), Filter.equalTo((String)"c", (Object)30), Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"d", (Object)40), Filter.greaterThan((String)"e", (Object)50)}), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"f", (Object)60)}), Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[0])})})}));
        this.assertSerialization(this.query);
        this.query = this.query.orderBy("l");
        this.assertSerialization(this.query);
        this.query = this.query.startAt(new Object[]{"o"});
        this.assertSerialization(this.query);
        this.query = this.query.startAfter(new Object[]{"p"});
        this.assertSerialization(this.query);
        this.query = this.query.endBefore(new Object[]{"q"});
        this.assertSerialization(this.query);
        this.query = this.query.endAt(new Object[]{"r"});
        this.assertSerialization(this.query);
        this.query = this.query.limit(8);
        this.assertSerialization(this.query);
        this.query = this.query.offset(9);
        this.assertSerialization(this.query);
    }

    private void assertSerialization(Query query) {
        RunQueryRequest runQueryRequest = query.toProto();
        Query deserializedQuery = Query.fromProto((Firestore)this.firestoreMock, (RunQueryRequest)runQueryRequest);
        Assert.assertEquals((Object)runQueryRequest, (Object)deserializedQuery.toProto());
        Assert.assertEquals((Object)deserializedQuery, (Object)query);
    }

    @Test
    public void serializationVerifiesDatabaseName() {
        RunQueryRequest runQueryRequest = this.query.toProto();
        runQueryRequest = runQueryRequest.toBuilder().setParent("projects/foo/databases/(default)/documents").build();
        try {
            Query.fromProto((Firestore)this.firestoreMock, (RunQueryRequest)runQueryRequest);
            Assert.fail((String)"Expected serializtion error");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot deserialize query from different Firestore project (\"projects/test-project/databases/(default)\" vs \"projects/foo/databases/(default)\")", (Object)e.getMessage());
        }
    }

    @Test
    public void ensureFromProtoWorksWithAProxy() throws InvalidProtocolBufferException {
        Object o = Proxy.newProxyInstance(QueryTest.class.getClassLoader(), new Class[]{Firestore.class, FirestoreRpcContext.class}, (proxy, method, args) -> {
            Method getDatabaseNameMethod = FirestoreRpcContext.class.getDeclaredMethod("getDatabaseName", new Class[0]);
            if (method.equals(getDatabaseNameMethod)) {
                return "projects/test-project/databases/(default)";
            }
            return null;
        });
        Assert.assertTrue((boolean)(o instanceof Firestore));
        Assert.assertTrue((boolean)(o instanceof FirestoreRpcContext));
        String base64Proto = "CjNwcm9qZWN0cy90ZXN0LXByb2plY3QvZGF0YWJhc2VzLyhkZWZhdWx0KS9kb2N1bWVudHMSKxIUEhJ0ZXN0aW5nLWNvbGxlY3Rpb24aExIRCgkSB2VuYWJsZWQQBRoCCAE=";
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)base64Proto);
        RunQueryRequest runQueryRequest = RunQueryRequest.parseFrom((byte[])bytes);
        Query query = Query.fromProto((Firestore)((Firestore)o), (RunQueryRequest)runQueryRequest);
        ResourcePath path = query.options.getParentPath();
        Assert.assertEquals((Object)"projects/test-project/databases/(default)/documents", (Object)path.getName());
        Assert.assertEquals((Object)"testing-collection", (Object)query.options.getCollectionId());
        Query.FilterInternal next = (Query.FilterInternal)query.options.getFilters().iterator().next();
        Assert.assertTrue((boolean)(next instanceof Query.ComparisonFilterInternal));
        Query.ComparisonFilterInternal comparisonFilter = (Query.ComparisonFilterInternal)next;
        Assert.assertEquals((Object)"enabled", (Object)comparisonFilter.fieldReference.getFieldPath());
        Assert.assertFalse((boolean)comparisonFilter.isInequalityFilter());
        Assert.assertEquals((Object)Value.newBuilder().setBooleanValue(true).build(), (Object)comparisonFilter.value);
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyOnCharacters() {
        Query query_ = this.query.whereLessThan("a", (Object)"value").whereGreaterThanOrEqualTo("a", (Object)"value").whereGreaterThan("aa", (Object)"value").whereGreaterThan("b", (Object)"value").whereGreaterThan("A", (Object)"value");
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("A", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("aa", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("b", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyOnCharactersAndNumbers() {
        Query query_ = this.query.whereLessThan("a", (Object)"value").whereGreaterThan("1", (Object)"value").whereGreaterThan("19", (Object)"value").whereGreaterThan("2", (Object)"value");
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("1", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("19", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("2", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyOnNestedFields() {
        Query query_ = this.query.whereLessThan("a", (Object)"value").whereGreaterThan("aa", (Object)"value").whereGreaterThan("a.a", (Object)"value");
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a.a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("aa", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyOnSpecialCharacters() {
        Query query_ = this.query.whereLessThan("a", (Object)"value").whereGreaterThan("_a", (Object)"value").whereGreaterThan("a.a", (Object)"value");
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("_a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a.a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyOnFieldNameWithDot() {
        Query query_ = this.query.whereLessThan("a", (Object)"value").whereGreaterThan(FieldPath.of((String[])new String[]{"a.a"}), (Object)"value").whereGreaterThan("a.z", (Object)"value");
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a.z", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("`a.a`", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyInCompositeFilter() {
        Query query_ = this.query.where(Filter.and((Filter[])new Filter[]{Filter.lessThan((String)"a", (Object)"value"), Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[]{Filter.greaterThanOrEqualTo((String)"b", (Object)"value"), Filter.lessThanOrEqualTo((String)"c", (Object)"value")}), Filter.or((Filter[])new Filter[]{Filter.greaterThan((String)"d", (Object)"value"), Filter.equalTo((String)"e", (Object)"value")})})}));
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("b", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("c", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("d", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyWithExplicitOrderBys() {
        Query query_ = this.query.whereLessThan("b", (Object)"value").whereGreaterThan("a", (Object)"value").whereGreaterThan("z", (Object)"value").orderBy("z", Query.Direction.ASCENDING);
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("z", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("b", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyFollowingExplicitOrderByDirection() {
        Query query_ = this.query.whereLessThan("b", (Object)"value").whereGreaterThan("a", (Object)"value").orderBy("z", Query.Direction.DESCENDING);
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("z", Query.Direction.DESCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.DESCENDING));
        orderFields.add(new Query.FieldOrder("b", Query.Direction.DESCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.DESCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    @Test
    public void inequalityFiltersImplicitlyOrderedLexicographicallyFollowingLastExplicitOrderByDirection() {
        Query query_ = this.query.whereLessThan("b", (Object)"value").whereGreaterThan("a", (Object)"value").orderBy("z", Query.Direction.DESCENDING).orderBy("c", Query.Direction.ASCENDING);
        ArrayList<Query.FieldOrder> orderFields = new ArrayList<Query.FieldOrder>();
        orderFields.add(new Query.FieldOrder("z", Query.Direction.DESCENDING));
        orderFields.add(new Query.FieldOrder("c", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("a", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder("b", Query.Direction.ASCENDING));
        orderFields.add(new Query.FieldOrder(FieldPath.documentId().toProto(), Query.Direction.ASCENDING));
        Assert.assertEquals(orderFields, (Object)query_.createImplicitOrderBy());
    }

    static class MockClock
    implements ApiClock {
        long nanoTime = 0L;

        MockClock() {
        }

        public void advance(long nanos) {
            this.nanoTime += nanos;
        }

        public long nanoTime() {
            return this.nanoTime;
        }

        public long millisTime() {
            return this.nanoTime / 1000000L;
        }
    }
}

