/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.RateLimiter;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RateLimiterTest {
    private RateLimiter limiter;

    @Before
    public void before() {
        this.limiter = new RateLimiter(500, 1.5, 300000, 1000000, new Date(0L).getTime());
    }

    @Test
    public void processRequestsFromCapacity() {
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(250, new Date(0L).getTime()));
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(250, new Date(0L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(1, new Date(0L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(501, new Date(1000L).getTime()));
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(500, new Date(1000L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(250, new Date(1499L).getTime()));
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(249, new Date(1500L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(751, new Date(299000L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(751, new Date(300000L).getTime()));
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(750, new Date(300000L).getTime()));
        Assert.assertFalse((boolean)this.limiter.tryMakeRequest(751, new Date(303000L).getTime()));
        try {
            this.limiter.tryMakeRequest(751, new Date(302000L).getTime());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Request time should not be before the last token refill time", (Object)e.getMessage());
        }
    }

    @Test
    public void calculatesMsForNextRequest() {
        long timestamp = new Date(0L).getTime();
        Assert.assertEquals((long)0L, (long)this.limiter.getNextRequestDelayMs(500, timestamp));
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(250, timestamp));
        Assert.assertEquals((long)500L, (long)this.limiter.getNextRequestDelayMs(500, timestamp));
        timestamp = new Date(1000L).getTime();
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(500, timestamp));
        Assert.assertEquals((long)200L, (long)this.limiter.getNextRequestDelayMs(100, timestamp));
        Assert.assertEquals((long)500L, (long)this.limiter.getNextRequestDelayMs(250, timestamp));
        Assert.assertEquals((long)1000L, (long)this.limiter.getNextRequestDelayMs(500, timestamp));
        Assert.assertEquals((long)-1L, (long)this.limiter.getNextRequestDelayMs(501, timestamp));
        timestamp = new Date(300000L).getTime();
        Assert.assertTrue((boolean)this.limiter.tryMakeRequest(750, timestamp));
        Assert.assertEquals((long)334L, (long)this.limiter.getNextRequestDelayMs(250, timestamp));
        Assert.assertEquals((long)667L, (long)this.limiter.getNextRequestDelayMs(500, timestamp));
        Assert.assertEquals((long)1000L, (long)this.limiter.getNextRequestDelayMs(750, timestamp));
        Assert.assertEquals((long)-1L, (long)this.limiter.getNextRequestDelayMs(751, timestamp));
    }

    @Test
    public void calculatesMaxOperations() {
        Assert.assertEquals((long)500L, (long)this.limiter.calculateCapacity(new Date(0L).getTime()));
        Assert.assertEquals((long)750L, (long)this.limiter.calculateCapacity(new Date(300000L).getTime()));
        Assert.assertEquals((long)1125L, (long)this.limiter.calculateCapacity(new Date(600000L).getTime()));
        Assert.assertEquals((long)1687L, (long)this.limiter.calculateCapacity(new Date(900000L).getTime()));
        Assert.assertEquals((long)738945L, (long)this.limiter.calculateCapacity(new Date(5400000L).getTime()));
        Assert.assertEquals((long)1000000L, (long)this.limiter.calculateCapacity(new Date(60000000L).getTime()));
    }
}

