/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterTest;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.protobuf.Message;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class RecursiveDeleteTest {
    @Rule
    public Timeout timeout = new Timeout(10L, TimeUnit.SECONDS);
    @Spy
    private final FirestoreRpc firestoreRpc = (FirestoreRpc)Mockito.mock(FirestoreRpc.class);
    private final ScheduledExecutorService immediateExecutor = new ScheduledThreadPoolExecutor(1){

        @Override
        @Nonnull
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
        }
    };
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), this.firestoreRpc);
    @Captor
    private ArgumentCaptor<BatchWriteRequest> batchWriteCapture;
    @Captor
    private ArgumentCaptor<RunQueryRequest> runQueryCapture;
    @Captor
    private ArgumentCaptor<ResponseObserver<Message>> streamObserverCapture;
    private BulkWriter bulkWriter;
    private LocalFirestoreHelper.ResponseStubber responseStubber;

    @Before
    public void before() {
        ((FirestoreRpc)Mockito.lenient().doReturn((Object)this.immediateExecutor).when((Object)this.firestoreRpc)).getExecutor();
        ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1){

            @Override
            @Nonnull
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
            }
        };
    }

    private Value recursiveDeleteStartAt(String name) {
        return Value.newBuilder().setReferenceValue(LocalFirestoreHelper.DATABASE_NAME + "/documents/" + name + "/" + "__id-9223372036854775808__").build();
    }

    private Value recursiveDeleteEndAt(String name) {
        return Value.newBuilder().setReferenceValue(LocalFirestoreHelper.DOCUMENT_ROOT + name + '\u0000' + "/" + "__id-9223372036854775808__").build();
    }

    private String fullDocumentPath(String name) {
        return LocalFirestoreHelper.DOCUMENT_ROOT + LocalFirestoreHelper.COLLECTION_ID + "/" + name;
    }

    private void setupMocks(List<String> childrenDocuments) throws Exception {
        this.setupMocks(childrenDocuments, "");
    }

    private void setupMocks(List<String> childrenDocuments, String deleteDocRef) throws Exception {
        this.setupMocks(childrenDocuments, deleteDocRef, null);
    }

    private void setupMocks(List<String> childrenDocuments, String deleteDocRef, @Nullable ApiFuture<BatchWriteResponse> customResponse) throws Exception {
        ArrayList<String> fullDocumentPaths = new ArrayList<String>();
        for (String documentName : childrenDocuments) {
            fullDocumentPaths.add(this.fullDocumentPath(documentName));
        }
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(fullDocumentPaths.toArray(new String[0]))).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        if (!deleteDocRef.equals("")) {
            childrenDocuments = new ArrayList<String>(childrenDocuments);
            childrenDocuments.add(deleteDocRef);
        }
        final ArrayList<Write> expectedRequests = new ArrayList<Write>();
        ArrayList<ApiFuture<BatchWriteResponse>> returnedResponse = new ArrayList<ApiFuture<BatchWriteResponse>>();
        for (String documentPath : childrenDocuments) {
            expectedRequests.add(LocalFirestoreHelper.delete(LocalFirestoreHelper.COLLECTION_ID + "/" + documentPath));
            returnedResponse.add(BulkWriterTest.successResponse(1));
        }
        final ApiFuture<BatchWriteResponse> finalResponse = customResponse != null ? customResponse : BulkWriterTest.mergeResponses(returnedResponse.toArray(new ApiFuture[0]));
        this.responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(expectedRequests.toArray(new Write[0])), (ApiFuture<? extends Message>)finalResponse);
            }
        };
        this.responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
    }

    @Test
    public void getAllDescendantsRootLevelCollection() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(null, true, true, LocalFirestoreHelper.select(FieldPath.documentId()), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, FieldPath.documentId().toString(), this.recursiveDeleteStartAt("root")), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN, FieldPath.documentId().toString(), this.recursiveDeleteEndAt("root")), LocalFirestoreHelper.limit(5000));
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("root")).get();
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQueryCapture.getValue());
    }

    @Test
    public void getAllDescendantsNestedCollection() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(null, "root/doc", true, true, LocalFirestoreHelper.select(FieldPath.documentId()), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, FieldPath.documentId().toString(), this.recursiveDeleteStartAt("root/doc/nestedCol")), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN, FieldPath.documentId().toString(), this.recursiveDeleteEndAt("root/doc/nestedCol")), LocalFirestoreHelper.limit(5000));
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("root/doc/nestedCol")).get();
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQueryCapture.getValue());
    }

    @Test
    public void getAllDescendantsDocument() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(mock -> BulkWriterTest.successResponse(1)).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(null, "root/doc", true, true, LocalFirestoreHelper.select(FieldPath.documentId()), LocalFirestoreHelper.limit(5000));
        this.firestoreMock.recursiveDelete(this.firestoreMock.document("root/doc")).get();
        Assert.assertEquals((Object)expectedRequest, (Object)this.runQueryCapture.getValue());
    }

    @Test
    public void createsRetryQueryAfterStreamExceptionWithLastReceivedDoc() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse((Throwable)new FirestoreException("Mock runQuery() failed in test", Status.UNAVAILABLE), this.fullDocumentPath("doc1"))).doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(mock -> BulkWriterTest.successResponse(1)).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(null, true, true, LocalFirestoreHelper.select(FieldPath.documentId()), LocalFirestoreHelper.order(FieldPath.documentId(), StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(LocalFirestoreHelper.reference(this.fullDocumentPath("doc1")), false), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, FieldPath.documentId().toString(), this.recursiveDeleteStartAt("coll")), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN, FieldPath.documentId().toString(), this.recursiveDeleteEndAt("coll")), LocalFirestoreHelper.limit(5000));
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("coll")).get();
        Assert.assertEquals((Object)expectedRequest, this.runQueryCapture.getAllValues().get(1));
    }

    @Test
    public void createsSecondQueryWithCorrectStartAfter() throws Exception {
        int i;
        int maxPendingOps = 100;
        int minPendingOps = 11;
        int maxBatchSize = 10;
        int cutoff = maxPendingOps - minPendingOps;
        int[] numDeletesBuffered = new int[]{0};
        SettableApiFuture bufferFuture = SettableApiFuture.create();
        SettableApiFuture secondQueryFuture = SettableApiFuture.create();
        ArrayList<String> firstStream = new ArrayList<String>();
        ArrayList<ApiFuture<BatchWriteResponse>> batchWriteResponse = new ArrayList<ApiFuture<BatchWriteResponse>>();
        for (i = 0; i < maxPendingOps; ++i) {
            firstStream.add(this.fullDocumentPath("doc" + i));
        }
        for (i = 0; i < maxBatchSize; ++i) {
            batchWriteResponse.add(BulkWriterTest.successResponse(1));
        }
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(firstStream.toArray(new String[0]))).doAnswer(invocation -> {
            secondQueryFuture.set(null);
            Object[] args = invocation.getArguments();
            ResponseObserver observer = (ResponseObserver)args[1];
            observer.onComplete();
            return null;
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(mock -> {
            if (numDeletesBuffered[0] < cutoff) {
                numDeletesBuffered[0] = numDeletesBuffered[0] + batchWriteResponse.size();
                return ApiFutures.transformAsync((ApiFuture)bufferFuture, unused -> BulkWriterTest.mergeResponses(batchWriteResponse.toArray(new ApiFuture[0])), (Executor)MoreExecutors.directExecutor());
            }
            bufferFuture.set(null);
            return ApiFutures.transformAsync((ApiFuture)secondQueryFuture, unused -> BulkWriterTest.mergeResponses(batchWriteResponse.toArray(new ApiFuture[0])), (Executor)MoreExecutors.directExecutor());
        }).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        BulkWriter bulkWriter = this.firestoreMock.bulkWriter();
        bulkWriter.setMaxBatchSize(maxBatchSize);
        RunQueryRequest expectedRequest = LocalFirestoreHelper.query(null, true, true, LocalFirestoreHelper.select(FieldPath.documentId()), LocalFirestoreHelper.order(FieldPath.documentId(), StructuredQuery.Direction.ASCENDING), LocalFirestoreHelper.startAt(LocalFirestoreHelper.reference(this.fullDocumentPath("doc" + (maxPendingOps - 1))), false), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, FieldPath.documentId().toString(), this.recursiveDeleteStartAt("coll")), LocalFirestoreHelper.filter(StructuredQuery.FieldFilter.Operator.LESS_THAN, FieldPath.documentId().toString(), this.recursiveDeleteEndAt("coll")), LocalFirestoreHelper.limit(maxPendingOps));
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("coll").getResourcePath(), bulkWriter, maxPendingOps, minPendingOps).get();
        Assert.assertEquals((long)2L, (long)this.runQueryCapture.getAllValues().size());
        Assert.assertEquals((Object)expectedRequest, this.runQueryCapture.getAllValues().get(1));
    }

    @Test
    public void deletesCollection() throws Exception {
        List<String> documents = Arrays.asList("anna", "bob", "bob/children/charlie", "bob/children/daniel");
        this.setupMocks(documents);
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID)).get();
        this.responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void deletesDocumentAndReference() throws Exception {
        List<String> documents = Arrays.asList("bob/children/brian", "bob/children/charlie", "bob/children/daniel");
        this.setupMocks(documents, "bob");
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).document("bob")).get();
        this.responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void exceptionContainsLastErrorCodeIfWritesFail() throws Exception {
        List<String> documents = Arrays.asList("bob/children/brian", "bob/children/charlie", "bob/children/daniel");
        ApiFuture<BatchWriteResponse> customResponse = BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.failedResponse(1), BulkWriterTest.failedResponse(7), BulkWriterTest.successResponse(1));
        this.setupMocks(documents, "bob", customResponse);
        try {
            ApiFuture future = this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).document("bob"));
            future.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.PERMISSION_DENIED, (Object)((FirestoreException)e.getCause()).getStatus());
            Assert.assertTrue((boolean)e.getMessage().contains("2 deletes failed"));
        }
    }

    @Test
    public void exceptionThrownIfBulkWriterSuccessHandlerFails() throws Exception {
        List<String> documents = Arrays.asList("bob/children/brian");
        this.setupMocks(documents, "bob");
        this.bulkWriter = this.firestoreMock.bulkWriter();
        this.bulkWriter.addWriteResultListener((documentReference, result) -> {
            throw new UnsupportedOperationException("Test code threw UnsupportedOperationException");
        });
        try {
            ApiFuture future = this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).document("bob"), this.bulkWriter);
            future.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("2 deletes failed"));
        }
    }

    @Test
    public void successHandlerProvidesCorrectReferencesAndResults() throws Exception {
        List<String> documents = Arrays.asList("bob/children/brian", "bob/children/charlie");
        ApiFuture<BatchWriteResponse> customResponse = BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(2), BulkWriterTest.successResponse(3));
        this.setupMocks(documents, "bob", customResponse);
        ArrayList results = new ArrayList();
        ArrayList references = new ArrayList();
        this.bulkWriter = this.firestoreMock.bulkWriter();
        this.bulkWriter.addWriteResultListener((documentReference, result) -> {
            results.add((int)result.getUpdateTime().getSeconds());
            references.add(documentReference.getPath());
        });
        ApiFuture future = this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).document("bob"), this.bulkWriter);
        future.get();
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])results.toArray());
        Assert.assertArrayEquals((Object[])new String[]{"coll/bob/children/brian", "coll/bob/children/charlie", "coll/bob"}, (Object[])references.toArray());
    }

    @Test
    public void errorHandlerProvidesCorrectInformation() throws Exception {
        List<String> documents = Arrays.asList("bob/children/brian", "bob/children/charlie");
        ApiFuture<BatchWriteResponse> customResponse = BulkWriterTest.mergeResponses(BulkWriterTest.failedResponse(7), BulkWriterTest.failedResponse(14), BulkWriterTest.failedResponse(13));
        this.setupMocks(documents, "bob", customResponse);
        ArrayList codes = new ArrayList();
        ArrayList references = new ArrayList();
        this.bulkWriter = this.firestoreMock.bulkWriter();
        this.bulkWriter.addWriteErrorListener(error -> {
            codes.add(error.getStatus());
            references.add(error.getDocumentReference().getPath());
            return false;
        });
        ApiFuture future = this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).document("bob"), this.bulkWriter);
        try {
            future.get();
            Assert.fail((String)"Operation should have failed");
        }
        catch (Exception e) {
            Assert.assertArrayEquals((Object[])new Status[]{Status.PERMISSION_DENIED, Status.UNAVAILABLE, Status.INTERNAL}, (Object[])codes.toArray());
            Assert.assertArrayEquals((Object[])new String[]{"coll/bob/children/brian", "coll/bob/children/charlie", "coll/bob"}, (Object[])references.toArray());
        }
    }

    @Test
    public void exceptionThrownIfProvidedReferenceWasNotDeleted() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doReturn(BulkWriterTest.FAILED_FUTURE).when((Object)this.firestoreMock)).sendRequest((Object)((BatchWriteRequest)this.batchWriteCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture future = this.firestoreMock.recursiveDelete(this.firestoreMock.document("root/doc"));
        try {
            future.get();
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Mock batchWrite failed in test"));
        }
    }

    @Test
    public void handlesSuccessfulStreamErrorRetries() throws Exception {
        FirestoreException mockException = new FirestoreException("runQuery() failed in test", Status.UNAVAILABLE);
        ArrayList<Answer> runQueryResponses = new ArrayList<Answer>(Arrays.asList(LocalFirestoreHelper.queryResponse((Throwable)mockException, this.fullDocumentPath("a"), this.fullDocumentPath("b")), LocalFirestoreHelper.queryResponse((Throwable)mockException, this.fullDocumentPath("c")), LocalFirestoreHelper.queryResponse((Throwable)mockException, this.fullDocumentPath("d")), LocalFirestoreHelper.queryResponse(this.fullDocumentPath("e"))));
        ((FirestoreImpl)Mockito.doAnswer((Answer)((Answer)runQueryResponses.get(0))).doAnswer((Answer)runQueryResponses.get(1)).doAnswer((Answer)runQueryResponses.get(2)).doAnswer((Answer)runQueryResponses.get(3)).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.delete("coll/a"), LocalFirestoreHelper.delete("coll/b"), LocalFirestoreHelper.delete("coll/c"), LocalFirestoreHelper.delete("coll/d"), LocalFirestoreHelper.delete("coll/e")), BulkWriterTest.mergeResponses(BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(1), BulkWriterTest.successResponse(1)));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID)).get();
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void handlesMultipleCallsToRecursiveDelete() throws Exception {
        ArrayList<Answer> runQueryResponses = new ArrayList<Answer>(Arrays.asList(LocalFirestoreHelper.queryResponse(this.fullDocumentPath("a")), LocalFirestoreHelper.queryResponse(this.fullDocumentPath("b")), LocalFirestoreHelper.queryResponse(this.fullDocumentPath("c"))));
        ((FirestoreImpl)Mockito.doAnswer((Answer)((Answer)runQueryResponses.get(0))).doAnswer((Answer)runQueryResponses.get(1)).doAnswer((Answer)runQueryResponses.get(2)).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.delete("coll/a")), BulkWriterTest.successResponse(1));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.delete("coll/b")), BulkWriterTest.successResponse(2));
                this.put((Message)LocalFirestoreHelper.batchWrite(LocalFirestoreHelper.delete("coll/c")), BulkWriterTest.successResponse(3));
            }
        };
        responseStubber.initializeStub(this.batchWriteCapture, this.firestoreMock);
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("a")).get();
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("b")).get();
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("c")).get();
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void usesSameBulkWriterInstanceAcrossCalls() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.emptyQueryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQueryCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        int[] callCount = new int[]{0};
        BulkWriter bulkWriter = this.firestoreMock.bulkWriter();
        ((FirestoreImpl)Mockito.doAnswer(mock -> {
            callCount[0] = callCount[0] + 1;
            return bulkWriter;
        }).when((Object)this.firestoreMock)).bulkWriter();
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("foo")).get();
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("boo")).get();
        this.firestoreMock.recursiveDelete(this.firestoreMock.collection("moo")).get();
        Assert.assertEquals((long)1L, (long)callCount[0]);
    }

    @Test
    public void throwsErrorIfBulkWriterInstanceIsClosed() throws Exception {
        this.bulkWriter = this.firestoreMock.bulkWriter();
        this.bulkWriter.close();
        try {
            this.firestoreMock.recursiveDelete(this.firestoreMock.collection("foo"), this.bulkWriter);
            Assert.fail((String)"Operation should have failed in test");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("BulkWriter has already been closed"));
        }
    }
}

