/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.firestore.SilenceableBidiStream;
import com.google.common.truth.Truth;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SilenceableBidiStreamTest {
    @Mock
    BidiStreamObserver<Integer, String> mockObserver;
    @Mock
    ClientStream<Integer> mockClientStream;
    SilenceableBidiStream<Integer, String> sut;

    @Before
    public void before() {
        Consumer captureCall = (Consumer)Mockito.mock(Consumer.class);
        this.sut = new SilenceableBidiStream(this.mockObserver, o -> {
            captureCall.accept(o);
            return this.mockClientStream;
        });
        ((Consumer)Mockito.verify((Object)captureCall)).accept(this.sut);
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_onComplete() {
        this.sut.onComplete();
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onComplete();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_onError() {
        Exception e = new Exception("Something bad");
        this.sut.onError((Throwable)e);
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)e);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_onResponse() {
        this.sut.onResponse((Object)"ABC");
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onResponse((Object)"ABC");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_onStart() {
        StreamController controller = (StreamController)Mockito.mock(StreamController.class);
        this.sut.onStart(controller);
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onStart(controller);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver, controller});
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_onReady() {
        ClientStream client = (ClientStream)Mockito.mock(ClientStream.class);
        this.sut.onReady(client);
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onReady(client);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver, client});
    }

    @Test
    public void byDefault_theStreamWillPassThroughData_send() {
        this.sut.send((Object)7);
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).send((Object)7);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void closeMethod() {
        Truth.assertWithMessage((String)"Expect isSilenced() to be false by default").that(Boolean.valueOf(this.sut.isSilenced())).isFalse();
        this.sut.closeSend();
        Truth.assertWithMessage((String)"Expect isSilenced() to be unaffected after close()").that(Boolean.valueOf(this.sut.isSilenced())).isFalse();
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void closeAndSilenceMethod() {
        Truth.assertWithMessage((String)"Expect isSilenced() to be false by default").that(Boolean.valueOf(this.sut.isSilenced())).isFalse();
        this.sut.closeSendAndSilence();
        Truth.assertWithMessage((String)"Expect isSilenced() to be true after closeAndSilence()").that(Boolean.valueOf(this.sut.isSilenced())).isTrue();
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterClose_theStreamWillPassThroughData_onComplete() {
        this.sut.closeSend();
        this.sut.onComplete();
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onComplete();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterClose_theStreamWillPassThroughData_onError() {
        Exception e = new Exception("Something bad");
        this.sut.closeSend();
        this.sut.onError((Throwable)e);
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)e);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterClose_theStreamWillPassThroughData_onResponse() {
        this.sut.closeSend();
        this.sut.onResponse((Object)"ABC");
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        ((BidiStreamObserver)Mockito.verify(this.mockObserver, (VerificationMode)Mockito.times((int)1))).onResponse((Object)"ABC");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterCloseAndSilence_theStreamWillPassThroughData_onComplete() {
        this.sut.closeSendAndSilence();
        this.sut.onComplete();
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterCloseAndSilence_theStreamWillPassThroughData_onError() {
        Exception e = new Exception("Something bad");
        this.sut.closeSendAndSilence();
        this.sut.onError((Throwable)e);
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }

    @Test
    public void afterCloseAndSilence_theStreamWillPassThroughData_onResponse() {
        this.sut.closeSendAndSilence();
        this.sut.onResponse((Object)"ABC");
        ((ClientStream)Mockito.verify(this.mockClientStream, (VerificationMode)Mockito.times((int)1))).closeSend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientStream, this.mockObserver});
    }
}

