/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.truth.Truth;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ToStringTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    private WriteBatch batch;
    private DocumentReference documentReference;

    @Before
    public void before() {
        this.batch = this.firestoreMock.batch();
        this.documentReference = this.firestoreMock.document("coll/doc");
    }

    @Test
    public void testDocumentSnapshot() {
        Map<String, Value> fields = Collections.singletonMap("key123", UserDataConverter.encodeValue((FieldPath)FieldPath.of((String[])new String[]{"key456"}), (Object)CustomClassMapper.convertToPlainJavaTypes((Object)"value789"), (UserDataConverter.EncodingOptions)UserDataConverter.NO_DELETES));
        String toStringResult = new DocumentSnapshot(null, this.documentReference, fields, Timestamp.ofTimeMicroseconds((long)1L), Timestamp.ofTimeMicroseconds((long)2L), Timestamp.ofTimeMicroseconds((long)3L)).toString();
        Truth.assertThat((String)toStringResult).startsWith("DocumentSnapshot{");
        Truth.assertThat((String)toStringResult).containsMatch("doc=DocumentReference\\{path=.*/documents/coll/doc}");
        Truth.assertThat((String)toStringResult).containsMatch("(?s)fields=\\{key123=string_value:.*value789.*}");
        Truth.assertThat((String)toStringResult).contains((CharSequence)"readTime=1970-01-01T00:00:00.000001000Z");
        Truth.assertThat((String)toStringResult).contains((CharSequence)"updateTime=1970-01-01T00:00:00.000002000Z");
        Truth.assertThat((String)toStringResult).contains((CharSequence)"createTime=1970-01-01T00:00:00.000003000Z");
        Truth.assertThat((String)toStringResult).endsWith("}");
    }

    @Test
    public void testWriteOperation() {
        String toStringResult = new UpdateBuilder.WriteOperation(this.documentReference, DocumentSnapshot.fromObject(null, (DocumentReference)this.documentReference, Collections.singletonMap("key", "value"), (UserDataConverter.EncodingOptions)UserDataConverter.NO_DELETES).toPb().build()).toString();
        Truth.assertThat((String)toStringResult).startsWith("WriteOperation{");
        Truth.assertThat((String)toStringResult).containsMatch("(?s)write=update\\s*\\{\\s*name:.*/documents/coll/doc.*}");
        Truth.assertThat((String)toStringResult).containsMatch("doc=DocumentReference\\{path=.*/documents/coll/doc}");
        Truth.assertThat((String)toStringResult).endsWith("}");
    }

    @Test
    public void testWriteBatch() {
        this.batch.update(this.documentReference, Collections.singletonMap("key", "value"));
        String toStringResult = this.batch.toString();
        Truth.assertThat((String)toStringResult).startsWith("WriteBatch{");
        Truth.assertThat((String)toStringResult).containsMatch("(?s)writes=\\[WriteOperation\\{write=update.*/documents/coll/doc.*}]");
        Truth.assertThat((String)toStringResult).contains((CharSequence)"committed=false");
        Truth.assertThat((String)toStringResult).endsWith("}");
    }
}

