/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.it.ITQueryTest;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.common.truth.Truth;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Write;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionTest {
    private final ApiFuture<Message> RETRYABLE_API_EXCEPTION = ApiFutures.immediateFailedFuture((Throwable)new ApiException((Throwable)new Exception("Test exception"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNKNOWN), true));
    @Spy
    private final FirestoreRpc firestoreRpc = (FirestoreRpc)Mockito.mock(FirestoreRpc.class);
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setRetrySettings(LocalFirestoreHelper.IMMEDIATE_RETRY_SETTINGS)).build(), this.firestoreRpc);
    @Captor
    private ArgumentCaptor<Message> requestCapture;
    @Captor
    private ArgumentCaptor<ResponseObserver<Message>> streamObserverCapture;
    private DocumentReference documentReference;
    private Query queryReference;
    private AggregateQuery aggregateQueryReference;
    private TransactionOptions options;

    @Before
    public void before() {
        ((FirestoreRpc)Mockito.doReturn((Object)Executors.newSingleThreadScheduledExecutor()).when((Object)this.firestoreRpc)).getExecutor();
        this.documentReference = this.firestoreMock.document("coll/doc");
        this.queryReference = this.firestoreMock.collection("coll");
        this.aggregateQueryReference = this.queryReference.count();
        this.options = TransactionOptions.create((Executor)Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("user_provided");
            return thread;
        }));
    }

    @Test
    public void returnsValue() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            Assert.assertEquals((Object)"user_provided", (Object)Thread.currentThread().getName());
            return "foo";
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(1));
    }

    @Test
    public void returnsValueAsync() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> {
            Assert.assertEquals((Object)"user_provided", (Object)Thread.currentThread().getName());
            return ApiFutures.immediateFuture((Object)"foo");
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(1));
    }

    @Test
    public void canReturnNull() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(transaction1 -> null, this.options);
        Assert.assertNull((Object)transaction.get());
    }

    @Test
    public void canReturnNullAsync() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> ApiFutures.immediateFuture(null), this.options);
        Assert.assertNull((Object)transaction.get());
    }

    @Test
    public void rollbackOnCallbackError() {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.rollbackResponse()).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            throw new Exception("Expected exception");
        }, this.options);
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Expected exception"));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.rollback(), requests.get(1));
    }

    @Test
    public void rollbackOnCallbackApiFutureErrorAsync() {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.rollbackResponse()).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> ApiFutures.immediateFailedFuture((Throwable)new Exception("Expected exception")), this.options);
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Expected exception"));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.rollback(), requests.get(1));
    }

    @Test
    public void noRollbackOnBeginFailure() {
        ((FirestoreImpl)Mockito.doReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new Exception("Expected exception"))).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            Assert.fail();
            return null;
        }, this.options);
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Expected exception"));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)1L, (long)requests.size());
    }

    @Test
    public void noRollbackOnBeginFailureAsync() {
        ((FirestoreImpl)Mockito.doReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new Exception("Expected exception"))).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> {
            Assert.fail();
            return null;
        }, this.options);
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Expected exception"));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)1L, (long)requests.size());
    }

    @Test
    public void noRollbackOnThrownExceptionAsync() {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.rollbackResponse()).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> {
            throw new RuntimeException("User exception");
        }, this.options);
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("User exception"));
        }
    }

    @Test
    public void limitsRetriesWithFailure() {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo1"), LocalFirestoreHelper.beginResponse("foo2"));
                this.put((Message)LocalFirestoreHelper.commit("foo2", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo2"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo2"), LocalFirestoreHelper.beginResponse("foo3"));
                this.put((Message)LocalFirestoreHelper.commit("foo3", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo3"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo3"), LocalFirestoreHelper.beginResponse("foo4"));
                this.put((Message)LocalFirestoreHelper.commit("foo4", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo4"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo4"), LocalFirestoreHelper.beginResponse("foo5"));
                this.put((Message)LocalFirestoreHelper.commit("foo5", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo5"), LocalFirestoreHelper.rollbackResponse());
            }
        };
        responseStubber.initializeStub(this.requestCapture, this.firestoreMock);
        AtomicInteger retryCount = new AtomicInteger(1);
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> "foo" + retryCount.getAndIncrement(), TransactionOptions.create((Executor)this.options.getExecutor(), (int)5));
        try {
            transaction.get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("Transaction was cancelled because of too many retries."));
        }
        responseStubber.verifyAllRequestsSent();
    }

    @Test
    public void limitsRetriesWithSuccess() throws Exception {
        LocalFirestoreHelper.ResponseStubber responseStubber = new LocalFirestoreHelper.ResponseStubber(){
            {
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo1"), LocalFirestoreHelper.beginResponse("foo2"));
                this.put((Message)LocalFirestoreHelper.commit("foo2", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo2"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo2"), LocalFirestoreHelper.beginResponse("foo3"));
                this.put((Message)LocalFirestoreHelper.commit("foo3", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo3"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo3"), LocalFirestoreHelper.beginResponse("foo4"));
                this.put((Message)LocalFirestoreHelper.commit("foo4", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo4"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo4"), LocalFirestoreHelper.beginResponse("foo5"));
                this.put((Message)LocalFirestoreHelper.commit("foo5", new Write[0]), (ApiFuture<? extends Message>)TransactionTest.this.RETRYABLE_API_EXCEPTION);
                this.put((Message)LocalFirestoreHelper.rollback("foo5"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo5"), LocalFirestoreHelper.beginResponse("foo6"));
                this.put((Message)LocalFirestoreHelper.commit("foo6", new Write[0]), LocalFirestoreHelper.commitResponse(0, 0));
            }
        };
        responseStubber.initializeStub(this.requestCapture, this.firestoreMock);
        AtomicInteger retryCount = new AtomicInteger(1);
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> "foo" + retryCount.getAndIncrement(), TransactionOptions.create((Executor)this.options.getExecutor(), (int)6));
        Assert.assertEquals((Object)"foo6", (Object)transaction.get());
        responseStubber.verifyAllRequestsSent();
    }

    private void verifyRetries(Function<ApiException, LocalFirestoreHelper.ResponseStubber> expectedSequenceWithRetry, Function<ApiException, LocalFirestoreHelper.ResponseStubber> expectedSequenceWithoutRetry) throws ExecutionException, InterruptedException {
        ApiException[] exceptionWithRetryBehavior;
        for (ApiException apiException : exceptionWithRetryBehavior = new ApiException[]{this.exception(Status.Code.CANCELLED, true), this.exception(Status.Code.UNKNOWN, true), this.exception(Status.Code.INVALID_ARGUMENT, false), this.exception(Status.Code.INVALID_ARGUMENT, "The referenced transaction has expired or is no longer valid.", true), this.exception(Status.Code.DEADLINE_EXCEEDED, true), this.exception(Status.Code.NOT_FOUND, false), this.exception(Status.Code.ALREADY_EXISTS, false), this.exception(Status.Code.RESOURCE_EXHAUSTED, true), this.exception(Status.Code.FAILED_PRECONDITION, false), this.exception(Status.Code.ABORTED, true), this.exception(Status.Code.OUT_OF_RANGE, false), this.exception(Status.Code.UNIMPLEMENTED, false), this.exception(Status.Code.INTERNAL, true), this.exception(Status.Code.UNAVAILABLE, true), this.exception(Status.Code.DATA_LOSS, false), this.exception(Status.Code.UNAUTHENTICATED, true)}) {
            ApiFuture transaction;
            int[] attempts;
            LocalFirestoreHelper.ResponseStubber stubber;
            if (apiException.isRetryable()) {
                stubber = expectedSequenceWithRetry.apply(apiException);
                stubber.initializeStub(this.requestCapture, this.firestoreMock);
                attempts = new int[]{0};
                transaction = this.firestoreMock.runTransaction(t -> {
                    attempts[0] = attempts[0] + 1;
                    return null;
                });
                transaction.get();
                stubber.verifyAllRequestsSent();
                Assert.assertEquals((long)2L, (long)attempts[0]);
                continue;
            }
            stubber = expectedSequenceWithoutRetry.apply(apiException);
            stubber.initializeStub(this.requestCapture, this.firestoreMock);
            attempts = new int[]{0};
            transaction = this.firestoreMock.runTransaction(t -> {
                attempts[0] = attempts[0] + 1;
                return null;
            });
            try {
                transaction.get();
                Assert.fail((String)"Transaction should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            stubber.verifyAllRequestsSent();
            Assert.assertEquals((long)1L, (long)attempts[0]);
        }
    }

    @Test
    public void retriesCommitBasedOnErrorCode() throws Exception {
        this.verifyRetries(e -> new LocalFirestoreHelper.ResponseStubber((ApiException)e){
            final /* synthetic */ ApiException val$e;
            {
                this.val$e = apiException;
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$e));
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), LocalFirestoreHelper.rollbackResponse());
                this.put((Message)LocalFirestoreHelper.begin("foo1"), LocalFirestoreHelper.beginResponse("foo2"));
                this.put((Message)LocalFirestoreHelper.commit("foo2", new Write[0]), LocalFirestoreHelper.commitResponse(0, 0));
            }
        }, e -> new LocalFirestoreHelper.ResponseStubber((ApiException)e){
            final /* synthetic */ ApiException val$e;
            {
                this.val$e = apiException;
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$e));
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), LocalFirestoreHelper.rollbackResponse());
            }
        });
    }

    @Test
    public void retriesRollbackBasedOnErrorCode() throws Exception {
        ApiException retryable = this.exception(Status.Code.ABORTED, true);
        this.verifyRetries(e -> new LocalFirestoreHelper.ResponseStubber((ApiException)e, retryable){
            final /* synthetic */ ApiException val$e;
            final /* synthetic */ ApiException val$retryable;
            {
                this.val$e = apiException;
                this.val$retryable = apiException2;
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$e));
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$retryable));
                this.put((Message)LocalFirestoreHelper.begin("foo1"), LocalFirestoreHelper.beginResponse("foo2"));
                this.put((Message)LocalFirestoreHelper.commit("foo2", new Write[0]), LocalFirestoreHelper.commitResponse(0, 0));
            }
        }, e -> new LocalFirestoreHelper.ResponseStubber((ApiException)e, retryable){
            final /* synthetic */ ApiException val$e;
            final /* synthetic */ ApiException val$retryable;
            {
                this.val$e = apiException;
                this.val$retryable = apiException2;
                this.put((Message)LocalFirestoreHelper.begin(), LocalFirestoreHelper.beginResponse("foo1"));
                this.put((Message)LocalFirestoreHelper.commit("foo1", new Write[0]), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$e));
                this.put((Message)LocalFirestoreHelper.rollback("foo1"), (ApiFuture<? extends Message>)ApiFutures.immediateFailedFuture((Throwable)this.val$retryable));
            }
        });
    }

    @Test
    public void getDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> (DocumentSnapshot)t.get(this.documentReference).get(), this.options);
        Assert.assertEquals((Object)"doc", (Object)((DocumentSnapshot)transaction.get()).getId());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.get(LocalFirestoreHelper.TRANSACTION_ID), requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void getDocumentAsync() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runAsyncTransaction(t -> t.get(this.documentReference), this.options);
        Assert.assertEquals((Object)"doc", (Object)((DocumentSnapshot)transaction.get()).getId());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.get(LocalFirestoreHelper.TRANSACTION_ID), requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void getMultipleDocuments() throws Exception {
        DocumentReference doc1 = this.firestoreMock.document("coll/doc1");
        DocumentReference doc2 = this.firestoreMock.document("coll/doc2");
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> (List)t.getAll(new DocumentReference[]{doc1, doc2}).get(), this.options);
        Assert.assertEquals((long)2L, (long)((List)transaction.get()).size());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.getAll(LocalFirestoreHelper.TRANSACTION_ID, doc1.getResourcePath().toString(), doc2.getResourcePath().toString()), requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void getMultipleDocumentsWithFieldMask() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.getAllResponse(LocalFirestoreHelper.SINGLE_FIELD_PROTO)).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        DocumentReference doc1 = this.firestoreMock.document("coll/doc1");
        FieldMask fieldMask = FieldMask.of((FieldPath[])new FieldPath[]{FieldPath.of((String[])new String[]{"foo", "bar"})});
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> (List)t.getAll(new DocumentReference[]{doc1}, fieldMask).get(), this.options);
        transaction.get();
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        BatchGetDocumentsRequest expectedGetAll = LocalFirestoreHelper.getAll(LocalFirestoreHelper.TRANSACTION_ID, doc1.getResourcePath().toString());
        expectedGetAll = expectedGetAll.toBuilder().setMask(DocumentMask.newBuilder().addFieldPaths("foo.bar")).build();
        Assert.assertEquals((Object)expectedGetAll, requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void getQuery() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse()).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> (QuerySnapshot)t.get(this.queryReference).get(), this.options);
        Assert.assertEquals((long)1L, (long)((QuerySnapshot)transaction.get()).size());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.TRANSACTION_ID, false, new StructuredQuery[0]), requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void getAggregateQuery() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.countQueryResponse(42)).when((Object)this.firestoreMock)).streamRequest((Object)((Message)this.requestCapture.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> (AggregateQuerySnapshot)t.get(this.aggregateQueryReference).get(), this.options);
        Assert.assertEquals((long)42L, (long)((AggregateQuerySnapshot)transaction.get()).getCount());
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)3L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.countQuery(LocalFirestoreHelper.TRANSACTION_ID), requests.get(1));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, new Write[0]), requests.get(2));
    }

    @Test
    public void updateDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            t.update(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            t.update(this.documentReference, "foo", (Object)"bar", new Object[0]);
            return "foo";
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < 2; ++i) {
            writes.add(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo")));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, writes.toArray(new Write[0])), requests.get(1));
    }

    @Test
    public void setDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            ((Transaction)t.set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP)).set(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT);
            return "foo";
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < 2; ++i) {
            writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, writes.toArray(new Write[0])), requests.get(1));
    }

    @Test
    public void createDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            ((Transaction)t.create(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP)).create(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT);
            return "foo";
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < 2; ++i) {
            writes.add(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        }
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, writes.toArray(new Write[0])), requests.get(1));
    }

    @Test
    public void deleteDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            t.delete(this.documentReference);
            t.delete(this.documentReference, Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2)));
            return "foo";
        }, this.options);
        Assert.assertEquals((Object)"foo", (Object)transaction.get());
        ArrayList<Write> writes = new ArrayList<Write>();
        writes.add(LocalFirestoreHelper.delete());
        Precondition.Builder precondition = com.google.firestore.v1.Precondition.newBuilder();
        precondition.getUpdateTimeBuilder().setSeconds(1L).setNanos(2);
        writes.add(LocalFirestoreHelper.delete(precondition.build()));
        List requests = this.requestCapture.getAllValues();
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)LocalFirestoreHelper.begin(), requests.get(0));
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(LocalFirestoreHelper.TRANSACTION_ID, writes.toArray(new Write[0])), requests.get(1));
    }

    @Test
    public void readOnlyTransactionOptionsBuilder_setReadTime() {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        Timestamp.Builder readTime = com.google.protobuf.Timestamp.getDefaultInstance().toBuilder().setSeconds(1L).setNanos(0);
        TransactionOptions.ReadOnlyOptionsBuilder builder = ((TransactionOptions.ReadOnlyOptionsBuilder)TransactionOptions.createReadOnlyOptionsBuilder().setExecutor(executor)).setReadTime((TimestampOrBuilder)readTime);
        TransactionOptions transactionOptions = builder.build();
        Truth.assertThat((Object)builder.getExecutor()).isSameInstanceAs((Object)executor);
        Truth.assertThat((Object)builder.getReadTime()).isSameInstanceAs((Object)readTime);
        Truth.assertThat((Object)transactionOptions.getExecutor()).isSameInstanceAs((Object)executor);
        Truth.assertThat((Comparable)transactionOptions.getType()).isEqualTo((Object)TransactionOptions.TransactionOptionsType.READ_ONLY);
        Truth.assertThat((Object)transactionOptions.getReadTime()).isEqualTo((Object)readTime.build());
        Truth.assertThat((Integer)transactionOptions.getNumberOfAttempts()).isEqualTo((Object)1);
    }

    @Test
    public void readOnlyTransactionOptionsBuilder_defaults() {
        TransactionOptions.ReadOnlyOptionsBuilder builder = TransactionOptions.createReadOnlyOptionsBuilder();
        TransactionOptions transactionOptions = builder.build();
        Truth.assertThat((Object)builder.getExecutor()).isNull();
        Truth.assertThat((Object)builder.getReadTime()).isNull();
        Truth.assertThat((Object)transactionOptions.getReadTime()).isNull();
        Truth.assertThat((Integer)transactionOptions.getNumberOfAttempts()).isEqualTo((Object)1);
    }

    @Test
    public void readWriteTransactionOptionsBuilder_setNumberOfAttempts() {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        TransactionOptions.ReadWriteOptionsBuilder builder = ((TransactionOptions.ReadWriteOptionsBuilder)TransactionOptions.createReadWriteOptionsBuilder().setExecutor(executor)).setNumberOfAttempts(2);
        TransactionOptions transactionOptions = builder.build();
        Truth.assertThat((Object)builder.getExecutor()).isSameInstanceAs((Object)executor);
        Truth.assertThat((Integer)builder.getNumberOfAttempts()).isEqualTo((Object)2);
        Truth.assertThat((Object)transactionOptions.getExecutor()).isSameInstanceAs((Object)executor);
        Truth.assertThat((Comparable)transactionOptions.getType()).isEqualTo((Object)TransactionOptions.TransactionOptionsType.READ_WRITE);
        Truth.assertThat((Integer)transactionOptions.getNumberOfAttempts()).isEqualTo((Object)2);
        Truth.assertThat((Object)transactionOptions.getReadTime()).isNull();
    }

    @Test
    public void readWriteTransactionOptionsBuilder_defaults() {
        TransactionOptions transactionOptions = TransactionOptions.createReadWriteOptionsBuilder().build();
        Truth.assertThat((Object)transactionOptions.getExecutor()).isNull();
        Truth.assertThat((Integer)transactionOptions.getNumberOfAttempts()).isEqualTo((Object)5);
        Truth.assertThat((Object)transactionOptions.getReadTime()).isNull();
    }

    @Test
    public void readWriteTransactionOptionsBuilder_errorAttemptingToSetNumAttemptsLessThanOne() {
        try {
            TransactionOptions.createReadWriteOptionsBuilder().setNumberOfAttempts(0);
            Assert.fail((String)"Error expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getShouldThrowWhenInvokedAfterAWriteWithAQuery() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).when((Object)this.firestoreMock)).sendRequest(ArgumentMatchers.any(), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            t.set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            t.get(this.queryReference);
            return null;
        });
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> transaction.get());
        Truth.assertThat((Throwable)executionException.getCause()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void getShouldThrowWhenInvokedAfterAWriteWithAnAggregateQuery() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).when((Object)this.firestoreMock)).sendRequest(ArgumentMatchers.any(), (UnaryCallable)ArgumentMatchers.any());
        ApiFuture transaction = this.firestoreMock.runTransaction(t -> {
            t.set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP);
            t.get(this.aggregateQueryReference);
            return null;
        });
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> transaction.get());
        Truth.assertThat((Throwable)executionException.getCause()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void givesProperErrorMessageForCommittedTransaction() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.beginResponse()).doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((Message)this.requestCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        String expectedErrorMessage = "Cannot modify a Transaction that has already been committed.";
        DocumentReference docRef = this.firestoreMock.collection("foo").document("bar");
        Transaction t = (Transaction)this.firestoreMock.runTransaction(transaction -> transaction).get();
        LocalFirestoreHelper.assertException(() -> t.set(docRef, ITQueryTest.map("foo", "bar")), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> t.update(docRef, ITQueryTest.map("foo", "bar")), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> t.create(docRef, ITQueryTest.map("foo", "bar")), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> t.delete(docRef), expectedErrorMessage);
    }

    private ApiException exception(Status.Code code, boolean shouldRetry) {
        return this.exception(code, "Test exception", shouldRetry);
    }

    private ApiException exception(Status.Code code, String message, boolean shouldRetry) {
        return new ApiException((Throwable)new Exception(message), (StatusCode)GrpcStatusCode.of((Status.Code)code), shouldRetry);
    }
}

