/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QueryTest;
import com.google.cloud.firestore.VectorQuery;
import com.google.cloud.firestore.VectorQueryOptions;
import com.google.cloud.firestore.VectorQuerySnapshot;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import io.grpc.Status;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VectorQueryTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<RunQueryRequest> runQuery;
    @Captor
    private ArgumentCaptor<ResponseObserver<RunQueryResponse>> streamObserverCapture;
    private Query queryA;
    private Query queryB;
    private QueryTest.MockClock clock;

    @Before
    public void before() {
        this.clock = new QueryTest.MockClock();
        ((FirestoreImpl)Mockito.doReturn((Object)this.clock).when((Object)this.firestoreMock)).getClock();
        this.queryA = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID);
        this.queryB = this.firestoreMock.collection(LocalFirestoreHelper.COLLECTION_ID).whereEqualTo("foo", (Object)"bar");
    }

    @Test
    public void isEqual() {
        Query queryA = this.firestoreMock.collection("collectionId").whereEqualTo("foo", (Object)"bar");
        Query queryB = this.firestoreMock.collection("collectionId").whereEqualTo("foo", (Object)"bar");
        CollectionReference queryC = this.firestoreMock.collection("collectionId");
        Assert.assertEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE));
        Assert.assertEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN));
        Assert.assertEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.125)).build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.125)).build()));
        Assert.assertEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.125)).setDistanceResultField(FieldPath.of((String[])new String[]{"foo"})).build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.125)).setDistanceResultField(FieldPath.of((String[])new String[]{"foo"})).build()));
        Assert.assertEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField(FieldPath.of((String[])new String[]{"distance"})).build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE), (Object)queryC.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE), (Object)queryB.findNearest("embedding", new double[]{40.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 1000, VectorQuery.DistanceMeasure.COSINE));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.COSINE), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.125)).build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(1.125)).build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(1.0)).build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(1.0)).build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("result").build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField(FieldPath.of((String[])new String[]{"distance"})).build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField(FieldPath.of((String[])new String[]{"result"})).build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("result").build()));
        Assert.assertNotEquals((Object)queryA.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build()), (Object)queryB.findNearest("embedding", new double[]{40.0, 41.0, 42.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN));
    }

    @Test
    public void validatesInputsLimit() {
        String expectedExceptionMessage = ".*Not a valid positive `limit` number.*";
        Throwable exception = Assert.assertThrows(RuntimeException.class, () -> this.queryA.findNearest("embedding", new double[]{10.0, 100.0}, 0, VectorQuery.DistanceMeasure.EUCLIDEAN));
        Assert.assertTrue((boolean)exception.getMessage().matches(expectedExceptionMessage));
    }

    @Test
    public void validatesInputsVectorSize() {
        String expectedExceptionMessage = ".*Not a valid vector size.*";
        Throwable exception = Assert.assertThrows(RuntimeException.class, () -> this.queryA.findNearest("embedding", new double[0], 10, VectorQuery.DistanceMeasure.EUCLIDEAN));
        Assert.assertTrue((boolean)exception.getMessage().matches(expectedExceptionMessage));
    }

    @Test
    public void successfulReturnWithoutOnComplete() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponseWithDone(true, LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.COSINE).get().get();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)false, (Object)snapshot.isEmpty());
        Assert.assertTrue((boolean)(LocalFirestoreHelper.DOCUMENT_NAME + "1").endsWith(((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getId()));
        Assert.assertTrue((boolean)(LocalFirestoreHelper.DOCUMENT_NAME + "2").endsWith(((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getId()));
        Assert.assertEquals((long)2L, (long)snapshot.getDocumentChanges().size());
        Assert.assertEquals((long)1L, (long)snapshot.getReadTime().getSeconds());
        Assert.assertEquals((long)2L, (long)snapshot.getReadTime().getNanos());
        Assert.assertEquals((long)1L, (long)this.runQuery.getAllValues().size());
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.findNearest("vector", new double[]{1.0, -9.5}, 10, StructuredQuery.FindNearest.DistanceMeasure.COSINE)), (Object)this.runQuery.getValue());
    }

    @Test
    public void successfulReturn() throws Exception {
        ((FirestoreImpl)Mockito.doAnswer(LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2")).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)false, (Object)snapshot.isEmpty());
        Assert.assertTrue((boolean)(LocalFirestoreHelper.DOCUMENT_NAME + "1").endsWith(((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getId()));
        Assert.assertTrue((boolean)(LocalFirestoreHelper.DOCUMENT_NAME + "2").endsWith(((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getId()));
        Assert.assertEquals((long)2L, (long)snapshot.getDocumentChanges().size());
        Assert.assertEquals((long)1L, (long)snapshot.getReadTime().getSeconds());
        Assert.assertEquals((long)2L, (long)snapshot.getReadTime().getNanos());
        Assert.assertEquals((long)1L, (long)this.runQuery.getAllValues().size());
        Assert.assertEquals((Object)LocalFirestoreHelper.query(LocalFirestoreHelper.findNearest("vector", new double[]{1.0, -9.5}, 10, StructuredQuery.FindNearest.DistanceMeasure.DOT_PRODUCT)), (Object)this.runQuery.getValue());
    }

    @Test
    public void handlesStreamExceptionRetryableError() {
        boolean[] returnError = new boolean[]{true};
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            if (returnError[0]) {
                returnError[0] = false;
                return LocalFirestoreHelper.queryResponse((Throwable)FirestoreException.forServerRejection((Status)Status.DEADLINE_EXCEEDED, (String)"Simulated test failure", (Object[])new Object[0]), LocalFirestoreHelper.DOCUMENT_NAME + "1", LocalFirestoreHelper.DOCUMENT_NAME + "2").answer(invocation);
            }
            return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3").answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get());
        List requests = this.runQuery.getAllValues();
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertTrue((boolean)((RunQueryRequest)requests.get(0)).getStructuredQuery().hasFindNearest());
        Assert.assertEquals(e.getCause().getClass(), FirestoreException.class);
        Assert.assertTrue((boolean)e.getCause().getMessage().matches(".*Simulated test failure.*"));
    }

    @Test
    public void handlesStreamExceptionNonRetryableError() {
        boolean[] returnError = new boolean[]{true};
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            if (returnError[0]) {
                returnError[0] = false;
                return LocalFirestoreHelper.queryResponse((Throwable)FirestoreException.forServerRejection((Status)Status.PERMISSION_DENIED, (String)"Simulated test failure", (Object[])new Object[0]), new String[0]).answer(invocation);
            }
            return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3").answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get());
        List requests = this.runQuery.getAllValues();
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertTrue((boolean)((RunQueryRequest)requests.get(0)).getStructuredQuery().hasFindNearest());
        Assert.assertEquals(e.getCause().getClass(), FirestoreException.class);
        Assert.assertTrue((boolean)e.getCause().getMessage().matches(".*Simulated test failure.*"));
    }

    @Test
    public void vectorQuerySnapshotEquality() throws Exception {
        int[] count = new int[]{0};
        ((FirestoreImpl)Mockito.doAnswer(invocation -> {
            int n = count[0];
            count[0] = n + 1;
            switch (n) {
                case 0: {
                    return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3", LocalFirestoreHelper.DOCUMENT_NAME + "4").answer(invocation);
                }
                case 1: {
                    return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3", LocalFirestoreHelper.DOCUMENT_NAME + "4").answer(invocation);
                }
                case 2: {
                    return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "3", LocalFirestoreHelper.DOCUMENT_NAME + "4").answer(invocation);
                }
                case 3: {
                    return LocalFirestoreHelper.queryResponse(LocalFirestoreHelper.DOCUMENT_NAME + "4").answer(invocation);
                }
            }
            return LocalFirestoreHelper.queryResponse().answer(invocation);
        }).when((Object)this.firestoreMock)).streamRequest((Object)((RunQueryRequest)this.runQuery.capture()), (ResponseObserver)this.streamObserverCapture.capture(), (ServerStreamingCallable)ArgumentMatchers.any());
        VectorQuerySnapshot snapshotA = (VectorQuerySnapshot)this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get();
        VectorQuerySnapshot snapshotB = (VectorQuerySnapshot)this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get();
        VectorQuerySnapshot snapshotC = (VectorQuerySnapshot)this.queryB.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get();
        VectorQuerySnapshot snapshotD = (VectorQuerySnapshot)this.queryA.findNearest("vector", new double[]{1.0, -9.5}, 10, VectorQuery.DistanceMeasure.DOT_PRODUCT).get().get();
        Assert.assertEquals((Object)snapshotA, (Object)snapshotB);
        Assert.assertNotEquals((Object)snapshotA, (Object)snapshotC);
        Assert.assertNotEquals((Object)snapshotA, (Object)snapshotD);
    }
}

